var
 btnid : longint;
 hbtn : handle_button;
 hbtnw : handle_dialog;
 cbid : longint;
 hcb : handle_checkbox;
 hcbw : handle_dialog;
 tid : longint;
 ht : handle_text;
 htw : handle_dialog;

 lbid : longint;
 hlb : handle_listbox;
 hlbw : handle_dialog;

 did2 : longint;
 hd : handle_data;
 hdw : handle_dialog;

 darray : array[1..10] of longint;

Procedure Initializedarray;
var
 x : integer;
Begin
 for x := 1 to 10 do darray[x] := unique_id;
end;

Procedure RCAdd_Button;
var
 xpos,ypos : integer;
 bid : longint;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not (new_rect(0,0,1023,479,54,18,true)) then exit;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  bid := unique_id;
  Add_Button(bid,cur_dialog,xpos,ypos,0,'BUTTON',0,true,32612);
  cur_dialog^.cur_button^.tfuncnum := unique_id;
  Draw_Button(cur_dialog,cur_dialog^.cur_button);
  repeat handlemouse until not leftmousekeypressed;
end;

Procedure RCAdd_Text;
var
 xpos,ypos : integer;
 bid : longint;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not (new_rect(0,0,1023,479,72,8,true)) then exit;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  bid := unique_id;
  Add_Text(bid,cur_dialog,xpos,ypos,'TEXTFIELD',rc_movetext);
  cur_dialog^.cur_text^.tfuncnum := unique_id;
  hm;
  Draw_Text(cur_dialog,cur_dialog^.cur_text);
  sm;
  repeat handlemouse until not leftmousekeypressed;
end;

Procedure RCAdd_Listbox;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 lid : longint;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not (new_sized_rect(0,0,1023,479)) then exit;

  swapit(rect.x2,rect.x1);
  swapit(rect.y2,rect.y1);

  xpos := (rect.x1-cur_dialog^.x1);
  ypos := (rect.y1-cur_dialog^.y1);
  xpos1 := (rect.x1-cur_dialog^.x1)+(rect.x2-rect.x1);
  ypos1 := (rect.y1-cur_dialog^.y1)+(rect.y2-rect.y1);
  lid := unique_id;
  Add_Listbox(lid,cur_dialog,'',xpos,ypos,xpos1,ypos1,0,0,rc_movelb,nil,rc_movelb);
  cur_dialog^.cur_lb^.tselectfunc    := unique_id;
  cur_dialog^.cur_lb^.tinclientfunct := unique_id;

  draw_dialog(cur_dialog);
end;

Procedure RCAdd_HorzScrollbar;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 len: integer;
 sbid : longint;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not (new_rect(0,0,1023,767,50,14,true)) then exit;
  if not new_sized_width(rect.x1,rect.y1,rect.x2,rect.y2,37,1023) then exit;

  swapit(rect.x2,rect.x1);
  swapit(rect.y2,rect.y1);

  xpos := (rect.x1-cur_dialog^.x1);
  ypos := (rect.y1-cur_dialog^.y1);
  xpos1 := (rect.x1-cur_dialog^.x1)+(rect.x2-rect.x1);
  ypos1 := (rect.y1-cur_dialog^.y1)+(rect.y2-rect.y1);
  len := xpos1-xpos;
  sbid := unique_id;
  add_scrollbar(sbid,cur_dialog,xpos,ypos,len,1,len,1,1,len div 200,horz,rc_movesb);
  cur_dialog^.cur_sb^.tfuncnum := unique_id;
  draw_dialog(cur_dialog);
end;

Procedure RCAdd_VertScrollbar;
var
 xpos,ypos : integer;
 len,xpos1,ypos1 : integer;
 sbid : longint;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not (new_rect(0,0,1023,479,14,50,true)) then exit;
  if not new_sized_height(rect.x1,rect.y1,rect.x2,rect.y2,37,767) then exit;

  swapit(rect.x2,rect.x1);
  swapit(rect.y2,rect.y1);

  xpos := (rect.x1-cur_dialog^.x1);
  ypos := (rect.y1-cur_dialog^.y1);
  xpos1 := (rect.x1-cur_dialog^.x1)+(rect.x2-rect.x1);
  ypos1 := (rect.y1-cur_dialog^.y1)+(rect.y2-rect.y1);

  len := ypos1-ypos;
  sbid := unique_id;
  add_scrollbar(sbid,cur_dialog,xpos,ypos,len,1,len,1,1,len div 200,vert,rc_movesb);
  cur_dialog^.cur_sb^.tfuncnum := unique_id;
  draw_dialog(cur_dialog);
end;

Procedure RCAdd_Data;
var
 xpos,ypos : integer;
 len,xpos1,ypos1 : integer;
 sbid : longint;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not(new_sized_rect(0,0,maxx,maxy)) then exit;

  swapit(rect.x2,rect.x1);
  swapit(rect.y2,rect.y1);

  xpos := (rect.x1-cur_dialog^.x1);
  ypos := (rect.y1-cur_dialog^.y1);
  xpos1 := (rect.x1-cur_dialog^.x1)+(rect.x2-rect.x1);
  ypos1 := (rect.y1-cur_dialog^.y1)+(rect.y2-rect.y1);

  len := ypos1-ypos;
  sbid := unique_id;
  add_data(sbid,cur_dialog,xpos,ypos,true,(xpos1-xpos-48) shr 3,((xpos1-xpos-48) shr 3)*(len shr 3),
           string_field,'DATA','',rc_movedata);
  cur_dialog^.cur_data^.tfuncnum := unique_id;
  draw_dialog(cur_dialog);
end;

Procedure RCAdd_Checkbox;
var
 xpos,ypos : integer;
 bid : longint;
 w : word;
Begin
  setactive(tdid);
  setclip(cur_dialog);
  if not (new_rect(0,0,1023,479,78,12,true)) then exit;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  bid := unique_id;
  Add_Checkbox(bid,cur_dialog,xpos,ypos,'CHECKBOX',true,false,rc_movecheckbox);
  cur_dialog^.cur_cb^.tfuncnum:= unique_id;

  hm;
  Draw_Checkbox(cur_dialog,cur_dialog^.cur_cb);
  sm;
  repeat handlemouse until not leftmousekeypressed;
end;

Procedure RCMove_Button;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
 bid : longint;
Begin
 setclip(cur_dialog);
 if (cur_dialog^.cur_button^.hbmp<>nil) then
   Begin
    w := cur_dialog^.cur_button^.hbmp^.width+5;
    h := cur_dialog^.cur_button^.hbmp^.height-12;
    if (h<0) then h := 0;
   end else
   Begin
    w := 0;
    h := 0;
   end;
  xpos  := cur_dialog^.x1+cur_dialog^.cur_button^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_button^.ypos;
  if cur_dialog^.cur_button^.btext.length= 0 then
  xpos1 := xpos+w else xpos1 := xpos+(cur_dialog^.cur_button^.btext.length shl 3)+6+w;
  ypos1 := ypos+18+h;
  setmousecursorpos(xpos shl 1,ypos);
  handlemouse;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  if not (new_rect(0,0,1023,479,xpos1-xpos+1,ypos1-ypos+1,false)) then
    Begin
      hm;
      Draw_Button(cur_dialog,cur_dialog^.cur_button);
      sm;
      exit;
    end;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  xpos1 := rect.x2-cur_dialog^.x1;
  ypos1 := rect.y2-cur_dialog^.y1;
  cur_dialog^.cur_button^.xpos := xpos;
  cur_dialog^.cur_button^.ypos := ypos;
  Draw_Button(cur_dialog,cur_dialog^.cur_button);
  repeat handlemouse; until not leftmousekeypressed;
end;

Procedure RCMove_Listbox;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
Begin
  setclip(cur_dialog);
  xpos  := cur_dialog^.x1+cur_dialog^.cur_lb^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_lb^.ypos;
  xpos1 := cur_dialog^.x1+cur_dialog^.cur_lb^.xpos1;
  ypos1 := cur_dialog^.y1+cur_dialog^.cur_lb^.ypos1;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  if mousein(xpos1-3,ypos1-3,xpos1,ypos1) then
     Begin
       if not (new_sized(xpos,ypos,xpos1,ypos1,20,1024,20,768)) then
         Begin
           hm;
           Draw_Listbox(Cur_dialog,cur_dialog^.cur_lb,true);
           sm;
           exit;
         end;
     end else
  if mousein(xpos1-3,ypos,xpos1,ypos1-4) then
     Begin
       if not (new_sized_width(xpos,ypos,xpos1,ypos1,20,1024)) then
         Begin
           hm;
           Draw_Listbox(Cur_dialog,cur_dialog^.cur_lb,true);
           sm;
           exit;
         end;
     end else
  if mousein(xpos,ypos1-3,xpos1-4,ypos1) then
     Begin
       if not (new_sized_height(xpos,ypos,xpos1,ypos1,20,767)) then
         Begin
           hm;
           Draw_Listbox(Cur_dialog,cur_dialog^.cur_lb,true);
           sm;
           exit;
         end;
     end else

     Begin
       setmousecursorpos(xpos shl 1,ypos);
       handlemouse;
       if not (new_rect(0,0,1023,479,xpos1-xpos+1,ypos1-ypos+1,false)) then
         Begin
           hm;
           Draw_Listbox(Cur_dialog,cur_dialog^.cur_lb,true);
           sm;
           exit;
         end;
     end;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  xpos1 := rect.x2-cur_dialog^.x1;
  ypos1 := rect.y2-cur_dialog^.y1;
  cur_dialog^.cur_lb^.xpos := xpos;
  cur_dialog^.cur_lb^.ypos := ypos;
  cur_dialog^.cur_lb^.xpos1 := xpos1;
  cur_dialog^.cur_lb^.ypos1 := ypos1;
  Draw_Listbox(Cur_dialog,cur_dialog^.cur_lb,true);
  repeat handlemouse; until not leftmousekeypressed;
end;

Procedure RCMove_SB;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
Begin
  setclip(cur_dialog);
  xpos  := cur_dialog^.x1+cur_dialog^.cur_sb^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_sb^.ypos;
  xpos1 := cur_dialog^.x1+cur_dialog^.cur_sb^.xpos1;
  ypos1 := cur_dialog^.y1+cur_dialog^.cur_sb^.ypos1;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);

  if (cur_dialog^.cur_sb^.horv=horz) and (mousein(xpos1-14,ypos,xpos1,ypos+14)) then
    Begin
      if not (new_sized_width(xpos,ypos,xpos1,ypos1,37,1024)) then
         Begin
           hm;
           Draw_Scrollbar(cur_dialog,cur_dialog^.cur_sb);
           sm;
           exit;
         end
    end else
  if (cur_dialog^.cur_sb^.horv=vert) and (mousein(xpos,ypos1-14,xpos1,ypos1)) then
    Begin
      if not (new_sized_height(xpos,ypos,xpos1,ypos1,37,767)) then
        Begin
          hm;
          Draw_Scrollbar(cur_dialog,cur_dialog^.cur_sb);
          sm;
          exit;
        end;
    end else
      Begin
        setmousecursorpos(xpos shl 1,ypos);
        handlemouse;
        if not (new_rect(0,0,1023,479,xpos1-xpos+1,ypos1-ypos+1,false)) then
          Begin
            hm;
            Draw_Scrollbar(cur_dialog,cur_dialog^.cur_sb);
            sm;
            exit;
          end;
      end;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  xpos1 := rect.x2-cur_dialog^.x1;
  ypos1 := rect.y2-cur_dialog^.y1;
  cur_dialog^.cur_sb^.xpos := xpos;
  cur_dialog^.cur_sb^.ypos := ypos;
  cur_dialog^.cur_sb^.xpos1 := xpos1;
  cur_dialog^.cur_sb^.ypos1 := ypos1;
  Draw_Scrollbar(cur_dialog,cur_dialog^.cur_sb);
  repeat handlemouse; until not leftmousekeypressed;
end;

Procedure RCMove_Data;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
Begin
  setclip(cur_dialog);
  xpos  := cur_dialog^.x1+cur_dialog^.cur_data^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_data^.ypos;
  xpos1 := cur_dialog^.x1+cur_dialog^.cur_data^.x2;
  ypos1 := cur_dialog^.y1+cur_dialog^.cur_data^.y2;
  hm;
  fill(xpos,ypos,xpos1,ypos1+1,client_background_color);
  if mousein(xpos1-3,ypos1-3,xpos1,ypos1) then
     Begin
       if not (new_sized(xpos,ypos,xpos1,ypos1,20,1024,8,767)) then
         Begin
           hm;
           Draw_Data(Cur_dialog,cur_dialog^.cur_data);
           sm;
           exit;
         end;
     end else
  if mousein(xpos1-3,ypos,xpos1,ypos1-4) then
     Begin
       if not (new_sized_width(xpos,ypos,xpos1,ypos1,20,1024)) then
         Begin
           hm;
           Draw_Data(Cur_dialog,cur_dialog^.cur_data);
           sm;
           exit;
         end;
     end else
  if mousein(xpos,ypos1-3,xpos1-4,ypos1) then
     Begin
       if not (new_sized_height(xpos,ypos,xpos1,ypos1,8,767)) then
         Begin
           hm;
           Draw_Data(Cur_dialog,cur_dialog^.cur_data);
           sm;
           exit;
         end;
     end else
     Begin
       setmousecursorpos(xpos shl 1,ypos);
       handlemouse;
       if not (new_rect(0,0,maxx,maxy,xpos1-xpos+1,ypos1-ypos+1,false)) then
         Begin
           hm;
           Draw_Data(Cur_dialog,cur_dialog^.cur_data);
           sm;
           exit;
         end;
     end;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  xpos1 := rect.x2-cur_dialog^.x1;
  ypos1 := rect.y2-cur_dialog^.y1;
  cur_dialog^.cur_data^.xpos := xpos;
  cur_dialog^.cur_data^.ypos := ypos;
  cur_dialog^.cur_data^.x1:= xpos;
  cur_dialog^.cur_data^.x2:= xpos1;

  h := (ypos1-ypos) shr 3;
  if length(cur_dialog^.cur_data^.name)>0 then
    w := (xpos1-xpos-(length(cur_dialog^.cur_data^.name) shl 3)-7) shr 3 else
    w := (xpos1-xpos) shr 3;

  cur_dialog^.cur_data^.fieldwidth := w;
  cur_dialog^.cur_data^.maxlength := w*h;


  if length(cur_dialog^.cur_data^.name)>0 then
   Begin
    inc(cur_dialog^.cur_data^.x1,length(cur_dialog^.cur_data^.name)shl 3+7);
    cur_dialog^.cur_data^.x2 := cur_dialog^.cur_data^.x1+cur_dialog^.cur_data^.fieldwidth shl 3+7;
   end;

  cur_dialog^.cur_data^.y1:= ypos;
  cur_dialog^.cur_data^.y2:= ypos1;

  Draw_Data(Cur_dialog,cur_dialog^.cur_data);
  repeat handlemouse; until not leftmousekeypressed;
end;

Procedure RCMove_Text;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
 bid : longint;
Begin
 setclip(cur_dialog);
 w := length(cur_dialog^.cur_text^.textdata) shl 3;

 xpos  := cur_dialog^.x1+cur_dialog^.cur_text^.xpos;
 ypos  := cur_dialog^.y1+cur_dialog^.cur_text^.ypos;
 xpos1 := xpos+w;
 ypos1 := ypos+8;

 setmousecursorpos(xpos shl 1,ypos);
 handlemouse;
 hm;
 fill(xpos,ypos,xpos1,ypos1,client_background_color);

if not (new_rect(0,0,1023,479,xpos1-xpos+1,ypos1-ypos+1,false)) then
  Begin
    hm;
     Draw_text(cur_dialog,cur_dialog^.cur_text);
    sm;
    exit;
  end;
xpos := rect.x1-cur_dialog^.x1;
ypos := rect.y1-cur_dialog^.y1;
xpos1 := rect.x2-cur_dialog^.x1;
ypos1 := rect.y2-cur_dialog^.y1;

cur_dialog^.cur_text^.xpos := xpos;
cur_dialog^.cur_text^.ypos := ypos;
hm;
Draw_text(cur_dialog,cur_dialog^.cur_text);
sm;
  repeat handlemouse; until not leftmousekeypressed;
end;

Procedure RCMove_Checkbox;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
 bid : longint;
Begin
 setclip(cur_dialog);
 if length(cur_dialog^.cur_cb^.data.pstr)>0 then
    w := 14+(cur_dialog^.cur_cb^.data.length shl 3) else
    w := 12;
  xpos  := cur_dialog^.x1+cur_dialog^.cur_cb^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_cb^.ypos;
  xpos1 := xpos+w;
  ypos1 := ypos+12;
  setmousecursorpos(xpos shl 1,ypos);
  handlemouse;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  if not (new_rect(0,0,1023,479,xpos1-xpos+1,ypos1-ypos+1,false)) then
    Begin
      hm;
      Draw_Checkbox(cur_dialog,cur_dialog^.cur_cb);
      sm;
      exit;
    end;
  xpos := rect.x1-cur_dialog^.x1;
  ypos := rect.y1-cur_dialog^.y1;
  xpos1 := rect.x2-cur_dialog^.x1;
  ypos1 := rect.y2-cur_dialog^.y1;
  cur_dialog^.cur_cb^.xpos := xpos;
  cur_dialog^.cur_cb^.ypos := ypos;
  cur_dialog^.cur_cb^.selected:= false;
  hm;
  Draw_Checkbox(cur_dialog,cur_dialog^.cur_cb);
  sm;
  repeat handlemouse; until not leftmousekeypressed;
end;

Procedure Convert_Dialog(id:longint);
var
 hdlg : handle_dialog;
 hb : handle_button;
 ht : handle_text;
 hcb : handle_checkbox;
 hsb : handle_scrollbar;
 hd : handle_data;
 hc : handle_client;
 ha : handle_accelerator;
 hlb : handle_listbox;
Begin
 hdlg := get_handle_dialog(id);
 if hdlg=nil then exit;
 tdid := id;

 hdlg^.inclientfunct := rc_editdlg;
 hdlg^.close_func := nothing;
 hdlg^.maximize_func := nothing;
 hdlg^.minimize_func := nothing;
 hdlg^.help_func := nothing;

 ht := hdlg^.first_text;
 while (ht<>nil) do
   Begin
     ht^.funcnum := rc_movetext;
     ht := ht^.next;
   end;
 hd := hdlg^.first_data;
 while (hd<>nil) do
   Begin
     hd^.funcnum := rc_movedata;
     hd := hd^.next;
   end;
 hlb := hdlg^.first_lb;
 while (hlb<>nil) do
   Begin
     hlb^.inclientfunct:= rc_movelb;
     hlb^.selectfunc:= rc_movelb;
     hlb := hlb^.next;
   end;
 hcb := hdlg^.first_cb;
 while (hcb<>nil) do
   Begin
     hcb^.funcnum:= rc_movecb;
     hcb := hcb^.next;
   end;

 hsb := hdlg^.first_sb;
 while (hsb<>nil) do
   Begin
     hsb^.funcnum:= rc_movesb;
     hsb := hsb^.next;
   end;

 hb := hdlg^.first_button;
 while (hb<>nil) do
   Begin
     hb^.funcnum:= rc_movebtn;
     hb := hb^.next;
   end;
end;

Procedure Soundoff;
Begin
  sound(750);
  delay(1);
  nosound;
end;

Procedure Update_Button;
var
 s1 : string;
 changed : boolean;
Begin
  changed := false;

  {Button Text}
  s1 := retrievepchar(darray[1]);
  if not(s1=hbtn^.btext.pstr) then
    Begin
      hbtn^.btext.done;
      hbtn^.btext.init(length(s1));
      hbtn^.btext.addstring(s1);
      changed := true;
    end;

  {Resource ID}
    s1 := retrievepchar(darray[2]); hbtn^.id := stoi(s1);

    s1 := retrievepchar(darray[3]);
    if (s1<>'') then
     Begin
       if hbtn^.hbmp<>nil then
         Begin
           if not(hbtn^.hbmp^.id=stoi(s1)) then
             Begin
               hbtn^.hbmp := get_handle_bmp(stoi(s1));
               changed := true;
             end;
         end else
         Begin
           hbtn^.hbmp := get_handle_bmp(stoi(s1));
           changed := true;
         end;
     end;

  s1 := retrievepchar(darray[4]);
  hbtn^.tfuncnum := stoi(s1);

  if changed then
   Begin
     setactive(tdid);
     setactive(btnid);
   end;
end;

Procedure RCEdit_Button;
Begin
  cur_dialog^.cur_button^.state:=0;
  draw_button(cur_dialog,cur_dialog^.cur_button);
  initializedarray;
  btnid := unique_id;
  hbtn  := cur_dialog^.cur_button;
  hbtnw := cur_dialog;

  create_dialog(btnid,'Edit Button',0,312,1023,maxy,Standard_Dialog,
                help_button+close_button,0,0,0,0,0,0,0,0,0);

  add_data(darray[2],cur_dialog,10,10,false,11,11,string_field,'Resource ID    ',itos(hbtn^.id),rc_updatebutton);
  add_data(darray[1],cur_dialog,10,30,false,30,30,string_field,'Text           ',hbtn^.btext.pstr,rc_updatebutton);
  if hbtn^.hbmp<>nil then
  add_data(darray[3],cur_dialog,10,50,false,11,11,string_field,'BMP Resource ID',itos(hbtn^.hbmp^.id),rc_updatebutton) else
  add_data(darray[3],cur_dialog,10,50,false,11,11,string_field,'BMP Resource ID','',rc_updatebutton);

  Add_Button(unique_id,cur_dialog,600,240,0,'&OK',0,true,standard_close_dialog);
  add_data(darray[4],cur_dialog,10,70,false,11,11,string_field,'Function #     ',itos(hbtn^.tfuncnum),rc_updatebutton);

  Add_Accelerator(unique_id,cur_dialog,Alt,Okey,standard_close_dialog);

  setactive(btnid);
end;

Procedure RCEdit_Sb;
Begin
  soundoff;
end;

Procedure Update_Listbox;
var
 hlbt : handle_listbox;
 hcb : handle_checkbox;
 hdlg : handle_dialog;
 s1 : string;
 changed : boolean;
Begin
  changed := false;

  hdlg := get_handle_dialog(tdid);

  {Text Text}
  s1 := retrievepchar(darray[2]);
  if not(s1=hlb^.title) then
    Begin
      hlb^.title := s1;
      changed := true;
    end;

  {Resource ID}
    s1 := retrievepchar(darray[1]); hlb^.id := stoi(s1);
    s1 := retrievepchar(darray[3]); hlb^.tselectfunc:= stoi(s1);
    s1 := retrievepchar(darray[4]); hlb^.tinclientfunct:= stoi(s1);

  hcb := get_handle_checkbox(darray[5]);
  if (hcb<>nil) then
    Begin
      if (hcb^.selected) and not(hlb^.horz_sb<>nil) then
        Begin
          dec(hlb^.ypos1,15);
          {if (hlb^.vert_sb<>nil) then dec(hlb^.xpos1,15);}
          Add_Scrollbar(unique_id,hdlg,hlb^.xpos,hlb^.ypos1+1,hlb^.xpos1-hlb^.xpos,1,1,1,1,5,horz,0);
          hlb^.horz_sb := hdlg^.cur_sb;
          changed := true;
        end else
      if not(hcb^.selected) and (hlb^.horz_sb<>nil) then
        Begin
          inc(hlb^.ypos1,15);
          {if hlb^.vert_sb<>nil then inc(hlb^.xpos1,15);}
          delete_scrollbar(hdlg,hlb^.horz_sb);
          hlb^.horz_sb := nil;
          changed := true;
        end;
    end;

  hcb := get_handle_checkbox(darray[6]);
  if (hcb<>nil) then
    Begin
      if (hcb^.selected) and not(hlb^.vert_sb<>nil) then
        Begin
          dec(hlb^.xpos1,15);
          Add_Scrollbar(unique_id,hdlg,hlb^.xpos1+1,hlb^.ypos,hlb^.ypos1-hlb^.ypos,1,1,1,1,5,vert,0);
          hlb^.vert_sb := hdlg^.cur_sb;
          changed := true;
        end else
      if not(hcb^.selected) and (hlb^.vert_sb<>nil) then
        Begin
          inc(hlb^.xpos1,15);
          delete_scrollbar(hdlg,hlb^.vert_sb);
          hlb^.vert_sb := nil;
          changed := true;
        end;
    end;

  if get_handle_data(stoi(retrievepchar(darray[7])))<>nil then
      hlb^.data_field := get_handle_data(stoi(retrievepchar(darray[7]))) else
      hlb^.data_field := nil;

  if changed then
    Begin
      setactive(tdid);
      setactive(lbid);
    end;
end;


Procedure RCEdit_Listbox;
Begin
  initializedarray;
  lbid := unique_id;
  hlb  := cur_dialog^.cur_lb;
  hlbw  := cur_dialog;

  create_dialog(lbid,'Edit Listbox',0,312,1023,maxy,Standard_Dialog,
                help_button+close_button,0,0,0,0,0,0,0,0,0);

  add_data(darray[1],cur_dialog,10,10,false,11,11,string_field,'Resource ID    ',itos(hlb^.id),rc_updatelistbox);
  add_data(darray[2],cur_dialog,10,30,false,60,60,string_field,'Title          ',hlb^.title,rc_updatelistbox);
  add_data(darray[3],cur_dialog,10,50,false,11,11,string_field,'Select Function',itos(hlb^.tselectfunc),rc_updatelistbox);
  add_data(darray[4],cur_dialog,10,70,false,11,11,string_field,'Client Function',itos(hlb^.tinclientfunct),rc_updatelistbox);
  if hlb^.data_field<>nil then
  add_data(darray[7],cur_dialog,10,130,false,11,11,string_field,'Data Field ID ',itos(hlb^.data_field^.id),
           rc_updatelistbox) else
  add_data(darray[7],cur_dialog,10,130,false,11,11,string_field,'Data Field ID ',itos(0),rc_updatelistbox);

  add_checkbox(darray[5],cur_dialog,10,90,'Horizontal Scrollbar',true,hlb^.horz_sb<>nil,rc_updatelistbox);
  add_checkbox(darray[6],cur_dialog,10,110,'Vertical Scrollbar',true,hlb^.vert_sb<>nil,rc_updatelistbox);

  Add_Button(unique_id,cur_dialog,600,240,0,'&OK',0,true,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,Alt,Okey,standard_close_dialog);
  setactive(lbid);
end;

Procedure Update_Text;
var
 hcbt : handle_Text;
 s1 : string;
 changed : boolean;
Begin
  changed := false;

  {Text Text}
  s1 := retrievepchar(darray[2]);
  if not(s1=ht^.textdata) then
    Begin
      ht^.textdata := s1;
      changed := true;
    end;

  {Resource ID}
    s1 := retrievepchar(darray[1]); ht^.id := stoi(s1);

    s1 := retrievepchar(darray[3]); ht^.tfuncnum := stoi(s1);

  if changed then
   Begin
     setactive(tdid);
     setactive(tid);
   end;
end;

Procedure RCEdit_Text;
Begin
  initializedarray;
  tid := unique_id;
  ht   := cur_dialog^.cur_text;
  htw  := cur_dialog;

  create_dialog(tid,'Edit Text',0,312,1023,maxy,Standard_Dialog,
                help_button+close_button,0,0,0,0,0,0,0,0,0);

  add_data(darray[1],cur_dialog,10,10,false,11,11,string_field,'Resource ID    ',itos(ht^.id),rc_updateText);
  add_data(darray[2],cur_dialog,10,30,false,40,80,string_field,'Text           ',ht^.textdata,rc_updateText);
  add_data(darray[3],cur_dialog,10,60,false,11,11,string_field,'Function #     ',itos(ht^.tfuncnum),rc_updateText);

  Add_Button(unique_id,cur_dialog,600,240,0,'&OK',0,true,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,Alt,Okey,standard_close_dialog);

  setactive(tid);
end;



Procedure Update_Checkbox;
var
 hcbt : handle_checkbox;
 s1 : string;
 changed : boolean;
Begin
  changed := false;

  {Checkbox Text}
  s1 := retrievepchar(darray[2]);
  if not(s1=hcb^.data.pstr) then
    Begin
      hcb^.data.done;
      hcb^.data.init(length(s1));
      hcb^.data.addstring(s1);
      changed := true;
    end;

  {Resource ID}
    s1 := retrievepchar(darray[1]); hcb^.id := stoi(s1);

    s1 := retrievepchar(darray[5]); hcb^.tfuncnum := stoi(s1);

  hcbt := get_handle_checkbox(darray[3]);
  if (hcbt<>nil) then
    Begin
      if (hcbt^.selected) and not (hcb^.enabled) then
        Begin
          hcb^.enabled := true;
          changed := true;
        end else
      if not(hcbt^.selected) and (hcb^.enabled) then
        Begin
          hcb^.enabled := false;
          changed := true;
        end;
    end;

  hcbt := get_handle_checkbox(darray[4]);
  if (hcbt<>nil) then
    Begin
      if (hcbt^.selected) and not(hcb^.selected) then
        Begin
          hcb^.selected:= true;
          changed := true;
        end else
      if not(hcbt^.selected) and (hcb^.selected) then
        Begin
          hcb^.selected:= false;
          changed := true;
        end;
    end;
  if changed then
    Begin
      setactive(tdid);
      setactive(cbid);
    end;
end;

Procedure RCEdit_Checkbox;
Begin
  if cur_dialog^.cur_cb^.enabled then
  Begin
    cur_dialog^.cur_Cb^.selected:= not(cur_dialog^.cur_cb^.selected);
    hm;
    draw_Checkbox(cur_dialog,cur_dialog^.cur_Cb);
    sm;
  end;
  initializedarray;
  cbid := unique_id;
  hcb   := cur_dialog^.cur_Cb;
  hcbw  := cur_dialog;

  create_dialog(cbid,'Edit Checkbox',0,312,1023,maxy,Standard_Dialog,
                help_button+close_button,0,0,0,0,0,0,0,0,0);

  add_data(darray[1],cur_dialog,10,10,false,11,11,string_field,'Resource ID    ',itos(hcb^.id),rc_updateCheckbox);
  add_data(darray[2],cur_dialog,10,30,false,60,60,string_field,'Text           ',hcb^.data.pstr,rc_updateCheckbox);
  add_checkbox(darray[3],cur_dialog,137,50,'Enabled',true,hcb^.enabled,rc_updatecheckbox);
  add_checkbox(darray[4],cur_dialog,137,70,'Selected',true,hcb^.selected,rc_updatecheckbox);
  add_data(darray[5],cur_dialog,10,90,false,11,11,string_field,'Function #     ',itos(hcb^.tfuncnum),rc_updateCheckbox);

  Add_Button(unique_id,cur_dialog,600,240,0,'&OK',0,true,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,Alt,Okey,standard_close_dialog);

  setactive(cbid);
end;

Procedure Update_Data;
var
 hcbt : handle_data;
 s1 : string;
 changed : boolean;
 db_ftype : byte;
 fieldname : string;
 fieldtype : byte;
Begin
  changed := false;

  {Text data}
  s1 := retrievepchar(darray[2]);
  if not(s1=hd^.name) then
    Begin
      hd^.name := s1;
      hd^.x1 := hd^.xpos;
      hd^.y1 := hd^.ypos+1;
      hd^.x2 := hd^.xpos+(hd^.fieldwidth shl 3)+7;
      hd^.y2 := hd^.ypos+((hd^.maxlength div hd^.fieldwidth)*9)+2;
      if length(hd^.name)>0 then
      Begin
        inc(hd^.x1,length(hd^.name)shl 3+7);
        inc(hd^.x2,length(hd^.name)shl 3+7);
      end;
      changed := true;
    end;

  s1 := retrievepchar(darray[4]); {Fieldwidth}
  if stoi(s1)<>hd^.fieldwidth then
    Begin
      hd^.fieldwidth := stoi(s1);
      hd^.x1 := hd^.xpos;
      hd^.y1 := hd^.ypos+1;
      hd^.x2 := hd^.xpos+(hd^.fieldwidth shl 3)+7;
      hd^.y2 := hd^.ypos+((hd^.maxlength div hd^.fieldwidth)*9)+2;
      if length(hd^.name)>0 then
      Begin
        inc(hd^.x1,length(hd^.name)shl 3+7);
        inc(hd^.x2,length(hd^.name)shl 3+7);
      end;
      changed := true;
    end;

  s1 := retrievepchar(darray[5]); {Fieldwidth}
  if stoi(s1)<>hd^.maxlength then
    Begin
      hd^.maxlength := stoi(s1);
      s1 := hd^.data.pstr;
      hd^.data.done;
      hd^.data.init(hd^.maxlength);
      hd^.data.addstring(s1);
      hd^.x1 := hd^.xpos;
      hd^.y1 := hd^.ypos+1;
      hd^.x2 := hd^.xpos+(hd^.fieldwidth shl 3)+7;
      hd^.y2 := hd^.ypos+((hd^.maxlength div hd^.fieldwidth)*9)+2;
      if length(hd^.name)>0 then
      Begin
        inc(hd^.x1,length(hd^.name)shl 3+7);
        inc(hd^.x2,length(hd^.name)shl 3+7);
      end;
      changed := true;
    end;

  {default Data}
  s1 := retrievepchar(darray[3]);
  if not(s1=hd^.data.pstr) then
    Begin
      hd^.data.done;
      hd^.data.init(hd^.maxlength);
      hd^.data.addstring(s1);
      changed := true;
    end;

  {Resource ID}
    s1 := retrievepchar(darray[1]); hd^.id := stoi(s1);
    s1 := retrievepchar(darray[6]); hd^.tfuncnum := stoi(s1);

    fieldtype := stoi(retrievepchar(darray[7]));
    db_ftype := stoi(retrievepchar(darray[8]));
    fieldname := retrievepchar(darray[9]);

    if (db_ftype<>hd^.db_ftype) then
      Begin
        hd^.db_ftype := db_ftype;
        changed := true;
      end;

    if (fieldtype<>hd^.fieldtype) then
      Begin
        hd^.fieldtype := fieldtype;
        changed := true;
      end;

    if (fieldname<>hd^.fieldname) then
      Begin
        hd^.fieldname := fieldname;
        changed := true;
      end;

  if changed then
    Begin
      setactive(tdid);
      setactive(did2);
    end;
end;

Procedure RCEdit_Data;
Begin
  initializedarray;
  did2:= unique_id;
  hd   := cur_dialog^.cur_data;
  hdw  := cur_dialog;

  create_dialog(did2,'Edit Data',0,312,1023,maxy,Standard_Dialog,
                help_button+close_button,0,0,0,0,0,0,0,0,0);

  add_data(darray[1],cur_dialog,10,10,false,11,11,string_field,'Resource ID       ',itos(hd^.id),rc_updatedata);
  add_data(darray[2],cur_dialog,10,30,false,30,30,string_field,'Field Description ',hd^.name,rc_updatedata);
  add_data(darray[3],cur_dialog,10,50,false,40,240,string_field,'Default Data      ',hd^.data.pstr,rc_updatedata);
  add_data(darray[4],cur_dialog,10,110,false,5,5,string_field,'Field Width       ',itos(hd^.fieldwidth),rc_updatedata);
  add_data(darray[5],cur_dialog,10,130,false,5,5,string_field,'Total Field Length',itos(hd^.maxlength),rc_updatedata);
  add_data(darray[6],cur_dialog,10,150,false,11,11,string_field,'Function #        ',itos(hd^.tfuncnum),rc_updatedata);
  add_data(darray[7],cur_dialog,10,170,false,3,3,string_field,'Field Type        ',itos(hd^.fieldtype),rc_updatedata);
  add_data(darray[8],cur_dialog,10,190,false,3,3,string_field,'DB Field Type     ',itos(hd^.db_ftype),rc_updatedata);
  add_data(darray[9],cur_dialog,10,210,false,11,11,string_field,'Fieldname         ',hd^.fieldname,rc_updatedata);

  Add_Button(unique_id,cur_dialog,600,240,0,'&OK',0,true,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,Alt,Okey,standard_close_dialog);
  setactive(did2);
end;

Procedure RCDelete_Button;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
 bid : longint;
Begin
 setclip(cur_dialog);
 if (cur_dialog^.cur_button^.hbmp<>nil) then
   Begin
    w := cur_dialog^.cur_button^.hbmp^.width+5;
    h := cur_dialog^.cur_button^.hbmp^.height-12;
    if (h<0) then h := 0;
   end else
   Begin
    w := 0;
    h := 0;
   end;
  xpos  := cur_dialog^.x1+cur_dialog^.cur_button^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_button^.ypos;
  if cur_dialog^.cur_button^.btext.length= 0 then
  xpos1 := xpos+w else xpos1 := xpos+(cur_dialog^.cur_button^.btext.length shl 3)+6+w;
  ypos1 := ypos+18+h;
  handlemouse;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  delete_button(cur_dialog,cur_dialog^.cur_button);
  sm;
  repeat handlemouse until not(leftmousekeypressed);
end;

Procedure RCDelete_Sb;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
Begin
  setclip(cur_dialog);
  xpos  := cur_dialog^.x1+cur_dialog^.cur_sb^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_sb^.ypos;
  xpos1 := cur_dialog^.x1+cur_dialog^.cur_sb^.xpos1;
  ypos1 := cur_dialog^.y1+cur_dialog^.cur_sb^.ypos1;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  delete_scrollbar(cur_dialog,cur_dialog^.cur_sb);
  sm;
  repeat handlemouse until not(leftmousekeypressed);
end;

Procedure RCDelete_Text;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
 bid : longint;
Begin
 setclip(cur_dialog);
 w := length(cur_dialog^.cur_text^.textdata) shl 3;

 xpos  := cur_dialog^.x1+cur_dialog^.cur_text^.xpos;
 ypos  := cur_dialog^.y1+cur_dialog^.cur_text^.ypos;
 xpos1 := xpos+w;
 ypos1 := ypos+8;
 handlemouse;
 hm;
 fill(xpos,ypos,xpos1,ypos1,client_background_color);
 delete_text(cur_dialog,cur_dialog^.cur_text);
 sm;
  repeat handlemouse until not(leftmousekeypressed);
end;

Procedure RCDelete_Listbox;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
Begin
  setclip(cur_dialog);
  xpos  := cur_dialog^.x1+cur_dialog^.cur_lb^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_lb^.ypos;
  xpos1 := cur_dialog^.x1+cur_dialog^.cur_lb^.xpos1;
  ypos1 := cur_dialog^.y1+cur_dialog^.cur_lb^.ypos1;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  delete_listbox(cur_dialog,cur_dialog^.cur_lb);
  sm;
  repeat handlemouse until not(leftmousekeypressed);
end;

Procedure RCDelete_Checkbox;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
 bid : longint;
Begin
 setclip(cur_dialog);
 if cur_dialog^.cur_cb^.data.length>0 then
    w := 14+(cur_dialog^.cur_cb^.data.length shl 3) else
    w := 12;
  xpos  := cur_dialog^.x1+cur_dialog^.cur_cb^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_cb^.ypos;
  xpos1 := xpos+w;
  ypos1 := ypos+12;
  handlemouse;
  hm;
  fill(xpos,ypos,xpos1,ypos1,client_background_color);
  delete_checkbox(cur_dialog,cur_dialog^.cur_cb);
  sm;
  repeat handlemouse until not(leftmousekeypressed);
end;

Procedure RCDelete_Data;
var
 xpos,ypos : integer;
 xpos1,ypos1 : integer;
 w,h : integer;
Begin
  setclip(cur_dialog);
  xpos  := cur_dialog^.x1+cur_dialog^.cur_data^.xpos;
  ypos  := cur_dialog^.y1+cur_dialog^.cur_data^.ypos;
  xpos1 := cur_dialog^.x1+cur_dialog^.cur_data^.x2;
  ypos1 := cur_dialog^.y1+cur_dialog^.cur_data^.y2;
  hm;
  fill(xpos,ypos,xpos1,ypos1+1,client_background_color);
  delete_data(cur_dialog,cur_dialog^.cur_data);
  sm;
  repeat handlemouse until not(leftmousekeypressed);
end;

Procedure ButtonMode;
Begin
  case mode of
    0 : RCMove_Button;
    1 : RCEdit_Button;
    3 : RCDelete_Button;
  end;
end;


Procedure ScrollbarMode;
Begin
  soundoff;
  case mode of
    0 : RCMove_Sb;
    1 : RCEdit_Sb;
    3 : RCDelete_SB;
  end;
end;

Procedure ListboxMode;
Begin
  case mode of
    0 : RCMove_Listbox;
    1 : RCEdit_Listbox;
    3 : RCDelete_Listbox;
  end;
end;

Procedure Textmode;
Begin
  case mode of
    0 : RCMove_text;
    1 : RCEdit_text;
    3 : RCDelete_Text;
  end;
end;

Procedure Datamode;
Begin
  case mode of
    0 : RCMove_data;
    1 : RCEdit_data;
    3 : RCDelete_data;
  end;
end;

Procedure Checkboxmode;
Begin
  case mode of
    0 : RCMove_checkbox;
    1 : RCEdit_checkbox;
    3 : RCDelete_Checkbox;
  end;
end;

