Unit Constant;

Interface

Uses Crt,Dos,Windows,global,resource,desktop;

Var
  constant_id : longint;
  constant_lbid : longint;

Procedure Initialize_Constants;
Procedure Add_List(fname:string);
Procedure SelectPas;
Procedure Create_Constants;

Implementation

Uses filedlg;

Procedure Add_List(fname:string);
var
 hlb : handle_listbox;
 f : text;
 s : string;
 done : boolean;
 s1,s2,s3,s4 : string;

Function uc(s:string):string;
var
 x : byte;
Begin
 uc := s;
 if length(s)<1 then exit;
 for x := 1 to length(s) do s[x] := upcase(s[x]);
 uc := s;
end;

Procedure strip(var s:string;c:char);
begin
  while pos(c,s)>0 do delete(s,pos(c,s),1);
end;

Begin
 hlb := get_handle_listbox(constant_lbid);
 if (hlb=nil) then exit;
 if not(exists(fname)) then exit;
 assign(f,fname);
 reset(f);
 s := '';
 repeat
   readln(f,s);
   s := uc(s);
 until (pos('CONST',s)>0) or (eof(f));
 if eof(f) then exit;
 repeat
   readln(f,s);
   s := uc(s);
   if (length(s)>0) and (pos('=',s)>0) and (pos(';',s)>0) then
     Begin
       delete(s,pos(';',s),255);
       s1 := s;
       s2 := s;
       delete(s1,pos('=',s1),255);
       strip(s1,' ');
       delete(s2,1,pos('=',s2));
       strip(s2,' ');
       if stoi(s2)>0 then add_listbox_item(hlb,lpad(s1,30)+s2,255,stoi(s2));
     end;
   if (pos('VAR',s)>0) or (pos('TYPE',s)>0) or (pos('IMPLEMENTATION',s)>0) or
   (pos('PROCEDURE',s)>0) or (pos('FUNCTION',s)>0) then done := true;
   if eof(f) then done := true;
 until (done);
close(f);
sort_listbox(hlb);
setactive(constant_id);
end;

Procedure Initialize_Constants;
var
 x : integer;
Begin
  constant_id   := unique_id;
  constant_lbid := unique_id;
  Create_Dialog(constant_id,'Constant List',314,236,710,532,standard_dialog,
                help_button+close_button+moveable+modal,0,0,0,nothing,0,0,0,0,0);
  Add_ListBox(constant_lbid,cur_dialog,'',10,15,386,216,unique_id,unique_id,nothing,nil,0);
  Add_Button(unique_id,cur_dialog,10,236,0,'&Add',0,true,rc_selectpas);
  setactive(constant_id);
end;

Procedure SelectPas;
Begin
  FD_Setsearch('*.*');
  OpenFile_Dialog('Import Constant DEFS',rc_selpas,0);
end;

Procedure Create_Constants;
var
 f : text;
 x,y,y1 : integer;
 hb : handle_button;
 ht : handle_text;
 hcb : handle_checkbox;
 hsb : handle_scrollbar;
 hd : handle_data;
 hc : handle_client;
 ha : handle_accelerator;
 hlb : handle_listbox;
 hdlg : handle_dialog;
 h2 : longint;
Begin
 h2 := cur_dialog^.id;
 if not  resource_loaded then exit;
 assign(f,'CONST.TXT');
 rewrite(f);
 writeln(f,'{*******************************************');
 writeln(f,'    File Created by Resource Editor v1.00');
 writeln(f,' *******************************************}');
 writeln('Const');
 for x := 1 to 750 do
   if read_resource(resource_index^[x].id) then
   begin
     writeln(f,lpad('dlg'+resource_index^[x].filename,25),'=',lpad(itos(cur_dialog^.id)+';',15),'    {Dialog Box}');
     hdlg := cur_dialog;
     hb := hdlg^.first_button;
     y := 1;
     while (hb<>nil) do
       Begin
         writeln(f,lpad('btn'+resource_index^[x].filename+'_'+itos(y)+'ID',25),'=',lpad(itos(hb^.id)+';',15),
                   '    {',hb^.btext.pstr,' RID}');
         writeln(f,lpad('btn'+resource_index^[x].filename+'_'+itos(y),25),'=',lpad(itos(hb^.tfuncnum)+';',15),
                   '    {',hb^.btext.pstr,'}');
         inc(y);
         hb := hb^.next;
       end;

     hlb := hdlg^.first_lb;
     y := 1;
     while (hlb<>nil) do
       Begin
         writeln(f,lpad('lb'+resource_index^[x].filename+'_'+itos(y)+'ID',25),'=',lpad(itos(hlb^.id)+';',15),
                   '    {',hlb^.title,' RID}');
         writeln(f,lpad('lb'+resource_index^[x].filename+'_'+itos(y)+'SEL',25),'=',lpad(itos(hlb^.tselectfunc)+';',15),
                   '    {',hlb^.title,'}');
         writeln(f,lpad('lb'+resource_index^[x].filename+'_'+itos(y)+'IC',25),'=',lpad(itos(hlb^.tinclientfunct)+';',15),
                   '    {',hlb^.title,'}');
         inc(y);
         hlb := hlb^.next;
       end;

     hcb := hdlg^.first_cb;
     y := 1;
     while (hcb<>nil) do
       Begin
         writeln(f,lpad('cb'+resource_index^[x].filename+'_'+itos(y)+'ID',25),'=',lpad(itos(hcb^.id)+';',15),
                   '    {',hcb^.data.pstr,' RID}');
         writeln(f,lpad('cb'+resource_index^[x].filename+'_'+itos(y),25),'=',lpad(itos(hcb^.tfuncnum)+';',15),
                   '    {',hcb^.data.pstr,'}');
         inc(y);
         hcb := hcb^.next;
       end;

     hd := hdlg^.first_data;
     y := 1;
     y1 := 1;
     while (hd<>nil) do
       Begin
         if (hd^.fieldtype=DB_EDIT) or (hd^.fieldtype=DB_TEXT) then
         writeln(f,lpad('dta'+resource_index^[x].filename+'_'+hd^.fieldname,25),'=',lpad(itos(hd^.id)+';',15),
                   '    {',hd^.name,' RID}') else
         writeln(f,lpad('dta'+resource_index^[x].filename+'_'+itos(y)+'ID',25),'=',lpad(itos(hd^.id)+';',15),
                   '    {',hd^.name,' RID}');

         if hd^.funcnum>0 then
         Begin
           writeln(f,lpad('dta'+resource_index^[x].filename+'_'+itos(y1),25),'=',lpad(itos(hd^.tfuncnum)+';',15),
                     '    {',hd^.name,'}');
           inc(y1);
         end;
         if (hd^.fieldtype<>DB_EDIT) and (hd^.fieldtype<>DB_TEXT) then inc(y);
         hd := hd^.next;
       end;
     close_dialog(hdlg);
   end;
 close(f);
 setactive(h2);
 browser('CONST.TXT');
end;

Begin
{  writeln('Constant Extensions v1.0');
  delay(750);}
end.

