{
Procedure BubbleSort(sorttype:Byte);
Var
   i,j  :Word;
   tempname : String;
   tempsize : LongInt;
   tempext  : string;
Begin
     For i := 1 to MaxFptr do
         For j := 1 to MaxFptr do
         Begin
              if (FileTree^[i].typ = _file) and (filetree^[j].typ = _file) then
              Begin
                   case sorttype of
                        _toname : Begin
                                  if (FileTree^[i].Name < FileTree^[j].Name) then
                                  Begin
                                       tempname := FileTree^[i].name;
                                       FileTree^[i].Name := FileTree^[j].Name;
                                       FileTree^[j].Name := tempname;
                                  End;
                                  End;
                        _tosize : Begin
                                  if (FileTree^[i].size < FileTree^[j].Size) then
                                  Begin
                                       tempsize := filetree^[i].size;
                                       filetree^[i].size := filetree^[j].size;
                                       filetree^[j].size := tempsize;
                                  end;
                                  End;
                   End;
              end;
         End;
End;
}

Procedure LoadShowFiles;
Begin
     vrestoremouse;
     SetFillStyle(SolidFill,Black);
     Bar(lx1+CharW,ly1+CharH*5,lx1+CharW*20,ly2-CharH);
     For DummyByte := 0 to 17 do
     Begin
         FilePosition[DummyByte].Name := '';
         FilePosition[DummyByte].Typ  := 3;
     End;
     For DummyByte := Fptr to (Fptr + 17) do
     Begin
         if DummyByte = MaxFPtr then Break;
         if FileTree^[DummyByte].typ = _file then
         Begin
             if FileTree^[DummyByte].Status = _NOTSELECTED then
                SetColor(Black+31)
             else
                SetColor(Red+31);
         End
         else
         if FileTree^[DummyByte].typ = _dir then
             SetColor(Green+16)
         else
         if FileTree^[DummyByte].typ = _drive then
             SetColor(Yellow+31);
         OutTextXY(lx1+CharW,ly1+CharH*(5+DummyByte-Fptr),FileTree^[DummyByte].Name);
         if FileTree^[DummyByte].typ = _file then
         Begin
              SetColor(Black+16);
              OutTextXY(lx1+CharW*14,ly1+CharH*(5+DummyByte-Fptr),S((FileTree^[DummyByte].Size div KB)+1,6,False));
         End;
         FilePosition[DummyByte-Fptr].Name := FileTree^[DummyByte].Name;
         FilePosition[DummyByte-Fptr].Typ  := FileTree^[DummyByte].Typ;
         FilePosition[DummyByte-Fptr].MainNo := DummyByte;
     End;
     vputmouse;
End;

Procedure LoadGetFileTree;
Var
    F :SearchRec;
    Fname :String[8];
    FExt  :String[3];
    Path  :String;
Begin
     MaxFptr := 0;
     {$I-}
     GetDir(0,Path);
     if Path <> CurrentPath then Fptr := 0;
     ChDir(CurrentPath);
     GetDir(0,CurrentPath);
     {$I+}
     For DummyByte := 0 to 25 do
     Begin
          if DriveAvailAble[DummyByte] then
          Begin
               FileTree^[MaxFptr].typ := _drive;
               FileTree^[MaxFptr].Name := Chr(65+DummyByte)+':';
               Inc(MaxFPtr);
          End;
     End;
     FindFirst('*.*',Directory,F);
     While DosError = 0 do
     Begin
          if F.Attr = Directory then
          Begin
               FileTree^[MaxFptr].typ  := _dir;
               FileTree^[MaxFptr].Name := F.Name;
               Inc(MaxFPtr);
          End;
          FindNext(F);
     End;
     FindFirst(FilePattern,0,F);
     While DosError = 0 do
     Begin
          if Pos('.',F.Name) = 0 then
             FileTree^[MaxFptr].Name := Left(F.Name,8)
          else
             FileTree^[MaxFptr].Name := Left(Left(F.Name,Pos('.',F.Name)-1),8)+'.'+
             Left(Right(F.Name,Length(F.Name)-Pos('.',F.Name)),3);
          if F.Attr = Directory then
             FileTree^[MaxFptr].typ  := _dir
          else
             FileTree^[MaxFptr].typ := _file;
          FileTree^[MaxFPtr].Size    := F.Size;
          FileTree^[MaxFPtr].Status  := _NOTSELECTED;
          Inc(MaxFptr);
          FindNext(F);
     End;
     if FPtr > MaxFptr then FPtr := 0;
{
     BubbleSort(_tosize);
}
End;

Procedure LoadDefaultPath;
Begin
     if CurrentPath <> DefaultPath then
     Begin
          LoadFile := '';
          CurrentPath := DefaultPath;
          LoadGetFileTree;
     End;
     ButtonPos := False;
End;

Procedure LoadSetDefault;
Var
   OldOkay,
   OldCanceled : Boolean;
Begin
     OldOkay := Okay;
     OldCanceled := Canceled;
     if ASKBox('Do you really want to make current path default ?') then
     Begin
          DefaultPath := CurrentPath;
     End;
     VPutMouse;
     Okay := OldOkay;
     Canceled := OldCanceled;
     ButtonPos := False;
End;

Procedure LoadFPtrUp;
Var
   LeftPressed : Boolean;
Begin
     if Fptr > 0 then
     Begin
          Dec(FPtr);
          LoadShowFiles;
     End;
     Delay(100);
     LeftPressed := LeftButton;
     While LeftPressed do
     Begin
          VertWait;
          if Fptr > 0 then
          Begin
               Dec(Fptr);
               LoadShowFiles;
          End;
          LeftPressed := LeftButton;
          VertWait;
     End;
     ButtonPos := False;
End;

Procedure LoadFPtrDown;
Var
   LeftPressed: Boolean;
Begin
     if (Fptr+18) < MaxFptr then
     Begin
          Inc(FPtr);
          LoadShowFiles;
     End;
     Delay(100);
     LeftPressed := LeftButton;
     While LeftPressed do
     Begin
          VertWait;
          if (Fptr + 18) < MaxFPtr then
          Begin
               Inc(FPtr);
               LoadShowFiles;
          End;
          LeftPressed := LeftButton;
          VertWait;
     End;
     ButtonPos := False;
End;



Procedure LoadShowInFo;
Begin
     vrestoreMouse;
     SetFillStyle(SolidFill,Black);
     Bar(lx1+CharW*11,ly1+CharH,lx2-CharW,ly1+CharH*4);
     SetColor(Black+31);
     if Length(CurrentPath) > 28 then
         OutTextXY(lx1+CharW*11,ly1+CharH,'...'+Right(CurrentPath,25))
     else
         OutTextXY(lx1+CharW*11,ly1+CharH,CurrentPath);
     OutTextXY(lx1+CharW*11,ly1+CharH*2,LoadFile);
     OutTextXY(lx1+CharW*11,ly1+CharH*3,FilePattern);
     SetFillStyle(SolidFill,Blue+16);
     Bar(lx1+CharW*24,ly2-CharH*10,lx2-CharW,ly2-CharH*3-2);
     OutTextXY(lx1+CharW*24,ly2-CharH*10,'Space:'+S(DiskFree(0) div KB,8,FALSE)+'KB');
     Asm
        Mov Ah,42h
        int 67h
        mov FreeEMS,bx
     End;
     OutTextXY(lx1+CharW*24,ly2-CharH*8,'Free EMS:'+S(FreeEMS*16,5,FALSE)+'KB');
     LoadShowFiles;
     vrestoremouse;
     vPutMouse;
End;

Procedure LoadSetFileHand;
Var
   FF           : File;
   NewLoadFile  : String[12];
Begin
   NewLoadFile  := Upper(GetInput(lx1+CharW*11,ly1+CharH*2,12,False,Black,Black+31));
   if NewLoadFile <> '' then
   Begin
        {$I-}
        Assign(FF,NewLoadFile);
        Reset(FF,1);
        {$I+}
        if IOResult <> 0 then OKBox(NewLoadFile+' not found or not valid.')
        else
        Begin
             Close(FF);
             LoadFile := NewLoadFile;
             if Pos('.',LoadFile) = 0 then
                LoadFile := Left(LoadFile,8)
             else
                LoadFile := Left(Left(LoadFile,Pos('.',LoadFile)-1),8)+'.'+
                Left(Right(LoadFile,Length(LoadFile)-Pos('.',LoadFile)),3);
             Okay := True;
        End;
   End;
End;

Procedure LoadSetDirectory;
Var
   NewDirectory : String;
   New2         : String;
Begin
     NewDirectory := GetInput(lx1+CharW*11,ly1+CharH,28,False,Black,Black+31);
     {$I-}
     ChDir(NewDirectory);
     GetDir(0,New2);
     {$I+}
     if IOResult <> 0 then OKBox(NewDirectory+' not valid or error occured.')
     else
     Begin
          CurrentPath := NewDirectory;
          LoadFile := '';
          LoadGeTfileTree;
     End;
End;

Procedure LoadSetPattern;
Var
   NewPattern : String[12];
Begin
     NewPattern := GetInput(lx1+CharW*11,ly1+CharH*3,12,False,Black,Black+31);
     if Pos('\',NewPattern) <> 0 then
     Begin
          Sound(600);
          Delay(100);
          NoSound;
     End
     else
     if NewPattern <> '' then
     Begin
          FilePattern := NewPattern;
          LoadGetFileTree;
     End;
End;

Procedure LoadSetFile;
Var
   OldOkay,
   OldCanceled : Boolean;
   _y : Integer;
   OldPath : String;
   DI      : Integer;
Begin
     _y := ((MouseY+1 - ly1+CharH*5) div CharH) - 10;
     GetDir(0,OldPath);
     Case FilePosition[_y].typ of
          _file : Begin
                       LoadFile := FilePosition[_y].Name;

                       if OldSelected <> $FFFF then
                            FileTree^[OldSelected].Status := _NOTSELECTED;
                       FileTree^[FilePosition[_y].MainNo].Status := _SELECTED;
                       OldSelected := FilePosition[_y].MainNo;
                  End;
          _dir  : Begin
                       {$I-}
                       ChDir(ClearSlash(FilePosition[_y].Name));
                       {$I+}
                       if IOResult = 0 then
                       Begin
                            GetDir(0,CurrentPath);
                            LoadGetFileTree;
                            LoadFile := '';
                       End
                       else
                       Begin
                           {$I-}
                           ChDir(OldPath);
                           {$I+}
                           DI := IOResult;
                           OKBox('Having problems with '+FilePosition[_y].Name);
                           vputmouse;
                       End;
                  End;
          _drive: Begin
                       {$I-}
                       ChDir(FilePosition[_y].Name+'.');
                       {$I+}
                       if IOResult = 0 then
                       Begin
                            GetDir(0,CurrentPath);
                            LoadGetFileTree;
                            LoadFile := '';
                       End
                       else
                       Begin
                           {$I-}
                           ChDir(OldPath);
                           {$I+}
                           DI := IOResult;
                           OldOkay := Okay;
                           OKBox('Having problem with drive '+FilePosition[_y].Name);
                           vputmouse;
                           Okay := OldOkay;
                       End;
                  End;
     End;
End;

Procedure LoadFptrTop;
Begin
     Fptr := 0;
     ButtonPos := False;
End;

Procedure LoadFptrBot;
Begin
     if MaxFptr > 18 then
        Fptr := MaxFptr-18
     else
        Fptr := 0;
     ButtonPos := False;
End;

Procedure LoadFptrMid;
Begin
     if MaxFptr > 18 then Fptr := (MaxFptr div 2);
     LoadShowFiles;
     ButtonPos := False;
End;

Procedure LoadWAV;
Var
   WAVSign      : String[5];
   w            : Word;
Begin
   WAVSign[0] := Char(4);
   BlockRead(InFile,WAVSign[1],4);
   if WAVSign = 'RIFF' then
   Begin
        Seek(InFile,$18);
        BlockRead(InFile,W,SizeOf(w));
        Rate := w ;
        Seek(InFile,$2c);
   End
   else Seek(InFile,0);
End;

Procedure LoadAU;
Var
   AUType       : Byte;
   UlawSign     : String[5];
   w            : Word;
   HdrSize      : Word;
Begin
     UlawSign[0] := Char(4);
     BlockRead(InFile,ULawSign[1],4);
     if UlawSign = '.snd' then
     Begin
          ISitAU := True;
          BlockRead(InFile,W,SizeOf(w));
          w := lo(w)*$100+hi(w);
          HdrSize := W;
          Hdrsize := Hdrsize * $10000;
          BlockRead(InFile,W,SizeOf(w));
          w := lo(w)*$100+hi(w);
          HdrSize := HdrSize + w;
          Seek(InFile,15);
          BlockRead(InFile,AUType,1);
          BlockRead(InFile,W,SizeOf(w));
          w := lo(w)*$100+hi(w);
          Rate := w ;
          Rate := Rate * $10000;
          BlockRead(InFile,W,SizeOf(w));
          w := lo(w)*$100+hi(w);
          Rate := Rate+w;
          if AUType > 1 then IsItAU := False;
          if AUType = 2 then
          Begin
               SampleInfo[ActiveSample].Signed := True;
               Signed := True;
               if signed then _signed := 1 else _signed := 0;
          End;
          if AUtype > 3 then
             OKBox('Unsupported AU type for the time being.');
          Seek(InFile,HdrSize);
     End
     else Seek(InFile,0);
End;

Procedure LoadFileProc;
Var
   i,
   j,
   DHandle      :Word;
   OrgSize,
   Size         :LongInt;
   Free         :LongInt;
   Page         :Word;
   SmpPtr       :LongInt;
   Percent      :Byte;
   LastPercent  :Byte;
Begin
     IsItAU := False;
     {$I-}
     ChDir(CurrentPath);
     Assign(InFile,LoadFile);
     FileMode := 0;
     Reset(InFile,1);
     {$I+}
     DummyByte := IOResult;
     if DummyByte <> 0 then
        OKBox('Unable to open '+CurrentPath+LoadFile+' [IOresult:'+S(DummyByte,2,False)+']')
     else
     Begin
          Asm                   { Get unallocated page count }
             mov ah,42h
             int 67h
             mov FreeEMS,bx
          End;
          Size := FileSize(InFile);
          if SampleInfo[ActiveSample].Length <> 0 then
             FreeEms := FreeEms + (SampleInfo[ActiveSample].Length div (16*KB))+1;
          Free := FreeEms*16;
          Free := Free*KB;
          if ((Size > Free) and (Not EMSFit)) or (Free = 0) then
          Begin
             OKBox('Not enough memory to load file.');
             Canceled := False;
             Okay := False;
          End
          else
          Begin
               Opened := True;
               if Size > Free then
               Begin
                    Size := Free-(16*KB);  { EMSFit = True }
                    OKBox('Not enough EMS.Fitting.');
               End;
               if SampleInfo[ActiveSample].Length <> 0 then
               Begin
                    DHandle := SampleInfo[ActiveSample].EMSHandle;
                    Asm
                       mov ah,45h
                       mov dx,DHandle
                       int 67h
                       mov rc,ax
                    End;
                    if hi(rc) <> 0 then
                    Begin
                         CloseGraph;
                         WriteLn('Unable to free allocated memory.');
                         Halt;
                    End;
               End;
               Dhandle := (Size div (16*KB))+1;
               Asm
                  mov ah,43h
                  mov bx,DHandle
                  int 67h
                  mov rc,ax
                  mov DHandle,dx
               End;
               if hi(rc) <> 0 then
               Begin
                    CloseGraph;
                    WriteLn('Unable to allocate requested memory.');
                    WriteLn(Free,' ',Size);
                    Halt;
               End;
               if Pos('.',LoadFile) <> 0 then
                  SampleInfo[ActiveSample].Name := Left(LoadFile,Pos('.',LoadFile))
               else
                  SampleInfo[ActiveSample].Name := LoadFile;
               SampleInfo[ActiveSample].EMSHandle := DHandle;
               Sampleinfo[ActiveSample].Pos    := 0;
               SampleInfo[ActiveSample].Volume := DefaultVolume;
               SampleInfo[ActiveSample].Twin   := DefaultTwin;
               SampleInfo[ActiveSample].BlockStart := 0;

               SampleInfo[ActiveSample].Rate   := DefaultRate;
               SampleInfo[ActiveSample].Signed := False;

               SampleInfo[ActiveSample].Zoomed := False;

               Signed     := SampleInfo[ActiveSample].Signed;
               if signed then _signed := 1 else _signed := 0;

               ButtonTree^[SampleBase+ActiveSample-1,0].Text := SampleInfo[ActiveSample].Name;
               Page := 0;
               FileBuffer := Ptr(EMSBase,0);
               OrgSize := Size;
               StatusBox('Loading...',0);
               Asm {Cli}End;
               if Pos('.WAV',LoadFile) <> 0 then LoadWAV;
               if Pos('.AU',LoadFile) <> 0 then LoadAU;
               Size := Size - FilePos(InFile);
               SampleInfo[ActiveSample].Length := Size;
               SampleInfo[ActiveSample].BlockEnd := Size;
               For DummyWord := 1 to (SIZE div (64*KB)) do
               Begin
                    Asm
                       push bp
                       push sp
                       mov ah,44h
                       mov al,0
                       mov bx,page
                       mov dx,Dhandle
                       push ax
                       push bx
                       push dx
                       int 67h          { Page 0 }
                       pop dx
                       pop bx
                       pop ax
                       inc al
                       inc bx
                       push ax
                       push bx
                       push dx
                       int 67h          { Page 1 }
                       pop dx
                       pop bx
                       pop ax
                       inc al
                       inc bx
                       push ax
                       push bx
                       push dx
                       int 67h          { Page 2 }
                       pop dx
                       pop bx
                       pop ax
                       inc al
                       inc bx
                       int 67h          { Page 3 }
                       pop sp
                       pop bp
                   End;
                   BlockRead(InFile,FileBuffer^,$FFFF);
                   if IsItAU then ConvertUlaw(EMSBASE,0,$FFFF);
                   Size := Size - (64*KB);
                   page := page + 4;
                   Percent := 100-(Size div (OrgSize div 100));
                   if (Percent > 0) and (Percent < 100) then
                      StatusBox('Loading...',Percent);
               End;
               Asm
                  push bp
                  push sp
                  mov ah,44h
                  mov al,0
                  mov bx,page
                  mov dx,Dhandle
                  push ax
                  push bx
                  push dx
                  int 67h          { Page 0 }
                  pop dx
                  pop bx
                  pop ax
                  inc al
                  inc bx
                  push ax
                  push bx
                  push dx
                  int 67h          { Page 1 }
                  pop dx
                  pop bx
                  pop ax
                  inc al
                  inc bx
                  push ax
                  push bx
                  push dx
                  int 67h          { Page 2 }
                  pop dx
                  pop bx
                  pop ax
                  inc al
                  inc bx
                  int 67h          { Page 3 }
                  pop sp
                  pop bp
              End;
              if size > 0 then
              Begin
                   BlockRead(InFile,FileBuffer^,Size);
                   if IsItAu then ConvertUlaw(EMSBASE,0,Size);
              End;
              if StatusBoxActive then
                 StatusBox('Loading...',100);
              Asm{Sti}End;
               i := ActiveSample div 7;
               j := ActiveSample - (i*7);
               if j = 0 then
               Begin
                    j := 7;
                    dec(i);
               End;
               BoxPrint(9*(j-1)*CharW,(CharH*6)+i*CharH*2,
               SampleInfo[ActiveSample].Name,8,Yellow+31,Blue,SampleInfo[ActiveSample].Active);
               if (device <> 1) then
               Begin
                    _maxcntr := 1;
                    volume := 1;
               End;
               if (device = 1) then
               Begin
                    _maxcntr := 3;
                    if Rate > 10000 then _maxcntr := 2;
                    if Rate > 25000 then _maxcntr := 1;
               End;
               cntr1 := False;
               cntr2 := False;
               cntr3 := False;
               Case _maxcntr of
                    1 : Cntr1 := True;
                    2 : Cntr2 := True;
                    3 : Cntr3 := True;
               End;
               SampleInfo[ActiveSample].Rate := Rate;
               Twin       := SampleInfo[ActiveSample].Twin;
               Volume     := SampleInfo[ActiveSample].Volume;
               SampleLen  := SampleInfo[ActiveSample].Length;
               BlockStart := SampleInfo[ActiveSample].BlockStart;
               BlockEnd   := SampleInfo[ActiveSample].BlockEnd;
               Position   := SampleInfo[ActiveSample].Pos;
               SampleInfo[ActiveSample].Cntr   := _maxCntr;
          End;
          Close(InFile);
     End;
End;

Procedure LoadFileDelete;
Var
   F    :File;
   OFptr : Word;
Begin
     if LoadFile <> '' then
     Begin
          if ASKBox('Deleting '+LoadFile+' !.Are you sure ?') then
          Begin
               Assign(F,LoadFile);
               Erase(F);
               LoadFile := '';
               OFptr := Fptr;
               LoadGetfileTree;
               Fptr := OFptr;
               LoadShowFiles;
               VRestoreMouse;
          End;
          VPutMouse;
     End;
     ButtonPos := False;
End;

Procedure LoadEMSFit;
Begin
     if EMSFit then EMSFit := False else EMSFit := True;
     BoxPrint(lx2-CharW*9,ly1+CharH*11,'EMS Fit'       ,7,Blue+31 ,Turquise,EMSFit);
     vputmouse;
     ButtonPos := EMSFit;
End;

Procedure Load;
Var
   OldTreePtr  : Byte;
   LoadIt      : Boolean;
Begin
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     Begin
          Opened :=False;
          OldSelected := $FFFF;
          LoadIt := TRUE;
          if SampleInfo[ActiveSample].Length <> 0 then
               LoadIt := ASKBox('Cell is already occupied.Dou you really want to load ?');
          if LoadIt then
          Begin
               Bussy;
               PushMouse;
               LoadFile := '';
               lx1 := HALFMAXX-CharW*(20);
               lx2 := HALFMAXX+CharW*(21);
               ly1 := HALFMAXY-CharH*12;
               ly2 := HALFMAXY+CharH*12;
               SaveScreen(lx1,ly1,lx2,ly2);
               MsgBox(lx1,ly1,lx2,ly2,Blue,Blue+16);
               Inc(TreeLevel);
               OldTreePtr := TreePtr[TreeLevel];
               Okay     := False;
               Canceled := False;
               SetColor(Black+16);
               OutTextXY(lx1+CharW,ly1+CharH,'Directory: ');
               OutTextXY(lx1+CharW,ly1+CharH*2,'Filename : ');
               OutTextXY(lx1+CharW,ly1+CharH*3,'Pattern  : ');

               RegisterWindow(lx1+CharW,ly1+CharH  ,lx2-CharW   ,ly1+CharH*2,LoadSetDirectory);
               RegisterWindow(lx1+CharW,ly1+CharH*2,lx2-CharW   ,ly1+CharH*3,LoadSetFileHand );
               RegisterWindow(lx1+CharW,ly1+CharH*3,lx2-CharW   ,ly1+CharH*4,LoadSetPattern  );
               RegisterWindow(lx1+CharW,ly1+CharH*5,lx1+CharW*20,ly2-CharH  ,LoadSetFile     );

               ButtonPrint(lx2-CharW*17,ly1+CharH*5 ,'Default Path ' ,15,Black,Green ,False,LoadDefaultPath ,NoNo);
               ButtonPrint(lx2-CharW*17,ly1+CharH*8 ,'Set as Default',15,Black,Green ,False,LoadSetDefault  ,NoNo);
               ButtonPrint(lx2-CharW*17,ly2-CharH*3,'OK'             ,7,Black,Gray ,False,Ok              ,NoNo);
               ButtonPrint(lx2-CharW*9,ly2-CharH*3 ,'CANCEL'         ,7,Black,Gray ,False,Cancel          ,NoNo);
               ButtonPrint(lx1+CharW*21,ly1+CharH*5 ,Chr(30)         , 1,Black+31,Blue,False,LoadFptrUp      ,NoNo);
               ButtonPrint(lx1+CharW*21,ly2-CharH*3 ,Chr(31)         , 1,Black+31,Blue,False,LoadFptrDown    ,NoNo);
               ButtonPrint(lx1+CharW*21,ly1+CharH*8 ,Chr(24)         , 1,Black+31,Blue,False,LoadFPtrTop     ,NoNo);
               ButtonPrint(lx1+CharW*21,ly2-CharH*6 ,Chr(25)         , 1,Black+31,Blue,False,LoadFPtrBot     ,NoNo);
               ButtonPrint(lx1+CharW*21,ly2-CharH*11,''             , 1,Black+31,Blue,False,LoadFPtrMid     ,NoNo);
               ButtonPrint(lx2-CharW*17,ly1+CharH*11,'Delete'        ,7,Black+31,Red ,False,LoadFileDelete  ,NoNo);
               ButtonPrint(lx2-CharW*9 ,ly1+CharH*11,'EMS Fit'       ,7,Blue+31 ,Turquise,EMSFit,LoadEMSFit  ,NoNo);
               LoadGetFileTree;
               LoadShowInfo;
               vrestoremouse;
               vsetmousecoor(lx2-CharW*9,ly2-CharH*3);
               NotBussy;
               While Not ((Opened) or (Canceled)) do
               Begin
                    Okay := False;
                    Canceled := False;
                    Repeat
                          if ProcNo = 2 then
                          Begin
                               Bussy;
{
                               MainProc[ProcNo];
                               MainProc[ProcNo] := Nothing;
                               ProcNo := 1;
}
                               Kernel;
                               LoadShowInfo;
                               VRestoreMouse;
                               NotBussy;
                          End;
                    Until (Okay) or (Canceled);
                    Bussy;
                    if (Okay) and (LoadFile <> '') then LoadFileProc;
                    NotBussy;
               End;
               Bussy;
               TreePtr[TreeLevel] := OldTreePtr;
               Dec(TreeLevel);
               RestoreScreen;
               Analyser;
               ShowSampleInfo;
               PopMouse;
               NotBussy;
          End;
     End;
     ButtonPos := False;
End;