Unit Resource;

Interface

Uses Crt,Dos,windows,global,input,hdbf;

Procedure Create_Resource(fname:string);
Function  Load_Resource(fname:string):boolean;
Function  Read_Resource(id:longint):boolean;
Function  Read_Dialog(fname:string):boolean;
Procedure Initialize_Resource_Handler;
Function  Write_Dialog(fname:string;dlg:handle_dialog):boolean;
Function  Exists(fname:string):boolean;
Procedure Save_Resource(fname:string);

Function  Write_Table(fname:string;dbf:handle_dbf_object):Boolean;
Function  Read_Table(fname:string):boolean;
Procedure Pack_Header(fname:string);
Procedure Resource_Done;


Const
  Major_Version_Num = 1;
  Minor_Version_Num = 0;

Type
    Resource_Header_Type = Record
                             bor : array[1..45] of byte;
                             ID : string[6];
                             Major_Version,
                             Minor_Version : Word;
                             Mode : Byte;
                             Serialnum : String[20];
                             Index_Start : Longint;
                             Chunk_Start : Longint;
                             Num_chunks : word;
                           end;

    Index_Type = Array[1..750] of
                 Record
                   ID : Longint;
                   Title : string[60];
                   Fileposition : Longint;
                   Filename : string[8];
                 end;

    Chunk_Type = Record
                   id : longint;
                   restype : string[6];
                   chunksize : longint;
                 end;


{$I RESTYPES}  {Type Defs of ALL Resource and Dialog Box Chunks!}

Var
  Resource_Loaded : Boolean;
  Resource_Header : ^Resource_Header_Type;
  Resource_Index  : ^Index_Type;
  Resource_Chunk  : Chunk_Type;
  Resource_Name   : string;
  TSPHEADER       : string[45];
  res_data        : pbyte;
  res_start       : pbyte;
  res_file        : file;
  cur_res_pos     : longint;
  res_size        : longint;
  cur_res_size    : longint;

Implementation

{$I INPUT.INC}

Procedure Deallocate_Resource_mem;
Begin
  dispose(resource_header);
  dispose(resource_index);
  resource_header := nil;
  resource_index := nil;
  resource_loaded := false;
  resource_name := '';
end;

Procedure Allocate_Resource_Mem;
Begin
  if (resource_header<>nil) then deallocate_resource_mem;
  new(resource_header);
  new(resource_index);
  resource_loaded := false;
  resource_name := '';
end;

Function Exists(fname:string):boolean;
var
 f : file;
Begin
 {$I-}
   assign(f,fname);
   reset(f,1);
   if IORESULT>0 then exists := false else
     Begin
       exists := true;
       close(f);
     end;
 {$I+}
end;

{Creates a new resource file}
Procedure Create_Resource(fname:string);
var
 f : file;
Begin
 Allocate_Resource_Mem;
 Resource_name := fname+'.RES';
 with resource_header^ do
   Begin
     move(tspheader[1],bor[1],45);
     id := 'TSPRES';
     major_version := major_version_num;
     minor_version := minor_version_num;
     mode := 101;
     serialnum := '000-000-000-000-00000';
     Index_Start := sizeof(resource_header^);
     Chunk_Start := sizeof(resource_header^)+sizeof(resource_index^);
     num_chunks := 0;
   end;
 fillchar(resource_index^,sizeof(resource_index^),0);
 assign(f,resource_name);
 rewrite(f,1);
 blockwrite(f,resource_header^,sizeof(resource_header^));
 blockwrite(f,resource_index^,sizeof(resource_index^));
 close(f);
 resource_loaded := true;
end;

Procedure Save_Resource(fname:string);
var
 f : file;
 f2 : file;
 x : integer;
 buffer : array[1..2048] of byte;
 br : word;
 dhdr : string[6];
Begin
 Resource_name := fname;
 assign(f,resource_name);
 rewrite(f,1);
 blockwrite(f,resource_header^,sizeof(resource_header^));
 blockwrite(f,resource_index^,sizeof(resource_index^));
 for x := 1 to 750 do
   with resource_index^[x] do
   Begin
     if (id>0) then
      Begin
       if (exists('\RESEDIT\DIALOG\'+filename+'.DLG')) then
       Begin
         resource_chunk.id := id;
         resource_chunk.restype := 'TSPDLG';
         fileposition := filepos(f);
         assign(f2,'\RESEDIT\DIALOG\'+filename+'.DLG');
         reset(f2,1);
         resource_chunk.id := id;
         resource_chunk.chunksize := filesize(f2)-sizeof(dhdr);
         blockwrite(f,resource_chunk,sizeof(resource_chunk));
         blockread(f2,dhdr,sizeof(dhdr),br);
         if (br<>sizeof(dhdr)) or (dhdr<>'TSPDLG') then
           Begin
             message_box('Save Resource','Invalid Dialog ('+itos(id)+')',OK,standard_close_dialog,0);
             close(f);
             close(f2);
             exit;
           end;
         repeat
           blockread(f2,buffer,2048,br);
           if (br>0) then blockwrite(f,buffer,br);
         until (br=0);
         close(f2);
       end else
       if (exists('\RESEDIT\DBF\'+filename+'.TBL')) then
        Begin
          resource_chunk.id := id;
          fileposition := filepos(f);
          assign(f2,'\RESEDIT\DBF\'+filename+'.TBL');
          reset(f2,1);
          resource_chunk.id := id;
          resource_chunk.restype := 'TSPDBF';
          resource_chunk.chunksize := filesize(f2)-sizeof(dhdr);
          blockwrite(f,resource_chunk,sizeof(resource_chunk));
          blockread(f2,dhdr,sizeof(dhdr),br);
          if (br<>sizeof(dhdr)) or (dhdr<>'TSPDBF') then
            Begin
              message_box('Save Resource','Invalid Table ('+itos(id)+')',OK,standard_close_dialog,0);
              close(f);
              close(f2);
              exit;
            end;
          repeat
            blockread(f2,buffer,2048,br);
            if (br>0) then blockwrite(f,buffer,br);
          until (br=0);
          close(f2);
        end;
     end;
   end;
 reset(f,1);
 blockwrite(f,resource_header^,sizeof(resource_header^));
 blockwrite(f,resource_index^,sizeof(resource_index^));
 close(f);
 resource_loaded := true;
end;

Function validate_resource_header(br:word):boolean;
Begin
  validate_resource_header := false;
  if (br<>sizeof(resource_header^)) then exit;
  if (resource_header^.id<>'TSPRES') then exit;
  if (resource_header^.major_version>major_version_num) then exit;
  if (resource_header^.index_start<>br) then exit;
  validate_resource_header := true;
end;

{Loads in an existing resource file}
Function Load_Resource(fname:string):boolean;
var
 f : file;
 br : word;
 x : integer;
Begin
  Load_Resource := false;
  Resource_name := fname;
  if not exists(resource_name) then exit;
  Allocate_Resource_Mem;
  Resource_name := fname;
  assign(f,resource_name);
  reset(f,1);
  blockread(f,resource_header^,sizeof(resource_header^),br);
  if not(validate_resource_header(br)) then exit;
  blockread(f,resource_index^,sizeof(resource_index^),br);
  if (br<>sizeof(resource_index^)) then exit;
  resource_loaded := true;
  close(f);
  load_resource := true;
  resource_loaded := true;

  {Clear up duplicate ID's}
  for x := 1 to 750 do
      if (resource_index^[x].id>mbox) then mbox := resource_index^[x].id;

end;


Function B:byte;
Begin
  if cur_res_size=0 then
    Begin
      if res_size>8192 then
        Begin
          blockread(res_file,res_start^,8192);
          res_data := res_start;
          cur_res_size := 8192;
          cur_res_pos := 1;
        end else
        Begin
          blockread(res_file,res_start^,res_size);
          res_data := res_start;
          cur_res_size := res_size;
          cur_res_pos := 1;
        end;
    end;
  b := res_data^;
  dec(res_size);
  dec(cur_res_size);
  inc(res_data);
  inc(cur_res_pos);
end;

Function Get_Char:char;
Begin
  Get_Char := chr(b);
end;

Function Get_Byte:byte;
Begin
  Get_Byte := b;
end;

Function Get_Integer:Integer;
var
 i : integer;
Begin
  i := b;
  i := i + (b shl 8);
  Get_Integer := i;
end;

Function Get_Word:Word;
var
 i : word;
Begin
  i := b;
  i := i + (b shl 8);
  Get_Word := i;
end;

Function Get_Longint:Longint;
var
 l : longint;
Begin
  l := get_word*65536+get_word;
  Get_Longint := l;
end;

Function Get_String(sl:byte):string;
var
 x : byte;
 s : string;
Begin
  get_string := '';
  if sl=0 then exit;
  s[0] := get_char;
  for x := 1 to sl do
    s[x] := get_char;
  get_string := s;
end;

Function Get_SOC:Boolean;
var
 s : string[3];
Begin
 s := get_string(3);
 if s='SOC' then get_soc := true else
    get_soc := false;
end;

Function Get_EOC:Boolean;
var
 s : string[3];
Begin
 s := get_string(3);
 if s='EOC' then get_eoc := true else
    get_eoc := false;
end;

Function Get_Chunktype:string;
var
 s : string[11];
Begin
 get_chunktype := get_string(11);
end;

Procedure Get_Dialog;
var
 rdt : ^resource_dialog_type;
Begin
  new(rdt);
  with rdt^ do
    Begin
      id            := get_longint;
      dtype         := get_byte;
      name          := get_string(60);
      xpos          := get_integer;
      ypos          := get_integer;
      xpos1         := get_integer;
      ypos1         := get_integer;
      x1            := get_integer;
      y1            := get_integer;
      x2            := get_integer;
      y2            := get_integer;
      flags         := get_byte;
      horz_sb       := get_longint;
      vert_sb       := get_longint;
      minimize_func := get_longint;
      maximize_func := get_longint;
      close_func    := get_longint;
      help_func     := get_longint;
      inclientfunct := get_longint;
      z             := get_byte;
      Create_Dialog(id,name,xpos,ypos,xpos1,ypos1,dtype,flags,help_func,minimize_func,maximize_func,close_func,inclientfunct,
                    horz_sb,vert_sb,0,0);
   end;
 dispose(rdt);
end;

Procedure Get_Bmp;
var
 rsb : ^resource_bmp_list;
Begin
 new(rsb);
     with rsb^ do
       Begin
         id := get_longint;
         xpos := get_integer;
         ypos := get_integer;
         width := get_integer;
         height := get_integer;
         puttype := get_byte;
         fname := get_string(255);
         funcnum := get_longint;
         add_bmp(id,cur_dialog,xpos,ypos,puttype,fname,0);
       end;
  dispose(rsb);
end;

Procedure Get_Listbox_Item;
var
  rmit : ^resource_listbox_item;
Begin
  new(rmit);
  rmit^.ref := get_longint;
  rmit^.data := get_string(255);
  rmit^.maxlength := get_integer;
  rmit^.selected := get_byte=1;
  add_listbox_item(cur_dialog^.cur_lb,rmit^.data,rmit^.maxlength,rmit^.ref);
  dispose(rmit);
end;

Procedure Get_listbox;
var
 rmt : ^resource_listbox_type;
 hsb : handle_scrollbar;
Begin
 new(rmt);
     with rmt^ do
       Begin
         id := get_longint;
         xpos := get_integer;
         ypos := get_integer;
         xpos1 := get_integer;
         ypos1 := get_integer;
         title := get_string(60);
         horz_sb := get_longint;
         vert_sb := get_longint;
         numitems := get_longint;
         data_field := get_longint;
         first_item := get_longint;
         last_item := get_longint;
         cur_item := get_longint;
         selected := get_longint;
         selectfunc := get_longint;
         inclientfunct := get_longint;

         if (horz_sb>0) then
           Begin
             hsb := get_handle_scrollbar(horz_sb);
             delete_scrollbar(cur_dialog,hsb);
           end;
         if (vert_sb>0) then
           Begin
             hsb := get_handle_scrollbar(vert_sb);
             delete_scrollbar(cur_dialog,hsb);
           end;

         if data_field>0 then
         add_listbox(id,cur_dialog,title,xpos,ypos,xpos1,ypos1,
                     horz_sb,vert_sb,selectfunc,get_handle_data(data_field),inclientfunct) else
         add_listbox(id,cur_dialog,title,xpos,ypos,xpos1,ypos1,
                     horz_sb,vert_sb,selectfunc,nil,inclientfunct);
      end;
  dispose(rmt);
end;

Procedure Get_Data;
var
 rsb : ^resource_data_type;
Begin
 new(rsb);
  rsb^.id := get_longint;
  rsb^.xpos := get_integer;
  rsb^.ypos := get_integer;
  rsb^.x1   := get_integer;
  rsb^.y1   := get_integer;
  rsb^.x2   := get_integer;
  rsb^.y2   := get_integer;
  rsb^.name := get_string(30);
  rsb^.fieldtype := get_byte; {0-255}
  rsb^.MaxLength := get_word;
  rsb^.fieldwidth := get_byte;
  rsb^.required := get_byte=1;
  rsb^.funcnum := get_longint;
  rsb^.data := get_string(255);
  rsb^.fieldname := get_string(11);
  rsb^.db_ftype := get_byte;
  rsb^.dbf_id := get_longint;

  if rsb^.dbf_id=0 then rsb^.dbf_id := unique_id;
  if rsb^.fieldwidth<1 then rsb^.fieldwidth := 6;
  if rsb^.maxlength<1 then rsb^.maxlength := 6;
  if not (rsb^.fieldtype in [1,2,241..255]) then rsb^.fieldtype := 241;

  if (rsb^.fieldtype=DB_EDIT) or (rsb^.fieldtype=DB_TEXT) then
  Add_Data(rsb^.id,cur_dialog,rsb^.xpos,rsb^.ypos,rsb^.required,
           rsb^.fieldwidth,rsb^.maxlength,rsb^.fieldtype,rsb^.name,
           '['+itos(rsb^.dbf_id)+';'+rsb^.fieldname+';'+itos(rsb^.db_ftype)+']',
           rsb^.funcnum) else
  Add_Data(rsb^.id,cur_dialog,rsb^.xpos,rsb^.ypos,rsb^.required,
           rsb^.fieldwidth,rsb^.maxlength,rsb^.fieldtype,rsb^.name,rsb^.data,
           rsb^.funcnum);
  dispose(rsb);
end;

Procedure Get_Scrollbar;
var
 rsb : ^resource_scrollbar_list;
 hsb : handle_scrollbar;
Begin
 new(rsb);
  with rsb^ do
       Begin
         id := get_longint;
         xpos := get_integer;
         ypos := get_integer;
         xpos1 := get_integer;
         ypos1 := get_integer;
         min := get_longint;
         max := get_longint;
         step := get_longint;
         jump := get_longint;
         curpos := get_longint;
         curpixpos := get_integer;
         changed := get_byte=1;
         amount := get_longint;
         funcnum := get_longint;
         horv := get_byte;
         hsb := get_handle_scrollbar(id);
         if (hsb=nil) then
         Begin
           if horv=horz then
             add_scrollbar(id,cur_dialog,xpos,ypos,xpos1-xpos,min,max,curpos,step,jump,horv,funcnum) else
             add_scrollbar(id,cur_dialog,xpos,ypos,ypos1-ypos,min,max,curpos,step,jump,horv,funcnum);
         end;
       end;
  dispose(rsb);
end;

Procedure Get_Button;
var
 rsb : ^resource_Button_list;
Begin
 new(rsb);
     with rsb^ do
       Begin
         id      := get_longint;
         xpos    := get_integer;
         ypos    := get_integer;
         btype   := get_byte;
         state   := get_byte;
         btext   := get_string(30);
         funcnum := get_longint;
         enabled := get_byte=1;
         hbmp := get_longint;
         add_button(id,cur_dialog,xpos,ypos,btype,btext,hbmp,enabled,funcnum);
       end;
  dispose(rsb);
end;

Procedure Get_Client;
var
 rsb : ^resource_Client_list;
Begin
 new(rsb);
     with rsb^ do
       Begin
         id      := get_longint;
         xpos    := get_integer;
         ypos    := get_integer;
         xpos1    := get_integer;
         ypos1    := get_integer;
         width := get_word;
         height := get_word;
         speed := get_longint;
         nexttime := get_longint;
         add_client(id,cur_dialog,xpos,ypos,width,height,speed);
       end;
  dispose(rsb);
end;

Procedure Get_Callback;
var
 rsb : ^resource_callback_list;
Begin
 new(rsb);
     with rsb^ do
       Begin
         id       := get_longint;
         speed    := get_longint;
         nexttime := get_longint;
         funcnum  := get_longint;
         add_callback(id,cur_dialog,funcnum,speed);
       end;
  dispose(rsb);
end;

Procedure Get_Accelerator;
var
 rsb : ^resource_accelerator_list;
Begin
 new(rsb);
     with rsb^ do
       Begin
         id      := get_longint;
         functionkey := get_byte;
         character   := get_byte;
         funcnum     := get_longint;
         add_accelerator(id,cur_dialog,functionkey,character,funcnum);
       end;
  dispose(rsb);
end;

Procedure Get_Text;
var
 rsb : ^resource_Text_data;
Begin
 new(rsb);
     with rsb^ do
       Begin
         id      := get_longint;
         xpos    := get_integer;
         ypos    := get_integer;
        color    := get_byte;
     textdata    := get_string(80);
      funcnum    := get_longint;
       add_text (id,cur_dialog,xpos,ypos,textdata,funcnum);
       end;
 dispose(rsb);
end;

Procedure Get_Checkbox;
var
 rsb : ^resource_Checkbox_list;
Begin
 new(rsb);
         rsb^.id      := get_longint;
         rsb^.xpos    := get_integer;
         rsb^.ypos    := get_integer;
      rsb^.enabled    := get_byte=1;
     rsb^.selected    := get_byte=1;
         rsb^.data    := get_string(255);
      rsb^.funcnum    := get_longint;
     add_checkbox(rsb^.id,cur_dialog,rsb^.xpos,rsb^.ypos,rsb^.data,rsb^.enabled,
                  rsb^.selected,rsb^.funcnum);
  dispose(rsb);
end;

Procedure Get_Menu_Item;
var
  rmit : ^resource_menu_item;
Begin
  new(rmit);
  with (rmit^) do
  Begin
    id := get_longint;
    name := get_string(30);
    funcnum := get_longint;
    highlight := get_byte=1;
    add_menu_item(id,cur_dialog^.cur_menu,name,funcnum);
  end;
  dispose(rmit);
end;

Procedure Get_Menu;
var
 rmt : ^resource_menu_list;
Begin
 new(rmt);
     with rmt^ do
       Begin
         name := get_string(20);
         first_item := get_longint;
         last_item := get_longint;
         cur_item := get_longint;
         highlight := get_byte=1;
         xpos1 := get_word;
         xpos2 := get_word;
         width := get_integer;
         height:= get_byte;
         add_menu(cur_dialog,name);
       end;
  dispose(rmt);
end;

Procedure Get_DBF;
var
 x : word;
 rmt : ^resource_dbf_object;
Begin
 new(rmt);
     with rmt^ do
       Begin
         id          := get_longint;
         filename    := get_string(255);
         numindexes  := get_byte;
         for x := 1 to maxindexes do
                        Begin
                          indexes[x].filename  := get_string(255);
                          indexes[x].indexedby := get_string(255);
                        end;
         privilege  := get_longint;
         fileopen   := (get_byte=1);
         fullindex  := get_string(255);
         curindex   := get_byte;
         status     := get_byte;
         gsobarea   := get_byte;
         currecno   := get_longint;
         maxfieldlength:= get_longint;
         maxlength:= get_longint;
         rangestart := get_longint;
         rangeend   := get_longint;
         dlg        := get_longint;
         for x := 1 to 256 do
           Begin
             columndef[x].fieldnum    := get_byte;
             columndef[x].fieldlength := get_byte
           end;
         numcolumns := get_byte;
        end;
 add_dbf(rmt^.id,rmt^.privilege,rmt^.dlg,rmt^.filename,rmt^.maxlength,rmt^.maxfieldlength);
         for x := 1 to 256 do
           Begin
             cur_dbf^.columndef[x].fieldnum    := rmt^.columndef[x].fieldnum;
             cur_dbf^.columndef[x].fieldlength := rmt^.columndef[x].fieldlength;
           end;
         for x := 1 to maxindexes do
                        Begin
                          cur_dbf^.indexes[x].filename  := rmt^.indexes[x].filename;
                          cur_dbf^.indexes[x].indexedby := rmt^.indexes[x].indexedby;
                        end;

         cur_dbf^.numindexes := rmt^.numindexes;
 dispose(rmt);
end;

Procedure Initialize_Reader;
Begin
  getmem(res_data,8192);
  res_start := res_data;
  cur_res_pos := 1;
  cur_res_size := 0;
  res_size    := resource_chunk.chunksize;
end;

Procedure Initialize_Reader2;
Begin
  getmem(res_data,8192);
  res_start := res_data;
  cur_res_pos := 1;
  cur_res_size := 0;
  res_size    := filesize(res_file)-7;
end;

Function Read_Chunk_Data(idx:integer):boolean;
var
 br : word;
 ct : string[11];
 done : boolean;
Begin
  done := false;
  read_chunk_data := false;
  blockread(res_file,Resource_Chunk,sizeof(Resource_Chunk),br);
  if (br<>sizeof(Resource_Chunk)) then exit;
  if (resource_index^[idx].id<>resource_chunk.id) then exit;
  initialize_reader;
  repeat
    if get_soc then
      Begin
        ct := get_chunktype;
        if (ct='DIALOG') then get_dialog else
        if (ct='BITMAP') then get_bmp else
        if (ct='LISTBOXITEM') then get_listbox_item else
        if (ct='LISTBOX') then get_listbox else
        if (ct='DATA') then get_data else
        if (ct='SCROLLBAR') then get_scrollbar else
        if (ct='MENUITEM') then get_menu_item else
        if (ct='MENU') then get_menu else
        if (ct='BUTTON') then get_button else
        if (ct='CLIENT') then get_client else
        if (ct='CALLBACK') then get_callback else
        if (ct='ACCELERATOR') then get_accelerator else
        if (ct='TEXT') then get_text else
        if (ct='CHECKBOX') then get_checkbox else
        if (ct='DTABLE') then  get_dbf else
          message_box('Resource Error','Unsupported Function : '+ct,OK,standard_close_dialog,0);
      end else message_box('Resource Error','No Chunk Data! '+ct,OK,standard_close_dialog,0);
    if not(get_eoc) then
       Begin
         message_box('Resource Error','Invalid Chunk',OK,standard_close_dialog,0);
         freemem(res_start,8192);
         exit;
       end;
  until (res_size=0);
  freemem(res_start,8192);
  read_chunk_data := true;
end;

Function Read_Chunk_Data2:boolean;
var
 br : word;
 ct : string[11];
 done : boolean;
Begin
  done := false;
  read_chunk_data2 := false;
  initialize_reader2;
  repeat
    if get_soc then
      Begin
        ct := get_chunktype;
        if (ct='DIALOG') then get_dialog else
        if (ct='BITMAP') then get_bmp else
        if (ct='LISTBOXITEM') then get_listbox_item else
        if (ct='LISTBOX') then get_listbox else
        if (ct='DATA') then get_data else
        if (ct='SCROLLBAR') then get_scrollbar else
        if (ct='MENUITEM') then get_menu_item else
        if (ct='MENU') then get_menu else
        if (ct='BUTTON') then get_button else
        if (ct='CLIENT') then get_client else
        if (ct='CALLBACK') then get_callback else
        if (ct='ACCELERATOR') then get_accelerator else
        if (ct='TEXT') then get_text else
        if (ct='CHECKBOX') then get_checkbox else
        if (ct='DTABLE') then get_dbf else
          message_box('Resource Error','Unsupported Function : '+ct,OK,standard_close_dialog,0);
      end else message_box('Resource Error','No Chunk Data! '+ct,OK,standard_close_dialog,0);
    if not(get_eoc) then
       Begin
         message_box('Resource Error','Invalid Chunk',OK,standard_close_dialog,0);
         freemem(res_start,8192);
         exit;
       end;
  until (res_size=0);
  freemem(res_start,8192);
  read_chunk_data2 := true;
end;


Function Read_Resource(id:longint):boolean;
var
 x : integer;
 found : integer;
Begin
  Read_Resource := false;
  if not(resource_loaded) then exit;
  if (resource_header^.num_chunks=0) then exit;
  if get_handle_dialog(id)<>nil then
    Begin
      read_resource := true;
      cur_dialog := get_handle_dialog(id);
      exit;
    end;
  found := 0;
  for x := 1 to {(resource_header^.num_chunks)} 750 do
    if resource_index^[x].id=id then found := x;

  if (found=0) then exit;
  if not(found>0) and not(found<751) then exit;
  if (resource_index^[found].fileposition<resource_header^.chunk_start) then exit;

  assign(res_file,resource_name);
  reset(res_file,1);
  seek(res_file,resource_index^[found].fileposition);
  if not(Read_Chunk_Data(found)) then
    Begin
      close(res_file);
      exit;
    end;
  close(res_file);
  setup_accelerators(cur_dialog);
  Read_Resource := true;
end;

Function Read_Dialog(fname:string):boolean;
var
 x : integer;
 hdr : string[6];
Begin
  Read_Dialog := false;
  assign(res_file,fname);
  reset(res_file,1);
  blockread(res_file,hdr,sizeof(hdr));
  if not(hdr='TSPDLG') then
    Begin
      close(res_file);
      message_box('Dialog Error','Corrupt Dialog',OK,standard_close_dialog,0);
      exit;
    end;
  if not(Read_Chunk_Data2) then
    Begin
      close(res_file);
      exit;
    end;
  close(res_file);
  Read_Dialog := true;
end;

Function Read_Table(fname:string):boolean;
var
 x : integer;
 hdr : string[6];
Begin
  Read_table := false;
  assign(res_file,fname);
  reset(res_file,1);
  blockread(res_file,hdr,sizeof(hdr));
  if not(hdr='TSPDBF') then
    Begin
      close(res_file);
      message_box('Table Error','Corrupt Table',OK,standard_close_dialog,0);
      exit;
    end;
  if not(Read_Chunk_Data2) then
    Begin
      close(res_file);
      exit;
    end;
  close(res_file);
  Read_table := true;
end;

Procedure Initialize_Resource_Handler;
var
 resname : string;
 x : integer;
 wx,wy : byte;
 num_total : word;
 num_loaded: word;
Begin
  coff;
  writeln('WOS Resource Subsytem');
  writeln('Copyright (C) 1997 Trilliun Software Products');

  resname := paramstr(1);
  if length(resname)>0 then
    for x := 1 to length(resname) do resname[x] := upcase(resname[x]);
  if pos('.',resname)>0 then
      delete(resname,pos('.',resname),length(resname));
  resname := resname+'.RES';
  if not(Load_Resource(resname)) then
    Begin
      writeln('Error Loading Resource Header From : '+resname);
      con;
      halt;
    end;

  write ('Loading Resource(s) : ');
  wx := wherex;
  wy := wherey;

  num_loaded := 0;
  num_total := 0;

if resource_header^.num_chunks>0 then
for x := 1 to {resource_header^.num_chunks} 750 do
 Begin
   if (read_resource(resource_index^[x].id)) then inc(num_loaded);
   inc(num_total);
   gotoxy(wx,wy);
   write(num_loaded,'/',resource_header^.num_chunks,'   ');
 end;
 writeln;
con;
end;

Function Write_Dialog(fname:string;dlg:handle_dialog):boolean;
type
 string20 = string[11];
var
 f : file;
 dlghdr : string[6];
 hsb : handle_scrollbar;
 rdt : ^resource_dialog_type;

Function Write_EOC:Boolean;
var
 eoc : string[3];
 bw : word;
Begin
  eoc := 'EOC';
  blockwrite(f,eoc,sizeof(eoc),bw);
  if bw<>sizeof(eoc) then write_eoc := false else write_eoc := true;
end;


Function Write_Chunk(chunktype:string20;address:pointer;size:word;write_eoc:boolean):Boolean;
var
 bw : word;
 soc : string[3]; {Start of Chunk}
 eoc : string[3]; {End of Chunk}
Begin
  write_chunk := false;
  soc := 'SOC';
  blockwrite(f,soc,sizeof(soc),bw);
  if bw<>sizeof(soc) then exit;
  blockwrite(f,chunktype,sizeof(chunktype),bw);
  if bw<>sizeof(chunktype) then exit;
  blockwrite(f,address^,size,bw);
  if (bw<>size) then exit;
  if (write_eoc) then
   Begin
     eoc := 'EOC';
     blockwrite(f,eoc,sizeof(eoc),bw);
    if bw<>sizeof(eoc) then exit;
   end;
  write_chunk := true;
end;

Function Bmp_Res:Boolean;
var
 rsb : ^resource_bmp_list;
 this : handle_bmp;
 tmp : pbyte;
 br,bw : word;
 f2 : file;
 done : boolean;
Begin
 bmp_res := false;
 new(rsb);
 this := dlg^.first_bmp;
 getmem(tmp,4096);
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id := this^.id;
         xpos := this^.xpos;
         ypos := this^.ypos;
         width := this^.width;
         height := this^.height;
         puttype := this^.puttype;
         fname := this^.fname;
         funcnum := this^.funcnum;
       end;
         if not(write_chunk('BITMAP',rsb,sizeof(rsb^),true)) or not(exists(rsb^.fname)) then
          Begin
            dispose(rsb);
            close(f);
            freemem(tmp,4096);
            exit;
          end;
        {assign(f2,rsb^.fname);
        reset(f2,1);
        done := false;
        repeat
          blockread(f2,tmp^,4096,br);
          if (br=0) then done := true else
            Begin
              blockwrite(f,tmp^,br,bw);
              if (bw<>br) then done := true;
            end;
        until done;
        close(f2);
        if not (write_eoc) then
          Begin
            dispose(rsb);
            freemem(tmp,4096);
            exit;
          end;}
     this := this^.next;
   end;
  dispose(rsb);
  freemem(tmp,4096);
  bmp_res := true;
end;


Function Listbox_Item_Res(hmi:lt):Boolean;
var
  rmit : ^resource_listbox_item;
Begin
  new(rmit);
  with (rmit^) do
  Begin
    ref := hmi^.ref;
    data := hmi^.data.pstr;
    maxlength := hmi^.maxlength;
    selected := hmi^.selected;
  end;
 if not(write_chunk('LISTBOXITEM',rmit,sizeof(rmit^),true)) then
   Begin
     listbox_item_res := false;
     close(f);
   end else listbox_item_res := true;
  dispose(rmit);
end;

Function listbox_Res:Boolean;
var
 this : handle_listbox;
 this_li : lt;
 rmt : ^resource_listbox_type;
Begin
 listbox_res := false;
 new(rmt);
 this := dlg^.first_lb;
 while (this<>nil) do
   Begin
     with rmt^ do
       Begin
         id := this^.id;
         xpos := this^.xpos;
         ypos := this^.ypos;
         xpos1 := this^.xpos1;
         ypos1 := this^.ypos1;
         title := this^.title;
         if this^.horz_sb<>nil then
           Begin
             inc(xpos1,15);
             horz_sb := this^.horz_sb^.id
           end else horz_sb := 0;
         if this^.vert_sb<>nil then
           Begin
             inc(ypos1,15);
             vert_sb := this^.vert_sb^.id
           end else vert_sb := 0;
         numitems := this^.numitems;
         if this^.data_field<>nil then data_field := this^.data_field^.id else data_field := 0;
         first_item := 0; last_item := 0; cur_item := 0;
         selected := this^.selected;
         selectfunc := this^.tselectfunc;
         inclientfunct := this^.tinclientfunct;
         if not(write_chunk('LISTBOX',rmt,sizeof(rmt^),true)) then
          Begin
            dispose(rmt);
            close(f);
            exit;
          end;
       end;
       this_li := this^.first_item;
       while (this_li<>nil) do
         Begin
           if not(listbox_item_res(this_li)) then
             Begin
               close(f);
               dispose(rmt);
               exit;
             end;
           this_li := this_li^.next;
         end;
     this := this^.next;
   end;
  dispose(rmt);
  listbox_res := true;
end;


Function Data_Res:Boolean;
var
 rsb : ^resource_data_type;
 this : handle_data;
Begin
 data_res:= false;
 new(rsb);
 this := dlg^.first_data;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id := this^.id;
         xpos := this^.xpos;
         ypos := this^.ypos;
         x1   := this^.x1;
         y1   := this^.y1;
         x2   := this^.x2;
         y2   := this^.y2;
         name := this^.name;
         fieldtype := this^.fieldtype; {0-255}
         MaxLength := this^.maxlength;
         fieldwidth := this^.fieldwidth;
         required := this^.required;
         funcnum := this^.tfuncnum;
         data := this^.data.pstr;
         fieldname := this^.fieldname;
         db_ftype := this^.db_ftype;
         dbf_id := this^.dbf_id;
       end;
         if not(write_chunk('DATA',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  data_res := true;
end;

Function Scrollbar_Res:Boolean;
var
 rsb : ^resource_scrollbar_list;
 this : handle_scrollbar;
Begin
 scrollbar_res := false;
 new(rsb);
 this := dlg^.first_sb;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id := this^.id;
         xpos := this^.xpos;
         ypos := this^.ypos;
         xpos1 := this^.xpos1;
         ypos1 := this^.ypos1;
         min := this^.min;
         max := this^.max;
         step := this^.step;
         jump := this^.jump;
         curpos := this^.curpos;
         curpixpos := this^.curpixpos;
         changed := false;
         amount := this^.amount;
         funcnum := this^.tfuncnum;
         horv := this^.horv;
       end;
         if not(write_chunk('SCROLLBAR',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  scrollbar_res := true;
end;

Function Button_Res:Boolean;
var
 rsb : ^resource_Button_list;
 this : handle_Button;
Begin
 Button_res := false;
 new(rsb);
 this := dlg^.first_button;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id      := this^.id;
         xpos    := this^.xpos;
         ypos    := this^.ypos;
         btype   := this^.btype;
         state   := this^.state;
         btext   := this^.btext.pstr;
         funcnum := this^.tfuncnum;
         enabled := this^.enabled;
         if this^.hbmp<>nil then hbmp := this^.hbmp^.id else hbmp := 0;
       end;
         if not(write_chunk('BUTTON',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  Button_res := true;
end;

Function Client_Res:Boolean;
var
 rsb : ^resource_Client_list;
 this : handle_client;
Begin
 client_res:= false;
 new(rsb);
 this := dlg^.first_client;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id      := this^.id;
         xpos    := this^.xpos;
         ypos    := this^.ypos;
         xpos1    := this^.xpos1;
         ypos1    := this^.ypos1;
         width := this^.width;
         height := this^.height;
         speed := this^.speed;
         nexttime := 0;
       end;
         if not(write_chunk('CLIENT',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  client_res:= true;
end;

Function callback_Res:Boolean;
var
 rsb : ^resource_callback_list;
 this : handle_callback;
Begin
 callback_res:= false;
 new(rsb);
 this := dlg^.first_callback;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id      := this^.id;
         funcnum := this^.tfuncnum;
         speed := this^.speed;
         nexttime := 0;
       end;
         if not(write_chunk('CALLBACK',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  callback_res:= true;
end;

Function Accelerator_Res:Boolean;
var
 rsb : ^resource_accelerator_list;
 this : handle_accelerator;
Begin
 accelerator_res:= false;
 new(rsb);
 this := dlg^.first_accelerator;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id      := this^.id;
         functionkey := this^.functionkey;
         character   := this^.character;
         funcnum     := this ^.tfuncnum;
       end;
         if not(write_chunk('ACCELERATOR',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  accelerator_res:= true;
end;


Function Text_Res:Boolean;
var
 rsb : ^resource_Text_data;
 this : handle_Text;
Begin
 Text_res := false;
 new(rsb);
 this := dlg^.first_Text;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id      := this^.id;
         xpos    := this^.xpos;
         ypos    := this^.ypos;
        color    := this^.color;
     textdata    := this^.textdata;
     funcnum     := this^.tfuncnum;
       end;
         if not(write_chunk('TEXT',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  Text_res := true;
end;

Function Checkbox_Res:Boolean;
var
 rsb : ^resource_Checkbox_list;
 this : handle_Checkbox;
Begin
 Checkbox_res := false;
 new(rsb);
 this := dlg^.first_cb;
 while (this<>nil) do
   Begin
     with rsb^ do
       Begin
         id      := this^.id;
         xpos    := this^.xpos;
         ypos    := this^.ypos;
      enabled    := this^.enabled;
     selected    := this^.selected;
         data    := this^.data.pstr;
      funcnum    := this^.tfuncnum;
       end;
         if not(write_chunk('CHECKBOX',rsb,sizeof(rsb^),true)) then
          Begin
            dispose(rsb);
            close(f);
            exit;
          end;
     this := this^.next;
   end;
  dispose(rsb);
  Checkbox_res := true;
end;


Function Menu_Item_Res(hmi:handle_menu_item):Boolean;
var
  rmit : ^resource_menu_item;
Begin
  new(rmit);
  with (rmit^) do
  Begin
    id := hmi^.id;
    name := hmi^.name;
    funcnum := hmi^.tfuncnum;
    highlight := false;
  end;
 if not(write_chunk('MENUITEM',rmit,sizeof(rmit^),true)) then
   Begin
     menu_item_res := false;
     close(f);
   end else menu_item_res := true;
  dispose(rmit);
end;

Function Menu_Res:Boolean;
var
 this : ml;
 this_mi : handle_menu_item;
 rmt : ^resource_menu_list;
Begin
 menu_res := false;
 new(rmt);
 this := dlg^.first_menu;
 while (this<>nil) do
   Begin
     with rmt^ do
       Begin
         name := this^.name;
         first_item := 0; last_item := 0; cur_item := 0;
         highlight := this^.highlight;
         xpos1 := this^.xpos1;
         xpos2 := this^.xpos2;
         width := this^.width;
         height:= this^.height;
         if not(write_chunk('MENU',rmt,sizeof(rmt^),true)) then
          Begin
            dispose(rmt);
            close(f);
            exit;
          end;
       end;
       this_mi := this^.first_item;
       while (this_mi<>nil) do
         Begin
           if not(menu_item_res(this_mi)) then
             Begin
               close(f);
               dispose(rmt);
               exit;
             end;
           this_mi := this_mi^.next;
         end;
     this := this^.next;
   end;
  dispose(rmt);
  menu_res := true;
end;

Function Dialog_RES:Boolean;
var
 rdt : ^resource_dialog_type;
Begin
 new(rdt);
 with rdt^ do
   Begin
     id          := dlg^.id;
     dtype       := dlg^.dtype;
     name        := dlg^.name;
     xpos        := dlg^.xpos;
     ypos        := dlg^.ypos;
     xpos1       := dlg^.xpos1;
     ypos1       := dlg^.ypos1;
     x1          := dlg^.x1;
     y1          := dlg^.y1;
     x2          := dlg^.x2;
     y2          := dlg^.y2;
     flags       := dlg^.flags;
     if dlg^.horz_sb<>nil then
     horz_sb := dlg^.horz_sb^.id else
     horz_sb := 0;
     if dlg^.vert_sb<>nil then
     vert_sb := dlg^.vert_sb^.id else
     vert_sb := 0;
     minimize_func := dlg^.tminimize_func;
     maximize_func := dlg^.tmaximize_func;
     close_func    := dlg^.tclose_func;
     help_func     := dlg^.thelp_func;
     inclientfunct := dlg^.tinclientfunct;
     z             := dlg^.z;
   end;

 if not(write_chunk('DIALOG',rdt,sizeof(rdt^),true)) then
   Begin
     dialog_res := false;
     close(f);
   end else dialog_res := true;
   dispose(rdt);
end;


Begin
 write_dialog := false;
 if (dlg=nil) then exit;
 assign(f,fname);
 rewrite(f,1);
 dlghdr := 'TSPDLG';
 blockwrite(f,dlghdr,sizeof(dlghdr));

 if not(dialog_res) then exit;  {write dialog}
 if not(bmp_res) then exit;
 if not(data_res) then exit;
 if not(text_res) then exit;
 if not(menu_res) then exit;
 if not(scrollbar_res) then exit;
 if not(listbox_Res) then exit;
 if not(button_res) then exit;
 if not(checkbox_res) then exit;
 if not(client_res) then exit;
 if not(accelerator_res) then exit;

 close(f);
 write_dialog := true;
end;

Function Write_Table(fname:string;dbf:handle_dbf_object):Boolean;
type
 string20 = string[11];
var
 f : file;
 dlghdr : string[6];

Function Write_EOC:Boolean;
var
 eoc : string[3];
 bw : word;
Begin
  eoc := 'EOC';
  blockwrite(f,eoc,sizeof(eoc),bw);
  if bw<>sizeof(eoc) then write_eoc := false else write_eoc := true;
end;

Function Write_Chunk(chunktype:string20;address:pointer;size:word;write_eoc:boolean):Boolean;
var
 bw : word;
 soc : string[3]; {Start of Chunk}
 eoc : string[3]; {End of Chunk}
Begin
  write_chunk := false;
  soc := 'SOC';
  blockwrite(f,soc,sizeof(soc),bw);
  if bw<>sizeof(soc) then exit;
  blockwrite(f,chunktype,sizeof(chunktype),bw);
  if bw<>sizeof(chunktype) then exit;
  blockwrite(f,address^,size,bw);
  if (bw<>size) then exit;
  if (write_eoc) then
   Begin
     eoc := 'EOC';
     blockwrite(f,eoc,sizeof(eoc),bw);
    if bw<>sizeof(eoc) then exit;
   end;
  write_chunk := true;
end;

Function DBF_RES:Boolean;
var
 rdt : ^resource_dbf_object;
 x : word;
Begin
 new(rdt);
 with rdt^ do
   Begin
     id          := dbf^.id;
     filename    := dbf^.filename;
     numindexes  := dbf^.numindexes;
     for x := 1 to maxindexes do
                  Begin
                    indexes[x].filename  := dbf^.indexes[x].filename;
                    indexes[x].indexedby := dbf^.indexes[x].indexedby;
                  end;
     privilege  := dbf^.privilege;
     fileopen   := false;
     fullindex  := dbf^.fullindex;
     curindex   := 0;
     status     := 0;
     gsobarea   := 0;
     currecno   := 0;
     maxfieldlength := 0;
     maxlength  := 0;
     rangestart := 0;
     rangeend   := 0;
     dlg        := dbf^.dlg;
     for x := 1 to 256 do
        Begin
          columndef[x].fieldnum    := dbf^.columndef[x].fieldnum;
          columndef[x].fieldlength := dbf^.columndef[x].fieldlength;
        end;
     numcolumns := dbf^.numcolumns;
   end;

 if not(write_chunk('DTABLE',rdt,sizeof(rdt^),true)) then
   Begin
     dbf_res := false;
     close(f);
   end else dbf_res := true;
   dispose(rdt);
end;

Begin
 write_table := false;
 if (dbf=nil) then exit;
 assign(f,fname);
 rewrite(f,1);
 dlghdr := 'TSPDBF';
 blockwrite(f,dlghdr,sizeof(dlghdr));
 if not(dbf_res) then exit;
 close(f);
 write_table := true;
end;

Procedure Pack_Header(fname:string);
var
 header1 : ^resource_header_type;
 index1,index2 : ^index_type;
 f : file;
 x1,x2 : word;
Begin
 assign(f,Resourcedir+fname+'.RES');
 reset(f,1);
 new(header1); new(index1); new(index2);
 blockread(f,header1^,sizeof(header1^));
 blockread(f,index1^,sizeof(index1^));
 fillchar(index2^,sizeof(index2^),0);
 x2 := 0;
 for x1 := 1 to 750 do
  if index1^[x1].id>0 then
  Begin
    inc(x2);
    index2^[x2].ID := index1^[x1].id;
    index2^[x2].Title := index1^[x1].title;
    index2^[x2].Fileposition := index1^[x1].Fileposition;
    index2^[x2].Filename := index1^[x1].filename;
  end;
 reset(f,1);
 header1^.num_chunks := x2;
 blockwrite(f,header1^,sizeof(header1^));
 blockwrite(f,index1^,sizeof(index1^));
end;

Procedure Resource_Done;
Begin
{  freemem(res_data,8192);}
end;


Begin
  {getmem(res_data,8192);}
  Resource_Loaded := False;
  Resource_Header := nil;
  Resource_Index  := nil;
  Resource_Name   := '';
  TSPHEADER := 'TSP RESOURCE FILE v'+chr(major_version_num+48)+'.'+chr(minor_version_num+48);
{  writeln('Dialog/Resource Extensions v1.0');
  delay(750);}
end.
