Unit skelbrow;

Interface

Uses Windows;

Procedure Deinit_Browser;
Procedure Init_Browser(y1,y2,offset:byte;dbfname,spref:string;fnum,b1,b2,b3,b4,b5,b6,b7,b8:byte;indexname:string;lf:boolean;
                       c1,c2,c3 : byte;
                       fn1,fn2,fn3 : byte;
                       f1,f2,f3 : string);
Procedure Browser(id:byte;fnum:integer;st:string;fnum2:integer;st2:string;fnum3:integer;st3:string;si:byte);
Procedure resetlf;
Function TA(fg,bg:byte):byte;
Procedure InitSkelbrow;

var
  delkeyhit : boolean;
  inskeyhit : boolean;
  showall : boolean;
  offs : byte;
  lastfield : integer;
  lastcursor : integer;
  iname : string;
  f10hit : boolean;
  cursorpos : integer;
  returnint2 : longint;
  search_pref : string;
  browse_fields : array[1..8] of integer;
  num_searches : byte;
  curdbf : string;
  returnint : longint;
  browsey1,browsey2 : byte;
  currec : longint;
  fieldnum : byte;
  mfl : byte;
  Numfields  : Integer;
  skelbrow_hlb : handle_listbox;
  skelbrow_dlg : handle_dialog;

Implementation

Uses Dos,GSOB_DBF,GSOBSHEL;

Const
  Backspace = #08;
  Enter = #13;
  CTRL_Y = #25;
  Ins = #82;
  Del = #83;
  Uparr = #72;
  Downarr = #80;
  LeftArr = #75;
  RightArr = #77;
  HomePos = #71;
  EndPos = #79;
  Pgup = #73;
  Pgdn = #81;
  Esc = #27;

Type
  FieldPtr = ^Field;
  Field = Record
            recnum : longint;
            fieldinfo : string[81];
            color : byte;
            prev,next : fieldptr;
          end;
  Color_Type = Record
                 color : byte;
                 fn    : byte;
                 fs    : string[20];
                end;

Var
  Bfirstfield : FieldPtr;  {Keeps track of 1st field in list}
  Blastfield  : FieldPtr;  {Keeps track of last field in list}
  Bcurfield   : FieldPtr;  {Keeps track of current field}
  Bcurfieldnum : Integer;
  Save_status : byte; {0 - abort, 1 - save}
  C : Array[1..3] of color_type;

Function TA(fg,bg:byte):byte;
Begin
  ta := (bg shl 4)+fg;
end;

Procedure resetlf;
begin
  lastfield := 0;
  lastcursor := 0;
end;

Function Fieldlenmod(f:integer):integer;
var
 z : integer;
Begin
 z := fieldlen(f);
 if z>mfl then z := mfl;
 fieldlenmod := z;
end;

Procedure Init_Browser(y1,y2,offset:byte;dbfname,spref:string;fnum,b1,b2,b3,b4,b5,b6,b7,b8:byte;indexname:string;lf:boolean;
                       c1,c2,c3:byte;
                       fn1,fn2,fn3 : byte;
                       f1,f2,f3:string);
Begin
  {$IFDEF DEBUG} debug('Init_Browser '+dbfname+' '+spref); {$ENDIF}
  delkeyhit := false;
  inskeyhit := false;
  showall := lf;
  fieldnum := fnum;
  browsey1 := y1;
  browsey2 := y2;
  curdbf := dbfname;
  search_pref := spref;
  num_searches := 0;
  iname := indexname;
  offs := offset;

  c[1].color := c1;
  c[2].color := c2;
  c[3].color := c3;
  c[1].fn := fn1;
  c[2].fn := fn2;
  c[3].fn := fn3;
  c[1].fs := f1;
  c[2].fs := f2;
  c[3].fs := f3;

  if b1>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b1;
    end;

  if b2>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b2;
    end;

  if b3>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b3;
    end;

  if b4>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b4;
    end;

  if b5>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b5;
    end;
  if b6>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b6;
    end;
  if b7>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b7;
    end;
  if b8>0 then
    Begin
      inc(num_searches);
      browse_fields[num_searches] := b8;
    end;
end;

Procedure GotoTop;
Begin
  Bcurfield := Bfirstfield;
end;

Procedure GotoBottom;
Begin
  Bcurfield := Blastfield;
end;

Procedure Deinit_Browser;
Begin
  {$IFDEF DEBUG} debug('Deinit_Browser'); {$ENDIF}
 gotobottom;
 if (bcurfield=nil) then exit;
   while bcurfield^.prev<>nil do
     Begin
      bcurfield := bcurfield^.prev;
      dispose(bcurfield^.next);
      bcurfield ^.next := nil;
     end;
 dispose(bcurfield);
 bfirstfield := nil;
 blastfield := nil;
 bcurfield := nil;
end;

Procedure Pad(var s:string; b:byte);
Begin
  while length(s)<b do s := s +' ';
end;

Procedure Processfield;
var
 t,
 x : integer;
 s : string;
 newfield : fieldptr;
Begin
  new(newfield);
  newfield^.prev := Blastfield;
  if (Blastfield<>nil) then Blastfield^.next := newfield;
  newfield^.next := nil;

  if (Bfirstfield=nil) then Bfirstfield := newfield; {reassign 1st and current}
  if (Bcurfield=nil) then Bcurfield := Bfirstfield;
  Blastfield := newfield;
  with newfield^ do
    Begin
      recnum := recno;
      fieldinfo := ' ';
      if offs>0 then for x := 1 to offs do fieldinfo := ' '+fieldinfo;
      for x := 1 to num_searches do
        Begin
          s := fieldgetn(browse_fields[x]);
          if length(s)>mfl then delete(s,mfl+1,length(s)-mfl);
          if fieldlenmod(browse_fields[x])>mfl then
          pad(s,mfl) else
          pad(s,fieldlenmod(browse_fields[x]));
          if ((length(fieldinfo+s+'  ')>80)) then
            Begin
              fieldinfo := fieldinfo + s + '  ';
              {if (length(fieldinfo)>80) then }delete(fieldinfo,81,255);
              fieldinfo[80] := '';
            end else
          fieldinfo := fieldinfo+s+'  ';
        end;
      color := 0;
      if (c[3].fn>0) then if pos(c[3].fs,fieldgetn(c[3].fn))>0 then color := c[3].color;
      if (c[2].fn>0) then if pos(c[2].fs,fieldgetn(c[2].fn))>0 then color := c[2].color;
      if (c[1].fn>0) then if pos(c[1].fs,fieldgetn(c[1].fn))>0 then color := c[1].color;
      add_listbox_item(skelbrow_hlb,fieldinfo,80,0);
    end;
 inc(numfields);
end;

Function qualifying_field:boolean;
var
 x : byte;
 ts : string;
Begin
 qualifying_field := false;
 if showall then
   Begin
     qualifying_field := true;
     exit;
   end;
 ts := fieldgetn(fieldnum);
 if (pos(search_pref,ts)>0) then qualifying_field := true;
end;

Function Browsertrailer:string;
var
 x,l : integer;
 s : string;
begin
 s := '';
 if offs>0 then for x := 1 to offs do s := ' '+s;
 for x := 1 to num_searches do
   Begin
     for l := 1 to fieldlenmod(browse_fields[x])+2 do
       s := s +'';
       if x<>num_searches then
       s := s +'';
   end;
if length(s)>79 then delete(s,79,length(s)-79);
s := s + '';
while length(s)<80 do s := s + ' ';
browsertrailer := s;
end;

Function Browserheader:string;
var
 x,l : integer;
 s : string;
begin
 s := '';
 if offs>0 then for x := 1 to offs do s := ' '+s;
 for x := 1 to num_searches do
   Begin
     for l := 1 to fieldlenmod(browse_fields[x])+2 do
       s := s +'';
       if x<>num_searches then
       s := s +'';
   end;
if length(s)>79 then delete(s,79,length(s)-79);
s := s + '';
while length(s)<80 do s := s + ' ';
browserheader := s;
end;

Function Browsernil:string;
var
 x,l : integer;
 s : string;
begin
 s := '';
 if offs>0 then for x := 1 to offs do s := ' '+s;
 for x := 1 to num_searches do
   Begin
     for l := 1 to fieldlenmod(browse_fields[x])+2 do
       s := s +' ';
       if x<>num_searches then
       s := s +'';
   end;
if length(s)>79 then delete(s,79,length(s)-79);
s := s + '';
while length(s)<80 do s := s + ' ';
browsernil := s;
end;

Procedure coolwrite(s:string;c:byte);
var
 x : integer;
Begin
end;


Procedure Display_List;
var
 x : integer;
 w : word;
Begin
end;

Function recnumber(z:integer) : longint;
var
 x : integer;
Begin
  recnumber := 0;
  z := z+cursorpos-browsey1;
  gototop;
  if z>1 then
  for x := 2 to z do
    if Bcurfield<>nil then
       Bcurfield := Bcurfield^.next;
  recnumber := Bcurfield^.recnum;
end;

Procedure Browser(id:byte;fnum:integer;st:string;fnum2:integer;st2:string;fnum3:integer;st3:string;si:byte);
var
 ch : char;
 done : boolean;
 tmp : longint;
Begin
  tmp := unique_id;
  create_dialog(tmp,'Browser',0,0,639,479,0,modal+minimize_button+close_button+maximize_button+
                moveable+sizeable,0,0,0,0,0,0,0,0,0);
  Add_listbox(unique_id,cur_dialog,'',10,10,625,302,0,unique_id,0,nil,0);
  skelbrow_dlg := cur_dialog;
  skelbrow_hlb := cur_dialog^.cur_lb;

  done := false;
  numfields := 0;
  use(curdbf);
  if (id>0) then
  Begin
    gotop;
    index(iname);
    setorderto(id);
    find(search_pref);
    if (found) then
       repeat
         if qualifying_field then
           Begin
             if (fnum=0) or (pos(st,fieldgetn(fnum))<>0) then
             if (fnum2=0) or (pos(fieldgetn(fnum2),st2)=0) then
             if (fnum3=0) or (pos(fieldgetn(fnum3),st3)=0) then
             if not(deleted) then
             Begin
               processfield;
             end;
             skip(1);
           end;
       until not(qualifying_field) or (deof);
  end else
  Begin
    if (si>0) then
      Begin
        index(iname);
        setorderto(si);
      end;
    gotop;
    while not(deof) do
      Begin
        if (fnum=0) or (pos(st,fieldgetn(fnum))<>0) then
        if (fnum2=0) or (pos(fieldgetn(fnum2),st2)=0) then
        if (fnum3=0) or (pos(fieldgetn(fnum3),st3)=0) then
        if (qualifying_field) and not(deleted) then
          Begin
            processfield;
          end;
        Skip(1);
      end;
   end;
  gototop;
  if Bcurfield=nil then
   Begin
     returnint := 0;
     exit;
   end;
  currec := 1;
  cursorpos := browsey1;
  if (lastfield>0) then
       Begin
         currec := lastfield;
         cursorpos := lastcursor;
       end;
 setactive(tmp);
{  textbackground (blue);
  if numfields>0 then display_list else
    Begin
      returnint := RECNUMBER(CURREC);
      if numfields>0 then DEINIT_BROWSER;
      exit;
    end;
  repeat
     if keypressed then
      Begin
        ch := upcase(readkey);
        if ch=#0 then
          Begin
            ch := upcase(readkey);
            case ch of
              HomePos : Begin
                          currec:=1;
                          cursorpos := browsey1;
                        end;
              EndPos  : Begin
                          currec:=numfields-(browsey2-browsey1);
                          if currec<1 then currec := 1;
                          cursorpos := browsey2;
                          while (currec+(cursorpos-browsey1))>numfields do dec(cursorpos);
                        end;
              Downarr : Begin
                          if (currec+(cursorpos-browsey1)<numfields) then
                          Begin
                            inc(cursorpos);
                          if (cursorpos>browsey2) then
                           Begin
                             cursorpos := browsey2;
                             if (currec<numfields) then currec := currec+1;
                           end;
                          end;
                        end;
              Uparr   : Begin
                          if (cursorpos>1) then dec(cursorpos);
                          if (cursorpos<browsey1) then
                             Begin
                               cursorpos := browsey1;
                               if (currec>1) then dec(currec);
                             end;
                        end;
              Pgup    : if (currec<(browsey2-browsey1)) then
                            Begin
                              cursorpos := browsey1;
                              currec := 1;
                            end else
                        begin
                          currec := currec-(browsey2-browsey1);
                        end;
              Pgdn    : if (currec+(browsey2-browsey1)>numfields) then
                        begin
                          cursorpos := browsey2;
                          currec := numfields;
                          while (currec+(cursorpos-browsey1))>numfields do dec(cursorpos);
                        end else
                        begin
                          currec := currec + (browsey2-browsey1);
                          while (currec+(cursorpos-browsey1))>numfields do dec(cursorpos);
                        end;
              DEL    : Begin
                          lastfield := currec;
                          lastcursor := cursorpos;
                          f10hit := true;
                          done := true;
                          delkeyhit := true;
                          returnint2 := recnumber(currec);
                          returnint := 0;
                        end;
              INS    : Begin
                          lastfield := currec;
                          lastcursor := cursorpos;
                          f10hit := true;
                          done := true;
                          inskeyhit := true;
                          returnint2 := recnumber(currec);
                          returnint := 0;
                        end;
              F10     : Begin
                          lastfield := currec;
                          lastcursor := cursorpos;
                          f10hit := true;
                          done := true;
                          returnint2 := recnumber(currec);
                          returnint := 0;
                        end;
            end;
           display_list;
          end else
          Begin
           if ch=esc then
             Begin
               done := true;
               f10hit := false;
               returnint := 0;
               returnint2 := 0;
             end;
           if ch=enter then
             Begin
               lastfield := currec;
               lastcursor := cursorpos;
               done := true;
               f10hit := false;
               returnint := recnumber(currec);
               returnint2 := 0;
             end;
            ch := ' ';
          end;
      end;
  until done;
}
if numfields>0 then deinit_browser;
end;

Procedure InitSkelbrow;
Begin
  mfl := 20;
  lastfield := 0;
  lastcursor := 0;
  Bfirstfield := NIL;
  Blastfield := NIL;
  Bcurfield := NIL;
end;

end.


