Unit S_New;

Interface

{$IFDEF DPMI}Uses Strings;{$ENDIF}

Type
  {Definition of String Type}
  S_Type = Object
             curlength : word;
             maxlength : word;
             curpos    : word; {position of NULL terminator}
             strdata   : pchar;
             Constructor Init(ml:word);   {Initializes String with Maxlength}
             Destructor  Done;
             Function    Length:word;     {Returns Length of String}
             Function    Pstr:string;     {returns a Pascal style String}
             Procedure   AddString(s:string); {adds string to object}
             Function    Pchr:pchar;
             Procedure   InsertChar(c:char);
             Procedure   DeleteChar;
           end;

Implementation

Uses fontvesa,crt,filer,win;

{$IFNDEF DPMI}
function strlen(s:pchar):word;
var
 x : word;
Begin
 x := 0;
 while s^<>#0 do
   Begin
       inc(x);
       inc(s);
   end;
 strlen := x;
end;

function strpas(s:pchar):string;
var
 rs : string;
Begin
 rs := '';
 while (s^<>#0) do
   Begin
     rs := rs+s^;
     inc(s);
   end;
 strpas := rs;
end;

function strend(s:pchar):pchar;
Begin
  while s^<>#0 do inc(s);
  strend := s;
end;

function strpcopy(s:pchar;s2:string):pchar;
var
 x : byte;
Begin
  strpcopy := nil;
  if length(s2)=0 then exit;
  s := strend(s);
  for x := 1 to length(s2) do
     Begin
       s^ := s2[x];
       inc(s);
     end;
  s^ := #0;
  strpcopy := s;
end;
{$ENDIF}

Constructor S_Type.Init;
Begin
  maxlength := ml;
  curlength := 0;
  curpos := 0;
  getmem(strdata,maxlength+2);
  if strdata=nil then fatal_error(4);
  strdata^ := #0;
end;

Destructor S_Type.Done;
Begin
  freemem(strdata,maxlength+2);
  maxlength := 0;
  curlength := 0;
  curpos := 0;
end;

Function S_Type.Length;
Begin
  length := strlen(strdata);
end;

Function S_Type.Pstr;
Begin
 if strlen(strdata)=0 then
 pstr := '' else pstr := strpas(strdata);
end;

Procedure S_Type.AddString;
Begin
 if (system.length(s)=0) then exit;
 if length=maxlength then exit;
 while (system.length(s)+length)>maxlength do s[0] := chr(ord(s[0])-1);
 if system.length(s)>0 then strpcopy(strdata,s);
 curlength := strlen(strdata);
 curpos := curlength+1;
 if (curpos>maxlength+1) then curpos := maxlength+1;
end;

Function S_Type.Pchr;
Begin
  Pchr := strdata;
end;

Procedure S_Type.InsertChar;
var
 src,dst : pchar;
 count : word;
 tstr : pchar;
Begin
  if (curlength>=maxlength) then exit;
  if (curlength=0) then
    Begin
      addstring(c);
      exit;
    end;
  if (curlength<maxlength-1) then
  Begin
    src := strdata+(curpos-1);
    dst := src+1;
    count := maxlength-curpos;
    if count<1 then exit;
    getmem(tstr,count);
    move(src^,tstr^,count);
    move(tstr^,dst^,count);
    freemem(tstr,count);
    src^ := c;
    inc(curpos);
    inc(curlength);
  end else
  Begin
    src := strend(strdata);
    src^ := c;
    inc(src);
    src^ := #0;
    inc(curpos);
    inc(curlength);
  end;
end;

Procedure S_Type.DeleteChar;
var
 src,dst : pchar;
 count : word;
Begin
  if (curlength=0) then exit;
  if (curlength<maxlength) then
  Begin
    src := strdata+curpos-1;
    dst := src-1;
    if (dst<strdata) then exit;
    count := maxlength-curpos+1;
    move(src^,dst^,count);
    dec(curpos);
    dec(curlength);
  end else
  Begin
    src := strend(strdata)-1;
    src^ := #0;
    dec(curpos);
    dec(curlength);
  end;
end;

end.
