{DEFINE DEBUG}
Unit UDP;

Interface

Uses PPP,IP;

Const
   UDP_Protocol = 17;
   Port = 0;
   ID   = 1;
   PORTID = 2;
Type
   pUDP = ^Udp_Record;
   UDP_Record = Record
                  ID : word;

                  SourceIP,DestIP     : IPType;
                  SourcePort,DestPort : word;

                  PacketLength : word;
                  checksum : word;

                  data_ptr : pbyte;
                  Data : pbyte;
                  Datasize : word;

                  prev,next : pUDP;
                end;

   UDP_Object = Object
                 Private
                    First_UDP,
                    Last_UDP,
                    Cur_UDP : pUDP;

                 Public
                    Function  B(var frame:pbyte):byte;
                    Function  GetByte(var frame:pbyte):byte;
                    Procedure AddByte(var frame:pbyte;bte:byte);

                    Procedure AddUDPFrame(frame:pIP);
                    Procedure DisposeUDPFrame(frame:pUDP);

                    Function  GetUDPFrame(portorid:byte;data,data2:word):pUDP;

                    Procedure SendUDP(ID:longint;
                                      DestIP:iptype;
                                      SourcePort,
                                      DestPort:longint;
                                      datalength:word;
                                      Data:pbyte);
                    Private
                       Constructor Init;
                       Destructor  Done;
                end;

var
  oUDP : UDP_Object;

Implementation

Uses Checksum;

Constructor UDP_Object.Init; {Nada}
Begin
  First_UDP := nil;
  Last_UDP := nil;
  Cur_UDP := nil;
end;

Destructor UDP_Object.Done; {Nada}
Begin
  while first_udp<>nil do disposeUDPframe(first_udp);
end;

Function UDP_Object.B(var frame:pbyte):byte;
Begin
  if frame<>nil then
  Begin
    b := frame^;
    inc(frame);
  end else b := 255;
end;

Function UDP_Object.GetByte(var frame:pbyte):byte;
Begin
  GetByte := b(frame);
end;

Procedure UDP_Object.AddByte(var frame:pbyte;bte:byte);
Begin
  frame^ := bte; inc(frame);
end;

Procedure UDP_Object.SendUDP(ID:longint;
                             DestIP:iptype;
                             SourcePort,
                             DestPort:longint;
                             datalength:word;
                             Data:pbyte);
var
 fdata : pbyte;
 fdp : pbyte;
 csumptr : pbyte;
 x : word;
 csum : word;
 pip : pbyte;
Begin
  getmem(fdata,8+datalength); {11=Pseudo Header}
  fdp := fdata;

  pip := oIP.PseudoIP(oPPP.IPaddr,DestIP,UDP_Protocol,datalength+8);

  Addbyte(fdp,sourceport shr 8);
  Addbyte(fdp,sourceport and $00ff);

  Addbyte(fdp,destport shr 8);
  Addbyte(fdp,destport and $00ff);

  Addbyte(fdp,(datalength+8) shr 8);
  Addbyte(fdp,(datalength+8) and $00ff);

  csumptr := fdp;

  Addbyte(fdp,0);
  Addbyte(fdp,0);

  if datalength>0 then
  for x := 1 to datalength do
    Begin
      Addbyte(fdp,data^);
      inc(data);
    end;

 csum := not cksum(pip,fdata,datalength+8); {8 - UDP Header, 12 - Pseudo IP Header}
 freemem(pip,12);
 {if csum=0 then csum := $ffff;}

 csumptr^ := csum shr 8; inc(csumptr);
 csumptr^ := csum and $00ff; dec(csumptr);

 fdp := fdata;

 oIP.SendIP_Datagram(ID,oPPP.IPaddr,DestIP,UDP_Protocol,datalength+8,fdp);
 freemem(fdata,8+datalength);
end;

Procedure UDP_Object.AddUDPFrame(frame:pIP);
var
 lframe : pUDP;
 tmp : word;
 x : byte;
 csum : word;
 tofs : pbyte;
 ph : pbyte;
Begin
  frame^.data_ptr := frame^.data;
  new(lframe);

  lframe^.id := frame^.id;
  lframe^.sourceip := frame^.sourceip;
  lframe^.destip := frame^.destip;

  lframe^.sourceport := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.sourceport,getbyte(frame^.data_ptr));
  lframe^.destport := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.destport,getbyte(frame^.data_ptr));
  lframe^.packetlength := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.packetlength,getbyte(frame^.data_ptr));

  lframe^.checksum := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.checksum,getbyte(frame^.data_ptr));

  {$IFDEF DEBUG}
    writeln('UDP Datagram info');
    writeln('-------------------------------');
    writeln('Source Port   : ',lframe^.sourceport);
    writeln('Dest Port     : ',lframe^.destport);
    writeln('Packet Length : ',lframe^.packetlength);
    writeln('Checksum      : ',lframe^.checksum);
    writeln('-------------------------------');
  {$ENDIF}

  if (frame^.datasize-8>0) then
    Begin
      lframe^.datasize := frame^.datasize-8;
      getmem(lframe^.data,lframe^.datasize);
      move(frame^.data_ptr^,lframe^.data^,lframe^.datasize);
      lframe^.data_ptr := lframe^.data;
    end else
    Begin
      lframe^.datasize := 0;
      lframe^.data := nil;
    end;

  lframe^.data_ptr := lframe^.data;

  ph := oIP.PseudoIP(frame^.sourceip,frame^.destip,frame^.protocol,lframe^.datasize);

  frame^.data_ptr := frame^.data;
  csum := cksum(ph,frame^.data_ptr,lframe^.packetlength)+8;

  {$IFDEF DEBUG} writeln('CHECKSUM : ',csum); writeln(lframe^.packetlength);{$ENDIF}
  if (csum<65535) then
    Begin
      {if (lframe^.datasize>0) then freemem(lframe^.data,lframe^.datasize);
      dispose(lframe);}
      {$IFDEF DEBUG} writeln('INVALID CRC IN IP FRAME!'); {$ENDIF}
      {exit;}
    end;

  lframe^.data_ptr := lframe^.data;
  lframe^.prev := last_UDP;
  last_udp := lframe;
  cur_udp := lframe;
  lframe^.next := nil;
  if first_udp=nil then first_udp := lframe;
  if lframe^.prev<>nil then lframe^.prev^.next := lframe;
  cur_udp:= lframe;
end;

Procedure UDP_Object.DisposeUDPFrame(frame:pUDP);
Begin
  if frame=nil then exit;

  if frame=first_udp then first_udp := first_udp^.next;
  if frame=last_udp then last_udp := last_udp^.prev;
  if frame=cur_udp then cur_udp := cur_udp^.next;

  if frame^.prev<>nil then frame^.prev^.next := frame^.next;
  if frame^.next<>nil then frame^.next^.prev := frame^.prev;

  if frame^.datasize>0 then freemem(frame^.data,frame^.datasize);
  dispose(frame);
end;

Function  UDP_Object.GetUDPFrame(portorid:byte;data,data2:word):pUDP;
var
 this : pUDP;
Begin
  GetUDPFrame := nil;
  this := first_udp;
  while (this<>nil) do
   Begin
     case portorid of
       PORT : if (this^.destport=data) then
                 Begin
                   GetUDPFrame := This;
                   exit;
                 end;
       ID   : if (this^.id=data) then
                 Begin
                   GetUDPFrame := This;
                   exit;
                 end;
       PORTID : if (this^.destport=data) and (this^.id=data2) then
                 Begin
                   GetUDPFrame := This;
                   exit;
                 end;
     end;
     this := this^.next;
   end;
end;

Begin
  oUDP.Init;
end.
