;
;
; 512x400 Video Mode adapted by:
;
; Written by: John McCarthy (aka Flynn)
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;
; Home phone,(905)831-1944, always willing to talk but don't call at 2 am eh!
;
; Send me a postcard from someplace near where you live.
;
; Note: The original code for this was posted on rec.games.programmer some
;       time ago.  I forget who posted it.  All I have done is converted
;       it to WATCOM 32 bit.
;
;

         .386p
DGROUP   GROUP _TEXT

_TEXT    SEGMENT BYTE PUBLIC 'CODE'
         ASSUME CS:_TEXT ,DS:DGROUP,SS:DGROUP

_aci     equ 3c0h
_mo      equ 3c2h
_sci     equ 3c4h
_gfxi    equ 3ceh
_crtci   equ 3d4h

         public set_512x400_
         public set_plane_
         public pixel_plot_

;
; Set flat video mode 512x400 for Cirrus Logic 54xx series SVGA cards
;

set_512x400_:
         mov dx,3dah                   ; disable video output
         in al,dx
         call sm_acwait
         mov dx,_aci
         xor ax,ax
         out dx,al

         mov dx,_sci                   ; set syncronous reset
         mov ax,100h
         out dx,ax

         mov esi,offset _modat         ; set dot clock (25mhz)
         mov dx,_mo
         lodsb
         out dx,al

         mov esi,offset _scdat         ; load sequencer regs (and disable video)
         mov ecx,_sclen
         mov dx,_sci
         rep outsw

         mov esi,offset _acdat         ; load attribute regs
         mov ecx,_aclen
sm_acinit:
         mov dx,3dah
         in al,dx
         call sm_acwait
         mov dx,_aci
         lodsb
         out dx,al
         call sm_acwait
         lodsb
         out dx,al
         call sm_acwait
         dec cl
         jnz short sm_acinit

         mov dx,_crtci                 ; unprotect crt 0-7 and cirrus extensions
         mov al,11h
         out dx,al
         inc dx
         in al,dx
         and al,7fh
         out dx,al
         mov dx,_sci
         mov ax,1206h
         out dx,ax

         mov esi,offset _crtcdat       ; load crtc and gfx regs
         mov ecx,_crtclen
         mov dx,_crtci
         rep outsw
         mov esi,offset _gfxdat
         mov ecx,_gfxlen
         mov dx,_gfxi
         rep outsw

         mov ecx,0cffffh               ; wait for video stability
sm_mc1del:
         loop sm_mc1del

         mov dx,3ceh                   ; clear video
         mov al,09h
         out dx,al
         inc dx

sm_mc1l1:
         out dx,al

         xor eax,eax
         mov eax,0f0f0f0fh
         mov edi,0a0000h
         mov ecx,4000h
         rep stosd

         in al,dx
         add al,10h
         jnc sm_mc1l1

         xor al,al
         out dx,al

         mov dx,3dah                   ; enable video
         in al,dx
         call sm_acwait
         mov dx,_aci
         mov ax,20h
         out dx,al
         mov edx,_sci
         mov ax,0101h
         out dx,ax
         ret

sm_acwait:
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         ret

;
; Select video plane
; In:
;  AL = video plane to switch to
;

set_plane_:
         mov dx,_gfxi
         mov ah,al
         mov al,09h
         out dx,ax
         ret

_modat   db 0e3h
_acdat   db 000h,000h,001h,001h,002h,002h,003h,003h,004h,004h,005h,005h
         db 006h,006h,007h,007h,008h,008h,009h,009h,00ah,00ah,00bh,00bh
         db 00ch,00ch,00dh,00dh,00eh,00eh,00fh,00fh,010h,001h,011h,000h
         db 012h,00fh,013h,000h,014h,000h
_aclen   equ ($-_acdat)/2

_crtcdat dw 04d00h                     ;horizontal total
         dw 03f01h                     ;horizontal display end
         dw 04002h                     ;start horizontal blanking
         dw 08d03h                     ;end horizontal blanking
         dw 04104h                     ;start horizontal retrace
         dw 00d05h                     ;end horizontal retrace
         dw 0a206h                     ;vertical total
         dw 01f07h                     ;overflow: lots'a higher bits for these registers
         dw 00008h
         dw 04009h                     ;some more overflow
         dw 0000ah
         dw 0000bh
         dw 0000ch
         dw 0000dh
         dw 0000eh
         dw 0000fh
         dw 09010h                     ;start vertical retrace
         dw 0a611h                     ;end vertical retrace
         dw 08f12h                     ;vertical display end
         dw 04013h                     ;offset: bytes-per-scanline/8
         dw 00014h
         dw 09015h                     ;start vertical blank
         dw 09116h                     ;end vertical blank
         dw 0c317h
         dw 0ff18h                     ;line compare: no split screen
         dw 00019h
         dw 0001ah
         dw 0221bh
_crtclen equ ($-_crtcdat)/2

_gfxdat  dw 00000h,00001h,00002h,00003h,00004h,04005h
         dw 00506h,00f07h,0ff08h,00009h,0000ah,0000bh
_gfxlen  equ ($-_gfxdat)/2

_scdat   dw 00300h,02101h,00f02h,00003h,00e04h,00f05h,01206h,00107h
         dw 08008h,00109h,0190ah,04a0bh,05b0ch,0450dh,04a0eh,0300fh
         dw 00010h,00011h,00012h,00013h,00014h,00015h,0d816h,00017h
         dw 00018h,00119h,0001ah,02b1bh,02f1ch,0301dh,02b1eh,01c1fh
_sclen   equ ($-_scdat)/2

;
; Plot pixel in 512x400 video mode (slow, testing purposes only)
; In:
;  ECX = x
;  EAX = y
;   BL = colour to plot
;
; Notes:
;  This routine could sometimes be inacurate if you change the plane yourself
;  because it checks for the last plane selected and skips the expensive OUT
;  DX,AL if it will write to the same plane.
;
;  Like I said, It is just for testing purposes.
;
; Modifies ESI EDX EAX
;

_lastplane db -1

pixel_plot_:
         mov esi,eax
         shl eax,5                     ; * 32
         and ah,0f0h

         cmp ah,_lastplane
         je short pp_skipout
         mov _lastplane,ah

         mov dx,_gfxi
         mov al,09h
         out dx,ax
pp_skipout:
         and esi,07fh
         shl esi,9                     ; * 512
         mov [0a0000h+esi+ecx],bl
         ret

_TEXT    ends
         end
