/****************************************************************************

                John McCarthy's Constant Slope Texture Mapping

                                  (JMCSTM)

****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "vmode.h"

/*******************************************************************/

#include <math.h>
#include "text.h"

/*******  Select.asm  ********/

extern short allocate_descriptors(int howmany);
extern short get_increment(void);
extern void free_descriptor(unsigned short descriptor);
extern void set_limits(char *base,long int limit, unsigned short descriptor);
extern char get_selected_byte(int offset, short selector);

#pragma aux  allocate_descriptors parm [ecx];
#pragma aux  free_descriptor      parm [ebx];
#pragma aux  set_limits           parm [eax] [edx] [ebx];

#define __320x200__

#define zoom_speed 40
#define min_z_distance 700
#define max_z_distance 4000
#define clip_z_distance 4000
#define cube_size 180
#ifdef __320x200__
#define x_aspect 178
#define y_aspect 178
#define xax 192
#define yay 192
#endif
#ifndef __320x200__
#define x_aspect 135
#define y_aspect 178
#define xax 150
#define yay 192
#endif
#define tol 70000
#define textures 4
#define M_PI 3.14159265
#define MIN(A,B) ((A)>(B)?(B):(A)) /* Min macro definition */

struct vertex{
  long vtx_x3d;                   // 3d world co-ordinates (object)
  long vtx_y3d;
  long vtx_z3d;
  long vtx_x2d;                   // 2d co-ordinates after frame rotation/perspective
  long vtx_y2d;
  } vertex;

struct poly_connection{
  struct vertex *pc_previous_vertex;
  struct vertex *pc_this_vertex;
  struct vertex *pc_next_vertex;
  long pc_texture_x;
  long pc_texture_y;
  struct poly_connection *pc_next_link;
  struct poly_connection *pc_previous_link;
  } poly_connection;

struct polygon{
  long pg_vertex_count;                    // number of verticies in polygon
  struct poly_connection *pg_poly_list;    // offset to first poly_connection (linked list)
  } polygon;

struct vertex verticies[8];
struct poly_connection connection[24];
struct polygon surface[6];

char * texture_offsets[textures];
int texture_selectors[textures];
int * cosine_tables;
int ax1,ay1,dist1,dist2;
int pos;

void draw_a_cube_if_it_is_visable(struct polygon *p1, unsigned short descriptor)
{
    int x1,y1;
    int x2,y2;
    int x3,y3;

    struct vertex *v1;
    struct vertex *v2;
    struct vertex *v3;

    struct poly_connection *c1;
    struct poly_connection *c2;
    struct poly_connection *c3;

    c1 = p1 -> pg_poly_list;
    c2 = c1 -> pc_next_link;
    c3 = c2 -> pc_next_link;

    v1 = c1 -> pc_this_vertex;
    v2 = c2 -> pc_this_vertex;
    v3 = c3 -> pc_this_vertex;

    x1 = v1 -> vtx_x2d;
    y1 = v1 -> vtx_y2d;
    x2 = v2 -> vtx_x2d;
    y2 = v2 -> vtx_y2d;
    x3 = v3 -> vtx_x2d;
    y3 = v3 -> vtx_y2d;

    /* check dot product */

    if (((x3-x1)*(y2-y1)-(x2-x1)*(y3-y1)) >= 0)
    {
        textured_polygon(p1,descriptor);
    }
}

void draw_cube(int xangle,
               int yangle,
               int additional_z_distance,
               int cube_textures_0or1)
{
    int q,sx,sy,cx,cy,xx,yy,zz;

    if (additional_z_distance > clip_z_distance)
    {
        return;
    }

    sx =   sine(xangle);
    cx = cosine(xangle);
    sy =   sine(yangle);
    cy = cosine(yangle);

    for (q=0;q<8;q++)
    {
        yy = mult64(verticies[q].vtx_y3d,cx) - mult64(verticies[q].vtx_z3d,sx);
        zz = mult64(verticies[q].vtx_y3d,sx) + mult64(verticies[q].vtx_z3d,cx);
        xx = mult64(verticies[q].vtx_x3d,cy) - mult64(zz,sy);
        zz = mult64(verticies[q].vtx_x3d,sy) + mult64(zz,cy) + additional_z_distance;
        verticies[q].vtx_x2d = (xx * x_aspect) / zz + xax / 2;
        verticies[q].vtx_y2d = (yy * y_aspect) / zz + yay / 2;
    }

    draw_a_cube_if_it_is_visable(&surface[0],texture_selectors[0 + cube_textures_0or1 * 2]);
    draw_a_cube_if_it_is_visable(&surface[1],texture_selectors[0 + cube_textures_0or1 * 2]);
    draw_a_cube_if_it_is_visable(&surface[2],texture_selectors[1 + cube_textures_0or1 * 2]);
    draw_a_cube_if_it_is_visable(&surface[3],texture_selectors[0 + cube_textures_0or1 * 2]);
    draw_a_cube_if_it_is_visable(&surface[4],texture_selectors[0 + cube_textures_0or1 * 2]);
    draw_a_cube_if_it_is_visable(&surface[5],texture_selectors[1 + cube_textures_0or1 * 2]);
}

signed int * init_cosine(coslen)
{
    signed int * cos;
    int z;

    if ((cos = (int *) malloc(coslen * sizeof(int)))!=NULL)
    {
        for (z=0;z<coslen;z++)
        {
            cos[z] = (sin(z * (M_PI/2) / coslen) * 65536);
        }
    }
    return (cos);
}

int * allocate_video_buffer(int xsize,int ysize)
{
    int * bufloc;
    int z,y;

    if ((bufloc = (int *) malloc((xsize + sizeof(int)) * ysize))!=NULL)
    {
       y = (sizeof(int) * ysize) + (int) bufloc;
       for (z=0; z<ysize; z++)
           bufloc[z] = (xsize * z) + y;
    }
    return (bufloc);
}

int cube_setup(char * tx_raw)
{
    int z;

    if ((virtual_video_tables = (int *) allocate_video_buffer(xax,yay))==NULL)
    {
        return(0); /* cannot allocate video memory */
    }

    virtual_video_width  = xax;
    virtual_video_height = yay;

    for (z=0;z<textures;z++)
    {
        texture_offsets[z]   = tx_raw + (64*z);
        texture_selectors[z] = allocate_descriptors(1);
        set_limits(texture_offsets[z],65536,texture_selectors[z]);
    }

    if ((cosine_tables = init_cosine(16384))==NULL)
    {
        return(0); /* cannot allocate video memory */
    }

    clear_memory((char *)virtual_video_tables[0],xax*yay,0);

    verticies[0].vtx_x3d =  cube_size;
    verticies[0].vtx_y3d =  cube_size;
    verticies[0].vtx_z3d =  cube_size;

    verticies[1].vtx_x3d = -cube_size;
    verticies[1].vtx_y3d =  cube_size;
    verticies[1].vtx_z3d =  cube_size;

    verticies[2].vtx_x3d = -cube_size;
    verticies[2].vtx_y3d = -cube_size;
    verticies[2].vtx_z3d =  cube_size;

    verticies[3].vtx_x3d =  cube_size;
    verticies[3].vtx_y3d = -cube_size;
    verticies[3].vtx_z3d =  cube_size;

    verticies[4].vtx_x3d =  cube_size;
    verticies[4].vtx_y3d =  cube_size;
    verticies[4].vtx_z3d = -cube_size;

    verticies[5].vtx_x3d = -cube_size;
    verticies[5].vtx_y3d =  cube_size;
    verticies[5].vtx_z3d = -cube_size;

    verticies[6].vtx_x3d = -cube_size;
    verticies[6].vtx_y3d = -cube_size;
    verticies[6].vtx_z3d = -cube_size;

    verticies[7].vtx_x3d =  cube_size;
    verticies[7].vtx_y3d = -cube_size;
    verticies[7].vtx_z3d = -cube_size;

    for (z=0;z<6;z++)
    {
        surface[z].pg_vertex_count = 4;
        surface[z].pg_poly_list    = &connection[z*4];
    }

    for (z=0;z<24;z+=4)
    {
        connection[z+0].pc_next_link     = &connection[z+1];
        connection[z+0].pc_previous_link = &connection[z+3];
        connection[z+0].pc_texture_x     =  0*65536+tol;
        connection[z+0].pc_texture_y     =  0*65536+tol;

        connection[z+1].pc_next_link     = &connection[z+2];
        connection[z+1].pc_previous_link = &connection[z+0];
        connection[z+1].pc_texture_x     = 64*65536-tol;
        connection[z+1].pc_texture_y     =  0*65536+tol;

        connection[z+2].pc_next_link     = &connection[z+3];
        connection[z+2].pc_previous_link = &connection[z+1];
        connection[z+2].pc_texture_x     = 64*65536-tol;
        connection[z+2].pc_texture_y     = 64*65536-tol;

        connection[z+3].pc_next_link     = &connection[z+0];
        connection[z+3].pc_previous_link = &connection[z+2];
        connection[z+3].pc_texture_x     =  0*65536+tol;
        connection[z+3].pc_texture_y     = 64*65536-tol;
    }

    connection[0*4+0].pc_this_vertex   = &verticies[0];
    connection[0*4+1].pc_this_vertex   = &verticies[1];
    connection[0*4+2].pc_this_vertex   = &verticies[2];
    connection[0*4+3].pc_this_vertex   = &verticies[3];

    connection[1*4+0].pc_this_vertex   = &verticies[4];
    connection[1*4+1].pc_this_vertex   = &verticies[0];
    connection[1*4+2].pc_this_vertex   = &verticies[3];
    connection[1*4+3].pc_this_vertex   = &verticies[7];

    connection[2*4+0].pc_this_vertex   = &verticies[3];
    connection[2*4+1].pc_this_vertex   = &verticies[2];
    connection[2*4+2].pc_this_vertex   = &verticies[6];
    connection[2*4+3].pc_this_vertex   = &verticies[7];

    connection[3*4+0].pc_this_vertex   = &verticies[1];
    connection[3*4+1].pc_this_vertex   = &verticies[5];
    connection[3*4+2].pc_this_vertex   = &verticies[6];
    connection[3*4+3].pc_this_vertex   = &verticies[2];

    connection[4*4+0].pc_this_vertex   = &verticies[5];
    connection[4*4+1].pc_this_vertex   = &verticies[4];
    connection[4*4+2].pc_this_vertex   = &verticies[7];
    connection[4*4+3].pc_this_vertex   = &verticies[6];

    connection[5*4+0].pc_this_vertex   = &verticies[0];
    connection[5*4+1].pc_this_vertex   = &verticies[4];
    connection[5*4+2].pc_this_vertex   = &verticies[5];
    connection[5*4+3].pc_this_vertex   = &verticies[1];

    ax1 = ay1 = 0;
    dist2 = min_z_distance;
    dist1 = max_z_distance;
    pos = 100;

    return(1);              /* 1 = setup ok */
}

void draw_both_cubes()
{
    int z;
    z = (pos % 1200) / 120;
    if (z==0)
    {
        dist1+= zoom_speed;
        dist2 = MAX(dist2 - zoom_speed, min_z_distance);
    }
    if (z==5)
    {
        dist2+= zoom_speed;
        dist1 = MAX(dist1 - zoom_speed, min_z_distance);
    }

    if (dist1 < dist2)
    {
        draw_cube(ax1,ay1,dist2,1);
        draw_cube(ax1,ay1,dist1,0);
    }
    else
    {
        draw_cube(ax1,ay1,dist1,0);
        draw_cube(ax1,ay1,dist2,1);
    }
}

void cube_uninit()
{
    int z;

    free (virtual_video_tables);
    free (cosine_tables);
    for (z=0;z<textures;z++)
    {
        free_descriptor(texture_selectors[z]);
    }
}

void update_cube_angles(void)
{
    ax1 += 323;
    ay1 += 254;
    pos++;
}

/*******************************************************************/

void main()
{
    int z;
    char * tx_pal;
    char * tx_raw;
    FILE *fp;
    int speed;

    tx_pal = (char *) malloc(64*256 + 768);
    tx_raw = tx_pal + 768;

    fp=fopen("textures.pal","rb");
    fread(tx_pal,768,1,fp);
    fclose(fp);
    fp=fopen("textures.raw","rb");
    fread(tx_raw,64*256,1,fp);
    fclose(fp);

#ifdef __320x200__
    fmode(M320x200x256);
#endif
#ifndef __320x200__
    fmode(M360x360x256);  // the x modes are also cool! //
#endif

    put_palette(tx_pal,0,768);

    cube_setup(tx_raw);    // provide setup with a pointer to textures

while (kbhit()==0)
{
    draw_both_cubes();     // this is called when you have time
    update_cube_angles();  // this should be called every IRQ for smoothness

    sync_display();
    copy_video_page((char *)virtual_video_tables[0],(320 - xax) / 2,(200 - yay) / 2);
    clear_memory((char *)virtual_video_tables[0],xax*yay,0);
    flip_video_page();
}
    vmode(3);
    cube_uninit();
    free(tx_pal);
    getch();

    printf("email: BRIANMCC@IDIRECT.COM\n");
    printf("   or: BRIAN.MCCARTHY@CANREM.COM\n");
    printf("   or: RY80@JECALPHA.KA.SUB.ORG\n");
    printf("\nWanna help write an Operating System?\n");
}

