{ -  -----      L E N T E        --     ---    }
{                                                                           }
{ * Este efecto ha sido creado con ayuda de un DOC de:                      }
{   Joey:Joey@****.***.**.be (Belgium)                                      }
{   ... donde explicaba como crear la lente.                                }
{ *  No es ms que una transformacin de una zona de video ! Gracias Joey  }
{ * Optimizacin sobre el DOC de Joey: Creacin de una zona alrededor de    }
{                                      la lente para borrar al mismo tiempo }
{                                      que escribimos en video.             }
{ * Incluido en MODERATO en Septiembre de 1994                              }
{                                                                           }
{                                    <rom & Mitra / Spanish Lords Sep 1994  }
{                                                                           }
{ * Modificaciones del cdigo para SOLO PROGRAMADORES en Oct 1995:          }
{     - Uso de la librera DEMOVGA                                          }
{     - Generacin de la matriz de transformacin en tiempo real.           }
{     - "des"optimizacin de codigo en orden a generar codigo LEARNWARE.    }
{     - Movimiento NO aleatorio.                                            }
{                                                                           }
{                                          Oct 95 <rom / Spanish Lords      }
Unit Lente;
INTERFACE
PROCEDURE ShowLens;

IMPLEMENTATION
Uses Mcga,Crt;
Const
  Ancho         =             80;
  SizeLente     =    Ancho*Ancho;
  RadioLente    =             35;
  WriteText     : Boolean = True;

Type
  DatosLente    = Array [1..SizeLente] of Byte;
Var
  BackGroundPtr : Pointer;
  BackGroundMem : dword;
  LenteOrg      : DatosLente;
  LenteTrans    : Array [0..SizeLente] of word;
  LenteDest     : DatosLente;
  XMov,YMov     : word;
  IncX,IncY     : Boolean;

Procedure MakeLenteTrans;
Const
  CentroX   = Ancho div 2;
  CentroY   = Ancho div 2;
  CtePlano  =          30;
Var
  CntDatosX : Integer;
  CntDatosY : Integer;
  Radio     : Integer;
  D,Qz      : Integer;
  Ix,Iy     : Integer;
  Index     : integer;
  Val       : word;
Begin
  For CntDatosY := -(Ancho div 2) to (Ancho div 2)-1 do
    Begin
      For CntDatosX := -(Ancho div 2) to Ancho div 2  do
        Begin
          Radio:= Round (Sqrt (Sqr(CntDatosX)+Sqr(CntDatosY)));
          If Radio>RadioLente
            then Begin
                   LenteTrans [CentroX+CntDatosX+((CentroY+CntDatosY)*Ancho)]:=CentroX+CntDatosX+((CentroY+CntDatosY)*Ancho);
                 End
            else Begin
                   D :=Abs(sqr(CtePlano)-sqr(CntDatosX)-sqr(CntDatosY)+sqr(RadioLente));
                   Qz:=Round (1+Sqrt(D));
                   Ix:=(CtePlano*CntDatosX) div (Qz + CtePlano);
                   Iy:=(CtePlano*CntDatosY) div (Qz + CtePlano);
                   LenteTrans [ CentroX+CntDatosX+((CentroY+CntDatosY)*Ancho)]:=(Ancho div 2)+Ix+(((Ancho div 2)+Iy)*Ancho);
                 End;
        End;
      If WriteText then write('.');
    End;
End;

Procedure FillLenteOrg (Org:dword;XMov,YMov:Word);assembler;
Asm
  xor  esi,esi
  mov  ax,[YMov]
  xchg ah,al
  mov  si,ax
  shr  si,2
  add  si,ax
  add  si,XMov
  add  esi,[Org]

  mov  edi,OFFSET LenteOrg
  mov  edx,320
  sub  edx,Ancho
  mov  ebx,Ancho
@@AnotherLine:
  mov  ecx,Ancho
{  rep  movsb         Optimize it!!! }
  sar  ecx,1
  jnc  @@Par
  movsb
@@Par:
  rep  movsw
  add  esi,edx
  dec  ebx
  jnz  @@AnotherLine
End;
Procedure CreateLenteDest;
Var
  Cnt   : Word;
Begin
  For Cnt:=1 to SizeLente do LenteDest [Cnt]:= LenteOrg [LenteTrans[Cnt]];
End;
Procedure PutLenteDest (Des:dword;XMov,YMov:Word);assembler;
Asm
  xor  edi,edi
  mov  ax,[YMov]
  xchg ah,al
  mov  di,ax
  shr  di,2
  add  di,ax
  add  di,[XMov]
  add  edi,[Des]
  mov  esi,OFFSET LenteDest
  mov  edx,320
  sub  edx,Ancho
  mov  ebx,Ancho
@@AnotherLine:
  mov  ecx,Ancho
{  rep  movsb          Optimize it!!! }
  sar  ecx,1
  jnc  @@Par
  movsb
@@Par:
  rep movsw
  add  edi,edx
  dec  ebx
  jnz  @@AnotherLine
End;

PROCEDURE ShowLens;
begin
  If WriteText then
    Begin
      ClrScr;
      WriteLn ('Codigo LearnWare:  L E N T E.');
      WriteLn ('Por Pedro Antn Alonso. aka <rom / Spanish Lords');
      WriteLn;
      WriteLn ('Generando la matriz de transformacin ');
    End;
  MakeLenteTrans;
  McgaOn;
{ Con este tamao, el offset es SIEMPRE cero ;-) }
  GetMem              (BackGroundPtr,64000);
  BackGroundMem:= Ofs (BackGroundPtr^);
  ReadPCXFile         (BackGroundMem,'GFX/BCKGR.PCX',0,0,True);
  VerticalRetrace;    { Para evitar escribir en ms de un retrazo :-}
  Copy64K             (BackGroundMem,$A0000);
  XMov := 60;
  YMov := 10;
  IncX :=True;
  IncY :=True;
  Repeat
    FillLenteOrg    (BackGroundMem,XMov,YMov);
    CreateLenteDest;
    VerticalRetrace;
    PutLenteDest    ($A0000,XMov,YMov);
    If IncX then If XMov+Ancho<319 then Inc (XMov)
                                   else Begin
                                          IncX:=False;
                                          Dec (XMov);
                                        End
            else If XMov>0         then Dec (XMov)
                                   else Begin
                                          IncX:=True;
                                          Inc (XMov);
                                        End;
    If IncY then If YMov+Ancho<199 then Inc (YMov)
                                   else Begin
                                          IncY:=False;
                                          Dec (YMov);
                                        End
            else If YMov>0         then Dec (YMov)
                                   else Begin
                                          IncY:=True;
                                          Inc (YMov);
                                        End;

  Until Keypress;
  FreeMem (BackGroundPtr,64000);
  McgaOff;
end;
END.