{-------------------------------------------------------------------------}
{                                                                         }
{ 3 D     U N I T     v e r   1 . 0                                       }
{     TmT pascal version      jeje, Protected Mode age is already here    }
{      -* FixeD point *-                                                  }
{                                                                         }
{ Details about CodeTable:                                                }
{ * CosTable values are stored in 8 fixed point ;)                        }
{ * 360 degrees are 1024 values then 90 are 255 values                   }
{ * Angle3D define a circle with 1024 values                              }
{                                                                         }
{                         ,---------------------------------------------, }
{                         | LearnWare Code by Crom / Spanish Lords      | }
{                         '-=========------=======---- crom@ergos.es ---' }
{                                                                         }
{*************************************************************************}
{                                                                         }
{    V i S i T    t H e    S p A n I s H    d E m O s C e N e    W e B    }
{                     http://www.demos.ergos.es                           }
{   Spanish Lords ftp site: ftp.blastersound.ergos.es/blastersound/SLORDS }
{                                                                         }
{*************************************************************************}
{-------------------------------------------------------------------------}
UNIT Lib3DFP;
INTERFACE
CONST
  POINTS_MAX = 1000;
  FACES_MAX  = 1000;
TYPE
  TPoint2D   = record
                 x,y : longint;
               end;
  PPoint2D   = ^TPoint2D;

  TPoint3D   = record
                 x,y,z : longint;
               end;
  PPoint3D   = ^TPoint3D;

  TFace3D    = record
                 a,b,c : dword;
                 z     : longint;
               end;
  PFace3D    = ^TFAce3D;

  TPoints    = array [0..POINTS_MAX] of TPoint3D;
  PPoints    = ^TPoints;

  TFaces     = array [0..FACES_MAX] of TFace3D;
  PFaces      = ^TFaces;

CONST
  RadDeg  = 1*3.1415926535/180;
{ 3D origin                                }
  XOrg      : longint =    0;
  YOrg      : longint =    0;
  ZOrg      : longint =   60;
{ Center screen                            }
  XCenter   : longint = 160;
  YCenter   : longint = 100;
{ Number of points in CosTable             }
  NumSinVal = 256*4;

VAR
{ About CosTable array:                    }
{  * Values are stores * 255 = 8 bits      }
{  * Circle is defined in 1024 incs.       }
{    then 90 degrees are 256 values ;)     }
  CosTable  : Array [0..NumSinVal] of longint;

FUNCTION  Rad (Deg:real):real;
FUNCTION  FastSin         (Angle3D:longint):longint;
FUNCTION  FastCos         (Angle3D:longint):longint;
PROCEDURE Calc3DRotations (SinX,CosX,SinY,CosY,SinZ,CosZ:longint;
                           POrgPoints , PDesPoints : PPoints;
                           NumPoints  : dword     );
PROCEDURE Proyect         (XScr, YScr : longint;
                           POrgPoints , PDesPoints : PPoints;
                           NumPoints  : dword);
FUNCTION  Visible         (X1,Y1,X2,Y2,X3,Y3:longint):Boolean;
PROCEDURE QuickSortZ      (PPoints2qS : PPoints;
                           PFaces2qS  : PFaces;
                           NumPoints  : dword);
IMPLEMENTATION
{         }
USES Mcga;
{         }

FUNCTION Rad (Deg:real):Real;
Begin
  Rad:=Deg*(Pi/180.0);
End;

PROCEDURE MakeCosTable;
Var
  CntVal : Word;
  CntAng : Real;
  IncDeg : Real;
Begin
  IncDeg := 2*PI/NumSinVal;
  CntAng := IncDeg;
  CntVal := 0;
  Repeat
    CosTable [CntVal] := Round(255*cos(CntAng));
    CntAng := CntAng+IncDeg;
    Inc (CntVal);
  Until CntVal>1024;
End;

FUNCTION FastSin (Angle3D:longint):longint;Assembler;
Asm
  mov  edi,Offset CosTable
  mov  edx,[Angle3D]
  mov  ebx,1024
  add  edx,256
  cmp  edx,ebx   { Check overflow }
  jle  @@Ok
  sub  edx,1024
@@Ok:
  shl  edx,2
  add  edi,edx
  mov  eax,[edi]
End;

FUNCTION FastCos (Angle3D:longint):longint;assembler;
Asm
  mov  edi,Offset CosTable
  mov  edx,[Angle3D]
  shl  edx,2
  add  edi,edx
  mov  eax,[edi]
End;

PROCEDURE Calc3DRotations (SinX,CosX,SinY,CosY,SinZ,CosZ:longint;
                           POrgPoints , PDesPoints : PPoints;
                           NumPoints  : dword );
Var
  X1,Y1,Z1  : longint;
  Aux1,Aux2 : longint;
  CntPoints : dword;
Begin
  For CntPoints:=0 to NumPoints do
    Begin
{     X1   := (cos(YAngle) * X  - sin(YAngle) * Z);}
      Aux1 := CosY*POrgPoints^[CntPoints].x;asm mov eax,[Aux1];sar eax,8;mov [Aux1],eax end;
      Aux2 := SinY*POrgPoints^[CntPoints].z;asm mov eax,[Aux2];sar eax,8;mov [Aux2],eax end;
      X1   := Aux1-Aux2;
{     Z1   := (sin(YAngle) * X  + cos(YAngle) * Z);}
      Aux1 := SinY*POrgPoints^[CntPoints].x;asm mov eax,[Aux1];sar eax,8;mov [Aux1],eax end;
      Aux2 := CosY*POrgPoints^[CntPoints].z;asm mov eax,[Aux2];sar eax,8;mov [Aux2],eax end;
      Z1   := Aux1+Aux2;
{     X    := (cos(ZAngle) * X1 + sin(ZAngle) * Y);}
      Aux1 := CosZ*X1;asm mov eax,[Aux1];sar eax,8;mov [Aux1],eax end;
      Aux2 := SinZ*POrgPoints^[CntPoints].y;asm mov eax,[Aux2];sar eax,8;mov [Aux2],eax end;
      PDesPoints^[CntPoints].x:= Aux1+Aux2;
{     Y1   := (cos(ZAngle) * Y  - sin(ZAngle) * X1);}
      Aux1 := CosZ*POrgPoints^[CntPoints].y;asm mov eax,[Aux1];sar eax,8;mov [Aux1],eax end;
      Aux2 := SinZ*X1;asm mov eax,[Aux2];sar eax,8;mov [Aux2],eax end;
      Y1   := Aux1-Aux2;
{     Z    := (cos(XAngle) * Z1 - sin(XAngle) * Y1);}
      Aux1 := CosX*Z1;asm mov eax,[Aux1];sar eax,8;mov [Aux1],eax end;
      Aux2 := SinX*Y1;asm mov eax,[Aux2];sar eax,8;mov [Aux2],eax end;
      PDesPoints^[CntPoints].z := Aux1-Aux2;
{     Y    := (sin(XAngle)) * Z1 + cos(XAngle) * Y1);}
      Aux1 := SinX*Z1;asm mov eax,[Aux1];sar eax,8;mov [Aux1],eax end;
      Aux2 := CosX*Y1;asm mov eax,[Aux2];sar eax,8;mov [Aux2],eax end;
      PDesPoints^[CntPoints].y := Aux1+Aux2;
    End;
End;

PROCEDURE Proyect (XScr, YScr : longint;
                   POrgPoints , PDesPoints : PPoints;
                   NumPoints  : dword);
Var
  CntPoints: dword;
Begin
  For CntPoints:=0 to NumPoints do
    Begin
{ Clipping in Z ;}
      If POrgPoints^[CntPoints].z>=Zorg then
        Begin
      { What happen if point are behind me? }
          PDesPoints^[CntPoints].x:=320;
          PDesPoints^[CntPoints].y:=200;
        End
      else
        Begin
          PDesPoints^[CntPoints].x:=XScr+((XOrg*POrgPoints^[CntPoints].z-POrgPoints^[CntPoints].x*ZOrg)
                                          div(POrgPoints^[CntPoints].z-ZOrg));
          PDesPoints^[CntPoints].y:=YScr+((YOrg*POrgPoints^[CntPoints].z-POrgPoints^[CntPoints].y*ZOrg)
                                          div(POrgPoints^[CntPoints].z-ZOrg));
        End;
    End;
End;
{ Comprueba si la coordenada z del vector normal al plano definido    }
{ por (X1,Y1,Z1),(X2,Y2,Z2),(X3,Y3,Z3) sea positiva o no.             }
{ OJO!!! Se definen los puntos de los planos que se ven en el sentido }
{ de las agujas del reloj.                                            }
{                                               <rom / Slords Sep 94  }
FUNCTION Visible (X1,Y1,X2,Y2,X3,Y3:longint):Boolean;assembler;
Asm
  mov  ecx,[X2]       { reg dx = (X2-X1)*(Y3-Y1)) }
  mov  ebx,[X1]
  sub  ecx,ebx
  mov  eax,[Y3]
  mov  ebx,[Y1]
  sub  eax,ebx
  imul ecx
  mov  edx,eax
  push edx
  mov  ecx,[X3]       { reg ax = (X3-X1)*(Y2-Y1) }
  mov  ebx,[X1]
  sub  ecx,ebx
  mov  eax,[Y2]
  mov  ebx,[Y1]
  sub  eax,ebx
  imul ecx
  pop  edx
  sub  edx,eax        { reg dx =(X2-X1)*(Y3-Y1)-(X3-X1)*(Y2-Y1) }
  js   @@InVisible { Si el resultado de la resta es negativo Invisible,}
  mov  eax,01
  jmp  @@Fin
@@InVisible:
   xor eax,eax
@@Fin:
End;

PROCEDURE QuickSortZ (PPoints2qS:PPoints;  PFaces2qS:PFaces; NumPoints:dword);
Var
  Cnt        : dword;
{ Specific sort }
  Procedure QSort (First, Last: longint; Var Split1: longint; Var Split2: longint);
  Var
    AuxFace    : TFace3D;
    ZVal       : real;
  Begin
    ZVal := PFaces2qS^[(First+Last) shr 1].z;
    Repeat
      While PFaces2qS^[First].z < ZVal do  Inc (First);
        While PFaces2qS^[Last].z > ZVal do Dec (Last );
          If First <= Last then
            Begin
              AuxFace         := PFaces2qS^[First];
              PFaces2qS^[First] := PFaces2qS^[Last];
              PFaces2qS^[Last]  := AuxFace;
              Inc (First);
              Dec (Last);
            End;
    Until First > Last;
    Split1 := First;
    Split2 := Last;
  End;
{ Generic QuickSort }
  Procedure QuickSort (First, Last:longint);
  Var
    SplitPt1, SplitPt2: longint;
  Begin
    If First < Last then
      Begin
        qSort (First, Last, SplitPt1, SplitPt2);
        If SplitPt1 < Last then QuickSort  (SplitPt1, Last);
        If First < SplitPt2 then QuickSort (First, SplitPt2);
      End;
end;
{QuickSortZ}
Begin
 { Calculate CenterZ coor. for each face }
   For Cnt :=0 to NumPoints do
     PFaces2qS^[Cnt].z:= (PPoints2qS^[PFaces2qS^[Cnt].a].z+
                          PPoints2qS^[PFaces2qS^[Cnt].b].z+
                          PPoints2qS^[PFaces2qS^[Cnt].c].z);
 { reOrder it QUICKLY!!!! }
   QuickSort (0,NumPoints);
End;

BEGIN
  MakeCosTable;
END.