


#include <stdio.h>
#include <stdlib.h>
#include "svc.h"
#include "ole.h"


static void dumpsymboldictionary(LIBHDR *libheader, FILE *inlibfh);



main(int argc, char **argv)
{
  FILE *inlibfh;
  LIBHDR libheader;
  long modfilepos;

  if (argc != 2)
     output(error, NOFILE, "Usage : %s file.lib\n", argv[0]);

  if ((inlibfh = fopen(argv[1], "rb")) == NULL)
     output(error, NOFILE, "Couldn't open file %s\n", argv[1]);

  getlibheader(&libheader, inlibfh);
  dumpsymboldictionary(&libheader, inlibfh);

  return 0;
}


static void dumpsymboldictionary(LIBHDR *libheader, FILE *inlibfh)
{
  int blockidx, bucketidx;
  DICTENTRY dictentry;
  char *modulename;
  char *symbolp;

  for (blockidx = 0; blockidx < libheader->numdictblocks; blockidx++)
     for (bucketidx = 0; bucketidx < NUMBUCKETS; bucketidx++)
      {
        dictentry = getsymdictentry(blockidx, bucketidx, libheader, inlibfh);
        if (dictentry.isfound == FALSE)
           continue;

        /* get the symbol name */
        symbolp = makeasciiz(dictentry.symbolp);

        /* get the corresponding module name record (THEADR or COMENT) */
        modulename = getmodulename(dictentry.modulefilepos, libheader, inlibfh);
        printf("%s -- Module %s (%08lxh)\n", symbolp, modulename, dictentry.modulefilepos);
        printf("Hash: Block %d, Bucket %d\n", blockidx, bucketidx);
        free(symbolp);
        free(modulename);
      }

  return;
}

