/*
    FILEIO.H is a fileinput-output handler..
    I had to make this because the standard C library files
    couldn't handle "far" allocated memory. far is a Borland C
    extended keyword and may not work correctly on other systems.

    Ola Andersson, 1996-01-04
*/

#pragma inline
#include "mandel.h"

int gFileHandle;

/*
    The following routines uses the DOS int 21h functions
    to create, open, write, read, close ... files on your system.

    Be warned! They were written to work in a very specific enviroment
    and using them for other purposes than this Fractalprogram may cause
    problems to your computer.

    Almost no error checkings are made.
*/

int delete_file(char far *filestr)
{
    asm push ds
    asm mov  ax, 0x4100
    asm lds  dx, filestr
    asm int  0x21
    asm jnc  done
    asm mov  ax, -1

done:;

    asm pop  ds
return _AX;
}

int open_file(char far *filestr)
{
    asm push ds
    asm lds  dx, filestr

    asm mov  ax, 0x3d02     /* opens the file for read/write */
    asm int  0x21
    asm jnc  done

    asm mov  ax, 0x3c00     /* if error try creating it */
    asm mov  cx, 0x20       /* single archive attribute */
    asm int  0x21
    asm jc   error          /* error. probably write protection */

    asm mov  ax, 0x3d02     /* then try to open it again */
    asm int  0x21
    asm jnc  done

error:;
    asm mov  ax, -1

done:;
    asm pop  ds

return _AX;
}

int open_file_read(char far *filestr)
{
    asm push ds
    asm lds  dx, filestr

    asm mov  ax, 0x3d00     /* opens the file for read */
    asm int  0x21
    asm jnc  done

error:;
    asm mov  ax, -1

done:;
    asm pop  ds

return _AX;
}

int open_file_write(char far *filestr)
{
    delete_file(filestr);   /* deletes a file if present */

    asm push ds
    asm lds  dx, filestr

    asm mov  ax, 0x3c00     /* try creating it */
    asm mov  cx, 0x20       /* single archive attribute */
    asm int  0x21
    asm jc   error          /* error. probably write protection */

    asm mov  ax, 0x3d01     /* opens the file for write */
    asm int  0x21
    asm jnc  done

error:;
    asm mov  ax, -1

done:;
    asm pop  ds

return _AX;
}

int close_file(int handle)
{
    asm mov  ah, 0x3d
    asm mov  bx, handle
    asm int  0x21
    asm jnc  done
    asm mov  ax, -1

done:;

return _AX;
}

int read_buffer(int handle, void far *buffer, unsigned int size)
{
    asm push ds
    asm mov  bx, handle
    asm lds  dx, buffer
    asm mov  ax, 0x3f00
    asm mov  cx, size
    asm int  0x21
    asm pop  ds

return _AX;
}

int write_buffer(int handle, void far *buffer, unsigned int size)
{
    asm push ds
    asm mov  bx, handle
    asm lds  dx, buffer
    asm mov  ax, 0x4000
    asm mov  cx, size
    asm int  0x21
    asm pop  ds

return _AX;
}
