/*
    GENMAND.C cotains the routines for handling
    the assembler made scanline of the mandelbrot set.

    Ola Andersson, 1996-01-04
*/

#include <math.h>
#include <alloc.h>
#include <process.h>
#include "mandel.h"

extern void CalcLine(unsigned char far *);
/* extern void CalcCLine(unsigned char far *); */
extern void CopyLine(unsigned char far *, unsigned char far *, int);

void generate_mandel( void )
{
    int pressed, step;

    save_settings();

    if(!video_on)
    {
        init_video(0x13);
        video_on = 1;
    }

    if(disk_pot)
    {
        if((gFileHandle = open_file_write(gFileName)) == -1)
            abort();

        step_zoom = 1;

        write_buffer(gFileHandle, &Maxx, sizeof(int));
        write_buffer(gFileHandle, &Maxy, sizeof(int));
        write_buffer(gFileHandle, &step_zoom, sizeof(int));
    }

    sX1 = (tX1 * dPow); sY1 = (tY1 * dPow);
    sX2 = (tX2 * dPow); sY2 = (tY2 * dPow);

    gen_mandel_bmp(bitmap);

    if(on_screen)
        show_on_screen(bitmap, Maxx, Maxy);

    if(disk_pot)
    {
        encode((char far *) bitmap, Maxx*Maxy);
        close_file(gFileHandle);

        /* The Calculations were aborted, nothing will be saved */
        if(break_handle)
            delete_file(gFileName);
    }

    get_all_key();
    break_handle = 0;

    if(video_on)
    {
       init_video(0x3);
       video_on = 0;
    }

    restore_settings();
}

void gen_mandel_bmp( unsigned char far *bitmap )
{
    volatile int row, nrow;
    char rowmap[200];

    delta_X = (sX2 - sX1) / Maxx;
    delta_Y = (sY2 - sY1) / Maxy;

    for(row = 0; row < Maxy; row++)
        rowmap[row] = 0;

    pY = sY1;

    for(row = 0; (row < Maxy) && (!break_handle); row++)
    {
        if(!rowmap[row])
        {
            CalcLine(ScanLine);
            CopyLine(ScanLine, bitmap, (int) row);
            rowmap[row] = 1;

            if((-pY >= sY2) && (pY >= 0))
            {
                nrow = (int) - ((pY + sY1) / delta_Y);
                CopyLine(ScanLine, bitmap, (int) nrow);
                rowmap[nrow] = 1;
            }
        }

        switch(evaluate_keys())
        {
            case K_Z:   make_zoom_box();
                        break;
            case K_Esc: break_handle = 1;
                        break;
        }

        pY += delta_Y;
    }
}


void make_zoom_box(void)
{
#ifdef _MOUSE_DONE_
    int mX, mY;

    show_mouse_cursor();

    while(!mouse_pressed())  /* wait for mouse_button to be pressed   */
        ;

    get_mouse( &mX, &mY);        /* get current mouse location    */

    dX = (mX * (tX2 - tX1)) / Maxx;  /* calculates the Target coords  */
    dY = (mX * (tX2 - tX1)) / Maxy;  /* from mouse location on screen */
#endif
}

/*
    CalcCLine is a C subset of the assembler one. This could take
    use when the difference in coordinates gets to small for the
    assemblers integer shifting. (2^27).

    This routine is not in use for the moment.
*/

#ifdef _FLOAT_ENABLE_
void CalcCLine(unsigned char far *ScanLine)
{
    long double p, q, xk, yk, fBailout;
    long double a, c, sPow, dx;
    int k, co, col;

    sPow = dPow;

    fBailout = Bailout / sPow;
    q = pY / sPow;
    p = sX1 / sPow;

    dx = (tX2 - tX1) / Maxx;

    for(col = 0; col < Maxx; col++, p += dx)
    {
        xk = p;
        yk = q;
        k = Maxit;

k_not_zero:;
        a = (xk*yk*2);
        xk = (xk*xk) - (yk*yk);             /* xk = xk*xk - yk*yk */
        yk = a;                             /* yk = (yk*xk*2) + q */

        c = (xk*xk) + (yk*yk);              /* c = yk*yk + xk*xk */

        if(c >= fBailout)
            goto found_pixel_out_of_here;

        a += p;
        xk += q;

        if(--k)
            goto k_not_zero;

        co = 1;
        goto write_pixel_and_dump;

found_pixel_out_of_here:;
        co = Maxit - k;

        if(!co)
            co = 1;

write_pixel_and_dump:;
        ScanLine[col] = co;
    }
}
#endif
