/*
    GENMANDZ.C is what makes the coordinate to struggle
    for a single point and still calculates when you
    wake up in the morning after a good nights sleep. (below PENTIUM)

    Ola Andersson, 1996-01-04
*/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "mandel.h"

void start_mandel_fly( void )
{
    long  double aTop, aLeft, aBottom, aRight;
    long  double min;

    volatile int step;  /* volatile Important */

    save_settings();

    if(!video_on)
    {
        init_video(0x13);
        video_on = 1;
    }

    if(disk_pot)
    {
        if((gFileHandle = open_file_write(gFileName)) == -1)
            abort();

        write_buffer(gFileHandle, &Maxx, sizeof(int));
        write_buffer(gFileHandle, &Maxy, sizeof(int));
        write_buffer(gFileHandle, &step_zoom, sizeof(int));
    }

    step = step_zoom;

    while ((step-- > 0) && (!break_handle))
    {
        sX1 = (tX1 * dPow); sY1 = (tY1 * dPow);
        sX2 = (tX2 * dPow); sY2 = (tY2 * dPow);

        gen_mandel_bmp(bitmap);

        if(on_screen)
            show_on_screen(bitmap, Maxx, Maxy);

        if(disk_pot)
            encode((char far *) bitmap, Maxx*Maxy);

        aTop = (tY1 - dY); aBottom = (tY2 - dY);
        aLeft = (tX1 - dX); aRight = (tX2 - dX);

        min = (aTop < aLeft) ? aTop: aLeft;
        min = (min < aBottom) ? min: aBottom;
        min = (min < aRight) ? min: aRight;

        tX1 -= (aLeft * aLeft / (dec_coord * min));
        tY1 += (aTop * aTop / (dec_coord * min));
        tX2 += (aRight * aRight / (dec_coord * min));
        tY2 -= (aBottom * aBottom / (dec_coord * min));
    }

    if(disk_pot)
    {
        close_file(gFileHandle);

        if(break_handle)
            delete_file(gFileName);
    }

    get_all_key();
    break_handle = 0;   /* everything is taken care of... */

    if(video_on)
    {
        init_video(0x03);
        video_on = 0;
    }

    restore_settings();
}
