#ifndef _mandel_h_
#define _mandel_h_
#include "keydef.h"

extern void process_args( int argc, char *argv[] );
extern void start_menu( void );

/* These below are for speed defined in Mbrot.asm */
extern unsigned long Bailout, dPow;
extern signed   long	sX1, sY1, sX2, sY2;
extern unsigned int  Maxx, Maxy, Maxit;
extern signed long delta_X, delta_Y;
extern signed long pX, pY;
/**************************************************/
extern void gen_mandel_bmp( unsigned char far *bitmap );
extern unsigned char far bitmap[64000L];   /* bitmap were to put fractal */
extern unsigned char far ScanLine[320];

extern void save_settings( void );
extern void restore_settings( void );
extern void show_on_screen( unsigned char far *, int, int );
extern void gen_mandel_bmp( unsigned char far * );
extern void start_mandel_fly( void );
extern void generate_mandel( void );
extern void mandel_restore_show( void );
extern int  load_palette(void);
extern void make_zoom_box( void );

extern void restore_memory(void);
extern void init_memory( void );
extern void init_video( int );
extern int  get_all_key( void );
extern int  evaluate_keys( void );

extern int delete_file(char far *filestr);
extern int open_file(char far *filestr);
extern int open_file_read(char far *filestr);
extern int open_file_write(char far *filestr);

extern int close_file(int handle);
extern int read_buffer(int, void far *, unsigned int );
extern int write_buffer(int, void far *, unsigned int );

extern int encode( char far *bmp, unsigned int size );
extern int decode( char far *bmp, unsigned int size );

extern char gFileName[256];/* file name to open/read/write/close */
extern char gRestoreFile[256];/* file name to open/read/write/close */
extern char gPaletteFile[256]; /* file name 4 palette */

extern int gFileHandle;    /* Global FileHandle */

extern int disk_pot;			/* if true => save to disk */
extern int on_screen;		/* if true => show on screen */
extern int mouse_on;			/* if true => mouse can be used */
extern int video_on;			/* if true => video is configured */
extern int julia;				/* if true => output is a julia */
extern int step_zoom;	   /* how many steps in the zooming */
extern int dec_coord;      /* = (100 / (percent 2 decrease)) */
extern int mandel_zoom;    /* if true => zooming mode is on */
extern int mandel_restore; /* if true => restore from file */
extern int mandel_write;
extern int break_handle;

extern long double tX1, tY1, tX2, tY2;		/* position coordinates */
extern long double dX, dY;	/* target coordinates */
#endif
