#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "mandel.h"
#include "menu.h"

struct xMenu MainMenu;
struct xMenu GenerateMandel;
struct xMenu RealtimeZoomMandel;
struct xMenu ChangeSettings;

void start_menu( void )
{
    int choosen;
    define_menus();
    init_video(0x03);

    while((choosen = do_menu(MainMenu)) != MainMenu.items)
    {
        switch(choosen)     {
            case    1:      start_gen_mandel(); break;
            case    2:      start_gen_realtime(); break;
            case    3:      mandel_restore_show(); break;
            case    4:      start_change_settings(); break;
        }
    }

    init_video(0x03);
}

void start_gen_mandel( void )
{
    int choosen;
    while((choosen = do_menu(GenerateMandel)) != GenerateMandel.items)
    {
        switch(choosen)     {
            case    1:      on_screen = 1;
                            generate_mandel();
                            break;

            case    2:      on_screen = 1;
                            disk_pot = 1;
                            generate_mandel();
                            break;

            case    3:      start_change_settings();
                            break;
        }
    }
}

void start_gen_realtime( void )
{
    int choosen;
    while((choosen = do_menu(RealtimeZoomMandel)) != RealtimeZoomMandel.items)
    {
        switch(choosen)    {
            case    1:      disk_pot = 0; start_mandel_fly(); break;
            case    2:      disk_pot = 1; start_mandel_fly(); break;
            case    3:      start_change_settings(); break;
        }
    }
}

/************************************************************
      1 = Change palette file.        DONE
      2 = Change Restore File name.   DONE
      3 = Change Screen Coordinates.  DONE
      4 = Change Calculating Area.    DONE
      5 = Change Video Modes.
      6 = Change Maxit, Bailout.      DONE
      7 = Change Zoom Factor, Steps   DONE
      8 = Main Menu, Back to Main Menu.
 ************************************************************/

void start_change_settings( void )
{
    int choosen;
    unsigned int iBailout;

    iBailout = (unsigned int) ((long) Bailout / dPow );

    while((choosen = do_menu(ChangeSettings)) != ChangeSettings.items)
    {
        switch(choosen)     {
            case    1:      ChangePalette();
                            break;
            case    2:      ChangeRestoreFile();
                            break;
            case    3:      ChangeCoordinates();
                            break;
            case    4:      change_2integers("[Change Calculation area in pixels]",
                                             "Maxx:", &Maxx,
                                             "Maxy:", &Maxy);
                            break;
            case    5:      break;
            case    6:      change_2integers("[Change Bailout and Maxit]",
                                             "Maxit:", &Maxit,
                                             "Bailout:", &iBailout);
                            Bailout = (long) iBailout * dPow;
                            break;
            case    7:      change_2integers("[Change Zoom Factor and Steps]",
                                             "Zoom Factor:", &dec_coord,
                                             "Steps in Zoom:", &step_zoom);
                            break;
            }
    }
}

int do_menu( struct xMenu pMenu)
{
    int i, k, ch, oldk;
    int ix, iy;

    _setcursortype(_NOCURSOR);
    window(1,1,79,24);
    textbackground(0);
    clrscr();

/* Displays Header */

    window(1,1,79,1);
    textbackground(1);
    clrscr();

    i = 0;

    while(pMenu.header[i++] != NULL)
       ;

    i = (80 - i) >> 1;

    gotoxy(i,1);
    textattr(23);
    cputs(pMenu.header);

/* Displays Footnote */

    window(1,25,79,25);
    textbackground(1);
    clrscr();

    i = sizeof(FootNote_header);
    i = (80 - i) >> 1;

    gotoxy(i,1);
    textattr(23);
    cputs(FootNote_header);

/* Displays the Menu items */

    ix = (80 - MAXLENGTH) >> 1;
    iy = (25 - pMenu.items) >> 1;

    window(ix-2, iy-2, ix+MAXLENGTH+2, iy+pMenu.items+2);
    textbackground(1);
    clrscr();

    gotoxy(4, 2);
    textattr(23);

    cputs("Make your choice with the up and down arrows:");
    for(i = 0; i < pMenu.items; i++)
    {
        gotoxy(4, 4+i);
        cputs(pMenu.Menu_text[i]);
    }

    oldk = k = 0;
    ch = 1;

    while(ch)
    {
        gotoxy(4, 4+oldk);
        textattr(23);
        cputs(pMenu.Menu_text[oldk]);
        gotoxy(4, 4+k);
        textattr(112);
        cputs(pMenu.Menu_text[k]);

        switch(get_all_key())  {
            case K_Tab:
            case K_DownArrow: oldk = k;
                              (k == pMenu.items-1) ? k = 0 : k++;
                              break;
            case K_ShiftTab:
            case K_UpArrow:   oldk = k;
                              (!k) ? k = pMenu.items-1 : k--;
                              break;
            case K_Esc:       k = pMenu.items-1;
            case K_Enter:     ch = 0; break;
        }
    }

return k+1;
}

void define_menus( void )
{
    int i;

    strcpy(MainMenu.header,pMainMenu_header);
    MainMenu.items = pMainMenu_items;
    for(i = 0; i < MainMenu.items; i++)
        strcpy(MainMenu.Menu_text[i], pMainMenu_Menu_text[i]);

    strcpy(GenerateMandel.header, pGenerateMandel_header);
    GenerateMandel.items = pGenerateMandel_items;
    for(i = 0; i < GenerateMandel.items; i++)
        strcpy(GenerateMandel.Menu_text[i], pGenerateMandel_Menu_text[i]);

    strcpy(RealtimeZoomMandel.header, pRealtimeZoomMandel_header);
    RealtimeZoomMandel.items = pRealtimeZoomMandel_items;
    for(i = 0; i < RealtimeZoomMandel.items; i++)
        strcpy(RealtimeZoomMandel.Menu_text[i],
              pRealtimeZoomMandel_Menu_text[i]);

    strcpy(ChangeSettings.header, pChangeSettings_header);
    ChangeSettings.items = pChangeSettings_items;
    for(i = 0; i < ChangeSettings.items; i++)
        strcpy(ChangeSettings.Menu_text[i], pChangeSettings_Menu_text[i]);

}

void change_2integers(char *header,
                      char *firsts, void *afirst,
                      char *seconds, void *asecond )
{
    int k, ch;
    char s1[35], s2[35];
    int *first, *second;

    first = (int *) afirst;
    second = (int *) asecond;

    ultoa((long) *first, s1, 10);
    ultoa((long) *second, s2, 10);

    _setcursortype(_NOCURSOR);
    window(1,1,79,24);
    textbackground(0);
    clrscr();

    window(1,1,79,1);
    textbackground(1);
    clrscr();

    k = 0;

    while(header[++k] != NULL)
       ;

    k = (80 - k) >> 1;

    gotoxy(k,1);
    textattr(23);
    cputs(header);

    window(10, 6, 70, 14);
    textbackground(1);
    clrscr();

    gotoxy(4, 2);
    textattr(23);
    cputs("Make your choice with the up and down arrows:");
    gotoxy(4, 4);
    cputs(firsts);
    gotoxy(4, 6);
    cputs(seconds);

    ch = 1; k = 0;

    while(ch)
    {
        if(!k)
        {
            window(30, 11, 40, 11);
            textbackground(BLUE);
            clrscr();
            textattr(23);
            cprintf("%s", s2);

            window(30, 9, 40, 9);
            textbackground(WHITE);
            clrscr();
            textattr(112);
            cprintf("%s", s1);
        }
        else
        {
            window(30, 9, 40, 9);
            textbackground(BLUE);
            clrscr();
            textattr(23);
            cprintf("%s", s1);

            window(30, 11, 40, 11);
            textbackground(WHITE);
            clrscr();
            textattr(112);
            cprintf("%s", s2);
        }

        switch(get_all_key()) {
            case K_Esc:     ch = 0; break;
            case K_Enter:   _setcursortype(_NORMALCURSOR);
                            clrscr();
                            if(!k)
                            {
                                cscanf("%s", &s1);
                                if(atol(s1))
                                    *first = (int) atol(s1);
                            }
                            else if(k)
                            {
                                cscanf("%s", &s2);
                                if(atol(s2))
                                    *second = (int) atol(s2);
                            }
                            _setcursortype(_NOCURSOR);
                            break;

            default:        k = (!k) ? 1: 0;
        }
    }
}

void ChangeCoordinates( void )
{
    char str[20];
    int k, ch, oldk;
    char data[6][35];

    strcpy(data[0], gcvt(tX1, 9, str));
    strcpy(data[1], gcvt(tY1, 9, str));
    strcpy(data[2], gcvt(tX2, 9, str));
    strcpy(data[3], gcvt(tY2, 9, str));
    strcpy(data[4], gcvt(dX,  9, str));
    strcpy(data[5], gcvt(dY,  9, str));

    window(1,1,79,24);
    textbackground(0);
    clrscr();

    window(1,1,79,1);
    textbackground(1);
    clrscr();
    gotoxy(25,1);
    textattr(23);
    cputs("[Change your screen coordinates]");

    window(10, 6, 70, 20);
    textbackground(1);
    clrscr();

    gotoxy(4, 2);
    textattr(23);

    cputs("Make your choice with the up and down arrows:");

    gotoxy(4, 4);
    cprintf("Upper Left  X  : ");
    gotoxy(4, 6);
    cprintf("Upper Left  Y  : ");
    gotoxy(4, 8);
    cprintf("Lower Right X  : ");
    gotoxy(4, 10);
    cprintf("Lower Right Y  : ");
    gotoxy(4, 12);
    cprintf("Target X value : ");
    gotoxy(4, 14);
    cprintf("Target Y value : ");


    for(k = 0; k != 6; k++)
    {
      gotoxy(40, 4 + 2*k);
      cputs(data[k]);
    }

    oldk = k = 0;
    ch = 1;

    while(ch != K_Esc)
    {
        gotoxy(40, 4 + 2*oldk);
        textattr(23);
        cputs(data[oldk]);

        gotoxy(40, 4 + 2*k);
        textattr(112);
        cputs(data[k]);

        switch(get_all_key())  {
            case K_Tab:
            case K_DownArrow: oldk = k;
                              (k == 5) ? k = 0 : k++;
                              break;
            case K_ShiftTab:
            case K_UpArrow:   oldk = k;
                              (!k) ? k = 5 : k--;
                              break;

            case K_Esc:       ch = 0x011b; break;
            case K_Enter:     textattr(112);
                              window(49, 9 + 2*k, 60, 9 + 2*k);
                              textbackground(WHITE);
                              clrscr();
                              gotoxy(1,1);
                              str[0] = 13;
                              cgets(str);
                              strcpy(data[k], str+2);
                              textbackground(BLUE);
                              clrscr();
                              textattr(23);
                              cputs(data[k]);
                              window(10, 6, 70, 20);
                              break;
        }
    }


    tX1 = _atold(data[0]);
    tY1 = _atold(data[1]);
    tX2 = _atold(data[2]);
    tY2 = _atold(data[3]);
    dX = _atold(data[4]);
    dY = _atold(data[5]);
}

void ChangePalette( void )
{
    char pal[256];

    window(1,1,79,24);
    textbackground(0);
    clrscr();

    window(1,1,79,1);
    textbackground(1);
    clrscr();
    gotoxy(25,1);
    textattr(23);
    cputs("[Change your palette file]");

    window(10, 6, 70, 14);
    textbackground(1);
    clrscr();

    gotoxy(4, 4);
    cprintf("Current Palette File    : [%s]", gPaletteFile);
    gotoxy(4, 6);
    cputs("Full palette File Name  : ");

    textattr(112);
    _setcursortype(_SOLIDCURSOR);

    gotoxy(30, 6);
    pal[0] = 25;
    cgets(pal);

    if(*(pal+2) != NULL)
    {
        strcpy(gPaletteFile, pal+2);
        load_palette();
    }
}

void ChangeRestoreFile( void )
{
    char file[256];

    window(1,1,79,24);
    textbackground(0);
    clrscr();

    window(1,1,79,1);
    textbackground(1);
    clrscr();
    gotoxy(25,1);
    textattr(23);
    cputs("[Change your restore file]");

    window(10, 6, 70, 14);
    textbackground(1);
    clrscr();

    gotoxy(4, 4);
    cprintf("Current Restore file   : [%s]", gRestoreFile);
    gotoxy(4, 6);
    cputs("Full Restore File name : ");

    textattr(112);
    _setcursortype(_SOLIDCURSOR);

    gotoxy(30, 6);
    file[0] = 25;
    cgets(file);

    if(*(file+2) != NULL)
        strcpy(gRestoreFile, file+2);
}
