#ifndef _MENU_H_
#define _MENU_H_
#include "mandel.h"

#define MAXLENGTH 60
#define MAXITEMS  8


extern void start_menu( void );
extern void start_gen_mandel( void );
extern void start_gen_realtime( void );
extern void start_change_settings( void );
extern int do_menu( struct xMenu pMenu);
extern void define_menus( void );

extern void change_2integers(char *header,
                      char *firsts, void *afirst,
                      char *seconds, void *asecond );
extern void ChangeCoordinates( void );
extern void ChangePalette( void );
extern void ChangeRestoreFile( void );

char FootNote_header[] = "Ola Andersson, 1996, email: md94-pan@nada.kth.se";

struct xMenu {
       char header[MAXLENGTH];
       int  items;
       char Menu_text[MAXITEMS][MAXLENGTH+1];
       };

char *pMainMenu_header = "Mandelbrot Fractal analyser, ver 0.9b";
int  pMainMenu_items = 5;
char pMainMenu_Menu_text[5][MAXLENGTH+1] =
     {  "Generate the Mandelbrot set.                                ",
        "Make a (Realtime) Mandelbrot Zooming slideshow (486+).      ",
        "Restore a previously saved file.                            ",
        "Change Settings (Palette, Ranges ... ).                     ",
        "Quit.                                                       "
     };

char *pGenerateMandel_header = "Generate a Mandelbrot";
int  pGenerateMandel_items = 4;
char pGenerateMandel_Menu_text[4][MAXLENGTH+1] =
     {  "On Screen.                                                  ",
        "On Screen + Save to file when done.                         ",
        "Change Settings (Palette, Ranges ... ).                     ",
        "Main Menu, Back to Main Menu.                               "
     };

char *pRealtimeZoomMandel_header = "Real time Zooming in the Mandelbrot set";
int  pRealtimeZoomMandel_items = 4;
char pRealtimeZoomMandel_Menu_text[4][MAXLENGTH+1] =
     {  "Start the trip (zoom in realtime).                          ",
        "Same as above but save to file.                             ",
        "Change Settings (Palette, Ranges ... ).                     ",
        "Main Menu, Back to Main Menu.                               "
     };

char *pChangeSettings_header = "Change default Settings";
int  pChangeSettings_items = 8;
char pChangeSettings_Menu_text[8][MAXLENGTH+1] =
     {  "Change Palette file.                                        ",
        "Change Restore file name.                                   ",
        "Change Screen Coordinates.                                  ",
        "Change Calculating Area.                                    ",
        "Change Video Modes.                (NOT IN USE)             ",
        "Change Maxit, Bailout.                                      ",
        "Change Zoom factor, Steps in Zooming                        ",
        "Back to previous Menu.                                      "
     };

#endif
