//--------------------------------------------------------------------------
//
//      EXAMPLE3.CPP: example for DOS multithreading library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      This example starts 3 identical threads, each of which repeatedly
//      displays a message on the same line.  1-second timeslices are used.
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <conio.h>
#include "threads.h"

class Example3 : public DOSThread
{
  public:
    Example3 (int n)      { num = n; }

  protected:
    virtual void main ();

  private:
    int num;
};

void Example3::main ()
{
    char c [70];
    sprintf (c, "Starting thread %d\n", num);
    fputs (c, stdout);
    sprintf (c, "Thread %d\r", num);
    while (!userbreak())
        fputs (c, stdout);
    sprintf (c, "\nEnd of thread %d\n", num);
    fputs (c, stdout);
}

void main ()
{
    DOSThread::timeslice (18);
    Example3 e1 (1), e2 (2), e3 (3);

    puts ("Press CONTROL-BREAK to terminate");
    puts ("Press any key to start...");
    getch ();

    if (e1.run ())
        puts ("Thread 1 started");
    if (e2.run ())
        puts ("Thread 2 started");
    if (e3.run ())
        puts ("Thread 3 started");
}
