#ifndef MYGRAPH_H
#define MYGRAPH_H

/*
    a simple graphics library
    copyright (c) march 27, 1997 John Paul D'India
*/


/* video functions */
void VideoInit ( void );
void VideoDone ( void );
void VideoRetrace ( void );

/* palette functions */
struct TPalette
{
    char rgb[768];
};
int PaletteLoad ( struct TPalette * pal, char * s );
void PaletteUpdate ( struct TPalette * pal );
void PaletteDone ( struct TPalette * pal );

/* screen functions */
struct TScreen
{
    char * bmp;
};
void ScreenInit ( struct TScreen * scr );
void ScreenDone ( struct TScreen * scr );
void ScreenClear ( struct TScreen * scr );
void ScreenUpdate ( struct TScreen * scr );

/* sprite functions */
struct TSprite
{
    char * bmp;
    int w,h;
};
int SpriteLoad ( struct TSprite * spr, char * s );
void SpriteDone ( struct TSprite * spr );
void SpritePut ( struct TSprite * spr, struct TScreen * scr, int tx, int ty );

#endif
