/*
    The Non-Graphic Game Programming Tutorials
    vol 1. by John Paul D'India
        simple object physics

    copyright (c) march 27, 1997 John Paul D'India
*/

#include <stdio.h>
#include <conio.h>
#include "mygraph.h"

#define GRAVITY 2
#define PRECISION 8

struct TBall
{
    int w, h;
    int x, y;
    int velx, vely;
    int boundx,boundy;
};
void BallInit ( struct TBall * ball, int tw, int th, int bx, int by );
void BallDone ( struct TBall * ball );
void BallUpdate ( struct TBall * ball );
int BallGetX ( struct TBall * ball );
int BallGetY ( struct TBall * ball );


int main ( void )
{
    struct TScreen scr;
    struct TSprite spr;
    struct TPalette pal;
    struct TBall ball;

    ScreenInit ( &scr );
    if (!PaletteLoad(&pal,"ng1.col"))
        return -1;
    if (!SpriteLoad(&spr,"ball.cel"))
        return -1;
    BallInit ( &ball, spr.w, spr.h, 320, 200 );
    VideoInit();
    PaletteUpdate ( &pal );

    do
    {
        ScreenClear ( &scr );
        BallUpdate ( &ball );
        SpritePut ( &spr, &scr, BallGetX (&ball), BallGetY(&ball) );
        VideoRetrace();
        ScreenUpdate ( &scr );
    }
    while (inp(0x60) != 1);
    
    VideoDone();
    BallDone ( &ball );
    SpriteDone ( &spr );
    PaletteDone ( &pal );
    ScreenDone ( &scr );
    return 0;
}


void BallInit ( struct TBall * ball, int tw, int th, int bx, int by )
{
    ball->w = tw*PRECISION;
    ball->h = th*PRECISION;
    ball->x = 0*PRECISION;
    ball->y = 10*PRECISION;
    ball->velx = 3*PRECISION;
    ball->vely = 0*PRECISION;
    ball->boundx = bx*PRECISION;
    ball->boundy = by*PRECISION;
}

void BallDone ( struct TBall * ball )
{
    ball = ball;
}

void BallUpdate ( struct TBall * ball )
{
    ball->x += ball->velx;
    ball->y += ball->vely;
    if (ball->y+ball->h >= ball->boundy)
    {
        ball->y = 2*ball->boundy-ball->y-2*ball->h;
        ball->vely = -ball->vely;
    }
    if (ball->x+ball->w >= ball->boundx)
    {
        ball->x = 2*ball->boundx-ball->x-2*ball->w;
        ball->velx = -ball->velx;
    }
    if (ball->x < 0*PRECISION)
    {
        ball->x = -ball->x;
        ball->velx = -ball->velx;
    }
    ball->vely += GRAVITY;
}

int BallGetX ( struct TBall * ball )
{
    return ball->x/PRECISION;
}

int BallGetY ( struct TBall * ball )
{
    return ball->y/PRECISION;
}

