.model tPascal
.code
;---------------------------------------------------------------------------
; InitInterrupt( IntNo : Word; NewInt : Pointer )
;---------------------------------------------------------------------------
InitInterrupt PROC FAR IntNo : Word, IntVector : DWord
PUBLIC  InitInterrupt
 ; Save _SELF_pointer.
 mov  ax,word ptr ss:[bp+20]
 mov  word ptr cs:[ObjectSeg],ax
 mov  ax,word ptr ss:[bp+18]
 mov  word ptr cs:[ObjectOfs],ax
 ; 
 push dx
 push ds
 push es
 
 ; Set/save interrupt 
 
 mov ax,IntNo
 mov word ptr cs:[Interrupt],ax
 mov ah,35H
 int 21H                        
 ; 
 mov word Ptr cs:[IntOfs],Bx
 mov word Ptr cs:[IntSeg],Es
 ; 
 mov ah,25h
 lds dx,IntVector
 int 21h
 ;
 pop es
 pop ds
 pop dx
 pop bp
 RetF 0006
 ; 
 ObjectAddr label Dword
  ObjectOfs    Dw 0
  ObjectSeg    Dw 0
 ; 
 Interrupt     Dw 0
 ;
InitInterrupt ENDP
;---------------------------------------------------------------------------
;  EntranceToInterrupt;
;---------------------------------------------------------------------------
; STACK :
; Flag
; IntSeg
; IntOfs
; Bp                    <-\
; ProcSeg               <--- 㤠  ⥪
; ProcOfs               <-/
;---------------------------------------------------------------------------
EntranceToInterrupt PROC  FAR
PUBLIC EntranceToInterrupt
 ASSUME  DS:@DATA
 ; 
 pop   word ptr cs:[JmpOfs]
 pop   word ptr cs:[JmpSeg]
 pop bp
 ; 
 push  ax
 push  bx
 push  cx
 push  dx
 push  ds
 push  es
 push  word ptr cs:[ObjectSeg]  ; [+8]
 push  word ptr cs:[ObjectOfs]  ; [+6]
 push  di                       ; [+4]
 push  si                       ; [+2]
 push  bp                       ; [+0]
 mov   bp,sp                    ; 
 ; 
 les di, dword ptr cs:[ObjectAddr]
 ; 
 JmpFar    Db 0EAh
 JmpOfs    Dw 000h
 JmpSeg    Dw 000h
EntranceToInterrupt  ENDP
;---------------------------------------------------------------------------
; CallOldInterrupt
;---------------------------------------------------------------------------
; STACK :
;   ProcSeg   
;   ProcOfs   
;---------------------------------------------------------------------------
CallOldInterrupt Proc Far
PUBLIC CallOldInterrupt
  ; 
  pop  word ptr cs:[TmpOfs]
  pop  word ptr cs:[TmpSeg]
  pushf                          
  push word ptr cs:[TmpSeg]
  push word ptr cs:[TmpOfs]
  ;
  JmpInt   Db 0EAh
  InterruptProc label Dword
  IntOfs   Dw 000h
  IntSeg   Dw 000h
  ;
  TmpOfs   Dw 000h
  TmpSeg   Dw 000h
  ;
CallOldInterrupt EndP
;---------------------------------------------------------------------------
;  ExitFromInterrupt;
;---------------------------------------------------------------------------
; STACK :
;  FLAG
;  IntSeg
;  IntOfs
;  ax
;  bx
;  cx
;  dx
;  ds
;  es
;  ObjectSeg   
;  ObjectOfs   
;  Di
;  Si
;  Bp
;  ProcSeg     
;  ProcOfs     
;---------------------------------------------------------------------------
ExitFromInterrupt PROC  FAR
PUBLIC ExitFromInterrupt
 add sp,4               
 pop bp
 pop si
 pop di
 add sp,4               
 pop es
 pop ds
 pop dx
 pop cx
 pop bx
 pop ax
 IRET
ExitFromInterrupt  ENDP
;---------------------------------------------------------------------------
;
;  DoneInterrupt
;
;---------------------------------------------------------------------------
DoneInterrupt PROC FAR
PUBLIC DoneInterrupt
 mov  ax,word ptr cs:[Interrupt]
 mov  ah,25h
 push ds
 lds  dx,dword ptr cs:[InterruptProc]
 int  21h
 pop  ds
 ret
DoneInterrupt ENDP
;---------------------------------------------------------------------------
END
