
(*
  A unit to implement FULL Ansi output.  Useful for a BBS or DOOR program
  where you would want to send string out over the modem.  Simply call
  your modem routine to :

             SendSTRING(port,AnsiGoToXY(1,1))

  Would reposition the cursor on the remote terminal.  Get the idea ??

  The thing will EVEN play Ansi music !!

  Gayle Davis 1/24/94      Edited by Andrew Eigus 2/09/96

1) Added allowance for "esc[M " as a valid music prefix.  It is used
   occasionally.

2) Changed the effect of "esc[0m" from "NormVideo" to "textattr:=7",
   which is what "esc[0m" literally means.  NormVideo just restores
   startup colors, which could be anything.

3) Added "HighVideo" line to take effect *immediately* when "esc[1m"
   ("Bold") is encountered.  Otherwise, "esc[1m" by itself would not
   activate "Bold".

4) Changed "{blink on}" from "5 : textattr := textattr +  blink;"
.                            "5 : textattr := textattr or blink;"
.                                                      ^^
   The "blink ON" was turning blink OFF when blink was turned ON
   with blink already ON.

5) Added "textattr and blink" to preserve blink status in the
   "{general foregrounds}" subroutine.

6) Changed default tempo assignment from "Min1:=120" to "Min1:=120/4"
   in order to be consistent with the way the unit deals with tempo.

7) Added an initialization line of "TextAttr:=7;" to allow for the
   fact that some Ansi artists assume that the screen is normal white
   on black to start with.  (My screen is NOT that color!)

DAVID DANIEL ANDERSON
09/08/94

*)

Unit AnsiIO;

interface

const AnsiEnabled : boolean = True; { ansi output enabled/disabled }

function AnsiClrScr : string;
function AnsiClrEol : string;
function AnsiGotoXY(X, Y : word) : string;
function AnsiUp(Lines : word) : string;
function AnsiDown(Lines : word) : string;
function AnsiRight(Cols : word) : string;
function AnsiLeft(Cols : word) : string;
function AnsiColor(Fg, Bg : byte) : string;
function AnsiAttr(FgBg : byte) : string;
function AnsiMusic(const s : string) : string;
procedure AnsiWrite(s : string);
procedure AnsiWriteLn(s : string);

implementation

uses Crt, VPUtils;

const ColorArray : array[0..7] of integer = (0,4,2,6,1,5,3,7);

var
  Bold, TruncateLines : boolean;
  Vari, Octave, Numb : integer;
  Test, Dly, Intern, DlyKeep : longInt;
  Flager, ChartoPlay : char;
  Typom, Min1, Adder : real;

 escape,blink,high,norm,any,any2,fflag,gflag: boolean;
 ansi_string: string;
const
  ddansibanner: boolean = true;


const
 scale: array[0..7] of integer = (0,4,2,6,1,5,3,7);
 scaleh: array[0..7] of integer = (8,12,10,14,9,13,11,15);
var
 bbb: boolean;
 t: char;
 restx,resty,curcolor: integer;
 Note_Octave: integer;
 Note_Fraction, Note_Length, Note_Quarter: real;



{****************************************************************************}
{***                                                                      ***}
{***       Function that returns the Ansi code for a Clear Screen.        ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiClrScr : string;
Begin
  if AnsiEnabled then
    AnsiClrScr := #27'[2J'
  else
    AnsiClrScr := ''
End; { AnsiClrScr }

{****************************************************************************}
{***                                                                      ***}
{***    Function that returns the Ansi code for a Clear to End of Line.   ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiClrEol : string;
Begin
  if AnsiEnabled then
    AnsiClrEol := #27'[K'
  else
    AnsiClrEol := ''
End; { AnsiClrEol }

{****************************************************************************}
{***                                                                      ***}
{***   Function that returns the Ansi code to move the cursor to (X,Y).   ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiGotoXY(X, Y : word) : string;
Begin
  if AnsiEnabled then
    AnsiGotoXY := Concat(#27'[', Int2Str(Y), ';', Int2Str(X), 'H')
  else
    AnsiGotoXY := ''
End; { AnsiGotoXY }

{****************************************************************************}
{***                                                                      ***}
{***  Function that returns the Ansi code to move the cursor up "Lines"   ***}
{***                         number of lines.                             ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiUp(Lines : word) : string;
Begin
  if AnsiEnabled then
    AnsiUp := Concat(#27'[', Int2Str(Lines), 'A')
  else
    AnsiUp := ''
End; { AnsiUp }

{****************************************************************************}
{***                                                                      ***}
{***  Function that returns the Ansi code to move the cursor down "Lines" ***}
{***                        number of lines.                              ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiDown(Lines : word) : string;
Begin
  if AnsiEnabled then
    AnsiDown := Concat(#27'[', Int2Str(Lines), 'B')
  else
    AnsiDown := ''
End; { AnsiDown }

{****************************************************************************}
{***                                                                      ***}
{***     Function that returns the Ansi code to move the cursor "Cols"    ***}
{***                         positions forward.                           ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiRight(Cols : word) : string;
Begin
  if AnsiEnabled then
    AnsiRight := Concat(#27'[', Int2Str(Cols), 'C')
  else
    AnsiRight := ''
End; { AnsiRight }

{****************************************************************************}
{***                                                                      ***}
{***     Function that returns the Ansi code to move the cursor "Cols"    ***}
{***                        positions backward.                           ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiLeft(Cols : word) : string;
Begin
  if AnsiEnabled then
    AnsiLeft := Concat(#27'[', Int2Str(Cols), 'D')
  else
    AnsiLeft := ''
End; { AnsiLeft }


{****************************************************************************}
{***                                                                      ***}
{***    Function that returns the Ansi code to change the screen color    ***}
{***             to an "Fg" foreground and a "Bg" background.             ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiColor(Fg, Bg : byte) : string;
var Temp : string[10];
Begin
  if AnsiEnabled then
  begin
    TextAttr := Fg + Bg shl 4;
    Temp := #27'[';
    if Bg > LightGray then
      Temp := Temp + '5;'
    else
      Temp := Temp + '0;';
    if Fg > LightGray then
      Temp := Temp + '1;'
    else
      Temp := Temp + '2;';
    AnsiColor := Concat(Temp,
      Int2Str(ColorArray[Fg mod 8] + 30), ';',
      Int2Str(ColorArray[Bg mod 8] + 40), 'm')
  end else AnsiColor := ''
End; { AnsiColor }

{****************************************************************************}
{***                                                                      ***}
{*** Function that returns an Ansi code to change TextAttr                ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiAttr(FgBg : byte) : string;
Begin
  AnsiAttr := AnsiColor(FgBg and 15, FgBg shr 4)
End; { AnsiAttr }

{****************************************************************************}
{***                                                                      ***}
{*** Function that returns an Ansi code representing a music string ("s") ***}
{***                                                                      ***}
{****************************************************************************}
Function AnsiMusic(const s : string) : string;
Begin
  if AnsiEnabled then
    AnsiMusic := Concat(#27'[MF', s, #14)
  else
    AnsiMusic := ''
End; { AnsiMusic }

{****************************************************************************}
{***                                                                      ***}
{***  Procedure that simulates BASIC's "PLAY" procedure.  Will also work  ***}
{***      with Ansi codes.  Taken from PC Magazine Volume 9 Number 3      ***}
{***                                                                      ***}
{****************************************************************************}
   procedure Play(SoundC : string);
      function IsNumber(ch : char) : boolean;
         begin
            IsNumber := (CH >= '0') AND (CH <= '9');
         end;

   {Converts a string to an integer}
      function value(s : string) : integer;
         VAR
            ss : integer;
            sss : longint;
         begin
            Val(s, ss, sss);
            value := ss;
         end;

   {Plays the selected note}
      procedure sounder(key : char; flag : char);
         VAR
            old, New, new2 : Real;
         begin
            adder := 1;
            old := dly;
            New := dly;
            intern := Pos(key, 'C D E F G A B')-1;
            IF (flag = '+') AND (key <> 'E') AND (key <> 'B') {See if note}
               THEN Inc(intern);                              {is sharped }
            IF (flag = '-') AND (key <> 'F') AND (key <> 'C')
               THEN Dec(intern);                              {or a flat. }
            WHILE SoundC[vari+1] = '.' DO
               begin
                  Inc(vari);
                  adder := adder/2;
                  New := New+(old*adder);
               end;
            new2 := (New/typom)*(1-typom);
{$IFDEF VIRTUALPASCAL}
            PlaySound(Round(Exp((octave+intern/12)*Ln(2))), Trunc(New));
{$ELSE}
            sound(Round(Exp((octave+intern/12)*Ln(2)))); {Play the note}
            Delay(Trunc(New));
            Nosound;
{$ENDIF}

            Delay(Trunc(new2));
         end;

   {Calculate delay for a specified note length}
      function delayer1 : integer;
         begin
            numb := value(SoundC[vari+1]);
            delayer1 := Trunc((60000/(numb*min1))*typom);
         end;

   {Used as above, except reads a number >10}

      function delayer2 : Integer;
         begin
            numb := value(SoundC[vari+1]+SoundC[vari+2]);
            delayer2 := Trunc((60000/(numb*min1))*typom);
         end;

      begin                           {Play}
         SoundC := SoundC+' ';
         FOR vari := 1 TO Length(SoundC) DO
            begin                     {Go through entire string}
               SoundC[vari] := Upcase(SoundC[vari]);
               CASE SoundC[vari] OF
{Check to see}    'C','D','E',
{if char is a}    'F','G','A',
{note}            'B' : begin
                           flager := ' ';
                           dlykeep := dly;
                           chartoplay := SoundC[vari];
                           IF (SoundC[vari+1] = '-') OR
                              (SoundC[vari+1] = '+') THEN
{Check for flats & sharps}    begin
                                 flager := SoundC[vari+1];
                                 Inc(vari);
                              end;
                           IF IsNumber(SoundC[vari+1]) THEN
                              begin
                                 IF IsNumber(SoundC[vari+2]) THEN
                                    begin
                                       test := delayer2;
{Make sure # is legal}                 IF numb < 65 THEN
                                          dly := test;
                                       Inc(vari, 2);
                                    end
                                 ELSE
                                    begin
                                       test := delayer1;
{Make sure # is legal}                 IF numb > 0 THEN
                                          dly := test;
                                       Inc(vari);
                                    end;
                              end;
                           sounder(chartoplay, flager);
                           dly := dlykeep;
                        end;
{Check for}       'O' : begin
{octave change}            Inc(vari);
                           CASE SoundC[vari] OF
                              '-' : IF octave > 1 THEN Dec(octave);
                              '+' : IF octave < 7 THEN Inc(octave);
                              '1','2','3',
                              '4','5','6',
                              '7' : octave := value(SoundC[vari])+4;
                           ELSE Dec(vari);
                           end;
                        end;
{Check for a}     'L' : IF IsNumber(SoundC[vari+1]) THEN
{change in length}         begin
{for notes}                   IF IsNumber(SoundC[vari+2]) THEN
                                 begin
                                    test := delayer2;
                                    IF numb < 65 THEN
{Make sure # is legal}                 dly := test;
                                    Inc(vari, 2);
                                 end
                              ELSE
                                 begin
                                    test := delayer1;
                                    IF numb > 0 THEN
{Make sure # is legal}                 dly := test;
                                    Inc(vari);
                                 end;
                           end;
{Check for pause} 'P' : IF IsNumber(SoundC[vari+1]) THEN
{and it's length}          begin
                              IF IsNumber(SoundC[vari+2]) THEN
                                 begin
                                    test := delayer2;
                                    IF numb < 65 THEN
{Make sure # is legal}                 Delay(test);
                                    Inc(vari, 2);
                                 end
                              ELSE
                                 begin
                                    test := delayer1;
                                    IF numb > 0 THEN
{Make sure # is legal}                 Delay(test);
                                    Inc(vari);
                                 end;
                           end;
{Check for}       'T' : IF IsNumber(SoundC[vari+1]) AND
{tempo change}             IsNumber(SoundC[vari+2]) THEN
                           begin
                              IF IsNumber(SoundC[vari+3]) THEN
                                 begin
                                    min1 := value(SoundC[vari+1]+
                                            SoundC[vari+2]+SoundC[vari+3]);
                                    Inc(vari, 3);
                                    IF min1 > 255 THEN
{Make sure # isn't too big}            min1 := 255;
                                 end
                              ELSE
                                 begin
                                    min1 := value(SoundC[vari+1]+
                                            SoundC[vari+2]);
                                    IF min1 < 32 THEN
{Make sure # isn't too small}          min1 := 32;
                                 end;
                              min1 := min1/4;
                           end;
{Check for music} 'M' : begin
{type}                     Inc(vari);
                           CASE Upcase(SoundC[vari]) OF
{Normal}                      'N' : typom := 7/8;
{Legato}                      'L' : typom := 1;
{Staccato}                    'S' : typom := 3/4;
                           end;
                        end;
               end;
            end;
      end;

procedure InitDDAnsi;
begin;
 escape:=false;
 ansi_string:='';
 blink:=false;
 high:=false;
end;

procedure change_color(c: integer);
begin;
 case c of
  00: begin;any:=true;blink:=false;high:=false;norm:=true;end;
  01: begin;high:=true;end;
  05: begin;blink:=true;any:=true;end;
 end;
 if (c>29) and (c<38) then begin;
  any:=true;
  any2:=true;
  c:=c-30;
  curcolor:=c;
  if (high=true) and (blink=true) then textcolor(scaleh[c]+32);
  if (high=true) and (blink=false) then textcolor(scaleh[c]);
  if (high=false) and (blink=true) then textcolor(scale[c]+32);
  if (high=false) and (blink=false) then textcolor(scale[c]);
  fflag:=true;
 end;
 if (c>39) and (c<48) then begin;
  any:=true;
  c:=c-40;
  textbackground(scale[c]);
  gflag:=true;
 end;
end;

procedure eval_string(var s: string);
var
 cp: integer;
 T: CHAR;
 b:byte;
 jj,a,ttt: integer;
 tttt : longint;
 flag1:boolean;
begin;
 t:=s[length(s)];
 cp:=2;
 case t of
  'k','K': clreol;
  'u': gotoxy(restx,resty);
  's': begin;
        restx:=wherex;
        resty:=wherey;
       end;
  'm','J':begin;
           repeat;
            a:=-1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
             end;
             change_color(a);
            end;
            cp:=cp+1;
           until cp>=length(s);
           if norm then begin;
             if (fflag=false) and (gflag=false) then begin;textcolor(7);textbackground(0);curcolor:=7;end;
             if (fflag=false) and (gflag=true) then begin;textcolor(7);curcolor:=7;end;
             if (high=true) and (fflag=false) then textcolor(scaleh[curcolor]);
             if (blink=true) and (fflag=false) then textcolor(scale[curcolor]+32);
             if (blink=true) and (high=true) and (fflag=false) then textcolor(scaleh[curcolor]+32);
             if (fflag=true) and (gflag=false) then begin;textbackground(0);end;
            end;
           if any=false then textcolor(scaleh[curcolor]);
{ 5/12/95 srl }
           if (any2=false)  then
             if (high=true) then
               begin
                 if (blink=true) then
                   textcolor(scaleh[curcolor]+32)
                 else
                   textcolor(scaleh[curcolor]);
               end
             else
             if (blink=true) then textcolor(scale[curcolor]+32);

           any2:=false;any:=false;fflag:=false;gflag:=false;norm:=false;
         end;
   'C': begin;
            a:=1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
             end;
            end else a:=1;
            ttt:=wherex;
            if a+ttt<=80 then gotoxy(a+ttt,wherey);
           end;
   'D': begin;
            a:=1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
             end;
            end else a:=1;
            ttt:=wherex;
            if ttt-a>=1 then gotoxy(ttt-a,wherey);
           end;
   'A': begin;
            a:=1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
             end;
            end else a:=1;
            ttt:=wherey;
            if ttt-a>=1 then gotoxy(wherex,ttt-a);
           end;
   'B': begin;
            a:=1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
             end;
            end else a:=1;
            ttt:=wherey;
            if ttt+a<=25 then gotoxy(wherex,ttt+a);
           end;
  'f','H': begin;
           flag1:=false;
           a:=1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
              flag1:=true;
             end;
            end else a:=1;
            jj:=a;
            if flag1=false then cp:=cp+1;
            if flag1=true then cp:=cp+2;
            if cp<length(s) then begin;
            a:=1;
            val(s[cp],a,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              a:=a*10;
              a:=a+ttt;
             end;
            end else a:=1;
           end else a:=1;
          gotoxy(a,jj);
       end;
  else writeln(s);
 end;
end;

Procedure AnsiWriteChar(ch: char);
begin;
  case ch of
   #12: clrscr;
   #09: repeat; write(' '); until wherex/8 = wherex div 8;
   #27: begin; escape:=true; bbb:=true; end;

   else begin;
    if escape then begin;
     if (bbb=true) and (ch<>'[') then begin;
      blink:=false;
      high:=false;
      escape:=false;
      ansi_string:='';
      write(#27);
     end else bbb:=false;
     if escape then begin;
      ansi_string:=ansi_string+ch;
      if ch=#13 then escape:=false;
      if (ch in ['u','s','A','B','C','D','H','m','J','f','K','k',#14]) then begin;
       escape:=false;
       eval_string(ansi_string);
       ansi_string:='';
      end;
     end;
    end else write(ch);
   end;
  end;
end;

Procedure AnsiWrite(s: string);
var
 a: integer;
begin
 if AnsiEnabled then
 begin
 for a:=1 to length(s) do begin;
  case s[a] of
   #12: clrscr;
   #09: repeat; write(' '); until wherex/8 = wherex div 8;
   #27: begin; escape:=true; bbb:=true; end;

   else begin;
    if escape then begin;
     if (bbb=true) and (s[a]<>'[') then begin;
      blink:=false;
      high:=false;
      escape:=false;
      ansi_string:='';
      write(#27);
     end else bbb:=false;
     if escape then begin;
      ansi_string:=ansi_string+s[a];
      if s[a]=#13 then escape:=false;
      if (s[a] in ['u','s','A','B','C','D','H','m','J','f','K','k',#14]) then begin;
       escape:=false;
       eval_string(ansi_string);
       ansi_string:='';
      end;
     end;
    end else write(s[a]);
   end;
  end;
 end;
 end else write(s)
end;


{****************************************************************************}
{***                                                                      ***}
{***         Procedure that calls AnsiWrite, then line feeds.             ***}
{***                                                                      ***}
{****************************************************************************}
Procedure AnsiWriteLn(s : string);
Begin
  AnsiWrite(s+#13#10);
End; { AnsiWriteLn }

   begin
      Octave := 4;
      ChartoPlay := 'N';
      Typom := 7/8;
      Min1 := 120/4;
{| Added "/4" to be consistent with the part of the "Play" procedure
   that reads and sets the tempo. DDA|}

      TruncateLines := false;
      TextAttr:=LightGray;
{| Added above line to account for the fact that some Ansi artists just
   assume that the screen is normal white on black to start with.  DDA|}

   end.
