;
;Ŀ
;۳  P5 Cutre rutina by TaS.                                                
;۳                                                                         
;۳                                                                         
;
;
;Locals @@                    ; las etiquetas locales son las identificadas por @@
.MODEL SMALL
.386

;
bPtr EQU   Byte ptr
wPtr EQU   Word ptr

SPEED1      EQU 1
SPEED2      EQU 2
SPEED3      EQU 3
SPEED4      EQU 4
SPEED_TPOS1 EQU 2
SPEED_TPOS2 EQU 1
SPEED_TPOS3 EQU 1
SPEED_TPOS4 EQU 3



;ͻ
;[ Segmento de Datos   ]͹
;ͼ

.data
     
    posi1  DB 0
    posi2  DB 0
    posi3  DB 0
    posi4  DB 0
     
    include imagen.inc               ;imagen de fondo
    include  tabla.inc               ;una tabla de senos
    include  paleta.inc              ;una pequea paleta de 48 colore de la imagen

    paleta   DB 768 dup (0)          ; la paleta completa



    PSP          DW ?        ; para guardar el PSP
    BackBuffer   DW ?        ; un buffer de fondo
    pImage       DW ?        ; un buffer para guardar la imagen

    tmposi1  DB ?
    tmposi2  DB ?
    tmposi3  DB ?
    tmposi4  DB ?



  ;-------------- Necesario para la musica
  WorkBuffer   db 522h dup(?)  ; para trabajar con el amdobj
  include musica.inc           ; er peazo canzin

.stack 200h                    ; la pila que quita el senti'o
;ͻ
;[  Segmento de Codigo ]͹
;ͼ

.code

;ͻ
;[     PLAYER    ]͹
;ͼ
EXTRN _InitAdlib   : near           ; funciones para el player de AMD
EXTRN _AdlibPlayer : near
EXTRN _StopAdlib   : near
EXTRN _AdlibState  : byte

;ͻ
;[  MAIN               ]͹
;ͼ

    Main:

;[ Cargamos los de datos. ]
	mov   ax,_DATA
	mov   ds,ax
	mov  [PSP],es      ; guardamos el psp , no combiene perderlo
	cld                ; no ocupa lugar

;[ Reajuste de memoria  ]
    mov  ax,es         ; ES contiene el PSP
    mov  bx,SegZZZ     ; usamos el segmento auxiliar SegZZZ
    sub  bx,ax
    mov  ah,4ah        ; reajustamos el tamao en parrafos reservados.
    int  21h
;[ Reserva de memoria  ]
    mov   ah,48h
    mov   bx,4000        ; 64kb para el buffer secundario
    int   21h
    mov  ds:[backbuffer],ax

    mov   ah,48h
    mov   bx,4000        ; 64kb para la imagen
    int   21h
    mov  ds:[pImage],ax

;[ Descompresion de las imagen ]
; la imagen esta comprimida para que entre en el segmento de 64kb
; usando la compresion RLE usada en los PCX.
; el siguiente codigo te servira  para leer los datos de un pcx.

    mov  cx,timage    ;nos sirve de contador de los bytes de la imagen
    xor  bx,bx        ;pImage
    xor  di,di        ;imagen
    mov  ax,pImage
    mov  es,ax        ;cargamos en ES = segmento donde almacenarlo

@@next:
    cmp  di,timage
    jae @@fin


    mov  al,imagen[di];leemos un byte
    inc  di           ;incrementamos el apuntador al siguiente
    dec  cx           ;decrementamos el numero que quedan por procesar

    cmp  al,192
    jb @@directo
    and  al,03Fh      ;veamos cuanto hay que repetirlo
    mov  dl,imagen[di];leemos el byte siguiente el que hay que escribir
    inc  di
    dec  cx           ;decrementamos el numero que quedan que procesar
 @@expande:
    mov  bPtr es:[bx],dl
    inc  bx
    dec  al           ;vemos cuantos faltan ??
    cmp  al,0
    jg   @@expande
    jmp  @@next

  @@directo:         ;escribimos el byte tal cual
    mov  bPtr es:[bx],al
    inc  bx
    jmp  @@next
  @@fin:



;[ Inicializacion de la musica]
; cargamos los valores necesarios para el player en los registros
; pertinentes.

   push    ds
   push    es
   mov     si,SEG Song          ; nada que decir, se cargan los punteros
   mov     ds,si                ; y se pasan a la funcion _InitAdlib
   mov     si,OFFSET Song

   mov     di,SEG WorkBuffer
   mov     es,di
   mov     di,OFFSET WorkBuffer
   xor     al,al       ;0=irq_mode  1=polling_mode
   call    _InitAdlib
   pop     es
   pop     ds

;[ Vamos a crear la paleta]
; creamos la paleta con degradados de rojos y azules....
;
	mov   bx,offset(paleta)           ; cargamos direccion paleta
	mov   cx,3F00h                    ; tenemos en CH un contador desde 63-0
	xor   di,di
@@Loop_color:                             ; tenemos en CL un contador desde 0-63

	mov   bPtr [bx+di],cl             ; el rojo va desde 0-63 en los primeros 64 colores
	mov   bPtr [bx+di+(192*3)+2],ch   ; el azul va desce 0-63 en los terceros 64 colores
	mov   bPtr [bx+di+64*3],ch        ; el rojo va desde 63-0 en los segundos 64 colores
	mov   bPtr [bx+di+(128*3)+2],cl   ; el azul va desde 63-0 en los ultimos  64 colores

	inc   cl
	dec   ch
	add   di,3
	cmp   di,3Fh*3
	jle   @@Loop_color

 ;---- Aadimos a la paleta los primeros 48 colores que son los de la imagen.
 ;del fondo

   push ds
   pop  es
   mov  si,offset(paleta2)
   mov  di,offset(paleta)
   mov  cx,144
   rep  movsb

 
;[ Pasemos al modo grafico ]
	mov   ax,13h
	int   10h
;[ Establecemos la paleta  ]
	push  ds
	pop   es
	mov   si,offset(paleta)
	mov   cx,768d        ; 256 * 3 (Rgb)
	mov   dx,3c8h
	xor   al,al
	out   dx,al
	inc   dx
	rep   outsb

;[ Pintermos ........      ]
; bucle principal donde pintamos....
; la verdad es que lo he enrollado un poco intentando optimizarlo
; he intercambiado el orden 'mas comprensible' de las instrucciones
; intentando aprovechar al maximo las capacidades del pipeline...
; aunque no se nota demasiado... en mi 486 .

@@Kbhit:
	mov  ax,backbuffer        ; el Kbhit() modifica el ES hay que restaurarlo
	mov  es,ax                ; ES = memoria video
  ;-- volcamos la imagen en el buffer de fondo
   push ds
   mov  ax,pimage
   mov  ds,ax
   xor  si,si
   xor  di,di
   mov  cx,16000
   rep  movsd
   pop  ds

  ;---- pintamos las interferencias en el buffer de fondo.


   mov bl,posi1              ; cargamos posi1
   xor ecx,ecx               ; ECX = contador x | contador y
   mov tmposi1,bl            ; tmposi1 = posi1
   mov bl,posi2              ; cargamos la tabla de senos en SI
   mov si,offset(tabla)      ; tmposi2 = posi2
   mov tmposi2,bl


 @@loop_y:
   mov   eax,ecx             ; metemos en EAX el contador Y
   mov   bl,posi3            ; CX=0  CX=x 0-320
   xor   cx,cx               ; ponemos cx=0
   mov   tmposi3,bl          ; tmposi3=posi3
   mov   bl,posi4
   shr   eax,16              ; parte alta de ECX = contador Y
   mov   tmposi4,bl
   imul  di,ax,320           ; en EDI = precalculamnos Y*320

   ;---------------------------------------------------------------
 @@loop_x:

   xor bx,bx
   mov bl,bPtr tmposi1
   mov dl,bPtr [si+bx]

   mov bl,bPtr tmposi4
   add dl,bPtr [si+bx]

   mov bl,bPtr tmposi2
   add tmposi4,SPEED_TPOS4
   add dl,bPtr [si+bx]

   mov bl,bPtr tmposi3
   add dl,bPtr [si+bx]


   ;--- posicion donde pintar
   cmp  dl,49
   jb @@no_pinto
   mov  bx,cx        ; cx=X
   add  bx,di        ; di=320*y
   mov bPtr es:[bx],dl       ; pintamos el color
 @@no_pinto:

   inc cx
   add tmposi3,SPEED_TPOS3
   cmp cx,320
   jl @@loop_x
   ;--------------------------------------------------------------------------

   shr ecx,16
   add tmposi2,SPEED_TPOS2
   inc cx
   shl ecx,16
   add tmposi1,SPEED_TPOS1
   cmp ecx,00C80000h         ; comparamos con y = 200
   jl @@loop_y

   ;--- volcamos el backbuffer
   push ds
   mov  ax,0A000h
   xor  di,di
   mov  es,ax               ; es=VGA
   sub posi2,SPEED2         ; ES = memoria video
   mov  ax,backbuffer
   xor  si,si
   mov  ds,backbuffer        ; ds=backbuffer
   mov  cx,16000
   ;--- esperamos retrazado

	mov   dx,3DAh
 @@2:
	in    al,dx
	test  al,08h
   jz    @@2

    rep  movsd
    pop  ds

   ;----------- miramos si se ha pulsado una tecla.
       xor  ax,ax
   sub posi4,SPEED4
	mov  es,ax
   add posi3,SPEED3
	mov  ax,es:[41Ah]
   add posi1,SPEED1
	cmp  ax,es:[41Ch]
	je   @@Kbhit

;[ Paramos la musica     ]
     cmp     cs:[_AdlibState],0     ; comprobamos si habiamos detectado tarjeta.
     jz      @@Pontexto             ; No adlib  pasamos a poner el texto final.
     call    _StopAdlib             ; si adlib llamamos a para la musica.
@@Pontexto:
;[ Liberamos memoria     ]
    mov   ax,pImage
    mov   es,ax
    mov   ah,49h
    int   21h
    mov   ax,backbuffer
    mov   es,ax
    mov   ah,49h
    int   21h


;[ Vamonos pa'r dos      ]
	mov   ax,03h
	int   10h
	mov   ax,4c00h
	int   21h




SEGZZZ Segment
SEGZZZ Ends

      END Main
