/**************************************************************************
Source file: colort.c
Program: Quick Linker v1.0
By: Luc Lavoie and Filip Spacek, 1998.
Rights: you are free to copy it.
**************************************************************************/

#include <stdio.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/farptr.h>
#include "colort.h"

// this function clears the memory and sets the colors
// to normal black and grey...
void text_b (void)
{
	int i, j;
	char color;
	
	color = BLACK;
	color <<= 4;
	color &= 11110000;
	color += LIGHTGREY;
	
	for(j = 0; j < 25; j++)
		for(i = 0; i < 160; i+=2)
		{
			_farpokeb (_dos_ds, 0xb8000+j*160+i, ' ');
			_farpokeb (_dos_ds, 0xb8000+j*160+i+1, color);
		}
}	

// here we change the background to 'color' starting at (x,y) to (x+w, y+h)
void back (int x, int y, int w, int h, char color)
{
	int i, j;
	char c;
	
	c = color;
	c <<= 4;
	c &= 11110000;
	c += LIGHTGREY;
	
	for(j = y; j < y+h; j++)
		for(i = x*2; i < 2*(x+w); i+=2)
		{
			_farpokeb (_dos_ds, 0xb8000+j*160+i, ' ');
			_farpokeb (_dos_ds, 0xb8000+j*160+i+1, c);
		}
}

// puts 'string' with 'color' at (x,y) position...
void str (char string[80], int x, int y, char color)
{
	int i, j = 0;

	for(i = x; i < x+strlen(string); i++)
	{
		printc(i, y, color, string[j]);
		j++;
	}
}

// same as "str" but with a single char...
void printc (int x, int y, char color, char c)
{
	char c_tmp; 
        c_tmp = _farpeekb (_dos_ds, 0xb8000+y*160+x*2+1);
	c_tmp &= 11110000;
	c_tmp += color;
	
        _farpokeb (_dos_ds, 0xb8000+y*160+x*2, c);
        _farpokeb (_dos_ds, 0xb8000+y*160+x*2+1, c_tmp);
}

// same as "str" but puts it centered in 'y'...
void str_ctr (char string[80], int y, char color)
{
        int border, i;

        border = (80 - strlen(string)) / 2;
        for(i = 0; i < strlen(string); i++)
        	printc(border+i, y, color, string[i]);
}

// draws a window at (x, y) to (x+w,y+h) with background color 'bcolor' and
// with bordering lines using 'wcolor'
void cwindow (int x, int y, int w, int h, char wcolor, char bcolor)
{
	int i;
	
	back(x, y, w, h, bcolor);
		
	printc(x, y, wcolor, '');
	
	for(i = 1; i < w-1; i++)
		printc(x+i, y, wcolor, '');
	
	printc(x+w-1, y, wcolor, '');
	
	for(i = 1; i < h-1; i++)
	{
		printc(x, y+i, wcolor, '');
		printc(x+w-1, y+i, wcolor, '');
	}
	
	printc(x, y+h-1, wcolor, '');
	
	for(i = 1; i < w-1; i++)
		printc(x+i, y+h-1, wcolor, '');
	
	printc(x+w-1, y+h-1, wcolor, '');
}
