/**************************************************************************
Source file: help.c
Program: Quick Linker v1.0
By: Luc Lavoie, 1998.
Rights: you are free to copy it.
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "colort.h"
#include "help.h"

// this is the main help, it gets the users choice and puts the file on the
// screen, using function "draw_file"...
void help (void)
{
	char choice;
	int i;
	
	back(0, 0, 80, 25, BLUE);
	str("*************************** Quick Linker v1.0 Help *****************************", 0, 0, YELLOW);
	str("*************************** Quick Linker v1.0 Help *****************************", 0, 24, YELLOW);
	
	for(i = 1; i < 25; i++)
	{
		printc(0, i, YELLOW, '*');
		printc(79, i, YELLOW, '*');
	}
	
	draw_file(MAIN);
	
	while (choice != 'q')
	{
		choice = getch();
		
		if (choice == 'h')
			draw_file(MAIN);

		if (choice == '1')
			draw_file(ADD);
			
		else if (choice == '2')
			draw_file(OPEN);

		else if (choice == '3')
			draw_file(REMOVE);
			
		else if (choice == '4')
			draw_file(LIST);

		else if (choice == '5')
			draw_file(ABOUT);
	}
}

// puts on the screen every character of "filename" ...
int draw_file (char filename[13])
{
	FILE *file;
	char *direc, full[80], c;
	int x=2, y=2;
	
	direc = getenv("QL");
	strcpy(full, direc);
	strcat(full, "\\");
	strcat(full, "qlh");
	strcat(full, "\\");
	strcat(full, filename);
	
	file = fopen(full, "rb");
	
	if (file == NULL)
		return 1;
	
	back(1, 1, 78, 23, BLUE);
			
	while ((c = fgetc(file)) != EOF)
	{	
		if (c != 10 && c != 13 && c != 9)
			printc(x, y, WHITE, c);
			
		if (c == '\t')
			x += 8;
		
		else if (c == '\n')
		{
			x = 2;
			y++;
		}
		
		else
			x++;	
	}
}	
