/**************************************************************************
Source file: link.c
Program: Quick Linker v1.0
By: Luc Lavoie, 1998.
Rights: you are free to copy it.
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <unistd.h>
#include "colort.h"
#include "link.h"
#include "list.h"

extern int total;
extern LINK *first;

char **args;
int argt;

// this function is used by DJGPP for tranlating all wildcards of dos like
// *.*, but I don't want them to be translated so I declare it to return 
// NULL...
char ** __crt0_glob_function (char *_argument)
{
	return NULL;
}

// here is the function who adds a link to the list, "type" is used for 
// knowing wether the link is started from it's program directory or only
// with the path like Dos's PATH does...
int addlink (int type)
{
	FILE *l;
	LINK *ptr;
	int i, ex;
	
	l = fopen(args[2], "rb");
	
	if (l != NULL)
	{
		if (access(args[2], X_OK) != 0)		
		{
			printf("The specified file is not executable.");
			return 0;
		}

		ex = exist();

		if (ex == 0)
			return 0;

		else if (ex == 1)
			return 1;
					
		if (ex != 2)
		{
			ptr = new();
			total++;
		}
		
		else
			for(ptr = first; ptr != NULL; ptr = ptr->next)
				if ((strcmp(ptr->linkname, args[3])) == 0)
					break;

		if (type == PATH)
			ptr->type = PATH;
			
		else
			ptr->type = NONPATH;

		if (args[2][1] == ':')
		{
			i = strlen(args[2]);
			while (args[2][i] != '/' && args[2][i] != '\\')
				i--;

			strcpy(ptr->appname, &args[2][i+1]);
			strncpy(ptr->pathname, args[2], i);
		}
		
		else
		{
			getwd(ptr->pathname);
			strcpy(ptr->appname, args[2]);
		}

		strcpy(ptr->linkname, args[3]);
					
		printf("Link to %s added with success.", args[2]);
		return 1;
	}
	
	else
	{
		printf("The file %s couldn't be found. \nMake sure it's in the current directory or that the specified path exist.", args[2]);
		return 0;
	}
}

// here we open the link and convert all necessary arguments by checking
// each argument with function look_file...
void openlink (void)
{
	LINK *ptr;
	char curpath[80], tmp[20];
	int i;
	
	for(ptr = first; ptr != NULL; ptr = ptr->next)
		if ((strcmp(ptr->linkname, args[1])) == 0)
		{
				getwd(curpath);
				strcat(curpath, "/");
				
				for(i = 2; i < argt; i++)
					if (look_file(args[i]))
					{
						strcat(curpath, args[i]);
						strcpy(tmp, args[i]);
						strcpy(args[i], curpath);
						curpath[strlen(curpath)-strlen(tmp)] = 0;
					}
				
				if (ptr->type == NONPATH)	
				{
					chdir(ptr->pathname);
					spawnv(P_WAIT, ptr->appname, &args[1]);
					chdir(curpath);
					break;
				}
				
				else
				{
					curpath[0] = 0;
					strcpy(curpath, ptr->pathname);
					strcat(curpath, "/");
					strcat(curpath, ptr->appname);
					spawnvp(P_WAIT, curpath, &args[1]);
					break;
				}
		}
		
	if (ptr == NULL)
		printf("Link wasn't found.\nMake sure it's been added to the list.");
}					

// removes a link from list...
int removelink (void)
{
	LINK *delete, *ptr;
	
	for(ptr = first; ptr != NULL; ptr = ptr->next)
		if ((strcmp(ptr->linkname, args[2])) == 0)
		{
			delete = ptr;
			
			if (delete == first)
			{
				first = first->next;
				total--;
				free(delete);
			}
			
			else
			{
				for(ptr = first; ptr->next != delete; ptr = ptr->next);
				ptr->next = delete->next;
				total--;
				free(delete);			
			}

			printf("Link \"%s\" removed with success.", args[2]);
			return 1;
		}
	
	if (ptr == NULL)
	{
		printf("Link wasn't found.\nMake sure it's been added to the list.");
		return 0;
	}
}

// here we draw the logo of my program and a quick reference like every
// program does...
void drawlogo (void)
{
		clrscr();
                str("     ", 30, 2, LIGHTCYAN);
	        str("        ", 29, 3, LIGHTCYAN);
                str("        ", 29, 4, LIGHTCYAN);
                str("        ", 29, 5, LIGHTCYAN);
                str("      ", 29, 6, LIGHTCYAN); 
                str("      ", 29, 7, LIGHTCYAN);   
                str("     ", 31, 8, LIGHTCYAN);
                str("", 36, 9, LIGHTCYAN);      
                str_ctr("QUICK LINKER V1.0 by Luc Lavoie, 1998.", 11, LIGHTCYAN);
		str_ctr("Add link: ql (-a | -A) (program filename) (your link name)", 13, WHITE);
		str_ctr("-a: execute program from it's directory; -A: execute program with path", 14, WHITE);
		str_ctr("Open link: ql (link name)", 15, WHITE);
		str_ctr("Remove link: ql -r (link name)", 16, WHITE);
		str_ctr("See list: ql -l or ql -l (first letter of link name)", 17, WHITE);
		str_ctr("For more help, type \"ql -h\"", 19, LIGHTCYAN);
                gotoxy(0, 24);
}

// checks if program or link name already exist in list and asks user what
// to do when it occurs...
int exist (void)
{
	LINK *ptr;
	char choice=0;
	int i=-1;

	if (args[2][1] == ':')
	{
		i = strlen(args[2]);
		while (args[2][i] != '/' && args[2][i] != '\\')
				i--;
	}

	for(ptr = first; ptr != NULL; ptr = ptr->next)
	{
		if ((strcmp(&args[2][i+1], ptr->appname)) == 0)
		{
			printf("Link to %s already exist. Rename? (y/n)\n", args[2]);
			while (choice != 'y' && choice != 'n')
				choice = getch();

			if (choice == 'n')
				return 0;
			
			else
			{
				ptr->linkname[0] = 0;
				strcpy(ptr->linkname, args[3]);
				printf("Link to %s renamed.", args[2]);
				return 1;
			}
		}

		else if ((strcmp(args[3], ptr->linkname)) == 0)		
		{
			printf("Link named \"%s\" already exist. Replace? (y/n)\n", args[3]);
			while (choice != 'y' && choice != 'n')
				choice = getch();

			if (choice == 'n')
				return 0;
			
			else
				return 2;
		}
	}

	if (ptr == NULL)
		return 3;
}

// looks if an argument is or seems to be a file...
int look_file (char str[80])
{
	if (str[1] == ':')
		return 0;

	else if (!access(str, F_OK))
		return 1;

	else if (str[strlen(str)-4] == '.')
		return 1;
	
	else
		return 0;
}			

// draws all the list of links or every link starting with "c[0]"...
void draw_list (char c[2])
{
	LINK *ptr;
	int i=4;
	
	clrscr();
	if (c != 0)
	{
		str("Links found...", 29, 0, CYAN);
		str("Link name", 8, 2, YELLOW);
		str("Program name", 59, 2, YELLOW);
		
		for(ptr = first; ptr != NULL; ptr = ptr->next)
	 	{
	 		if (i > 22)
	 		{
	 			str("Press any key to continue...", 23, 23, CYAN);
	 			getch();
	 			back(0, 4, 80, 21, BLACK);
	 			i=4;
	 		}
	 		
			if ((strncasecmp(ptr->linkname, c, 1)) == 0)
			{
				str(ptr->linkname, 8, i, WHITE);
				str(ptr->appname, 59, i, WHITE);
				i++;
			}
		}

	 	str("Press any key to continue...", 23, 23, CYAN);
	 	getch();
		gotoxy(0, 24);
	}

	else
	{
		str("List of links...", 29, 0, CYAN);
		str("Link name", 8, 2, YELLOW);
		str("Program name", 59, 2, YELLOW);

                for(ptr = first; ptr != NULL; ptr = ptr->next)
                {
	 		if (i > 22)
	 		{
	 			str("Press any key to continue...", 23, 23, CYAN);
	 			getch();
	 			back(0, 4, 80, 21, BLACK);
	 			i=4;
	 		}

                        str(ptr->linkname, 8, i, WHITE);
                        str(ptr->appname, 59, i, WHITE);
                        i++;
                }

	 	str("Press any key to continue...", 23, 23, CYAN);
	 	getch();
		gotoxy(0, 24);
        }
}
