/**************************************************************************
Source file: list.c
Program: Quick Linker v1.0
By: Luc Lavoie, 1998.
Rights: you are free to copy it.
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "list.h"

LINK *first;
int total;
char *path;

// callocs memory for a new LINK structure and puts it at the end of the 
// linked list...
LINK * new (void)
{
        LINK *ptr;
 
        if (first == NULL)
        {
                first = calloc (1, sizeof(LINK));
                first->next = NULL;

                return first;
        }

        else
        {
                for(ptr = first; ptr->next != NULL; ptr = ptr->next);

                ptr->next = calloc (1, sizeof(LINK));
                ptr->next->next = NULL;
                return ptr->next;
        }
}

// reads all information about a LINK structure in file "list.lnk" and puts
// it in the memory...
void readlinks (void)
{
        LINK *ptr;
        int i;
        char direc[80];
        FILE *data;

	path = getenv("QL");
	if (path == NULL)
	{
		printf("File \"autoexec.bat\" as been modified.\nConfig couldn't be read.\nPlease enter home directory of Quick Linker:");
		scanf("%s", path);
	}
	
	strcpy(direc, path);
	strcat(direc, "\\");
	strcat(direc, "list.lnk");
        data = fopen (direc, "rt");

	if (data == NULL)
	{
		printf("ERROR: File \"list.lnk\" wasn't found!\n");
		printf("WARNING: Creating new empty list. All previous links couldn't be found.\n");
		data = fopen(direc, "wt");
		      
		fprintf(data, "===========================================================================\n");
		fprintf(data, "Quick Linker v1.0, 1998, by Luc Lavoie.\n");
		fprintf(data, "===========================================================================\n");
		fprintf(data, "Changing this file can encounter bugs and loosing data!\n");
		fprintf(data, "===========================================================================\n");
        	fprintf(data, "%d\n", total);
	}

	else
	{
  		for(i = 0; i < 5; i++)
  			getline(data);
  			
        	fscanf(data, "%d\n", &total);

        	for(i = 0; i < total; i++)
        	{
                	ptr = new();
                	fscanf(data, "%s\n", ptr->pathname);
                	fscanf(data, "%s\n", ptr->appname);
                 	fscanf(data, "%s\n", ptr->linkname);
			fscanf(data, "%d\n", &ptr->type);
       		}
	}
	
        fclose(data);
}

// writes all info of links into file "list.lnk"...
void writelinks (void)
{
        LINK *ptr;
        FILE *data;
        char direc[95];
        
        path = getenv("QL");
        if (path == NULL)
        {
		printf("File \"autoexec.bat\" as been modified.\nConfig couldn't be read.\nPlease enter home directory of Quick Linker:");
		scanf("%s", path);
	}
	
        strcpy(direc, path);
	strcat(direc, "\\");
	strcat(direc, "list.lnk");

        data = fopen (direc, "wt");

	fprintf(data, "===========================================================================\n");
	fprintf(data, "Quick Linker v1.0, 1998, by Luc Lavoie.\n");
	fprintf(data, "===========================================================================\n");
	fprintf(data, "Changing this file can encounter bugs and loosing data!\n");
	fprintf(data, "===========================================================================\n");
        fprintf(data, "%d\n", total);

        for(ptr = first; ptr != NULL; ptr = ptr->next)
        {
                fprintf(data, "%s\n", ptr->pathname);
                fprintf(data, "%s\n", ptr->appname);
                fprintf(data, "%s\n", ptr->linkname);
                fprintf(data, "%d\n", ptr->type);
        }

        fclose(data);
}

// reads a line in "data"...
int getline (FILE *data)
{
        int i;
	char c;	

        for(i = 0; i < 80; i++)
        {
                c = getc(data);

                if (c == '\n')
                        return;
		
		if (c == EOF)
			return 1;
        }
}
