/**************************************************************************
Source file: main.c
Program: Quick Linker v1.0
By: Luc Lavoie, 1998.
Rights: you are free to copy it.
**************************************************************************/

#include <stdio.h>
#include "link.h"
#include "list.h"
#include "setup.h"

extern char **args;
extern int argt;

// MAIN, this is where it all happens...
void main(int argn, char **arg)
{
	if (searchpath("install.qlk") != NULL) // if present, we install...
	{
		install();
		text_b();
		exit(1);
	}
	
	if (argn < 2) // if no args, we draw the quick reference...
		drawlogo();
		
	else
	{
		args = arg;	
		argt = argn;
		
		if (!(strncmp(arg[1], "-a", 2)))
		{
			if (argn < 3)
				printf("No file as been specified.\nTry 'ql -h' for help with commands.");
			
			else if (argn < 4)	
				printf("Name for the link wasn't specified.\nTry 'ql -h' for help with commands.");
				
			else
			{	
				readlinks();
				if (addlink(NONPATH))
					writelinks();
			}
		}

		else if (!(strncmp(arg[1], "-A", 2)))
		{
			if (argn < 3)
				printf("No file as been specified.\nTry 'ql -h' for help with commands.");
			
			else if (argn < 4)	
				printf("Name for the link wasn't specified.\nTry 'ql -h' for help with commands.");
				
			else
			{	
				readlinks();
				if (addlink(PATH))
					writelinks();
			}
		}
			
		else if (!(strncmp(arg[1], "-r", 2)))
		{
			if (argn < 3)
				printf("Name of the link wasn't specified.\nTry 'ql -h' for help with commands.");
			
			else	
			{	
				readlinks();
				if (removelink())
					writelinks();
			}
		}
		
		else if (!(strncmp(arg[1], "-h", 2)))
		{
			help();
			text_b();
		}
			
		else if (!(strncmp(arg[1], "-l", 2)))
		{
			readlinks();
			if (argn < 3)		
				draw_list(0);

			else
				draw_list(arg[2]);
		}
			
		else 
		{
			readlinks();
			openlink();
		}
	}
}
		