Program ResourceBinder;

{ This program makes resourcefiles (*.RSC). It can appends a resource-
  file to an DOS .EXE

  Last update: 20/10/1996
  Author:      N. De Smedt (alias ThunderByte) member of
               << Houses of Immortality -- Belgium >>
------------------------------------------------------------------------------}
{$M 8192,70000,655320 }

Uses DOS,Suppack,CRC;

Type  ResHeadRec = RECORD
       CString: String[80];
       Count: Word;
       Offset: Longint;
     end;

     ResDirRec = RECORD
        Name: String[20];
        Offset: Longint;
        Size: Longint;
        CompressedSize: Longint;
        CRC32: Longint;
     end;

     ResBlockRec = RECORD
       ID: Array[1..3] of Char;
       Offset: Longint;
     end;

Const MaxSize = 65520;
      MaxResDirs = 100;
      TempRSC = 'RB10.$$$';

Type  OBuff = Array[0..MaxSize] of Char;
      OutBuf = ^OBuff;

Var ResFile,Resource,IdString: String;
    BindExe: Boolean;
    SourceFile,DestFile: File;
    ResHeader: ResHeadRec;
    ResDir: ResDirRec;
    ResBlock: ResBlockRec;
    P: Pointer;
    ResDirs: Array[1..MaxResDirs] of ResDirRec;
    CRC_32: Longint;
    BytesWritten,BytesRead,TotalSize: Longint;
    OutBuffer: OutBuf;
    Extract: Boolean;
    Ch: Char;

Procedure Explanation;
Begin
  Writeln('Syntaxis:  RB <Resfile>  <Resource>  <IdString> or <Options>');
  Writeln('           RB <ResFile>  <EXE>        /a (= option)');
  Writeln('           RB <ResFile>  <IdString>   <Resource> /e');
  Writeln('           RB <ResFile>  <IdString>   /d');
  Writeln;
  Writeln('  <Resfile>:  the resourcefile (*.rsc).');
  Writeln('  <Resource>: the resource itself, can be everything (a file).');
  Writeln('              If <Resfile> already exits, then <Resource> is');
  Writeln('              added.');
  Writeln('  <IdString>: Unique string for the resource (NOT');
  Writeln('              case sensitive !). Max. 20 characters.');
  Writeln;
  Writeln('  <Options>:  /l: list all resources in <ResFile>');
  Writeln('              /t: test all resources in <ResFile> (CRC test)');
  Writeln('              /e: extract <IdString> to <Resource> (decompress)');
  Writeln('              /d: delete <IdString> in <ResFile>');
  Writeln('              /a: add <ResFile> to the <EXE> (only one <ResFile>');
  Writeln('                  can be added !).');
  Writeln;
  Halt(0);
end;

Function Up(S: String): String;
Var i: Byte;
    Str: String;
Begin
  Str := '';
  For i := 1 to Length(S) do
    Str := Str + UpCase(S[i]);
  Up := Str;
end;

Function S(L: Longint): String;
Var P: String;
Begin
  Str(L,P);
  S := P;
end;

Procedure Ext(Var B: String; E: String);
Begin
  If POS('.',B) <> 0 then
     Delete(B,POS('.',B),Length(B));
  B := B + E;
end;

Procedure Error(What: String);
Begin
  Writeln;
  Writeln(What);
  Writeln;
  Halt(1);
end;

Function FileExist(B: String): Boolean;
Var DirInfo: SearchRec;
Begin
  FindFirst(B,Archive,DirInfo);
  FileExist := (DosError = 0);
end;

Procedure WriteBlock(Var What; Size: Word);
Var Count: Word;
Begin
  {$I-}
  BlockWrite(DestFile,What,Size,Count);
  {$I+}
  If (IOResult <> 0) or (Count <> Size) then
     Error('Error writing file !');
end;

Procedure ReadBlock(Var What; Size: Word);
Var Count: Word;
Begin
  {$I-}
  BlockRead(SourceFile,What,Size,Count);
  {$I+}
  If (IOResult <> 0) or (Count <> Size) then
     Error('Error reading file !');
end;

Procedure ReadDestBlock(Var What; Size: Word);
Var Count: Word;
Begin
  {$I-}
  BlockRead(DestFile,What,Size,Count);
  {$I+}
  If (IOResult <> 0) or (Count <> Size) then
     Error('Error reading file !');
end;

{ Compression routines: }
Function Read(u: Pointer; Var Buf: Byte; Var Size: Word): Integer; Far;
Var Aantal: Word;
Begin { read from file }
  {$I-}
  BlockRead(SourceFile,Buf,Size,Size);
  {$I+}
  If IOResult <> 0 then
     Error('Error reading file !');
  INC(BytesRead,Size);
  Read := PACK_NOERR;
  CRC_32 := UpDateCRC32(CRC_32,Buf,Size);
  Write('Compressing: ',Round(BytesRead/TotalSize*100),'%',#13);
End;

Function WriteBuf(u: Pointer; Var Buffer: Byte; Size: Word): Integer; Far;
Begin
  WriteBlock(Buffer,Size);
  INC(BytesWritten,Size);
  WriteBuf := PACK_NOERR;
End;

{ Decompression routines: }
Function DecodeRead(u: Pointer; Var Buf: Byte; Var Size: Word): Integer; Far;
Var Aantal: Word;
Begin { read from file }
  If BytesRead+Size > ResDir.CompressedSize then
     Size := ResDir.CompressedSize-BytesRead;
  {$I-}
  BlockRead(SourceFile,Buf,Size,Size);
  {$I+}
  If IOResult <> 0 then
     Error('Error reading file !');
  INC(BytesRead,Size);
  DecodeRead := PACK_NOERR;
End;

Function DecodeWrite(u: Pointer; Var Buffer: Byte; Size: Word): Integer; Far;
Begin
  If Extract then
     WriteBlock(Buffer,Size);
  CRC_32 := UpDateCRC32(CRC_32,Buffer,Size);
  INC(BytesWritten,Size);
  Write(Round(BytesWritten/ResDir.Size*100),'%',#13);
  DecodeWrite := PACK_NOERR;
End;

Procedure CompressFile;
Var CompressionError: Integer;
Begin
  GetMem(P,EnCode_Mem_Req);
  BytesWritten := 0;
  CRC_32 := -1; { Standart PKZIP 32-bit CRC calculation }
  BytesRead := 0;
  CompressionError := do_encode (Nil,Read,WriteBuf,P);
  FreeMem(P,Encode_Mem_Req);
  If CompressionError <> 0 then
     Error('Compression error !');
  CRC_32 := Not CRC_32; { Inverting all bits, like PKZIP }
  Write('                      ',#13);
  Writeln('Compressing: ',(Round(BytesWritten/TotalSize*100)),'%');
end;

Function HexN(B: Byte): Char;
Begin
  B := B and 15;
  If B > 9 then INC(B,7);
  HexN := Chr(B+48);
end;

Function HexB(B: Byte): String;
Begin
  HexB := HexN(B SHR 4) + HexN(B);
end;

Function HexW(W: Word): String;
Begin
  HexW := HexB(W SHR 8) + HexB(W);
end;

Function HexL(L: Longint): String;
Begin
  HexL := HexW(L SHR 16) + HexW(L);
end;

Procedure ListResources;
Var Str,P: String;
    i: Word;
Begin
  Writeln('Resources in: ',ResFile);
  Assign(SourceFile,ResFile);
  {$I-}
  Reset(SourceFile,1);
  {$I+}
  If IOResult <> 0 then
     Error('Could not open '+ResFile+' !');
  ReadBlock(ResHeader,SizeOf(ResHeader));
  Seek(SourceFile,ResHeader.Offset);
  Writeln('Name:                Offset:   Size:   Compressed size:  32 bit CRC:   Ratio:');
  Writeln('-----------------------------------------------------------------------------');
  TotalSize := 0;
  BytesRead := 0;
  For i := 1 to ResHeader.Count do
    Begin
      ReadBlock(ResDir,SizeOf(ResDir));
      With ResDir do
        Begin
          FillChar(Str,SizeOf(Str),' ');
          Str[0] := Chr(79);
          Move(Name[1],Str[1],Length(Name));
          P := S(Offset);
          Move(P[1],Str[22],Length(P));
          P := S(Size);
          Move(P[1],Str[32],Length(P));
          P := S(CompressedSize);
          Move(P[1],Str[45],Length(P));
          P := HexL(CRC32);
          Move(P[1],Str[58],Length(P));
          P := S(Round(CompressedSize/Size*100))+'%';
          Move(P[1],Str[73],Length(P));
          Writeln(Str);
          INC(BytesRead,CompressedSize);
          INC(TotalSize,Size);
        end; { With }
    end; { FOR }
  Writeln;
  Writeln(ResHeader.Count,' resource(s), ',TotalSize, ' bytes, total ratio: ',
          Round(BytesRead/TotalSize*100),'%');
  Writeln;
  Close(SourceFile);
end;

Procedure TestResources;
Var P: Pointer;
    i: Word;
    CompressionError: Integer;
    F: Longint;
Begin
  Writeln('Testing resources in: ',ResFile);
  Assign(SourceFile,ResFile);
  {$I-}
  Reset(SourceFile,1);
  {$I+}
  If IOResult <> 0 then
     Error('Could not open '+ResFile+' !');
  ReadBlock(ResHeader,SizeOf(ResHeader));
  Seek(SourceFile,ResHeader.Offset);
  GetMem(P,EnCode_Mem_Req);
  Extract := False;
  For i := 1 to ResHeader.Count do
    Begin
      ReadBlock(ResDir,SizeOf(ResDir));
      With ResDir do
        Begin
          F := FilePos(SourceFile);
          Seek(SourceFile,Offset);
          BytesRead := 0;
          BytesWritten := 0;
          CRC_32 := -1; { Standart PKZIP 32-bit CRC calculation }
          Write('       ',Name,#13);
          CompressionError := do_Decode (Nil,DecodeRead,DecodeWrite,P);
          If CompressionError <> 0 then
             Error('Compression error !');
          CRC_32 := Not CRC_32; { Inverting all bits, like PKZIP }
          If CRC_32 <> CRC32 then
             Error('32-bit CRC error !')
          Else
             Writeln('[OK]');
          Seek(SourceFile,F);
        end; { With }
    end; { FOR }
  FreeMem(P,Encode_Mem_Req);
  Writeln;
  Writeln(ResFile,' is OK!');
  Writeln;
  Close(SourceFile);
end;

Procedure DeleteFile(FName: String);
Var F: File;
Begin
  Assign(F,FName);
  {$I-}
  Erase(F);
  {$I+}
  If IOResult <> 0 then
     Error('Could not delete file !');
end;

Procedure DeleteResource;
Var Found: Boolean;
    i,j: Word;
    BytesToRead: Word;
Begin
  Writeln('Deleting "',IdString,'" in: ',ResFile);
  Assign(SourceFile,ResFile);
  {$I-}
  Reset(SourceFile,1);
  {$I+}
  If IOResult <> 0 then
     Error('Could not open '+ResFile+' !');
  ReadBlock(ResHeader,SizeOf(ResHeader));
  Seek(SourceFile,ResHeader.Offset);
  Found := False;
  j := 1;
  For i := 1 to ResHeader.Count do
    Begin
      ReadBlock(ResDir,SizeOf(ResDir));
      If ResDir.Name = IdString then
         Begin
           Found := True;
         end
      Else
         Begin
           ResDirs[j] := ResDir;
           INC(j);
         end;
    end; { FOR }
  If Not Found then
     Error('"'+IdString+'" not found !');
  DEC(ResHeader.Count);
  If ResHeader.Count <> 0 then
     Begin
       Assign(DestFile,TempRSC);
       {$I-}
       ReWrite(DestFile,1);
       {$I+}
       If IOResult <> 0 then
          Error('Could not create tempfile !');
       WriteBlock(ResHeader,SizeOf(ResHeader));
       New(OutBuffer);
       For i := 1 to ResHeader.Count do
         Begin
           Seek(SourceFile,ResDirs[i].Offset);
           ResDirs[i].Offset := FilePos(DestFile);
           BytesRead := 0;
           While BytesRead < ResDirs[i].CompressedSize do
              Begin
                If BytesRead+MaxSize > ResDirs[i].CompressedSize then
                   BytesToRead := ResDirs[i].CompressedSize - BytesRead
                Else
                   BytesToRead := MaxSize;
                ReadBlock(OutBuffer^,BytesToRead);
                WriteBlock(OutBuffer^,BytesToRead);
                INC(BytesRead,BytesToRead);
              end; { While }
         end; { For }
       ResHeader.Offset := FilePos(DestFile);
       Close(SourceFile);
       For i := 1 to ResHeader.Count do
         Begin
           WriteBlock(ResDirs[i],SizeOf(ResDir));
         end; { For }
       Seek(DestFile,0);
       WriteBlock(ResHeader,SizeOf(ResHeader));
       Close(DestFile);
       DeleteFile(ResFile);
       {$I-}
       ReName(DestFile,ResFile);
       {$I+}
       If IOResult <> 0 then
          Error('Could not rename tempfile ('+TempRSC+') !');
     end
  Else { No more resources ! }
     Begin
       Close(SourceFile);
       DeleteFile(ResFile);
     end;
  Writeln;
  Writeln('"',IdString,'" succesfully deleted.');
  Writeln;
end;

Function ReadKey: Char; ASSEMBLER;
ASM
  XOR   AX,AX
  INT   16h
end;

Procedure ExtractResource;
Var P: Pointer;
    i: Word;
    CompressionError: Integer;
    F: Longint;
Begin
  Writeln('Extracting resource "',IdString,'" to: ',Resource);
  Assign(SourceFile,ResFile);
  {$I-}
  Reset(SourceFile,1);
  {$I+}
  If IOResult <> 0 then
     Error('Could not open '+ResFile+' !');
  ReadBlock(ResHeader,SizeOf(ResHeader));
  Seek(SourceFile,ResHeader.Offset);
  GetMem(P,EnCode_Mem_Req);
  Extract := True;
  For i := 1 to ResHeader.Count do
    Begin
      ReadBlock(ResDir,SizeOf(ResDir));
      If IdString = ResDir.Name then
         Begin
           If FileExist(Resource) then { File exists ?? }
              Begin
                Write('File already exists. Overwrite? (y,N): N',#8);
                Repeat
                  Ch := UpCase(ReadKey);
                Until Ch in ['Y','N',#27,#13];
                If (Ch = #13) or (Ch = #27) then
                   Ch := 'N';
                Writeln(Ch);
                If Ch = 'N' then
                   Halt(0);
              end;
           Assign(DestFile,Resource);
           {$I-}
           ReWrite(DestFile,1);
           {$I+}
           If IOResult <> 0 then
              Error('Could not create file !');
           Seek(SourceFile,ResDir.Offset);
           BytesRead := 0;
           BytesWritten := 0;
           CRC_32 := -1; { Standart PKZIP 32-bit CRC calculation }
           Write('       ',ResDir.Name,#13);
           CompressionError := do_Decode (Nil,DecodeRead,DecodeWrite,P);
           Close(DestFile);
           If CompressionError <> 0 then
              Error('Compression error !');
           CRC_32 := Not CRC_32; { Inverting all bits, like PKZIP }
           If CRC_32 <> ResDir.CRC32 then
              Error('32-bit CRC error !')
           Else
              Writeln('[OK]');
           FreeMem(P,Encode_Mem_Req);
           Close(SourceFile);
           Writeln;
           Writeln('"',IdString,'" succesfully extracted.');
           Writeln;
           Exit;
         end;
    end; { FOR }
  Error('"'+IdString+'" not found');
end;

Procedure CopyFile;
Var Count: Word;
Begin
  Repeat
    {$I-}
    BlockRead(SourceFile,OutBuffer^,MaxSize,Count);
    {$I+}
    If IOResult <> 0 then
       Error('Error readin file !');
    WriteBlock(OutBuffer^,Count);
  Until Count = 0;
end;

Procedure MakeResource;
Var i: Word;
Begin
  If BindExe then
     Begin
       Writeln('Add ',ResFile,' to ',Resource,'. . .');
       Assign(SourceFile,ResFile);
       {$I-}
       Reset(SourceFile,1);
       {$I+}
       If IOResult <> 0 then
          Error('Could not open '+ResFile+' !');
       Assign(DestFile,Resource);
       {$I-}
       Reset(DestFile,1);
       {$I+}
       If IOResult <> 0 then
          Error('Could not open '+Resource+' !');
       Seek(DestFile,FileSize(DestFile));
       ResBlock.Offset := FileSize(DestFile);
       ResBlock.ID := 'RSC';
       CopyFile;
       WriteBlock(ResBlock,SizeOf(ResBlock));
     end
  Else
     Begin
       Writeln('Adding ',Resource,' to ',ResFile,' as "',IdString,'". . .');
       Assign(SourceFile,Resource);
       {$I-}
       Reset(SourceFile,1);
       {$I+}
       If IOResult <> 0 then
          Error('Could not open '+Resource+' !');
       Assign(DestFile,ResFile);
       If FileExist(ResFile) then
          Begin
            {$I-}
            Reset(DestFile,1);
            {$I+}
            If IOResult <> 0 then
               Error('Could not open '+ResFile+' !');
            ReadDestBlock(ResHeader,SizeOf(ResHeader));
            Seek(DestFile,ResHeader.Offset);
            For i := 1 to ResHeader.Count do
              Begin
                ReadDestBlock(ResDir,SizeOf(ResDir));
                If ResDir.Name = IdString then { NOT case sensitive !!!! }
                   Error(IdString+' already exits !');
                ResDirs[i] := ResDir;
              end; { FOR }
            INC(ResHeader.Count);
            Seek(DestFile,ResHeader.Offset);
            ResDirs[ResHeader.Count].Offset := FilePos(DestFile);
            TotalSize := FileSize(SourceFile);
            CompressFile;
            ResDirs[ResHeader.Count].Name := IdString;
            ResDirs[ResHeader.Count].Size := TotalSize;
            ResDirs[ResHeader.Count].CompressedSize := BytesWritten;
            ResDirs[ResHeader.Count].CRC32 := CRC_32;
            ResHeader.Offset := FilePos(DestFile);
            For i := 1 to ResHeader.Count do
              Begin
                ResDir := ResDirs[i];
                WriteBlock(ResDir,SizeOf(ResDir));
              end; { FOR }
            Seek(DestFile,0);
            WriteBlock(ResHeader,SizeOf(ResHeader));
          end
       Else
          Begin
            {$I-}
            ReWrite(DestFile,1);
            {$I+}
            If IOResult <> 0 then
               Error('Could not create '+ResFile+' !');
            ResHeader.CString := 'Resourcefile; (C) Copyright 1996, ThunderByte';
            ResHeader.Count := 1;
            ResHeader.Offset := 0;
            WriteBlock(ResHeader,SizeOf(ResHeader));
            ResDir.Offset := FilePos(DestFile);
            TotalSize := FileSize(SourceFile);
            ResDir.Size := TotalSize;
            ResDir.Name := IdString;
            CompressFile;
            ResDir.CompressedSize := BytesWritten;
            ResDir.CRC32 := CRC_32;
            ResHeader.Offset := FilePos(DestFile);
            WriteBlock(ResDir,SizeOf(ResDir));
            Seek(DestFile,0);
            WriteBlock(ResHeader,SizeOf(ResHeader));
          end;
     end;
  Close(SourceFile);
  Close(DestFile);
  Writeln('Operation succesful. . .');
  Writeln;
end;

Begin
  Writeln('RB - Resource Binder for DOS .EXE''s');
  Writeln('(C) Copyright 1996, N. De Smedt.');
  Writeln;
  Case ParamCount of
    2:
      Begin
        ResFile := Up(ParamStr(1));
        Ext(ResFile,'.RSC');
        IdString := Up(ParamStr(2));
        If IdString[1] = '/' then
           Begin
             Case IdString[2] of
              'L':
                Begin
                  ListResources;
                end;
              'T': TestResources;
              Else
                 Explanation;
             end; { CASE }
           end
        Else
           Explanation;
      end;
    3:
     Begin
       ResFile := Up(ParamStr(1));
       Resource := Up(ParamStr(2));
       IdString := ParamStr(3);
       BindExe := False;
       Ext(ResFile,'.RSC');
       If IdString[1] = '/' then
          Begin
            IdString := Up(IdString);
            Case IdString[2] of
              'A':
                Begin
                  BindExe := True;
                  Ext(Resource,'.EXE')
                end;
              'D':
                Begin
                  IdString := ParamStr(2);
                  DeleteResource;
                  Exit;
                end;
              Else
                 Explanation;
            end; { CASE }
          end;
       New(OutBuffer);
       MakeResource;
     end;
    4:
     Begin
       IdString := Up(ParamStr(4));
       If IdString[2] <> 'E' then
          Explanation;
       ResFile := Up(ParamStr(1));
       Resource := Up(ParamStr(3));
       IdString := ParamStr(2);
       Ext(ResFile,'.RSC');
       ExtractResource;
     end;
    Else
       Explanation
  end; { CASE }
end.