Unit ResUnit;

{ Resources could be anything: WAVes, pictures (.GIF, .BMP, ...),
                               datalist, ...

  BUT, the must be 'binded' (made) with the resource binder (RB.EXE).

  All your data is now added to the .EXE (only one .EXE; no more
  sacrifying from missing datafiles !!!

  See PLAY.PAS to use this unit.

  Last update: 30/12/1996
  Author:      N. De Smedt (alias ThunderByte) member of
               << Houses of Immortality -- Belgium >>
  Version:    1.1.
}

INTERFACE

Uses DOS,CRC,Supopack;

Type ResHeadRec = RECORD
       CString: String[80];
       Count: Word;
       Offset: Longint;
     end;

     ResDirRec = RECORD
        Name: String[20];
        Offset: Longint;
        Size: Longint;
        CompressedSize: Longint;
        CRC32: Longint;
     end;

     ResInfoRec = RECORD
        Offset: Longint;
        Size: Longint;
        CompressedSize: Longint;
        CRC32: Longint;
     end;

     ResBlockRec = RECORD
       ID: Array[1..3] of Char;
       Offset: Longint;
     end;

       PRSC = ^TRSC;
       TRSC = Object(Packing)
         Constructor InitRSCFile(FileName: String);
         Constructor InitRSC;
         Function RSCInfo(IdString: String; Var RInfo: ResInfoRec): Boolean;
         Function ReadRSC(IdString: String): Boolean;
         Function ReadBuffer(Var Buffer: Byte; Size: Word): Boolean; VIRTUAL;
         Destructor Done; VIRTUAL;

         PRIVATE

         ResFile: File;
         ResHeader: ResHeadRec;
         ResDir: ResDirRec;
         ResBlock: ResBlockRec;
         RSCThere: Boolean;
         RSCRead: Longint;
         CRC_32: Longint;
         FromExe: Boolean;
         Function ReadBlock(Var What; Size: Word): Boolean;
         Function Read(Var Buffer:Byte; Var Size:Word):Integer; Virtual;
         Function Write(Var Buffer:Byte; Size:Word):Integer; Virtual;
       end;

IMPLEMENTATION

Function TRSC.ReadBlock(Var What; Size: Word): Boolean;
Var Count: Word;
Begin
  {$I-}
  BlockRead(ResFile,What,Size,Count);
  {$I+}
  ReadBlock := (IOResult = 0) and (Size = Count);
end;

{ Decompression routines: }
Function TRSC.Read(Var Buffer: Byte; Var Size: Word): Integer;
Begin { read from file }
  If RSCRead+Size > ResDir.CompressedSize then
     Size := ResDir.CompressedSize-RSCRead;
  {$I-}
  BlockRead(ResFile,Buffer,Size,Size);
  {$I+}
  If IOResult <> 0 then
     Begin
       Read := -1;
       Exit;
     end;
  INC(RSCRead,Size);
  Read := PACK_NOERR;
End;

Function TRSC.Write(Var Buffer: Byte; Size: Word): Integer;
Begin
  CRC_32 := UpDateCRC32(CRC_32,Buffer,Size);
  ReadBuffer(Buffer,Size);
  Write := PACK_NOERR;
End;

Constructor TRSC.InitRSCFile(FileName: String);
{ From a resourcefile  (*.RSC) }
Begin
  FillChar(ResBlock,SizeOf(ResBlock),0);
  RSCThere := False;
  Assign(ResFile,FileName);
  {$I-}
  Reset(ResFile,1);
  {$I+}
  If IOResult <> 0 then
     Begin
       Fail;
       Exit;
     end;
  If Not ReadBlock(ResHeader,SizeOf(ResHeader)) then
     Begin
       Fail;
       Exit;
     end;
  RSCThere := True;
  Close(ResFile);
  FromExe := False;
end;

Constructor TRSC.InitRSC;
{ From itself: .EXE, .OVL, . ... }
Begin
  FillChar(ResBlock,SizeOf(ResBlock),0);
  RSCThere := False;
  Assign(ResFile,ParamStr(0)); { Full path to itself }
  {$I-}
  Reset(ResFile,1);
  {$I+}
  If IOResult <> 0 then
     Begin
       Fail;
       Exit;
     end;
  Seek(ResFile,FileSize(ResFile)-SizeOf(ResBlock));
  If Not ReadBlock(ResBlock,SizeOf(ResBlock)) then
     Begin
       Fail;
       Exit;
     end;
  If ResBlock.ID <> 'RSC' then
     Begin
       Fail;
       Exit;
     end;
  Seek(ResFile,ResBlock.Offset);
  If Not ReadBlock(ResHeader,SizeOf(ResHeader)) then
     Begin
       Fail;
       Exit;
     end;
  RSCThere := True;
  Close(ResFile);
  FromExe := True;
end;

Function TRSC.RSCInfo(IdString: String; Var RInfo: ResInfoRec): Boolean;
Var i: Word;
Begin
  RSCInfo := False;
  If Not RSCThere then Exit;
  {$I-}
  Reset(ResFile,1);
  {$I+}
  If IOResult <> 0 then Exit;
  If FromExe then
     Seek(ResFile,ResHeader.Offset+ResBlock.Offset)
  Else
     Seek(ResFile,ResHeader.Offset);
  For i := 1 to ResHeader.Count do
    Begin
      If Not ReadBlock(ResDir,SizeOf(ResDir)) then Exit;
      If ResDir.Name = IdString then { Found }
         Begin
           Move(ResDir.Offset,RInfo,SizeOf(RInfo));
           RSCInfo := True;
           Break;
         end;
    end; { For }
end;

Function TRSC.ReadRSC(IdString: String): Boolean;
Var i: Word;
    CompressionError: Integer;
Begin
  ReadRSC := False;
  If Not RSCThere then Exit;
  {$I-}
  Reset(ResFile,1);
  {$I+}
  If IOResult <> 0 then Exit;
  If FromExe then
     Seek(ResFile,ResHeader.Offset+ResBlock.Offset)
  Else
     Seek(ResFile,ResHeader.Offset);
  For i := 1 to ResHeader.Count do
    Begin
      If Not ReadBlock(ResDir,SizeOf(ResDir)) then Exit;
      If ResDir.Name = IdString then
         Begin
           RSCRead := 0;
           CRC_32 := -1;
           If FromExe then
              Seek(ResFile,ResDir.Offset+ResBlock.Offset)
           Else
              Seek(ResFile,ResDir.Offset);
           CompressionError := doDecode;
           If CompressionError <> 0 then
              Exit;
           CRC_32 := Not CRC_32; { Inverting all bits, like PKZIP }
           If CRC_32 <> ResDir.CRC32 then
              Exit;
           ReadRSC := True;
           Break;
         end;
    end; { For }
end;

Function TRSC.ReadBuffer(Var Buffer: Byte; Size: Word): Boolean;
Begin
  RunError(211); { OVERWRITE IT }
end;

Destructor TRSC.Done;
Begin
  Close(ResFile);
end;

Begin
end.