;SETVER beta 5 - DOS version utility
;Copyright (C) 1998 David McIlwraith
;For licensing info, see the file LICENSE.
;
;Uses a different approach to the standard DOS SETVER; checks for version check
;bytes in program and sets the returned version according to the CMP instruction.
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation; either version 2 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;REVISION HISTORY
;----------------
;
;Date                           Version              Author             Comments
;====                           =======              ======             ========
;November 1998                  beta 1               David McIlwraith   Wrote the initial release
;December 6 1998                beta 1               David McIlwraith   Accepted into FreeDOS Project
;December 7 1998                beta 2               David McIlwraith   Modified beta 1, better command line parsing, changed messages
;                                                                       Added revision history, now assembles under MASM 5. Added "springboards" to accomplish this.
;                                                                       Rewrote the comments, as a friend commented it for me.
;December 12 1998               beta 3               David McIlwraith   Optimized some of the code
;                               beta 4               David McIlwraith   Added 'E' and 'D' command line params for enable and
;                                                                       disable, respectively
;                                                                       Optimized and refined command line checking
;                                                                       Removed "How it works" section, no longer maintained
;December 25 1998               beta 5               David McIlwraith   Added interrupt services
;                                                                       Added resident check in INT 21h
;                                                                       Now compiles with TASM; tested with MASM 5.x and 6.x, and TASM 3.x
;                                                                       Changed device name so it doesn't conflict with the standard DOS SETVER.EXE
;
seg_a           segment byte public
		assume  cs:seg_a, ds:seg_a, ss:stack_seg_c

param_switch    equ 82h
parameter       equ 83h
len_params      equ 80h
		org 0h

program         proc far
nextdev         dd 0ffffffffh
devatt          dw 08000h
		dw offset strategy
		dw offset commands
device_name     db 'FDSETVER'                   ;Changed from SETVERXX because of conflicts with the standard DOS name,
                                                ;so now it is FDSETVER, for "FreeDOS SETVER"

;Variables
requestl        dw 0h                           ;The storage address of the device request header
requesth        dw 0h
check           db 0h
result          dw 05h                          ;Contains the DOS version result returned by alternate version method

enable_flag     db 1                            ;Enabled/Disabled flag

;Int 21h entry
int_21h_entry:
                cmp ax,0fdfdh
                jz check_again
                cmp byte ptr cs:enable_flag,0      ;Check if enabled
                jz old_int_21                   ;If not, jump to the old store interrupt
                cmp ah,30h                      ;DOS version request function
                jz save_reg                     ;Yes, save registers and continue
                cmp ax,3306h                    ;Alternate DOS version request fn
                jz alt_method                   ;Ok, jump to alternate method code
                jmp old_int_21
check_again:
                cmp dx,0abbah
                jz res_chk

old_int_21:
                db 0eah                         ;Far JMP to the previous interrupt in the chain
old_int21_l     dw 0
old_int21_h     dw 0

res_chk:
                mov ax,3412h
                iret

alt_method:
                mov ax,cs:result
                iret

save_reg:             
                cmp cs:check,10h                ;When check is equal to 10h SETVER has called int 21h fn30h itself. It should be handled by DOS instead of by itself.
                                                ;This is to find out the true DOS version.
                jz old_int_21
                mov byte ptr cs:check,10h       ;Set check to 10h
                int 21h                         ;Get official version
                mov byte ptr cs:check,0h        ;After this it should be reset to zero again
                push ax                         ;Save processor registers
		push dx
                push ds
		push bp

                mov dx,ax                       ;DX contains the official DOS version.

		mov bp,sp
                mov bx,[bp+08h]                 
                                                
                mov ax,[bp+0ah]                 ;This address is rather high on the stack because of all those register pushes.
                mov ds,ax                       ;DS will contain the segment of the calling program, and bx contains the offset address.
                mov cx,[bx]
                inc bx
                inc bx
                mov ax,[bx]                     ;AX contains the second word of the caller's code
                inc bx
                inc bx
                mov bp,[bx]                     ;BP the third
                inc bx
                inc bx
                mov bx,[bx]                     ;BX the fourth
Pos1:           cmp cl,3dh                      ;SETVER starts checking for possibility 1. The caller's code is 'cmp ax,DOS version'.
		jnz Pos2
                cmp ah,75h
                ja Pos1b
                cmp ah,74h
                jb Pos1b
		mov ah,al
		mov al,ch
		jmp ready
Pos2:           cmp cl,03ch                     ;Possibility 2: 'cmp al,DOS version'
		jnz Pos3       
		cmp al,75h                      ;jz/jnz ?
		ja Pos2b
		cmp al,74h       
		jb Pos2b
		mov al,ch
		mov ah,dh
		jmp ready
Pos3:           cmp cl,83h                      ;Possibility: 'cmp ax,DOS version' (only for the lower byte.).
		jnz Pos4
		cmp ch,0f8h
		jnz Pos6
		cmp ah,75h                      ;jz/jnz ?
		ja Pos3b
		cmp ah,74h
		jb Pos3b
		mov ah,dh
		jmp ready
Pos4:           cmp cx,0e086h                   ;Possibility 4: 'xchg ah,al' followed by a higher/lower comparison
		jz go_on
		cmp cx,0c486h                   ;'xchg ah,al' as well.
		jnz Pos5
go_on:          mov cx,ax
		mov ax,bp
		xchg ch,al
		jmp Pos1
Pos5:           cmp bh,al                       ;Possibility 5: Between the comparison code and the place of checking is some code. Remove it by scrolling up the bytes one by one. 
                jz Pos7                         
		mov cl,ch
		mov ch,al
		mov al,ah
		push cx
		mov cx,bp
		mov ah,cl
		mov cl,ch
		mov ch,bl
                mov bp,cx                       
		pop cx
		mov bl,bh
                jmp Pos1                        ;OK, try everything again.
Pos1b:          mov ah,ch                       ;This is the jb/ja case.
		xchg dl,dh                      ;Compare the minimal requested version with the official version.
                cmp ax,dx                       ;When the official version is higher, return that value.
		jb Pos6
		xchg al,ah
		jmp ready

Pos2b:          cmp ch,dl                       ;The same as 1b
		jb Pos6
		mov al,ch
		mov ah,dh
		jmp ready
Pos3b:          cmp al,dl                       ;The same as 1b
		jb Pos6
		mov ah,dh
		jmp ready
Pos6:
                pop bp                          ;Possibility 6: the comparisons turn out that the official version is ok to report.
		pop ds
		pop dx
		pop ax
                xor cx,cx
                xor bx,bx
		iret

Pos7:
                mov ax,cs:result                ;Since none of the other methods have worked, return 'result'.
                mov cs:result,dx                
                pop bp                          
		pop ds
		pop dx
		pop bx
                xor cx,cx
                xor bx,bx
		iret

ready:
                mov cs:result,ax                ;Save the found version.
                pop bp                          
		pop ds
		pop dx
                pop bx                          ;This should be 'pop ax' but this whould erase the found DOS version
;               mov cx,0h
                xor cx,cx
;               mov bx,0h
                xor bx,bx
pm_end:         iret

int_f9_handler:
                or ah,ah
                jz enable_int
		cmp ah,1
                jz disable_int
		cmp ah,2
                jz status
		iret
enable_int:
		push ds
                xor ax,ax
                mov ds,ax
                mov ax,word ptr ds:(0f2h*4+2)
                push ax
                pop ds
                mov byte ptr ds:enable_flag,1
                pop ds
		xor ax,ax
		iret

disable_int:
		push ds
                xor ax,ax
                mov ds,ax
                mov ax,word ptr ds:(0f2h*4+2)
                push ax
                pop ds
                mov byte ptr ds:enable_flag,0
                pop ds
		xor ax,ax
		iret

status:
		push ds
		xor ax,ax
		mov ds,ax
		mov ax,word ptr ds:(0f2h*4+2)
		push ax
		pop ds
                mov al,ds:enable_flag
                xor ah,ah
                pop ds
		iret
end_res:

strategy:       push ax                         ;This is the first entrypoint when loaded as a device driver.
                mov cs:requestl,bx              ;Save the address of the device request data.                     
		mov ax,es
		mov cs:requesth,ax
                mov ah,08h                      
                mov byte ptr cs:[check],ah
		pop ax
		retf

commands:       pushf                           ;This is the second entry point. It should report the length of the resident part to DOS.
		push ax
		push bx
		push es
                mov ax,cs:requesth              ;This goes via the request data.
		mov es,ax
		mov bx,cs:requestl
                mov al,es:[bx+2]                ;Is this the installation procedure?
                or al,al
                jnz finishd_spring              ;No, finish.
		mov ax,0100h                    ;Report installation was succesfull.
		mov es:[bx+03h],ax              
		mov ax,offset end_res+5
                mov es:[bx+0eh],ax              ;Report the end of the resident code: offset address
		mov ax,cs
                mov es:[bx+010h],ax             ;Report the end of the resident code: segment address
		jmp install

start:
                                                ;Entry point when called as an EXE
                mov ah,ds:param_switch
                cmp ah,'/'
                jz parse_continue
                cmp ah,'-'
                jz parse_continue
                mov ah,ds:len_params
                or ah,ah
                jz install
                jmp syntax_err
parse_continue:
                mov ah,ds:parameter
                cmp ah,'?'
                jz info_spring
                and ah,0dfh
                cmp ah,'H'
                jz info_spring
                cmp ah,'L'
                jz license_spring
                cmp ah,'D'
                jz disable_spring
                cmp ah,'E'
                jz enable_spring
                jmp syntax_err
finishd_spring:
                jmp finishd
info_spring:
                jmp info
license_spring:
                jmp license
enable_spring:
                jmp enable
disable_spring:
                jmp disable

install:
                mov ax,cs                       ;This is the common part of initialization. (Both as a device driver and TSR)
		mov ds,ax
                xor ax,ax
		mov es,ax                        
                mov ax,0fdfdh
                mov dx,0abbah
                int 21h
                cmp ax, 3412h                    ;3412h is returned when SETVER has been loaded
                jz no_install                   ;SETVER already has been loaded. Don't load to conserve memory and avoid delaying INT 21h.
		mov ax,es:84h   
                mov cs:old_int21_l,ax
		mov ax,es:86h
                mov cs:old_int21_h,ax		
		cli
                xor ax,ax
		mov es,ax
		mov word ptr es:084h,offset int_21h_entry
		mov ax,cs
		mov word ptr es:086h,ax
		sti
                cli
                xor ax,ax
                mov word ptr es:(0f2h*4),offset int_21h_entry
                mov word ptr es:(0f2h*4+2),cs
                sti
		cli
		xor ax,ax
		mov es,ax
		mov word ptr es:(0f9h*4), offset int_f9_handler
                mov word ptr es:(0f9h*4+2),cs
		sti
finish:
                mov ah,09
                mov dx,offset license_info
                int 21h
                mov ah,09h                      ;Display "successfully loaded" message
		mov dx,offset loaded
		int 21h
		mov ah,cs:check
		cmp ah,08h
                jnz finisht                     ;The end of the program depends on whether it has started as device driver or as a normal program.

finishd:
                mov ah,09
                mov dx,offset for_help
                int 21h
                pop es                          ;End of device driver.
		pop bx
		pop ax
		popf
		retf            

finisht:
                mov ah,09
                mov dx,offset for_help
                int 21h
                mov dx,offset end_res + 105h     ;The 'keepaddress' is counted from the PSP
                int 27h                         ;Not from CS=0, so something like the PSP length should be added. 
no_install:
                mov ah,09
                mov dx,offset license_info
                int 21h
                mov ah,09
                mov dx,offset already_loaded   ;Display: already loaded.
		int 21h
		mov ah,cs:check                 
		cmp ah,08h
                jnz no_installt                 ;The ending of the program depends of whether is has started as device driver or as a normal program.  

no_installd:         
		mov ax,cs:requesth
                mov es,ax                       ;Report to DOS installation has failed
		mov ax,08103h     
		mov es:[bx+3h],ax
                xor ax,ax
		mov es:[bx+0eh],ax
		jmp finishd     
		
no_installt:    
                mov ax,4c00h                    ;Exit
		int 21h

info:
                mov ah,9
                mov dx,offset license_info+100h
                int 21h
                mov ah,09
                mov dx,offset help_msg+100h
                int 21h
		mov ax,4c00h
		int 21h

license:
                mov ah,09
                mov dx,offset license_msg+100h
                int 21h
                mov ax,4c00h
                int 21h

syntax_err:
                mov ah,09
                mov dx,offset license_info+100h
                int 21h
                mov ah,09
                mov dx,offset invalid_par+100h
                int 21h
                mov ax,4cffh
                int 21h

enable:
                mov ax,0fdfdh
                mov dx,0abbah
                int 21h
		cmp ax,3412h
		jnz not_installed
                mov ah,0
		int 0f9h
                mov ah,09
                mov dx,offset license_info+100h
                int 21h
                mov ah,09
                mov dx,offset enabled_msg+100h
                int 21h
                mov ax,4c00h
                int 21h
disable:
                mov ax,0fdfdh
                mov dx,0abbah
                int 21h
		cmp ax,3412h
		jnz not_installed
                mov ah,1
		int 0f9h
                mov ah,09
                mov dx,offset license_info+100h
                int 21h
                mov ah,09
                mov dx,offset disabled_msg+100h
                int 21h
                mov ax,4c00h
                int 21h

not_installed:
		mov ah,09
		mov dx,offset license_info+100h
		int 21h
		mov ah,09
		mov dx,offset not_installed_msg+100h
		int 21h
		mov ax,4cffh
		int 21h

program         endp

help_msg        db 'Loads as a TSR or in CONFIG.SYS. See README.TXT for more information.',0dh,0ah,'$'
invalid_par     db 'Invalid parameter specified. Type SETVER /? for help.',0dh,0ah,'$'
license_msg     db 'SETVER beta 5 - (C) Copyright 1998 David McIlwraith',0dh,0ah,0dh,0ah
                db 'This program is free software; you can redistribute it and/or modify',0dh,0ah
                db 'it under the terms of the GNU General Public License as published by',0dh,0ah
                db 'the Free Software Foundation; either version 2 of the License, or',0dh,0ah
                db '(at your option) any later version.',0dh,0ah,0dh,0ah
                db 'This program is distributed in the hope that it will be useful,',0dh,0ah
                db 'but WITHOUT ANY WARRANTY; without even the implied warranty of',0dh,0ah
                db 'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the',0dh,0ah
                db 'GNU General Public License for more details.',0dh,0ah,0dh,0ah
                db 'You should have received a copy of the GNU General Public License',0dh,0ah
                db 'along with this program; if not, write to the Free Software',0dh,0ah
                db 'Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.',0dh,0ah,'$'
loaded          db 'SETVER beta 5 has been loaded successfully.',0dh,0ah,'$'
already_loaded  db 'SETVER has already been loaded.',0dh,0ah,'$'
license_info    db 'SETVER beta 5 - (C) Copyright 1998 David McIlwraith',0dh,0ah
                db 'SETVER comes with ABSOLUTELY NO WARRANTY; see the file LICENSE for details',0dh,0ah
                db 0dh,0ah
                db 'If the file was not distributed with this program, e-mail dave_cool@usa.net',0dh,0ah
                db 'This is free software, and you are welcome to redistribute it under certain',0dh,0ah
                db 'conditions; see the file LICENSE for more information.',0dh,0ah,0dh,0ah,'$'    
for_help        db 'For help, type SETVER /? or SETVER /H',0dh,0ah,'$'
enabled_msg     db 'SETVER now enabled.',0dh,0ah,'$'
disabled_msg    db 'SETVER now disabled.',0dh,0ah,'$'
not_installed_msg db 'SETVER is not installed.',0dh,0ah,'$'
;absolute_end   db 0h - Currently unused
		
seg_a           ends

stack_seg_c     segment word stack 'STACK'

		db      100 dup (0)

stack_seg_c     ends
                end start
