;	FLI Playing routine                           
;	Some bugs i assume...but it shows the FLI-file somewhat correctly....
;	At least i haven't found any errors...the code should be fairly
;	understandable...and slow...it reads all data from the disk as the 
;	FLI plays...so if somebody could add XMS support or something...
;	For details on copyrights and legal stuff see the dox...       
;	If you wanna contact me for some reason, mail me at shaitan@proxxi.uf.se
;                                                                               
;				a SHAi'TAN production                  
;				      (c) 1996

                                                      
	DOSSEG                                        
	IDEAL                                         
	P386                                                        
	LOCALS                                        
	                                                                
        INCLUDE "vga.inc"     
		  			    	      
;	MemCopy                                                         
;	Copies vmem variable to video
                                                      
MACRO   MemCopy                                       
	       	    				      
	pusha                                         
						      
                                                      
	mov     ax,fs                                               
	mov     ds,ax                                 
	                                                                
	mov     di,0                                            
	mov     si,OFFSET vmem                        
	mov     ax,0a000h                                  
	mov     es,ax                                               
	mov     cx,64000                              
	rep     movsb                                 
	                                              
	popa                                                        
	                                              
ENDM    MemCopy                                                         
	                                                            
                                                      
STRUC   FLIHead				; FLI Header Structure
						              
size    dd      ?                                             
magic   dw      ?                                             
frames  dw      ?                                             
unim    db      8 DUP(?)                                      
speed   dw      ?                                                   
unim2   db      110 dup(?)                                    
						                        
ENDS    FLIHead                                               
						              
STRUC   FrameHead                               ; FLI Frame Stucture
						            
size    dd      ?                                           
magic   dw      ?                                           
chunks  dw      ?                                           
unim    db      8 DUP(?)                                            
						                        
ENDS    FrameHead                                                       
			       			                    
STRUC   ChunkHead                               ; FLI Chunk Structure
						                        
size    dd      ?                                            
type    dw      ?                                            
		 				      	     
ENDS    ChunkHead                                            
	                                                            
	                                                     
FLI_COLOR       EQU     11                      ; The Differnt chunk types
FLI_LC          EQU     12                                        
FLI_BLACK       EQU     13                                          
FLI_BRUN        EQU     15                                                 
FLI_COPY        EQU     16                                          
TailLen         EQU     0080h                   ; Offset of param len byte
CommandTail     EQU     0081h                   ; Offset of parameters
PIC8259         EQU     0020h         
EOI             EQU     0020h        
			                                                
		   	                                     
SEGMENT _stack PARA STACK 'stack'               ; Stack area...no simplified memory
                                                ; models here...all done the REAL
        dw      1024 DUP(?)                     ; way...             
	                                                                
ENDS    _stack                                                      
		                                             
SEGMENT data PARA PRIVATE 'data'                                        
			                                     
clhelp  db      "Syntax: SFLI [fliname]",10,13,"(even somebody like you should have understood that...)$"
error   db      "Can't open fli file...$"                    
error2  db      "Error in FLI...$"              ; Different Status and Error messages
endmezz db      35 DUP(' '),"FLI Viewer",10,13,29 DUP(' '),"a SHAi'TAN production",10,13,36 DUP(' '),"(c) 1996",10,13,'$'
Zeropal db      768 DUP(0)                      ; Palettes for the funky fade effects...
MPal    db      786 DUP(63)                                                     
Oldpal  db      768 DUP(?)                                                      
Pal     db      768 DUP(?)                                                      
head    FLIHead <>                                                              
fhead   FrameHead       <>                                                      
chead   ChunkHead       <>                                                      
fname   db      128 DUP (?)                     ; Space for command line params
fhan    dw      ?                               ; FLI File handle    
bytes   dw      ?                               ; Different index vars...
index   dw      ?                                                       
temp    dw      ?                                                       
max     dw      ?                                                   
timer	dw	?                                                
numParams       DW      ?                       ; Number of parameters   
skip    db      ?                                                       
sizec   db      ?                                                       
char    db      ?                                                       
packs   db      ?                                                       
clocktick       dw      ?                       ; Tick counters for the modified INT 08h routine
videotick	dw	?                                                                            
                                                                        
ENDS    data                                                            
		       	 		                                
SEGMENT video PARA PRIVATE UNINIT 'data'                                
		  			                                
vmem    db      64000 DUP(?)                    ; A video memory size buffer    
					                                
ENDS    video                                                           
							     	    	
SEGMENT data2 PARA PRIVATE 'data'                                       
	  	 	      		                                
buf     db      65535 DUP(?)                    ; A general data buffer         
							                
ENDS    data2                                                           
		  			                                
SEGMENT code PARA PRIVATE 'code'                                            
							       	            
	ASSUME CS:code,DS:data,ES:NOTHING,FS:video,GS:data2,SS:_stack       
	     		  					            
	  			  				            
inProgress      DB      0                                                   
OldInt08h       dd      ?                       ; this is called by timer 0 (INT 8)     
                                                                            
;	Tick                                                            
;	New INT 08h handler                                             
                                                                        
PROC    Tick                                                                
                                                                            
                                                                            
        cmp     [byte cs:inProgress], 0         ; Check in-progress flag            
        jne     f89                                                     
        inc     [byte cs:inProgress]                                    
                                                                        
        sti                                     ; Allow interrupts to occur     
        push    ax                              ; Save modified registers       
        push    ds                                                      
        push    dx                                                      
                                                                        
        mov     al, EOI                         ; Allow the next timer INT to occur
        out     PIC8259, al                                             
                                                                        
	mov	ax,data                                                 
	mov	ds,ax                                                   
        inc     [clocktick]                     ; Increase the tick counters
        inc	[videotick]                                         
                                                                                     
        cmp     [videotick],9                   ; Check if video tick should occur(approx. 70 times/second)
	jb	checkclock                                                                                
	inc 	[timer]
                                                                                      
        mov	[videotick],0                                                         
                                                                                      
checkclock:                                                                           
                                                                                      
        cmp     [clocktick],35                  ; Check if clock tick should occur(approx. 18 times/second)
	jae	f99                                                 
                                                                            
        cli                                     ; Disable interrupts                
        dec     [byte cs:inProgress]            ; Reset in-progress flag            
        pop     dx                              ; Restore saved registers           
        pop     ds                                                          
        pop     ax                                                          
                                                                        
	jmp	f89                                                 
                                                                    
f99:                                                                    
 	mov	[clocktick],0                                       
	                                                            
        cli                                     ; Disable interrupts                
        dec     [byte cs:inProgress]            ; Reset in-progress flag            
        pop     dx                              ; Restore saved registers           
        pop     ds                                                          
        pop     ax                                                          
 	                                                                
        jmp     [DWORD cs:OldInt08h]            ; Call old INT 08h          
	                                                            
f89:                                                                
                                                                    
	iret                                                        
                                                                        
ENDP    Tick                                                            
                                                                    
;	Whitespace                                                      
;	Checks for spaces and tabs                                  
                                                                    
PROC    Whitespace	   	       	                                
        mov     al, [si]                        ; Get character at ds:si
        cmp     al, 020h                          
        je      @@10                                   
        cmp     al, 009h                            
        je      @@10                                   
        cmp     al, 00Dh                             
@@10:                                                               
        ret                                       
ENDP    Whitespace                                                  
                                                                    
;	GetParams                                                   
;	Inits the command line parameter buffer                     
                                                                    
PROC    GetParams                                                   
                                                                    
                                                                    
        xor     ch, ch                                                  
        mov     cl, [ds:TailLen]                ; cx = length of parameters 
        inc     cx                              ; Include cr at end         
        mov     si, CommandTail                                         
        mov     di, offset fname        
                                                                    
@@10:                                                               
                                                                    
        call    Whitespace                      ; Skip leading blanks & tabs
        jne     @@20                            ; Jump if not a blank or tab
        inc     si                                                  
        loop    @@10                                                
                                                                    
@@20:                                          
                                        
        push    cx                              ; Save cx for later
        jcxz    @@30                            ; Skip movsb if count = 0
        rep     movsb                   
                                        
                                        
@@30:                                                                   
        push    es                      
        pop     ds                      
        pop     cx                       
        xor     bx, bx                          ; Init parameter count
        jcxz    @@60                            ; Skip loop if length = 0
        mov     si, offset fname        
@@40:                                   
        call    Whitespace                      ; Check for blank, tab, or cr
        jne     @@50                            ; Jump if not a separator
        mov     [byte ptr si], 0                ; Change separator to null
        inc     bx                    
@@50:                                   
        inc     si                      
        loop    @@40                    
@@60:                                   
        mov     [numParams], bx                 ; Save number of parameters
        ret                             
                                        
ENDP    GetParams                       
                                                                        
;	Sleep                           
;	Waits for correct timing        
                                                                        
PROC	Sleep	far                                                     
                                                                        
still:                                                                  
                                                                        
	mov	ax,[timer]		
        cmp     ax,[head.speed]                 ; Compare FLI Playing speed
	jb	still		        
	                                                            
	mov	[timer],0                                           
	                                                            
	ret                                                         
	                                                            
ENDP	Sleep                                                       
                                                                    
;	flc                             
;	Decodes FLI_LC frames           
                                                                        
PROC    flc   	far                                                 
 	       	    	       			      		    
	mov     [index],0                                               
	mov     [bytes],0                                               
			                                                
	mov     ah,3fh                          ; Read data to buffer   
	mov     bx,[fhan]                                               
	mov     ecx,[chead.size]        
	push	ds                      
	mov	dx,data2                
	mov	ds,dx                   
	mov     dx,OFFSET buf           
	int	21h                     
	                                                            
	pop	ds                      
	                                
	mov	ax,[word buf]			; Get First modified line
	mov	[temp],ax                                                
	                                                                 
	add     [bytes],2                                                
		                                                         
  	mov	bp,[bytes]                                               
  	                                                                 
	mov	ax,[word buf+bp]  	
  	mov     [max],ax                                                 
                                                                         
	add     [bytes],2                                                
	   	                                                         
	mov     ax,[max]			; Get Last modified line
	add     ax,[temp]                                               
	mov     [max],ax                                                
                                                                        
lnextline:                                                              
			   						
	mov     ax,[temp]                                               
	imul    ax,320                                                  
	mov     [index],ax			; Screen write position
	 	    	 					       	
	mov	bp,[bytes]                                              
	mov     al,[byte buf+bp]                                           
	mov     [packs],al			; Get number of packets in this line
	                                                                            
	inc     [bytes]                                                             
		                                                                    
	cmp     [packs],0                                                           
	jne     lnextpack
		                                                        
	inc     [temp]                                                  
	mov     ax,[max]                                                
	cmp     ax,[temp]                                               
	je      vcopy                                                   
		                                                        
	jmp     lnextline                                               
	   	 	  					        
lnextpack:                                                              
			 					        
	mov	bp,[bytes]                                              
	mov	al,[byte buf+bp]                                        
	mov     [skip],al			; Get Skip Count
	                                                                
	inc     [bytes]                                                     
			  					        
	mov     al,[skip]                                               
	mov     ah,0                                               
	add     [index],ax                                          
		  	  					   
	mov	bp,[bytes]                                      
	mov	al,[byte buf+bp]                                
	mov     [sizec],al			; Get Size var
	                                                           
	inc     [bytes]                                       
			  				      	        
	test    [sizec],10000000b                                       
	jnz     lpositive			; Jump if negative
			  					        
	mov     cl,[sizec]                                        
	mov     ch,0                                                    
			                                                
	mov     di,[index]                                              
	add     [index],cx                                              
	mov     ax,fs                                                   
	mov     es,ax                                                   
	mov	bp,[bytes]                                              
	add     [bytes],cx                                                  
	mov     si,gs                                                   
	push    ds                                                      
	mov     ds,si                                             
	mov     si,OFFSET buf                                     
	add	si,bp                                             
	rep     movsb				; Copy [sizec] byte to video
		                                                            
	pop     ds                                                          
		                                                            
	dec     [packs]                                                     
	cmp     [packs],0                                                   
	jne     lnextpack                                                   
			                                                    
	inc     [temp]				; Check for last line
	mov     ax,[max]                                                    
	cmp     [temp],ax                                                   
	jne     lnextline                                                   
		                                                            
	jmp     lvcopy                                                      
                                                                            
lpositive:                                                                  
		                                                     
	neg     [sizec]				; ABS(sizec)
				                                     
	mov	bp,[bytes]                                           
	mov	al,[byte buf+bp]                                     
	mov     [char],al			; Get Char to copy
	                                                             
	inc     [bytes]                                              
							 	        
	mov     cl,[sizec]                                              
	mov     ch,0                                              
	mov     di,[index]                                              
	mov     ax,fs                                                   
	mov     es,ax                                              
	mov     al,[char]                                               
	add     [index],cx                                              
	rep     stosb				; Store [sizec] [char]:s to vidmem
								                  
	dec     [packs]                                                           
	cmp     [packs],0
	jne     lnextpack
			 					    
	inc     [temp]                                                      
	mov     ax,[max]                                            
	cmp     [temp],ax                                           
	jne     lnextline                                           
		   	                                            
	jmp     lvcopy                                              
								        
lvcopy:                                                                 
	    							    
	call	Sleep				; Wait for correct timing
	                                                                 
	push    ds                                                       
	MemCopy   				; Copy memory                                                       
	pop     ds                                           
							                 
	ret                                                              
							     	         
ENDP    flc                                                              
								         
								         
PROC    fbrun   far                                                         
								         
	mov     [index],0                                                
	mov     [temp],0                                                 
	mov	[bytes],0                                                
			     						 
	mov     ah,3fh                          ; Read data to buffer    
	mov     bx,[fhan]                                                
	mov     ecx,[chead.size]                                         
	push	ds                                                       
	mov	dx,data2
	mov	ds,dx                                                    
	mov     dx,OFFSET buf                                            
	int     21h                                                      
	pop	ds                                                       
	                                                                 
bnextline:                                      ; Suddenly, aliens force me to                         
                                                ; stop writing comments...figthing
        mov     ax,[temp]                       ; for my life, i still try to 
        imul    ax,320                          ; put some in....=)
	mov     [index],ax                                              
	                                                                
	mov	bp,[bytes]     
	mov	al,[byte buf+bp]
	mov	[packs],al
	inc	[bytes] 
		       						    
bnextpack:                                                                  
		  						    
	mov	bp,[bytes]
	mov	al,[byte buf+bp]                                        
	mov	[sizec],al
	                                                                
	inc 	[bytes]                                            
     	                                                                
	test    [sizec],10000000b                                       
	jz      positive                                                
								        
	neg     [sizec]                                                 
				     
	mov     cl,[sizec]
	mov     ch,0                                                
		        
	mov	bp,[bytes]
	add	[bytes],cx
	mov     di,[index]                                          
	add     [index],cx                                          
	mov     ax,fs                                                   
	mov     es,ax                                                   
	push    ds                                                      
	mov     si,gs                                                   
	mov     ds,si                                               
	mov     si,OFFSET buf                                           
	add	si,bp                                               
	rep     movsb                                               
		                                                        
	pop     ds                                                          
		     	   					    
	dec     [packs]                                             
	cmp     [packs],0
	jne     bnextpack                                               
		  	     
	inc     [temp]                                                  
	cmp     [temp],200                                              
	jne     bnextline                                          
		                                                        
	jmp     vcopy    
		                                                    
positive:                                                               
			 					        
                                                                        
	mov	bp,[bytes]
	mov	al,[byte buf+bp]                                        
	mov	[char],al
                                                                    
	inc	[bytes]	  						    
	                        
	mov     cl,[sizec]
	mov     ch,0                                                    
	mov     di,[index]                                              
	mov     ax,fs   
	mov     es,ax                                                   
	mov     al,[char]                                               
	add     [index],cx                                         
	rep     stosb                                                   
								    
	dec     [packs]                                             
	cmp     [packs],0                                               
	jne     bnextpack                                               
		        
	inc     [temp]                                                  
	cmp     [temp],200                                          
	jne     bnextline                                               
		        
	jmp     vcopy                                               
		 	      					            
vcopy:                          
		        
	Call	Sleep   
	                                                                
	push    ds                                                  
	                                                                
	MemCopy                                                         
	                                                           
	pop     ds                                                      
	                
			      					    
	ret                                                             
								        
ENDP    fbrun                                                       
								        
			 					    
PROC    fcolor  far                                                     
								    
	mov     dx,OFFSET temp                                      
	mov     cx,2                                                        
	mov     ah,3fh          
	mov     bx,[fhan]                                               
	int     21h                                                     
	                                                                
	sub     [word chead.size],ax                                
			                                                
	mov     ah,3fh                          ; Read data to buffer   
	mov     bx,[fhan]                                               
	mov     cx,[word chead.size]                                    
	mov     dx,SEG buf                                           
	push    ds                                                  
	mov     ds,dx                                                   
	mov     dx,OFFSET buf                                           
	int     21h                                                  
	pop     ds                                                      
	sub     [word chead.size],ax                                
		       						        
	mov     bp,0    
		                                                    
nextpack:                                                                   
			        
	mov     bh,0                                                    
	mov     bl,[byte buf+bp]                                        
	inc     bp                                                      
	mov     ch,0                                                
	mov     cl,[byte buf+bp]                                        
	inc     bp                                                      
	cmp     cx,0                                                    
	jne     colok                                                   
	mov     cx,256        
			                                            
colok:                                                                  
	mov     ax,cx                                                   
	shl     cx,1    
	add     cx,ax                                                   
		                                                    
	mov     dx,3c8h                                                 
	mov     al,bl   
	out     dx,al                                               
		                                                            
	push    ds              
	mov     ax,gs                                                   
	mov     ds,ax                                                   
	mov     si,OFFSET buf                                           
	add     si,bp                                               
	add     bp,cx                                                   
		                                                        
	WaitRetrace                                                     
		        
	mov     dx,3c9h 
	rep     outsb                                               
	                                                                
	pop     ds
	
	dec     [temp]                                                  
	cmp     [temp],0                                            
	jne     nextpack                                                
		    
		                                                    
	ret                                                                 
		                
ENDP    fcolor                                                          
		     	                                                
Start:                                                                  
								
	mov	ax,data
	mov	es,ax
	call	GetParams
	mov     ax,data                         ; Init all segments     
	mov     ds,ax                                                   
	mov     ax,data2                                                
	mov     gs,ax                                                   
	mov     ax,video                                                
	mov     fs,ax                                                   
	                                                                
	push	ds                                                      
	                                                                
	mov	[timer],0                                               
        mov     ax, 3508h                       ; Get interrupt 08 vector       
        int     21h                               
        mov     [word OldInt08h+2], es          ; Save SEG value
        mov     [word OldInt08h], bx            ; Save OFFSET value
                                                                            
        push    ds                                
        mov     ax, 2508h                       ; Set interrupt 08 vector       
        push    cs                           
        pop     ds                      
        mov     dx, offset tick                 ; DS:DX -> new routine
        int     21h                             ; Set new interrupt vector      
        pop     ds                              ; Restore ds                    
                                                                        
	mov	al,00110110b
	out	43h,al                                                  
	mov	ax,1894
	out	40h,al 
	mov	al,ah
	out	40h,al                                                  
                                                                        
	cmp	[numParams],1                                           
	jae	parok                                                   
	                                                                
	mov     ah,09h                          ; Write error string                                                                          
	mov     dx,OFFSET clhelp                                        
	int     21h
	
	jmp	ending
	                        
parok:	                 
	                                                                
	mov     ah,3dh                          ; Open file        
	mov     al,2                                               
	mov     dx,OFFSET fname                                         
	xor     cl,cl                                              
	int     21h                                                 
	jnc     openok                                                  
		     							    
	mov     ah,09h                          ; Write error string                                                                          
	mov     dx,OFFSET error                                         
	int     21h                                                     
									
	jmp     ending                                                  
								   	
openok:                                                                 
									
	mov     [fhan],ax                       ; Save handle           
			 						
	mov     ah,3fh                                                  
	mov     bx,[fhan]                                               
	                                                                
	mov     cx,128                                                  
	mov     dx,OFFSET head                  ; Read FLI header       
	int     21h                                                     
									
	cmp     [head.magic],0af11h             ; Check if FLI          
	je      fliok                                                   
									    
	mov     ah,09h                          ; Write error string                                                                          
	mov     dx,OFFSET error2                                           
	int     21h                                                     
			      	 					
	jmp     ending                                                  
									
fliok:                                                                  
									
	HideCursor                                                  
	                                                            
;	dec	[head.frames]                                           
	                                                                
	pusha                                                           
	                                                                
	mov ax,SEG Oldpal                                               
	mov es,ax                                                       
	mov di,OFFSET Oldpal                                            
	                                                                    
	SavePal                                                                                                                               
	
	mov di,OFFSET Pal                                               
	                                                                
	SavePal                                                         
				                                        
	mov cx,64                                                       
Down:                                                               
	mov ax,SEG Pal                                              
	mov es,ax                                                       
	mov di,OFFSET Pal
	          
	mov ax,SEG ZeroPal                                              
	mov ds,ax
	mov si,OFFSET ZeroPal
	
	FadeOut                                                     
	
	mov ax,SEG Pal
	mov ds,ax                                                           
	mov si,OFFSET Pal                                                                                                                     
	
	SetPal                                                          
	                                                                
	loop Down                                                       
				                                        
	popa                                                            
	                                                            
	VGA                                     ; Switch to VGA mode 13h
								        
nextframe:                                                          
		  						    
	cmp     [head.frames],0                                         
	je      endoffli                                            
	dec     [head.frames]                                       
								    
	mov     ah,3fh                                              
	mov     bx,[fhan]                                           
	mov     cx,16                                               
	mov     dx,OFFSET fhead                 ; Read frame header         
	int     21h                                                                                                                           
								    
nextchunk:                                                              
								        
	cmp     [fhead.chunks],0                                        
	je      nextframe                                               
	dec     [fhead.chunks]                                          
								    
	mov     ah,3fh                                              
	mov     bx,[fhan]                                               
	mov     cx,6                                                
	mov     dx,OFFSET chead                 ; Read chunk header 
	int     21h                                                     
								    
	mov     eax,[chead.size]                                    
	sub     eax,6                                               
	mov     [chead.size],eax                                    
								    
	cmp     [chead.type],FLI_COLOR                              
	je      color                                                       
	cmp     [chead.type],FLI_LC                                                                                                           
	je      lc                                                  
	cmp     [chead.type],FLI_BLACK                                  
	je      black                                                   
	cmp     [chead.type],FLI_BRUN                                   
	je      brun                                                    
	cmp     [chead.type],FLI_COPY                                   
	je      copy                                                
		   						    
	Text25                                                          
		  						    
	mov     ah,09h                          ; Write error string
	mov     dx,OFFSET error2                                           
	int     21h                                                    
		   						    
	jmp     ending                                              
		   						    
color:                   
			 
	call    fcolor                                                      
	jmp     nextchunk                                                                                                                     
			   
lc:                                                                     
		 	                                                
	call    flc                                                     
	jmp     nextchunk                                          
		     						        
black:                                                                      
								                                                                              
	call	Sleep
	                       
	WaitRetrace                                                     
								        
	ClrVGA                                                          
								   
	mov     ax,0                                               
	mov     bx,fs                                               
	mov     es,bx                                                   
	mov     di,0                                               
	mov     cx,32000                                                    
	rep     stosw                                               
	jmp     nextchunk                                               
				                                        
brun:                                                              
		       		                                        
	call    fbrun                                              
	jmp     nextchunk                                               
			                                            
copy:                    
			 
	mov     ah,3fh                                              
	mov     bx,[fhan]                                           
	mov     cx,64000                                                
	push    ds                                                  
	mov     dx,fs                                                   
	mov     ds,dx                                                                                                                         
	mov     dx,OFFSET vmem                  ; Read buffer           
	int     21h            
	                                                                
	call	Sleep                                                       
		     	                                                
	WaitRetrace  
		     	                                                
	MemCopy                                                         
	   		                                                
	pop     ds                                                      
	jmp     nextchunk                                               
		                                                        
		                                                        
endoffli:                                                               
		                                                        
	mov	ah,1     
	int 	16h                                                     
	jz	endoffli 
	mov	ah,0     
	int	16h                                                                                                                           
                         
	mov ax,SEG Pal                                              
	mov es,ax                                                       
	mov di,OFFSET Pal                                                   
	                 
	SavePal          
			 	                                        
	mov cx,64                                                   
Down2:                                                                  
     	mov ax,SEG Pal                                              
	mov es,ax                                                       
	mov di,OFFSET Pal                                           
	                                                            
	mov ax,SEG ZeroPal                                          
	mov ds,ax                                                   
	mov si,OFFSET ZeroPal                                       
	                                                                
	FadeOut                                                     
	                                                            
	mov ax,SEG Pal                                                                                                                        
	mov ds,ax                                                   
	mov si,OFFSET Pal                                           
	                                                                
	SetPal                                                              
	                                                            
	loop Down2                   
				                                        
	Text25                                                      
	                                                                
	HideCursor                   
	     			     				    	
	mov ax,SEG ZeroPal                                              
	mov ds,ax                                                       
	mov si,OFFSET ZeroPal                                           
                                                                        
	SetPal                                                          
                                                                        
	mov     ah,09h                                                  
	mov     dx,OFFSET endmezz                                       
	int     21h                                                                                                                           
                                                                        
	mov cx,64                                                       
@@U:                                                                    
	mov ax,SEG Pal                                                      
	mov es,ax                                                       
	mov di,OFFSET Pal                                               
                                                                        
	mov ax,SEG MPal                                                 
	mov ds,ax                                                       
	mov si,OFFSET MPal                                              
								    	
	FadeIn                                                          
                                                                        
	mov ax,SEG Pal                                                  
	mov ds,ax                                                       
	mov si,OFFSET Pal                                               
                                                                        
	SetPal                                                          
	                                                                
	loop @@U                                                                                                                              
                                                                        
	mov cx,64                                                       
@@p:                                                                    
	mov ax,SEG Pal                                                      
	mov es,ax                                                       
	mov di,OFFSET Pal                                               
                                                                        
	mov ax,SEG Oldpal                                               
	mov ds,ax                                                       
	mov si,OFFSET OldPal                                            
		      	  						
	FadeOut                                                         
                                                                        
	mov ax,SEG Pal                                                  
	mov ds,ax                                                       
	mov si,OFFSET Pal                                               
                                                                        
	SetPal                                                          
	                                                                
	loop @@p                                                                                                                              
                                                                        
	ShowCursor                                                      
                                                                        
                                                                            
ending:                        
			       
	mov	al,00110110b                                            
	out	43h,al
	mov	ax,65535
	out	40h,al                                                  
	mov	al,ah
	out	40h,al

        push    ds                              ; Save ds, changed below
        mov     ax, 2508h                       ; Set interrupt 08 vector
        mov     dx, [word OldInt08h]            ; Get saved offset value
        mov     ds, [word OldInt08h+2]          ; Get saved segment value
        int     21h
        pop     ds                              ; Restore ds

	mov     ax,4c00h
	int     21h     
			
ENDS    code            
                                                                            
END     Start

;	Hmm...it seems that the comments faded away towards the end...
;	who cares anyway...apart from me in 20 days and anybody else
;	reading this code...:)...
