	IDEAL
	P386
	LOCALS

;       HideCursor
;       Hides the hardware cursor

MACRO   HideCursor

	mov ah,3
	mov bh,0
	int 10h
	or ch,00100000b
	mov ah,1
	int 10h

ENDM    HideCursor


;       ShowCursor
;       Restores the hardware cursor

MACRO   ShowCursor

        mov ah,3
        mov bh,0
        int 10h
        and ch,11011111b
        mov ah,1
        int 10h

ENDM    ShowCursor


;       WaitRetrace
;       Waits for the VGA Vertical retrace to commence

MACRO   WaitRetrace
LOCAL   @@Tst1,@@Tst2

	push dx                 ; Save DX
	push ax                 ; Save AX
	mov dx,3dah             ; VGA Stat port
@@Tst1:
	in al,dx
	and al,8
	jnz @@Tst1              ; Wait if retrace is active

@@Tst2:
	in al,dx
	and al,8
	jz @@Tst2               ; Wait for the next retrace

	pop ax
	pop dx

ENDM    WaitRetrace

;       VGA
;       Sets VGA mode(13h)

MACRO   VGA

	push ax
	mov ax,13h
	int 10h
	pop ax

ENDM    VGA

;       Text25
;       Sets 80x25 mode

MACRO   Text25

	push ax
	mov ax,3
	int 10h
	pop ax

ENDM    Text25

;       ClrVGA
;       Clears the VGA Mem buffer

MACRO   ClrVGA

	push es
	push di
	push cx
	push ax

	mov cx,16000
	mov di,0a000h
	mov es,di
	mov di,0
	mov eax,0
	rep stosd               ; DWORD Store...faster...

	pop ax
	pop cx
	pop di
	pop es

ENDM    ClrVGA

;       SavePal
;       Saves the entire palette
;       ES:DI -> 768-byte RGB-buffer

MACRO   SavePal

	push dx
	push cx
	push ax

	mov dx,3c7h
	mov al,0
	out dx,al               ; Set Read mode

	mov cx,768
	mov dx,3c9h
	rep insb                ; Read 768 bytes

	pop ax
	pop cx
	pop dx

ENDM    SavePal

;       SetPal
;       Set the entire palette
;       DS:SI -> 768-byte RGB-buffer

MACRO   SetPal

	push dx
	push cx
	push ax

	WaitRetrace             ; Wait for vertical Retrace

	mov dx,3c8h
	mov al,0
	out dx,al               ; Set Write mode

	mov cx,768
	mov dx,3c9h
	rep outsb                ; Write 768 bytes

	pop ax
	pop cx
	pop dx

ENDM    SetPal

;       FadeOut
;       Fades entire buffer out one step
;       ES:DI -> 768-byte RGB-buffer
;       DS:SI -> 768-byte limit RGB-buffer

MACRO   FadeOut
LOCAL   @@next,@@nodec

	pusha

	mov cx,768
@@next:
	mov al,[byte ds:si]
	cmp al,[byte es:di]
	je @@nodec
	dec [byte es:di]
@@nodec:
	inc si
	inc di
	loop @@next

	popa

ENDM    FadeOut

;       FadeIn
;       Fades entire buffer in one step
;       ES:DI -> 768-byte RGB-buffer
;       DS:SI -> 768-byte limit RGB-buffer

MACRO   FadeIn
LOCAL   @@ne,@@nod

	pusha

	mov cx,768
@@ne:
	mov al,[byte ds:si]
	cmp al,[byte es:di]
	je @@nod
	inc [byte es:di]
@@nod:
	inc si
	inc di
	loop @@ne

	popa

ENDM    FadeIn
