Program COMtoStruc;

 { Convert PC-Magazine 'FONTEDIT.COM' files into the format used by
   SRMUserFont() - can easily be used to convert most _any_ monocolor
   bitmapped file (*.CPS *.FNT), and I suspect that the fonts used
   by XLib should work with just a little rearranging of the header  }

var
 F              :File;
 Ut             :File;
 B              :Byte;
 Data           :Array[1..16] of Byte;

 TopLine, BotLine,
 ROL, W, Width,
 InHeight,
 Height         :Byte;

 Loop,Loop2     :Word;
 FirstChar      :Byte;
 LastChar       :Byte;

 BytesRead      :Word;

BEGIN
 Assign(F,'C:\TEMP\SMALLER.COM');  Reset(F,1);
 Assign(Ut,'C:\TEMP\SMALLER.BIN'); ReWrite(UT,1);

 FirstChar:=32;   { 32  = ' ' }
 LastChar:=254;   { 153 = '' }

 TopLine:=1;
 BotLine:=5; { Probably 16 for a complete 8*16 font }
 Height:=BotLine-TopLine+1;

 Width:=3;  { Width of characters, for a 8*16 font this is should
              probably be set to 7 or 6 }
 ROL:=2;    { The character should always be located in the HIGH
              bits, not the low ones. This give us a good performance
              boost. For a 8*16 font this should probably be set to 1 or 0 }

 if Height>16 then Height:=16;

 Seek(F,$32);
 BlockRead(F,InHeight,1,BytesRead); { Get Character Height from file }

 BlockWrite(Ut,Height,1,BytesRead); { Write Header }
 BlockWrite(Ut,FirstChar,1,BytesRead);
 B:=LastChar-FirstChar;
 BlockWrite(Ut,B,1,BytesRead);

 Seek(F,$62+(FirstChar*InHeight));  { Find first bitmap }
 for loop:=FirstChar to LastChar do
  begin
  W:=Width;
  if Loop=32 then W:=2; { Some special cases: !,.W }
  if Loop=33 then W:=2;
  if Loop=44 then W:=2;
  if Loop=46 then W:=2;
  if Loop=87 then W:=5;
  if Loop=92 then W:=5;
  BlockWrite(Ut,W,1);
  BlockRead(F,Data,InHeight,BytesRead);
  if ROL>0 then for loop2:=TopLine to BotLine do Data[loop2]:=Data[loop2] SHL ROL;
  BlockWrite(Ut,Data[TopLine],Height,BytesRead);
  end;

 Close(F);
 Close(UT);
END.
