{Conditional compilation directives}

{Here you can specify which major parts of Sgraph should be compiled or not.
 If you find yourself running out of memory, you can probably economize
 here in the definition table on features of Sgraph you don't need. Just
 put an $UNDEF where a $DEFINE is to turn a feature off.}

{-Undefinable defines------------------------------------------------------}
{-$DEFINE yeswantstarfield_1}

{UNDEFINE if you don't want the first starfield routines & data}

{$DEFINE yeswantstarfield_2}

{UNDEFINE if you don't want the second starfield routines & data}

{$DEFINE yeswanttextfade}

{UNDEFINE if you don't want textfade routines & data}

{$DEFINE yeswantmousestuff}

{UNDEFINE if you don't want mouse unit compiled}

{$DEFINE yeswantlzss_stuff}

{UNDEFINE if you don't want the compression unit compiled}

{$DEFINE yeswantpalcycle}

{UNDEFINE if you don't want palette cycling}

{--------------------------------------------------------------------------}
{-Polymorphic defines, must never be undefined, modification only----------}

{$DEFINE normalstarfield_2}

{Define a largestarfield_2 if you want a larger starfield. No effect if
 yeswantstarfield_2 is undefined}

{--------------------------------------------------------------------------}

{Conditional compilation directives end}

unit sgraph; {Stfan Viljoen & Contributors' Graphic Unit, version 1.0
              Internet: 9128476@pukrs3.puk.ac.za

              Smooth, fast animation and other stuff for TP6, in 320x200x256
              Please feel free to contact me about ANYTHING pertaining to
              sgraph! If you use it for ANYTHING, let me know. :)
              Include my name and e-mail in any credits, PLEEEEEZE!
              
              Take a look at the SourceWare Archival Group's Pascal
              libraries. Great stuff!
              http://www.interlog.com/~jfanjoy/home.html

              Sprite animation code is MINE! ;)
              Zooming starfield code from Brendan Beaman, pulled from SWAG.
              Side view starfield code from Daniel Schlenzig, SWAG,
                modified by me.
              Text fading code from Reynir Stefansson, pulled from SWAG.
              Mouse interface unit form the SWAG group itself.
              LZSS compression unit from Andy Tam, Andrew Eigus (Mr Byte),
                and Douglas Webb.
              TSR routines for Snap4.pas from Ross Neilson Wentworth,
                Serendipity Software
                1422 Elkgrove Circle, #3
                Venice, CA  90291
                United States of America
                (213)399-1244
              Palette cycling code from SWAG, unaltered.
              Palette fading code's timer comes from swag.

              If you don't like your routines in here, LET ME KNOW. I'll
              remove them immediately. Just don't sue me.}

INTERFACE

uses {$IFDEF yeswantmousestuff}mouse,{$ENDIF}dos,
     {$IFDEF yeswantlzss_stuff}lzssunit,{$ENDIF}crt,graph;

const {$IFDEF yeswanttextfade}
      textfade_PelAddrRgR  = $3C7;
      textfade_PelAddrRgW  = $3C8;
      textfade_PelDataReg  = $3C9;
      {$ENDIF}

      hidscr: byte = 0;
      visscr: byte = 1;
      mastscr: byte = 2;

      nopalload = false;
      yespalload = true;
      no = false;
      yes = true;

{$IFDEF yeswantstarfield_2}

{$IFDEF normalstarfield_2}
      starfield_2maxstars = 200;
{$ENDIF}

{$IFDEF largestarfield_2}
      starfield_2maxstars = 400;
{$ENDIF}

{$ENDIF}

type
     {$IFDEF yeswanttextfade}

     textfade_rgbrecord = record
                            r,g,b: byte;
                          end;

     textfaderecord = record
                        i   : integer;
                        ch  : char;
                        col : array[0..63] of textfade_rgbrecord;
                      end;

     {$ENDIF}

     {$IFDEF yeswantstarfield_1}

     starfield_1record = record
                           l,l2,x,y: integer;
                           rad: array[1..20] of integer;
                           p: array[1..20, 1..5] of integer;
                           starscolor: byte;
                           starformvalue: word;
                         end;

     {$ENDIF}

     {$IFDEF yeswantstarfield_2}

     starfield_2record = record
                           star : Array[0..starfield_2maxstars] of Word;
                           speed : Array[0..starfield_2maxstars] of Byte;
                           starcolor: byte;
                           i,velocity: Word;
                         end;

     {$ENDIF}

     {$IFDEF yeswantlzss_stuff}

     lzssrecord = record
                    infile,outfile: file;
                  end;

     {$ENDIF}

     {$IFDEF yeswantpalcycle}

     cyclepal_PaletteType = Record
       red                        : Byte;
       green                      : Byte;
       blue                       : Byte;
     End;

     cyclepalrecord = record
       aa1                         : Word;
       aa5                         : Byte;
     end;

     {$ENDIF}

     fadepalrecord = record
                       preservedpal: array[1..768] of byte;
                     end;

dummy = array[0..0] of shortint; {Otherwise, unit will not compile if you
                                  select in the defines that both the
                                  starfields should be off. Somebody, anybody
                                  please tell me WHY!}

function sgraph_fileexists(ppalfile: string): boolean;
procedure sgraph_init;
procedure sgraph_close;
procedure sgraph_inithidscr;
procedure sgraph_closehidscr;
procedure sgraph_initmastscr;
procedure sgraph_closemastscr;
procedure sgraph_loadpal(ppalfile: string);
procedure sgraph_setpal(ppalp: pointer);
procedure sgraph_getoldpal;
procedure sgraph_closepal;
procedure sgraph_loadpicture(ppicfile: string; pwhere: byte;
                               palload: boolean);
procedure sgraph_savepicture(ppicfile: string; pwhere: byte);
procedure sgraph_copyscr(pfrom,pto: byte);
procedure sgraph_clearscr(pscr: byte);
function sgraph_testsnaptsrloaded: boolean;
procedure sgraph_getsnaptsrscreen(pgettowhere: byte; ppalload: boolean;
                                    psnapver: byte);
procedure sgraph_makepalglobalpal(ppalp: pointer);
procedure sgraph_filledevensizerect(px1,py1,px2,py2: word;
                                    pcolor: byte);
procedure sgraph_capturesprite(px1,py1,px2,py2: word;
                               psprdataarridx: byte);
procedure sgraph_displaysprite(px1,py1: word; psprdataarridx: byte);
procedure sgraph_savesprites(pcsffile: string;
                             pstartsprite,pendsprite: byte);
procedure sgraph_releasesprites(pstartsprite,pendsprite: byte);
procedure sgraph_loadsprites(pcsffile: string);
procedure sgraph_placesprite(px1,py1: word; psprdataarridx: byte);
procedure sgraph_viewsprite(px1,py1: word; psprdataarridx: byte);
procedure sgraph_erasesprite(px1,py1: word; psprdataarridx: byte);

{$IFDEF yeswantstarfield_1}
procedure sgraph_initstarfield_1(pstarscolor: byte; pstarformvalue: word);
procedure sgraph_advancestarfield_1(px,py,pspeed,pholesize,pfieldsize: word);
{$ENDIF}

{$IFDEF yeswanttextfade}
procedure sgraph_inittextfade;
procedure sgraph_textfadedown(pfadedelay: word);
procedure sgraph_textfadeup(pfadedelay: word);
{$ENDIF}

procedure sgraph_cursoroff;
procedure sgraph_cursoron;

{$IFDEF yeswantstarfield_2}
procedure sgraph_initstarfield_2(pallvelocity: word;
                                   pbackgroundstarcolor: byte;
                                     pforegroundspeed,
                                     pstarcolor,poutputpage: byte);
procedure sgraph_advancestarfield_2left;
procedure sgraph_advancestarfield_2right;
procedure sgraph_advancestarfield_2lefthid;
procedure sgraph_advancestarfield_2righthid;
{$ENDIF}

function sgraph_testkeys: boolean;
procedure sgraph_waitvrt;

{$IFDEF yeswantlzss_stuff}
procedure sgraph_lzssinit;
procedure sgraph_lzssdone;
procedure sgraph_lzssfiletofiledecomp(pinfile,poutfile: string);
{$ENDIF}

{$IFDEF yeswantpalcycle}
procedure sgraph_initcyclepalette;
procedure sgraph_CyclePalette(lowcolor,topcolor,times,upordown: Byte);
{$ENDIF}

procedure sgraph_initpalfade;
procedure sgraph_graphpalfadecomplete(pdelay: word; pfadetimes: byte);
procedure sgraph_graphpalfadesome(pstart,pend: byte;
                                    pdelay: word; pfadetimes: byte);

var hidscrp,palp,oldpalp,mastscrp: pointer;
    hidscrseg,hidscrofs,mastscrseg,mastscrofs,palpseg,palpofs: word;
    sprdataarr: array[0..255] of pointer;
    sprdataarridx: byte;
    csffile: file;
    letter: char;
    testkeypressed: boolean;
    fadepalrec: fadepalrecord;

    {$IFDEF yeswantstarfield_1}
    starfield_1rec: starfield_1record;
    {$ENDIF}

    {$IFDEF yeswanttextfade}
    textfaderec: textfaderecord;
    {$ENDIF}

    {$IFDEF yeswantstarfield_2}
    starfield_2rec: starfield_2record;
    {$ENDIF}

    {$IFDEF yeswantlzss_stuff}
    lzssrec: lzssrecord;
    {$ENDIF}

    {$IFDEF yeswantpalcycle}
    cyclepalrec: cyclepalrecord;
    cyclepal_rgb: cyclepal_PaletteType;
    cyclepal_pal: Array [0..255] of cyclepal_PaletteType;
    {$ENDIF}

IMPLEMENTATION

const version = '1.0';

function sgraph_fileexists(ppalfile: string): boolean;
var dirinfo: searchrec;
begin
  findfirst(ppalfile,anyfile,dirinfo);
  if doserror = 0 then sgraph_fileexists:= true else
    sgraph_fileexists:= false;
end;

procedure sgraph_init;
var card,mode: integer;
    clearloop: word;
begin
  card:= installuserdriver('VGA256',nil);
  initgraph(card,mode,'');
  sgraph_getoldpal;
  for clearloop:= 0 to 255 do
  begin
    sprdataarr[clearloop]:= nil;
  end;
  hidscrp:= nil;
  mastscrp:= nil;

  sprdataarridx:= 0;

  {$IFDEF yeswantmousestuff}
  initmouse;
  {$ENDIF}
end;

procedure sgraph_close;
begin
  sgraph_closehidscr;
  sgraph_closemastscr;
  sgraph_closepal;
  closegraph;
  writeln('This program used the unit SGraph version 1.0 by Stfan Viljoen');
  writeln('SGraph is a public domain TP6 unit for doing graphics animation & other');
  writeln('interesting stuff. Read the doc file SGraph.doc for more info.');
  writeln;
  writeln('Fanx to Brendan Beaman, Daniel Schlenzig, Reynir Stefansson, Douglas Webb,');
  writeln('Andy Tam, Andrew Eigus (Mr. Byte), SWAG, Ross Neilson Wentworth.');
  writeln;
  writeln('Contact me on internet: 9128476@pukrs3.puk.ac.za for snarfs, ideas, code etc...');
  Writeln('Read the file sgraph.doc!');
  writeln('Bye! ;)');
end;

procedure sgraph_inithidscr;
begin
  if memavail >= 64000 then
  begin
    getmem(hidscrp,64000);
    hidscrseg:= seg(hidscrp^);
    hidscrofs:= ofs(hidscrp^);
    sgraph_clearscr(hidscr);
  end
  else
  begin
    closegraph;
    writeln('Error: not enough memory to allocate a 64k hidden screen.');
    halt;
  end;
end;

procedure sgraph_closehidscr;
begin
  if hidscrp <> nil then
  begin
    freemem(hidscrp,64000);
    hidscrp:= nil;
  end;
end;

procedure sgraph_initmastscr;
begin
  if memavail >= 64000 then
  begin
    getmem(mastscrp,64000);
    mastscrseg:= seg(mastscrp^);
    mastscrofs:= ofs(mastscrp^);
    sgraph_clearscr(mastscr);
  end
  else
  begin
    closegraph;
    writeln('Error: not enough memory to allocate a 64k master screen.');
    halt;
  end;
end;

procedure sgraph_closemastscr;
begin
  if mastscrp <> nil then
  begin
    freemem(mastscrp,64000);
    mastscrp:= nil;
  end;
end;

procedure sgraph_loadpal(ppalfile: string);
var f: file;
begin
  if palp = nil then
  begin
    getmem(palp,768);
    palpseg:= seg(palp^);
    palpofs:= ofs(palp^);
  end;
  if sgraph_fileexists(ppalfile) then
  begin
    assign(f,ppalfile);
    reset(f,1);
    blockread(f,palp^,768);
    close(f);
  end
  else
  begin
    closegraph;
    writeln('Error: palette file ',ppalfile,' not found.');
    halt;
  end;
end;

procedure sgraph_setpal(ppalp: pointer);
Var ESReg,DXReg: Word;
Begin
 ESReg:= Seg(pPalP^);
 DXReg:= Ofs(pPalP^);
 Asm
  Mov  AH,10h
  Mov  AL,12h
  Mov  ES,ESReg
  Mov  DX,DXReg
  Mov  BX,0
  Mov  CX,255
  Int  10h
 End;
end;

procedure sgraph_getoldpal;
var esreg,dxreg: word;
begin
  if oldpalp = nil then getmem(oldpalp,768);
  esreg:= seg(oldpalp^);
  dxreg:= ofs(oldpalp^);
  asm
    Mov  ES,ESReg
    Mov  DX,DXReg
    Mov  BX,0
    Mov  CX,256
    Mov  AL,17h
    Mov  AH,10h
    Int  10h
  end;
end;

procedure sgraph_closepal;
begin
  if palp <> nil then
  begin
    freemem(palp,768);
    palp:= nil;
    palpseg:= 0;
    palpofs:= 0;
  end;
end;

procedure sgraph_loadpicture(ppicfile: string; pwhere: byte;
                               palload: boolean);
var f: file;
begin
  if sgraph_fileexists(ppicfile) then
  begin
    assign(f,ppicfile);
    reset(f,1);
    if palload = yespalload then
    begin
      if palp = nil then getmem(palp,768);
      blockread(f,palp^,768);
      sgraph_setpal(palp);
    end
    else
    begin
      seek(f,768);
    end;
    if pwhere = hidscr then
    begin
      if hidscrp = nil then sgraph_inithidscr;
      blockread(f,hidscrp^,64000);
    end
    else
    begin
      blockread(f,mem[$0a000:$00000],64000);
    end;
    close(f);
  end
  else
  begin
    closegraph;
    writeln('Error: picture file ',ppicfile,' not found.');
    halt;
  end;
end;

procedure sgraph_savepicture(ppicfile: string; pwhere: byte);
var f: file;
begin
  assign(f,ppicfile);
  rewrite(f,1);
  blockwrite(f,palp^,768);
  if pwhere = hidscr then blockwrite(f,hidscrp^,64000) else
    blockwrite(f,mem[$0a000:$00000],64000);
  close(f);
end;

procedure sgraph_copyscr(pfrom,pto: byte);
var esreg,direg,dsreg,sireg: word;
begin
  if ((pfrom = hidscr) and (pto = visscr)) then
  begin
    dsreg:= hidscrseg;
    sireg:= hidscrofs;
    esreg:= $0a000;
    direg:= 0;
  end
  else
  if ((pfrom = visscr) and (pto = hidscr)) then
  begin
    dsreg:= $0a000;
    sireg:= 0;
    esreg:= hidscrseg;
    direg:= hidscrofs;
  end;
  if ((pfrom = hidscr) and (pto = mastscr)) then
  begin
    dsreg:= hidscrseg;
    sireg:= hidscrofs;
    esreg:= mastscrseg;
    direg:= mastscrofs;
  end
  else
  if ((pfrom = mastscr) and (pto = hidscr)) then
  begin
    dsreg:= mastscrseg;
    sireg:= mastscrofs;
    esreg:= hidscrseg;
    direg:= hidscrofs;
  end;
  asm
    cli
    push ds
    mov  ds,dsreg
    mov  si,sireg
    mov  ax,esreg
    mov  es,ax
    mov  di,direg
    mov  cx,16000
    cld
    db $F3 {Rep movsd, fastest way to move double words}
    db $66
    db $A5
    pop  ds
    sti
  end;
end;

procedure sgraph_clearscr(pscr: byte);
var startseg,startoffset: word;
begin
  if pscr = visscr then
  begin
    startseg:= $0A000;
    startoffset:= 0;
  end;
  if pscr = hidscr then
  begin
    startseg:= hidscrseg;
    startoffset:= hidscrofs;
  end;
  if pscr = mastscr then
  begin
    startseg:= mastscrseg;
    startoffset:= mastscrofs;
  end;
  asm
    mov bx,startseg
    mov es,bx
    mov di,startoffset
    mov cx,16000
    cld
    cli

    db $66 {Mov eax,0}
    db $b8
    db $00
    db $00
    db $00
    db $00

    db $F3 {Rep stosd}
    db $66
    db $AB

    sti
  end;
end;

function sgraph_testsnaptsrloaded: boolean;
begin
  if sgraph_fileexists('snap*.emm') then sgraph_testsnaptsrloaded:= yes else
    sgraph_testsnaptsrloaded:= no;
end;

procedure sgraph_getsnaptsrscreen(pgettowhere: byte; ppalload: boolean;
                                    psnapver: byte);
var f: file of word;
    emmhand,pageseg,scrindex,pagenumb,destpseg,destpofs: word;
    snapver: string;
    temppalp: pointer;
label stop,ok;
begin
  if sgraph_testsnaptsrloaded = yes then
  begin
    str(psnapver,snapver);
    assign(f,'snap' + snapver + '.emm');
    reset(f);
    read(f,emmhand);
    read(f,pageseg);
    close(f);
    if ppalload = yespalload then
    begin
      getintvec($60,temppalp);
      sgraph_setpal(temppalp);
      sgraph_makepalglobalpal(temppalp);
    end;
    if pgettowhere = hidscr then
    begin
      if hidscrp = nil then sgraph_inithidscr;
      destpseg:= seg(hidscrp^);
      destpofs:= ofs(hidscrp^);
    end
    else
    begin
      destpseg:= $0a000;
      destpofs:= 0;
    end;
    asm
      Mov  ScrIndex,0
      Mov  PageNumb,0
      Mov  DX,EMMHand
      Cld
      @Loop1:
      Mov  AH,44h
      Mov  AL,0
      Mov  BX,PageNumb
      Int  67h
      Or   AH,AH
      Jnz  Stop
      Mov  CX,3FFFh
      Sub  SI,SI
      Mov  BX,ScrIndex
      @Loop2:
      Mov  ES,PageSeg
      Mov  AL,BYTE PTR ES:[SI]
      Mov  ES,destPSeg
      Mov  BYTE PTR ES:[BX],AL
      Inc  BX
      Inc  SI
      Loop @Loop2
      Mov  ScrIndex,BX
      Inc  PageNumb
      Cmp  PageNumb,4
      Jb   @Loop1
      Jmp  Ok
    end;
    stop:
    closegraph;
    writeln('Error: unable to obtain tsr screen from snap tsr. Check whether a snap tsr');
    writeln('is loaded, and if the snap*.emm file is in the current directory.');
    halt;
    ok:
  end
  else
  begin
    closegraph;
    writeln('Error: snap*.emm file not found in current directory. This means that the snap');
    writeln('tsr is not loaded, or the snap*.emm file is not available in the cur dir.');
    halt;
  end;
end;

procedure sgraph_makepalglobalpal(ppalp: pointer);
begin
  if palp = nil then getmem(palp,768);
  move(ppalp^,palp^,768);
end;

procedure sgraph_filledevensizerect(px1,py1,px2,py2: word;
                                    pcolor: byte); assembler;
asm
  mov  ax,0a000h
  mov  es,ax
  mov  ax,px1
  mov  di,py1
  Shl  di,6
  Mov  CX,di
  Shl  di,2
  Add  di,CX
  Add  di,AX {di = correct screen addr for x and y}
  mov  bx,px2
  sub  bx,ax
  shr  bx,1
  mov  dx,py2
  sub  dx,py1
  mov  cx,dx
  mov  ax,0
 @vertloop:
  push cx
  mov  cx,bx
  rep  stosw
  add  di,320
  sub  di,bx
  sub  di,bx
  pop  cx
  loop @vertloop
end;

procedure sgraph_capturesprite(px1,py1,px2,py2: word;
                               psprdataarridx: byte);
var sprseg,sprofs,xsize,ysize,sprsize,origscrofs,numwritten,
    origsprofs,stripdataofs,oldsprsize,ministripaddr,ministriploop,
    ministripnum: word;
    ministripflag,xstripflag: byte;
    tempsprp: pointer;
begin
  xsize:= px2 - px1;
  ysize:= py2 - py1;
  sprsize:= 2 * ((xsize * ysize) + (7 * ysize) + 11);
 {7 bytes of strip formatting data with each line, 11 bytes of x, y and size
  data and ministrip data, 2 * to account for ministrips,
  (ministrips: strips of colour after spaces of black in a sprite}
  oldsprsize:= sprsize;
  getmem(tempsprp,sprsize);
  sprseg:= seg(tempsprp^);
  sprofs:= ofs(tempsprp^);
  origsprofs:= sprofs;
  numwritten:= 0;
  ministripnum:= 0;
  {format of sprite data:
   type  length  purpose
   word  1       total storage size (pixels plus strip format info)
   word  1       x dimensions in pixels
   word  1       y dimensions in pixels
   word  1       number of ministrips
   byte  1       sprite x strip type, see "pixel strip type" below
  -pixel description data format from here on-
   word  1       starting offset relative to upper left screen corner of
                 this pixel strip
   word  1       pixel strip run length
   word  1       skip offset (this is used to make the sprite able to
                 scroll off the screen
   byte  1       pixel strip type
                 values: 0: pixel strip fits into movsw
                         1: pixel strip fits into movsb (one byte strip)
                         2: pixel strip fits into movsw and one movsb
                         3: pixel strip fits into movsd
                         4: pixel strip fits into movsd and one movsb
                         5: pixel strip fits into movsd and one movsw
                         6: pixel strip fits into movsd, 1 movsw and 1 movsb
                       255: pixel strip has no color pixels in it
   bytes x * y   describes the sprite by way of vga color lookup table
                 numbers, includes skip offsets, pixel strip type data
                 and run length data in the format described above}
  asm
    push ds
{-Set up data pointers & regs starts---------------------------------------}
    mov  ds,sprseg           {Set up sprite data pointer registers}
    mov  si,sprofs
    add  si,2                {Skip total storage size}
    mov  ax,xsize
    mov  word ptr ds:[si],ax {Store x and y sizes of sprite}
    add  si,2
    mov  ax,ysize
    mov  word ptr ds:[si],ax
    add  si,4    {Go to x strip type byte}
    mov  xstripflag,1
    mov  ax,xsize
    jmp  @detlength
   @donexdet:
    add  si,1    {Go to starting offset}

{-Set up data pointers & regs ends-----------------------------------------}
    mov  ax,0A000h           {Get starting offset into video ram}
    mov  es,ax
    mov  ax,px1
    mov  bx,py1
    shl  bx,6
    mov  cx,bx
    shl  bx,2
    add  bx,cx
    add  bx,ax
    mov  di,bx
    mov  origscrofs,bx
    mov  cx,ysize
   @yloop:
    push cx
    mov  cx,xsize
   @resetforministrip:
    xor  dh,dh
    mov  stripdataofs,si
    cmp  ministripflag,1
    jne  @xloop
    mov  ministripflag,dh
    mov  cx,ministriploop
    mov  di,ministripaddr
   @xloop:                   {Scan until a color pixel is found, i. e. the}
    mov  dl,byte ptr es:[di] {first pixel that is non-black in this strip}
    cmp  dl,0
    jne  @foundcolorpixel
   {Handle black spaces to prevent sprite "collapse"}
    cmp  dh,0
    je   @startnotyetnoted

    push cx
    push di
   @tstloop:
    mov  dl,byte ptr es:[di]
    cmp  dl,0
    je   @loopend
    mov  ministripflag,1
    mov  ministriploop,cx
    mov  cx,1
   @loopend:
    inc  di
    loop @tstloop
    dec  di
    mov  ministripaddr,di
    pop  di
    pop  cx
    cmp  ministripflag,1
    jne  @noministrip
    jmp  @handleministrip
   @noministrip:

   @startnotyetnoted:
    inc  di
    jmp  @endxloop
   @foundcolorpixel:         {Record the color pixel's spr rel addr}
    cmp  dh,1                {Has start been noted? DH = 0 no DH = 1 yes}
    je   @startnoted
    mov  ax,origscrofs
    mov  bx,di               {DI = curscreenaddr}
    sub  di,ax
    mov  word ptr ds:[si],di {Store sprite relative strip start addr}
    mov  di,bx
    mov  dh,1                {Indicate that the start of the strip is noted}
    add  si,7                {Skip start addr, run length, skip offset and
                              strip type}
   @startnoted:
    mov  byte ptr ds:[si],dl {Store the colour of the byte}
    inc  si                  {Go to next sprite data byte}
    inc  di                  {Go to next color byte on screen}
    inc  numwritten          {Note how many COLOR bytes are being written}
   @endxloop:
    loop @xloop
    jmp  @noministriptohandle
   @handleministrip:
    inc  ministripnum
   @noministriptohandle:
    push si
    mov  si,stripdataofs
    add  si,2                {Go to run length}
    mov  ax,numwritten
    mov  word ptr ds:[si],ax
    add  si,2
    mov  word ptr ds:[si],0  {No skip offset as yet}
    add  si,2                {Go to strip type byte}
   @detlength:
    cmp  ax,0
    je   @setzerobytelength
    cmp  ax,3
    ja   @tstlength
    je   @set3bytelength
    cmp  ax,2
    je   @setwordlength
    mov  byte ptr ds:[si],1 {Indicate a one byte strip}
    jmp  @endlengthtst
   @setzerobytelength:
    mov  byte ptr ds:[si],255  {Say this is a black strip}
    mov  word ptr ds:[si-6],bx {Store black strip start addr}
    pop  si
    add  si,7                  {Go to address for next strip}
    push si
    jmp  @endlengthtst
   @set3bytelength:
    mov  byte ptr ds:[si],2
    jmp  @endlengthtst
   @setwordlength:
    mov  byte ptr ds:[si],0
    jmp  @endlengthtst
   @tstlength:
    pusha
    mov  cx,ax
    xor  dx,dx
    mov  bx,4
    div  bx
    cmp  dx,0
    je   @setmovsd
    mov  ax,cx
    sub  ax,1
    xor  dx,dx
    mov  bx,4
    div  bx
    cmp  dx,0
    je   @setmovsdmovsb
    mov  ax,cx
    sub  ax,2
    xor  dx,dx
    mov  bx,4
    div  bx
    cmp  dx,0
    je   @setmovsdmovsw
    mov  ax,cx
    sub  ax,3
    xor  dx,dx
    mov  bx,4
    div  bx
    cmp  dx,0
    je   @setmovsdmovswmovsb
   @setmovsd:
    mov  byte ptr ds:[si],3
    cmp  xstripflag,0
    je   @noxflag
    mov  word ptr ds:[si-6],ax
    popa
    jmp  @endlengthtst
   @noxflag:
    mov  word ptr ds:[si-4],ax {Run length divided by 4 for movsd}
    popa
    jmp  @endlengthtst
   @setmovsdmovsb:
    mov  byte ptr ds:[si],4
    cmp  xstripflag,0
    je   @noxflag2
    mov  word ptr ds:[si-6],ax
    popa
    jmp  @endlengthtst
   @noxflag2:
    mov  word ptr ds:[si-4],ax
    popa
    jmp  @endlengthtst
   @setmovsdmovsw:
    mov  byte ptr ds:[si],5
    cmp  xstripflag,0
    je   @noxflag3
    mov  word ptr ds:[si-6],ax
    popa
    jmp  @endlengthtst
   @noxflag3:
    mov  word ptr ds:[si-4],ax
    popa
    jmp  @endlengthtst
   @setmovsdmovswmovsb:
    mov  byte ptr ds:[si],6
    cmp  xstripflag,0
    je   @noxflag4
    mov  word ptr ds:[si-6],ax
    popa
    jmp  @endlengthtst
   @noxflag4:
    mov  word ptr ds:[si-4],ax
    popa
    jmp  @endlengthtst
   @endlengthtst:
    cmp  xstripflag,1
    jne  @noxflag5
    mov  xstripflag,0
    jmp  @donexdet
   @noxflag5:
    pop  si                    {Go to offset for next strip}
    xor  ax,ax
    mov  numwritten,ax

    cmp  ministripflag,1
    je   @resetforministrip

    add  di,320
    sub  di,xsize
    pop  cx
    dec  cx
    cmp  cx,0
    jne  @yloop
   {Store the actual size of the sprite}
    mov  bx,si
    mov  ds,sprseg
    mov  si,sprofs
    mov  word ptr ds:[si],bx
    mov  sprsize,bx
    add  si,6
    mov  bx,ministripnum
    mov  word ptr ds:[si],bx {Store the number of ministrips}

   @stop:
    pop  ds
  end;
  getmem(sprdataarr[psprdataarridx],sprsize);
  move(mem[seg(tempsprp^):ofs(tempsprp^)],
    mem[seg(sprdataarr[psprdataarridx]^):ofs(sprdataarr[psprdataarridx]^)],
      sprsize);
  freemem(tempsprp,oldsprsize);
end;

procedure sgraph_displaysprite(px1,py1: word; psprdataarridx: byte);
var sprseg,sprofs,origscrofs: word;
begin
  sprseg:= seg(sprdataarr[psprdataarridx]^);
  sprofs:= ofs(sprdataarr[psprdataarridx]^);
  asm
    push ds
{-Set up data pointers & regs starts---------------------------------------}
    cld
    cli
    mov  ds,sprseg
    mov  si,sprofs
    add  si,4                {Go to y size}
    mov  ax,0A000h           {Get starting offset into video ram}
    mov  es,ax
    mov  ax,px1
    mov  di,py1
    shl  di,6
    mov  cx,di
    shl  di,2
    add  di,cx
    add  di,ax
    mov  origscrofs,di
{-Set up data pointers & regs ends-----------------------------------------}
{-Y display loop starts----------------------------------------------------}
    mov  cx,word ptr ds:[si] {Loop for y size times}
    add  si,2                {Add number of ministrips}
    add  cx,word ptr ds:[si]
    add  si,3                {Go to starting offset}
   @yloop:
    push cx
    mov  di,word ptr ds:[si]
    add  di,origscrofs
    add  si,2                {Go to run length}
    mov  cx,word ptr ds:[si] {Get run length}
    add  si,4                {Skip skip offset go to strip type byte}
    mov  dh,byte ptr ds:[si]
            {dh values: 0: pixel strip fits into 1 movsw
                        1: pixel strip fits into 1 movsb (one byte strip)
                        2: pixel strip fits into 1 movsw and one movsb
                        3: pixel strip fits into movsd
                        4: pixel strip fits into movsd and one movsb
                        5: pixel strip fits into movsd and one movsw
                        6: pixel strip fits into movsd, 1 movsw and 1 movsb}
    inc  si
    cmp  dh,255            {Skip black strips in sprites}
    je   @donedisplaying
    cmp  dh,0
    jne  @testmovsb
    movsw
    jmp  @donedisplaying
   @testmovsb:
    cmp  dh,1
    jne  @testmovswmovsb
    movsb
    jmp  @donedisplaying
   @testmovswmovsb:
    cmp  dh,2
    jne  @testmovsd
    movsw
    movsb
    jmp  @donedisplaying
   @testmovsd:
    cmp  dh,3
    jne  @testmovsdmovsb
    db   $F3 {Rep movsd}
    db   $66
    db   $A5
    jmp  @donedisplaying
   @testmovsdmovsb:
    cmp  dh,4
    jne  @testmovsdmovsw
    db   $F3
    db   $66
    db   $A5
    movsb
    jmp  @donedisplaying
   @testmovsdmovsw:
    cmp  dh,5
    jne  @domovsdmovswmovsb
    db   $F3
    db   $66
    db   $A5
    movsw
    jmp  @donedisplaying
   @domovsdmovswmovsb:
    db   $F3
    db   $66
    db   $A5
    movsw
    movsb
   @donedisplaying:
    pop  cx
    dec  cx
    cmp  cx,0
    jne  @yloop
{-Y display loop ends------------------------------------------------------}
    sti
    pop  ds
  end;
end;

procedure sgraph_savesprites(pcsffile: string;
                             pstartsprite,pendsprite: byte);
var filetotalsprites,spriteloop: byte;
    totalsprites: integer;
begin
  if ((pendsprite = 1) and (pstartsprite = 1)) then totalsprites:= 1 else
  totalsprites:= pendsprite - pstartsprite + 1;
  if (totalsprites < 0) or (totalsprites > 255) or (totalsprites = 0) then
  begin
    closegraph;
    writeln('Error: Invalid number of sprites in savesprite procedure. Check params.');
    writeln('pendsprite - pstartsprite must be greater than 0, smaller than 255 and not');
    writeln('equal to zero.');
    halt;
  end; 
  assign(csffile,pcsffile);
  if sgraph_fileexists(pcsffile) then
  begin
    reset(csffile,1);
    blockread(csffile,filetotalsprites,sizeof(filetotalsprites));
    filetotalsprites:= filetotalsprites + totalsprites;
    seek(csffile,0);
    blockwrite(csffile,filetotalsprites,sizeof(filetotalsprites));
    seek(csffile,filesize(csffile));
  end
  else
  begin
    rewrite(csffile,1);
    filetotalsprites:= totalsprites;
    blockwrite(csffile,filetotalsprites,sizeof(filetotalsprites));
  end;
  for spriteloop:= pstartsprite to pendsprite do
  begin
    blockwrite(csffile,sprdataarr[spriteloop-1]^,
      memw[seg(sprdataarr[spriteloop-1]^):
        ofs(sprdataarr[spriteloop-1]^)]);
  end;
  close(csffile);
end;

procedure sgraph_releasesprites(pstartsprite,pendsprite: byte);
var spriteloop: byte;
begin
  for spriteloop:= pstartsprite to pendsprite do
  begin
    freemem(sprdataarr[spriteloop-1],
      memw[seg(sprdataarr[spriteloop-1]^):
        ofs(sprdataarr[spriteloop-1]^)]);
    dec(sprdataarridx);
  end;
end;

procedure sgraph_loadsprites(pcsffile: string);
var numsprites,spriteloop: byte;
    memtoalloc: word;
begin
  assign(csffile,pcsffile);
  reset(csffile,1);
  blockread(csffile,numsprites,sizeof(numsprites));
  for spriteloop:= 0 to numsprites - 1 do
  begin
    blockread(csffile,memtoalloc,sizeof(memtoalloc));
    getmem(sprdataarr[sprdataarridx],memtoalloc);
    seek(csffile,filepos(csffile) - 2);
    blockread(csffile,sprdataarr[sprdataarridx]^,memtoalloc);
    inc(sprdataarridx);
  end;
  close(csffile);
end;

procedure sgraph_placesprite(px1,py1: word; psprdataarridx: byte);
var sprseg,sprofs,origscrofs,scrseg,xsize,ysize,stripdataofs: word;
begin
  sprseg:= seg(sprdataarr[psprdataarridx]^);
  sprofs:= ofs(sprdataarr[psprdataarridx]^);
  scrseg:= hidscrseg;
  asm
    push ds
    cld
    cli
    mov  ds,sprseg
    mov  si,sprofs
    add  si,2
    mov  ax,word ptr ds:[si]
    mov  xsize,ax
    add  si,2
    mov  ax,scrseg
    mov  es,ax
    mov  ax,px1
    mov  bx,py1
    shl  bx,6
    mov  cx,bx
    shl  bx,2
    add  bx,cx
    add  bx,ax
    mov  di,bx
    mov  ax,di {ax = origscrofs}
    mov  origscrofs,ax
    mov  cx,word ptr ds:[si] {ds:si y loop value}
    add  si,2
    add  cx,word ptr ds:[si] {ministrip loop compensation}
    mov  bx,cx  {Store yloop to bx}
    mov  ysize,bx
    add  si,3
   @yloop:
    push cx
    mov  di,word ptr ds:[si] {di = strip starting offset}
    add  di,ax {ax = origscrofs}
    add  si,2
    mov  cx,word ptr ds:[si] {ds:si = pixel strip run length}
    add  si,4
    mov  dh,byte ptr ds:[si] {ds:si = pixel strip type}
    inc  si                  {ds:si = pixel strip data}
    cmp  dh,255            {Skip black strips in sprites}
    je   @donedisplaying
    cmp  dh,0
    jne  @testmovsb
    movsw
    jmp  @donedisplaying
   @testmovsb:
    cmp  dh,1
    jne  @testmovswmovsb
    movsb
    jmp  @donedisplaying
   @testmovswmovsb:
    cmp  dh,2
    jne  @testmovsd
    movsw
    movsb
    jmp  @donedisplaying
   @testmovsd:
    cmp  dh,3
    jne  @testmovsdmovsb
    db   $F3 {Rep movsd}
    db   $66
    db   $A5
    jmp  @donedisplaying
   @testmovsdmovsb:
    cmp  dh,4
    jne  @testmovsdmovsw
    db   $F3
    db   $66
    db   $A5
    movsb
    jmp  @donedisplaying
   @testmovsdmovsw:
    cmp  dh,5
    jne  @domovsdmovswmovsb
    db   $F3
    db   $66
    db   $A5
    movsw
    jmp  @donedisplaying
   @domovsdmovswmovsb:
    db   $F3
    db   $66
    db   $A5
    movsw
    movsb
   @donedisplaying:
    pop  cx
    dec  cx
    cmp  cx,0
    jne  @yloop
    sti
    pop  ds
  end;
end;

procedure sgraph_viewsprite(px1,py1: word; psprdataarridx: byte);
var hidscrsegm,hidscroffset,sprseg,sprofs: word;
begin
  hidscrsegm:= hidscrseg;
  hidscroffset:= hidscrofs;
  sprseg:= seg(sprdataarr[psprdataarridx]^);
  sprofs:= ofs(sprdataarr[psprdataarridx]^);
  asm
    push ds
    cld
    cli
    push 0a000h
    pop  es
    mov  ax,px1
    mov  bx,py1
    shl  bx,6
    mov  cx,bx
    shl  bx,2
    add  bx,cx
    add  bx,ax {DI = screen addr of left upper corner}
    sub  bx,321 {Display block always one pixel line larger than sprite}
    mov  di,bx
    mov  ds,sprseg
    mov  si,sprofs
    add  si,2  {Go to x display size of sprite}
    mov  cx,word ptr ds:[si]
    mov  ax,cx {Store xsize to ax also}
    add  si,2  {Go to y display size of sprite}
    mov  bx,word ptr ds:[si]
    add  si,4  {Go to x strip type byte}
    mov  dh,byte ptr ds:[si]
    mov  si,di          {Setup regs for movs operations between "pages"}
    mov  ds,hidscrsegm
    add  si,hidscroffset
    cmp  dh,0
    jne  @testmovsb
    add  bx,2
   @yloop:
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    add  di,318
    sub  di,2
    mov  si,di
    dec  bx
    cmp  bx,0
    jne  @yloop
    jmp  @donedisplaying
   @testmovsb:
    cmp  dh,1
    jne  @testmovswmovsb
    add  bx,2 {One line below sprite and above it must also be copied}
   @yloop2:
    movsw {Display block always one pixel line larger than sprite}
    movsb
    add  di,319
    sub  di,1
    mov  si,di
    dec  bx
    cmp  bx,0
    jne  @yloop2
    jmp  @donedisplaying
   @testmovswmovsb:
    cmp  dh,2
    jne  @testmovsd
    add  bx,2
   @yloop3:
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    movsb
    add  di,318
    sub  di,3
    mov  si,di
    dec  bx
    cmp  bx,0
    jne  @yloop3
    jmp  @donedisplaying
   @testmovsd:
    cmp  dh,3
    jne  @testmovsdmovsb
    add  bx,2
   @yloop4:
    mov  cx,ax
    db   $F3 {Rep movsd}
    db   $66
    db   $A5
    movsw {Display block always one pixel line larger than sprite}
    add  di,318
    mov  cx,ax
    shl  ax,2 {mul cx by 4}
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop4
    jmp  @donedisplaying
   @testmovsdmovsb:
    cmp  dh,4
    jne  @testmovsdmovsw
    add  bx,2
   @yloop5:
    mov  cx,ax
    db   $F3
    db   $66
    db   $A5
    movsw {Display block always one pixel line larger than sprite}
    movsb
    add  di,318
    mov  cx,ax
    shl  ax,2
    add  ax,1
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop5
    jmp  @donedisplaying
   @testmovsdmovsw:
    cmp  dh,5
    jne  @domovsdmovswmovsb
    add  bx,2
   @yloop6:
    mov  cx,ax
    db   $F3
    db   $66
    db   $A5
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    add  di,318
    mov  cx,ax
    shl  ax,2
    add  ax,2
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop6
    jmp  @donedisplaying
   @domovsdmovswmovsb:
    add  bx,2
   @yloop7:
    mov  cx,ax
    db   $F3 {rep movsd}
    db   $66
    db   $A5
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    movsb
    add  di,318
    mov  cx,ax
    shl  ax,2
    add  ax,3
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop7
   @donedisplaying:
    sti
    pop  ds
  end;
end;

procedure sgraph_erasesprite(px1,py1: word; psprdataarridx: byte);
var hidscrsegm,hidscrofsm,mastscrsegm,mastscroffset,sprseg,sprofs: word;
begin
  mastscrsegm:= mastscrseg;
  mastscroffset:= mastscrofs;
  hidscrsegm:= hidscrseg;
  hidscrofsm:= hidscrofs;
  sprseg:= seg(sprdataarr[psprdataarridx]^);
  sprofs:= ofs(sprdataarr[psprdataarridx]^);
  asm
    push ds
    cld
    cli
    mov  ax,hidscrsegm
    mov  es,ax
    mov  ax,px1
    mov  bx,py1
    shl  bx,6
    mov  cx,bx
    shl  bx,2
    add  bx,cx
    add  bx,ax {DI = screen addr of left upper corner}
    sub  bx,321 {Display block always one pixel line larger than sprite}
    mov  di,bx
    mov  ds,sprseg
    mov  si,sprofs
    add  si,2  {Go to x display size of sprite}
    mov  cx,word ptr ds:[si]
    mov  ax,cx {Store xsize to ax also}
    add  si,2  {Go to y display size of sprite}
    mov  bx,word ptr ds:[si]
    add  si,4  {Go to x strip type byte}
    mov  dh,byte ptr ds:[si]
    mov  si,di          {Setup regs for movs operations between "pages"}
    mov  ds,mastscrsegm
    add  si,mastscroffset
    cmp  dh,0
    jne  @testmovsb
    add  bx,2
   @yloop:
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    add  di,318
    sub  di,2
    mov  si,di
    dec  bx
    cmp  bx,0
    jne  @yloop
    jmp  @donedisplaying
   @testmovsb:
    cmp  dh,1
    jne  @testmovswmovsb
    add  bx,2
   @yloop2:
    movsw {Display block always one pixel line larger than sprite}
    movsb
    add  di,319
    sub  di,1
    mov  si,di
    dec  bx
    cmp  bx,0
    jne  @yloop2
    jmp  @donedisplaying
   @testmovswmovsb:
    cmp  dh,2
    jne  @testmovsd
    add  bx,2
   @yloop3:
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    movsb
    add  di,318
    sub  di,3
    mov  si,di
    dec  bx
    cmp  bx,0
    jne  @yloop3
    jmp  @donedisplaying
   @testmovsd:
    cmp  dh,3
    jne  @testmovsdmovsb
    add  bx,2
   @yloop4:
    mov  cx,ax
    db   $F3 {Rep movsd}
    db   $66
    db   $A5
    movsw {Display block always one pixel line larger than sprite}
    add  di,318
    mov  cx,ax
    shl  ax,2 {mul cx by 4}
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop4
    jmp  @donedisplaying
   @testmovsdmovsb:
    cmp  dh,4
    jne  @testmovsdmovsw
    add  bx,2
   @yloop5:
    mov  cx,ax
    db   $F3
    db   $66
    db   $A5
    movsw {Display block always one pixel line larger than sprite}
    movsb
    add  di,318
    mov  cx,ax
    shl  ax,2
    add  ax,1
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop5
    jmp  @donedisplaying
   @testmovsdmovsw:
    cmp  dh,5
    jne  @domovsdmovswmovsb
    add  bx,2
   @yloop6:
    mov  cx,ax
    db   $F3
    db   $66
    db   $A5
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    add  di,318
    mov  cx,ax
    shl  ax,2
    add  ax,2
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop6
    jmp  @donedisplaying
   @domovsdmovswmovsb:
    add  bx,2
   @yloop7:
    mov  cx,ax
    db   $F3 {rep movsd}
    db   $66
    db   $A5
    db   $66 {movsd}
    db   $A5 {Display block always one pixel line larger than sprite}
    movsb
    add  di,318
    mov  cx,ax
    shl  ax,2
    add  ax,3
    sub  di,ax
    mov  si,di
    mov  ax,cx
    dec  bx
    cmp  bx,0
    jne  @yloop7
   @donedisplaying:
    sti
    pop  ds
  end;
end;

{$IFDEF yeswantstarfield_1}

procedure sgraph_initstarfield_1(pstarscolor: byte; pstarformvalue: word);
begin
  with starfield_1rec do
  begin
    randomize;
    for l:= 1 to 20 do rad[l]:= l * pstarformvalue;
    for l:= 1 to 20 do
      for l2:= 1 to 5 do
        p[l, l2]:= random(360);
    starscolor:= pstarscolor;
  end;
end;

procedure sgraph_putstarfield_put(pp,prad: integer; pcol: byte);
begin
  setcolor(pcol);
  with starfield_1rec do
  begin
    arc(x,y,pp,pp+1,prad);
  end;
end;

procedure sgraph_putstarfield(pstarcolor: byte);
begin
  with starfield_1rec do
  begin
    for l:= 1 to 20 do
      for l2:= 1 to 5 do
        sgraph_putstarfield_put(p[l,l2],rad[l],pstarcolor);
  end;
end;

procedure sgraph_delstarfield;
begin
  with starfield_1rec do
  begin
    for l:= 1 to 20 do
      for l2:= 1 to 5 do
        sgraph_putstarfield_put(p[l,l2],rad[l],0);
  end;
end;

procedure sgraph_advancestarfield_1(px,py,pspeed,pholesize,
                                      pfieldsize: word);
begin
  sgraph_delstarfield;
  with starfield_1rec do
  begin
    x:= px;
    y:= py;
    for l:= 1 to 20 do
    begin
      rad[l]:= rad[l] + round(rad[l] / pspeed + 1); {pspeed = starspeed}
      if rad[l] > pfieldsize then rad[l]:= l + pholesize;
    end;
  sgraph_putstarfield(starscolor);
  end;
end;

{$ENDIF}

{$IFDEF yeswanttextfade}

procedure sgraph_textfade_GetCol(pc: byte; Var pr,pg,pb: byte);
begin
  port[textfade_PelAddrRgR] := pc;
  pr := Port[textfade_PelDataReg];
  pg := Port[textfade_PelDataReg];
  pb := Port[textfade_PelDataReg];
end;

procedure sgraph_textfade_setcol(pc,pr,pg,pb: Byte);
begin
  Port[textfade_PelAddrRgW] := pc;
  Port[textfade_PelDataReg] := pr;
  Port[textfade_PelDataReg] := pg;
  Port[textfade_PelDataReg] := pb;
end;

procedure sgraph_textfade_setinten(b: byte);
Var l: integer;
    fr,fg,fb: byte;
begin
  with textfaderec do
  begin
    for l := 0 to 63 do
    begin
      fr:= col[l].r * b div 63;
      fg:= col[l].g * b div 63;
      fb:= col[l].b * b div 63;
      sgraph_textfade_setcol(l,fr,fg,fb);
    end;
  end;
end;

procedure sgraph_inittextfade;
begin
  with textfaderec do
  begin
    For i := 0 to 63 DO
      sgraph_textfade_getcol(i,col[i].r,col[i].g,col[i].b);
  end;
end;

procedure sgraph_textfadedown(pfadedelay: word);
begin
  with textfaderec do
  begin
    for i:= 63 downto 0 do
    begin
      sgraph_textfade_setinten(i);
      delay(pfadedelay); {best delay = 20}
    end;
  end;
end;

procedure sgraph_textfadeup(pfadedelay: word);
begin
  with textfaderec do
  begin
    for i:= 0 to 63 do
    begin
      sgraph_textfade_setinten(i);
      Delay(pfadedelay);
    end;
  end;
end;

{$ENDIF}

procedure sgraph_cursoroff; assembler;
asm
 mov  ah,01h
 mov  ch,1
 mov  cl,0
 int  10h
end;

procedure sgraph_cursoron; assembler;
asm
 mov  ah,01h
 mov  ch,10
 mov  cl,11
 int  10h
end;

{$IFDEF yeswantstarfield_2}

procedure sgraph_initstarfield_2(pallvelocity: word;
                                   pbackgroundstarcolor: byte;
                                     pforegroundspeed,
                                     pstarcolor,poutputpage: byte);
begin
  with starfield_2rec do
  begin
    For i := 0 to starfield_2maxstars do
    begin
      star[i]  := random(320) + random(200) * 320;
      speed[i] := random(pforegroundspeed) + 1;

      {Foreground also gets "thicker" with higher pforegroundspeeds}

      if poutputpage = visscr then
      begin
        if mem[$a000 : star[i]] = 0 then
          mem[$a000 : star[i]] := pbackgroundstarcolor;
      end
      else
      begin
        if mem[hidscrseg : star[i]] = 0 then
          mem[hidscrseg : star[i]] := pbackgroundstarcolor;
      end;
      velocity:= pallvelocity;
      starcolor:= pstarcolor;
    end;                
  end;
end;

procedure sgraph_advancestarfield_2left;
begin
  Asm
   push  bp
   xor   bp,bp
   mov   ax,0a000h
   mov   es,ax
   lea   bx,starfield_2rec.star
   lea   si,starfield_2rec.speed
   mov   cx,320
  @l1:
   mov   di,[bx]
   mov   al,es:[di]
   cmp   al,starfield_2rec.starcolor
   jne   @j1
   xor   al,al
   stosb
  @j1:
   mov   al,[si]
   xor   ah,ah
   sub   [bx],ax {Left}
   mov   ax,bx
   xor   dx,dx
   div   cx
   mul   cx
   mov   dx,bx
   sub   dx,ax
   cmp   dx,319
   jle   @j3
   sub   [bx],cx
  @j3:
   mov   di,[bx]
   mov   al,es:[di]
   or    al,al
   jnz   @j2
   mov   al,starfield_2rec.starcolor
   stosb
  @j2:
   add   bx,2
   inc   si
   inc   bp
   cmp   bp,starfield_2maxstars
   jle   @l1
   pop   bp
  end;
  delay(starfield_2rec.velocity);
end;

procedure sgraph_advancestarfield_2right;
begin
  Asm
   push  bp
   xor   bp,bp
   mov   ax,0a000h
   mov   es,ax
   lea   bx,starfield_2rec.star
   lea   si,starfield_2rec.speed
   mov   cx,320
  @l1:
   mov   di,[bx]
   mov   al,es:[di]
   cmp   al,starfield_2rec.starcolor
   jne   @j1
   xor   al,al
   stosb
  @j1:
   mov   al,[si]
   xor   ah,ah
   add   [bx],ax {Right}
   mov   ax,bx
   xor   dx,dx
   div   cx
   mul   cx
   mov   dx,bx
   sub   dx,ax
   cmp   dx,319
   jle   @j3
   sub   [bx],cx
  @j3:
   mov   di,[bx]
   mov   al,es:[di]
   or    al,al
   jnz   @j2
   mov   al,starfield_2rec.starcolor
   stosb
  @j2:
   add   bx,2
   inc   si
   inc   bp
   cmp   bp,starfield_2maxstars
   jle   @l1
   pop   bp
  end;
  delay(starfield_2rec.velocity);
end;

procedure sgraph_advancestarfield_2lefthid;
begin
  Asm
   push  bp
   xor   bp,bp
   mov   ax,hidscrseg
   mov   es,ax
   lea   bx,starfield_2rec.star
   lea   si,starfield_2rec.speed
   mov   cx,320
  @l1:
   mov   di,[bx]
   mov   al,es:[di]
   cmp   al,starfield_2rec.starcolor
   jne   @j1
   xor   al,al
   stosb
  @j1:
   mov   al,[si]
   xor   ah,ah
   sub   [bx],ax {Left}
   mov   ax,bx
   xor   dx,dx
   div   cx
   mul   cx
   mov   dx,bx
   sub   dx,ax
   cmp   dx,319
   jle   @j3
   sub   [bx],cx
  @j3:
   mov   di,[bx]
   mov   al,es:[di]
   or    al,al
   jnz   @j2
   mov   al,starfield_2rec.starcolor
   stosb
  @j2:
   add   bx,2
   inc   si
   inc   bp
   cmp   bp,starfield_2maxstars
   jle   @l1
   pop   bp
  end;
  delay(starfield_2rec.velocity);
end;

procedure sgraph_advancestarfield_2righthid;
begin
  Asm
   push  bp
   xor   bp,bp
   mov   ax,hidscrseg
   mov   es,ax
   lea   bx,starfield_2rec.star
   lea   si,starfield_2rec.speed
   mov   cx,320
  @l1:
   mov   di,[bx]
   mov   al,es:[di]
   cmp   al,starfield_2rec.starcolor
   jne   @j1
   xor   al,al
   stosb
  @j1:
   mov   al,[si]
   xor   ah,ah
   add   [bx],ax {Right}
   mov   ax,bx
   xor   dx,dx
   div   cx
   mul   cx
   mov   dx,bx
   sub   dx,ax
   cmp   dx,319
   jle   @j3
   sub   [bx],cx
  @j3:
   mov   di,[bx]
   mov   al,es:[di]
   or    al,al
   jnz   @j2
   mov   al,starfield_2rec.starcolor
   stosb
  @j2:
   add   bx,2
   inc   si
   inc   bp
   cmp   bp,starfield_2maxstars
   jle   @l1
   pop   bp
  end;
  delay(starfield_2rec.velocity);
end;

{$ENDIF}

Function SGraph_TestKeys: Boolean;
Const Yes = True;
      No  = False;
Var AyeOrNay: Integer;
Label Yep,Nope,Ended,Stop;
Begin
 Asm
  MOV  AH,0Bh
  INT  21h
  CMP  AL,255
  JE   Yep
  JNE  Nope
  Yep:
  MOV  AyeOrNay,1
  MOV  AH,07h
  INT  21h
  MOV  letter,AL
  JMP  Ended
  Nope:
  MOV  AyeOrNay,0
  JMP  Stop
  Ended:
  CMP  AL,0
  JNE  Stop
  MOV  AH,07h
  INT  21h
  MOV  letter,AL
  Stop:
 End;
 If AyeOrNay = 1 then
 Begin
  sgraph_TestKeys:=   Yes;
  testKeyPressed:= Yes;
 End
 Else
 Begin
  sgraph_TestKeys:= No;
  testKeyPressed:= No;
 End;
End;

procedure sgraph_waitvrt; assembler;
asm
  mov dx,03dah
 @l1:
  in al,dx
  test al,8
  jnz @l1
 @l2:
  in al,dx
  test al,8
  jz @l2
end;

{$IFDEF yeswantlzss_stuff}

Function lzss_ReadProc(var ReadBuf;
                        var NumRead : word) : word; far;
Begin
  BlockRead(lzssrec.InFile, ReadBuf, LZRWBufSize, NumRead);
End; { ReadProc }

Function lzss_WriteProc(var WriteBuf; Count : word;
                         var NumWritten : word) : word;
far;Begin
  BlockWrite(lzssrec.OutFile, WriteBuf, Count, NumWritten);
End; { WriteProc }

procedure sgraph_lzssinit;
begin
  If not lzInit then
  begin
    closegraph;
    Writeln('SGraph error: not enough memory for lzss decompression operation.');
    halt;
  end
end;

procedure sgraph_lzssdone;
begin
  lzdone;
end;

procedure sgraph_lzssfiletofiledecomp(pinfile,poutfile: string);
begin
  with lzssrec do
  begin
    assign(infile,pinfile);
    assign(outfile,poutfile);
    reset(infile,1);
    rewrite(outfile,1);
    lzunsquash(lzss_readproc,lzss_writeproc);
    close(outfile);
    close(infile);
  end;
end;

{$ENDIF}

{$IFDEF yeswantpalcycle}

Procedure cyclepal_SetRGB(col, r, g, b : Byte);
Begin
 ASM
  CLI
 END;
 Port[$3C8] := col;
 Port[$3C9] := r;
 Port[$3C9] := g;
 Port[$3C9] := b;
 ASM
  STI
 END;
End;

Procedure cyclepal_GetRGB(col : Byte);
Begin
 Port[$3C7] := col;
 with cyclepalrec do
 begin
   cyclepal_rgb.red := Port[$3C9];
   cyclepal_rgb.green := Port[$3C9];
   cyclepal_rgb.blue := Port[$3C9];
 end;
End;

Procedure cyclepal_SetPalette;
Begin
 with cyclepalrec do
 begin
   For aa5 := 0 to 255 Do
     cyclepal_SetRGB(aa5,cyclepal_pal[aa5].red,cyclepal_pal[aa5].green,
                       cyclepal_pal[aa5].blue);
 end;
End;

Procedure cyclepal_GetPalette;
Begin
  with cyclepalrec do
  begin
    For aa5 := 0 to 255 Do Begin
     cyclepal_GetRGB(aa5);
     cyclepal_pal[aa5] := cyclepal_rgb;
    End;
  end;
End;

procedure sgraph_initcyclepalette;
begin
  cyclepal_getpalette;
end;

procedure sgraph_CyclePalette(lowcolor,topcolor,times,upordown: Byte);
Var c1 : cyclepal_PaletteType;
Begin
 with cyclepalrec do
 begin
   If upordown = 1 then Begin
    aa1 := 0;
    Repeat
     c1 := cyclepal_pal[topcolor];
     For aa5 := topcolor downto lowcolor + 1 Do Begin
      cyclepal_pal[aa5] := cyclepal_pal[aa5 - 1];
     End;
     cyclepal_pal[lowcolor] := c1;
     Inc(aa1);
     cyclepal_SetPalette; {Sets cycled palette}
    Until aa1 = times;
   End;
   If upordown = 2 then Begin
    aa1 := 0;
    Repeat
     c1 := cyclepal_pal[lowcolor];
     For aa5 := lowcolor to topcolor - 1 Do Begin
      cyclepal_pal[aa5] := cyclepal_pal[aa5 + 1];
     End;
     cyclepal_pal[topcolor] := c1;
     Inc(aa1);
     cyclepal_SetPalette; {Sets cycled palette}
    Until aa1 = times;
   End;
 end;
End;

{$ENDIF}

procedure sgraph_initpalfade; assembler;
asm
  push ds
  lds  si,palp
  mov  ax,SEG fadepalrec
  mov  es,ax
  mov  di,OFFSET fadepalrec
  mov  cx,192 {768 / 4 when using movsd, moves double words}
  cld
  cli
  db  $F3
  db  $66
  db  $A5
  sti
  pop ds
end;

procedure sgraph_graphpalfadecomplete(pdelay: word;
                                        pfadetimes: byte); assembler;
asm
  push ds
  cld
  cli
  lds  si,palp
  xor  ax,ax
  mov  al,pfadetimes
  mov  di,ax
 @fadeloop:
  mov  cx,256
  mov  dx,3c8h
  mov  al,0
  out  dx,al
  inc  dx
 @decpalloop:
  mov  ax,word ptr ds:[si]
  mov  bh,byte ptr ds:[si+2]
  cmp  ah,0
  je   @nodecah
  dec  ah
 @nodecah:
  cmp  al,0
  je   @nodecal
  dec  al
 @nodecal:
  cmp  bh,0
  je   @nodecbh
  dec  bh
 @nodecbh:
  mov  word ptr ds:[si],ax
  mov  byte ptr ds:[si+2],bh
  add  si,3
  loop @decpalloop
  mov  cx,768
  sub  si,768
  rep  outsb
  mov  ax,1000;
  mul  pdelay;
  mov  cx, dx;
  mov  dx, ax;
  mov  ah, $86;
  int  15h;
  sub  si,768
  dec  di
  cmp  di,0
  jnz  @fadeloop
  sti
  pop  ds
end;

procedure sgraph_graphpalfadesome(pstart,pend: byte;
                                    pdelay: word; pfadetimes: byte);
                                      assembler;
asm
  push ds
  cld
  cli
  lds  si,palp

  mov  ax,3   {Selects correct offset in palette data area for start color's}
  mul  pstart {bytes}
  mov  si,ax

  xor  ax,ax
  mov  al,pfadetimes
  mov  di,ax
 @fadeloop:
  xor  cx,cx
  mov  cl,pend
  sub  cl,pstart
  mov  dx,3c8h
  mov  al,pstart
  out  dx,al
  inc  dx
 @decpalloop:
  mov  ax,word ptr ds:[si]
  mov  bh,byte ptr ds:[si+2]
  cmp  ah,0
  je   @nodecah
  dec  ah
 @nodecah:
  cmp  al,0
  je   @nodecal
  dec  al
 @nodecal:
  cmp  bh,0
  je   @nodecbh
  dec  bh
 @nodecbh:
  mov  word ptr ds:[si],ax
  mov  byte ptr ds:[si+2],bh
  add  si,3
  loop @decpalloop
  mov  al,pend
  sub  al,pstart
  mov  cl,3
  mul  cl
  sub  si,ax
  mov  cx,ax
  rep  outsb
  mov  ax,1000;
  mul  pdelay;
  mov  cx, dx;
  mov  dx, ax;
  mov  ah, $86;
  int  15h;
  mov  al,pend
  sub  al,pstart
  mov  cl,3
  mul  cl
  sub  si,ax
  dec  di
  cmp  di,0
  jnz  @fadeloop
  sti
  pop  ds
end;

begin
  hidscrp:= nil;
  palp:= nil;
  oldpalp:= nil;
end.

