;----------------------------------------------------------------------------
; SCREEN.ASM
;----------------------------------------------------------------------------
; A set of assembly language functions for accessing the mode 13h
; video display.
; Must be compiled & linked in LARGE mode
; Andrew Cheung (July 1996)
;----------------------------------------------------------------------------
;     .386     ; Doesn't like .386 AT ALL, so no rep stosd,movsd
		.MODEL   large
		.CODE
;     _TEXT SEGMENT DWORD PUBLIC 'CODE'
;     ASSUME   cs:_TEXT, ds:_DATA
		PUBLIC   _setmode,_setpalette,_cls,_FlipPage

;----------------------------------------------------------------------------
; setmode(short mode)
;----------------------------------------------------------------------------
;     Set VGA adapter to BIOS mode MODE
;----------------------------------------------------------------------------
_setmode PROC
		ARG      mode:WORD
		push     bp
		mov      bp,sp
		mov      ax,mode         ; ax = video mode
		mov      ah,0            ; ah = function 0
		int      10h
		pop      bp
		ret
_setmode ENDP

;----------------------------------------------------------------------------
; setpalette(unsigned char *color_regs)
;----------------------------------------------------------------------------
;     Set 256 VGA color registers
;----------------------------------------------------------------------------
_setpalette PROC
		ARG      color_regs:DWORD
		push     bp
		mov      bp,sp
		push     di
		les      di,color_regs   ; Point es:di to the 256 color array
		mov      al,0            ; Point to the starting color
		mov      dx,3C8h         ; Set the starting color for writing
		out      dx,al
		mov      dx,3C9h         ; Set the data port to 3C9h
		mov      cx,256          ; Count for 256 colors
	@SetPalLoop:
		mov      al,[es:di]      ; Set al to the Red value
		out      dx, al          ; Blast Red value out to port 3C9h
		mov      al,[es:di+1]    ; Green value
		out      dx, al          ; Set it
		mov      al,[es:di+2]    ; Blue value
		out      dx, al          ; Set it
		add      di,3            ; Move onto the next color
		dec      cx
		jnz      @SetPalLoop     ; Repeat 256 times
		pop      di
		pop      bp              ; Restore BP
		ret
_setpalette ENDP

;----------------------------------------------------------------------------
; cls(unsigned char *Screen)
;----------------------------------------------------------------------------
;     Clear video memory or offscreen buffer at Screen to color 0 usu. black
;----------------------------------------------------------------------------
_cls        PROC
		ARG      Screen:DWORD
		push     bp
		mov      bp,sp
		push     di
		les      di,Screen       ; Point es:di at screen (= A000:0000) or a buffer
		mov      cx,64000 / 2    ; We're counting 32000 WORD values
		mov      ax,0            ; Store zero (black) in ax
		rep      stosw           ; ... and in all of video memory/buffer
		pop      di
		pop      bp
		ret
_cls        ENDP

;----------------------------------------------------------------------------
; FlipPage(unsigned char *Buffer)
;----------------------------------------------------------------------------
;     Flip the hidden buffer to the screen
;----------------------------------------------------------------------------
_FlipPage        PROC
		ARG      Buffer:DWORD
		push     bp
		mov      bp,sp
		push     ds
		push     di
		push     si              ; Save ds,di & si registers
		mov      cx,64000 / 2    ; We're counting 32000 WORD values
		mov      ax,0A000h
		mov      es,ax           ; Point es:di at video memory (destination)
		xor      di,di           ; es:di = A000:0000
		lds      si,Buffer       ; point [ds:si] at the buffer (source)
		rep      movsw           ; Copy Buffer to the Screen
		pop      si              ; Restore si,di & ds registers
		pop      di
		pop      ds
		pop      bp
		ret
_FlipPage        ENDP

END
