/****************************************************************************
*
*                               S H A N D Y
*
*                            1996 Andrew Cheung
*
*  FILENAME :     $RCSfile: camera.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C++
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  Camera Class and methods for the SHANDY program
*
*  $Id: camera.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include "shandy.hpp"
#include "globals.hpp"
#include "defines.h"
//#include "shading.h"
/****************************************************************************
*
*                            CAMERA CLASS
*
****************************************************************************/
Camera::Camera()
{
}

Camera::Camera(float ViewX,float ViewY,float ViewZ,
					float TargX,float TargY,float TargZ)
{
	position = new Point(ViewX, ViewY, ViewZ);
	target = new Point(TargX, TargY, TargZ);
	SetCamSpace();
}

Camera::~Camera()
{
	delete target;
	delete position;
}

void Camera::SetCamSpace()
{
	float magnitude;

	SubVec(target,position);
	tPoint->Normalise();  //now Nx=x3d,Ny=y3d,Nz=z3d

	//Vdash is the preferred up direction
	//Change Vdash to user specified? I've chosen Vdash=(0,1,0)
	//at the moment, so you can never be upside down
	Nx = tPoint->x3d; Ny = tPoint->y3d; Nz = tPoint->z3d;

	//Now find V from Vdash by projecting Vdash onto view plane
	//From Watt: V=Vdash-(Vdash.N)N
	//Will crash if user is looking directly up or down d.v. (0,(-)1,0)
	Vx = -Ny*Nx; Vy = 1.0-(Ny*Ny); Vz = -Ny*Nz;
	//Vx=0.0;Vy=1.0;Vz=0.0;
	//Normalise
	magnitude = sqrt( (Vx * Vx) + (Vy * Vy) + (Vz * Vz) );

	Vx /= magnitude;
	Vy /= magnitude;
	Vz /= magnitude;

	//U = N cross V
	Ux = (Nz*Vy) - (Ny*Vz);
	Uy = (Nx*Vz) - (Nz*Vx);
	Uz = (Ny*Vx) - (Nx*Vy);
	//U,V & N should all be normalised, resulting in a lh coord system
}

void Camera::Display()
{
	//position->Display(62);
	target->Display(255);
	//Line(position,target);
}
