/****************************************************************************
*
*                               S H A N D Y
*
*                            1996 Andrew Cheung
*
*  FILENAME :     $RCSfile: eventmgr.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  Event Manager module for handling events
*
*
*  $Id: eventmgr.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include <stdio.h>
#include <dos.h>
#include "defines.h"
#include "eventmgr.h"
#include "keyboard.h"

char keybuffer[128]; // Buffer for 128 scan codes

void InitEvents()
// Initialize event manager
{
	puts("Installing alternative keyboard handler");
	initkey(keybuffer);  // Install alternate keyboard driver
}

void EndEvents()
// Terminate event manager routines
{
	remkey(); //remove keyboard handler and reinstall old one
	puts("Re-installed old keyboard handler");
}

void ClearEvents(event_struct *events)
{
	events->go_forward=0;
	events->go_back=0;
	events->go_left=0;
	events->go_right=0;
	events->go_up=0;
	events->go_down=0;
	events->rote_up=0;
	events->rote_down=0;
	events->rote_left=0;
	events->rote_right=0;
	events->rote_clock=0;
	events->rote_aclock=0;

	events->selected=0;
	events->change_step=0;
	events->change_mode=0;
	events->moving=0;
	events->set_origin=0;
	events->help=0;
	events->quit=0;
}

int GetEvents(int event_mask,event_struct *events)
// Get events from devices selected by EVENT_MASK
{
	// Clear any events in structure:
	if(!events->moving)
	{
		events->go_forward=0;
		events->go_back=0;
		events->go_left=0;
		events->go_right=0;
		events->go_up=0;
		events->go_down=0;
		events->rote_up=0;
		events->rote_down=0;
		events->rote_left=0;
		events->rote_right=0;
		events->rote_clock=0;
		events->rote_aclock=0;
	}
	events->selected=0;
	events->change_step=0;
	events->change_mode=0;
	events->set_origin=0;
	events->help=0;
	events->quit=0;

	// If keyboard events requested....
	if (event_mask & KEYBOARD_EVENTS)
	{
		if(keybuffer[ALT])
		{
			if (keybuffer[UPARROW]) events->go_up=1;
			if (keybuffer[DOWNARROW]) events->go_down=1;
			if (keybuffer[LEFTARROW]) events->go_left=1;
			if (keybuffer[RIGHTARROW]) events->go_right=1;
			return(1);
		}

		if(keybuffer[CTRL])
		{
			if (keybuffer[UPARROW]) events->rote_up=1;
			if (keybuffer[DOWNARROW]) events->rote_down=1;
			if (keybuffer[LEFTARROW]) events->rote_aclock=1;
			if (keybuffer[RIGHTARROW]) events->rote_clock=1;
			return(1);
		}

		if (keybuffer[UPARROW]) events->go_forward=1;
		if (keybuffer[DOWNARROW]) events->go_back=1;
		if (keybuffer[LEFTARROW]) events->rote_left=1;
		if (keybuffer[RIGHTARROW]) events->rote_right=1;

		if(keybuffer[LSHIFT] || keybuffer[RSHIFT])
		{
			if (keybuffer[CKEY]) events->selected = S_CAMERA_TARGET;
			if (keybuffer[OKEY]) events->selected = S_ORIGIN;
			return(1);
		}

		if (keybuffer[ESC])
		{
			events->quit=1;
			return(1);
		}

		if (keybuffer[SPACEBAR])
			events->moving = !events->moving;

		//Check the keys 1 to 0: 2,3,4...11 are the scancodes for keys 1,2,3...,0
		for(int i=2;i<=11;i++)
			if(keybuffer[i])
				events->change_mode = i-1;

		if (keybuffer[CKEY]) events->selected = S_CAMERA;
		if (keybuffer[OKEY]) events->selected = S_OBJECT;
		if (keybuffer[LKEY]) events->selected = S_LIGHT;
		if (keybuffer[SKEY]) events->selected = S_SCENE;
		if (keybuffer[TAB])  events->set_origin = 1;

		if (keybuffer[ENTER]) events->help = 1;

		if (keybuffer[GRAYPLUS])
			events->change_step = 1;
		if (keybuffer[GRAYMINUS])
			events->change_step = -1;
		return(1);
	}
	return(1);
}

/////////////////////////  WATCOM INLINE ASSEMBLER  /////////////////////////

#ifdef WATCOM32

//--------------------  KEYBOARD INTERRUPT ROUTINES   -----------------------
void interrupt(NewKey)(void);
//THE keyboard handler

unsigned short IntKey_Seg; // 16 bit segment of old keyboard vector
unsigned int   IntKey_Off; // 32 bit offset of old keyboard vector
unsigned short KeyBuf_Seg; // 16 bit segment of keyboard buffer
unsigned int   KeyBuf_Off; // 32 bit offset of keyboard buffer

void newkey();
//The keyboard routine
#pragma aux newkey =       \
	"push		es"				\
	"push		eax"				\
	"push		edi"				\
	"cli"							\
	"cld"							\
	"mov     ax,KeyBuf_Seg"	\
	"mov     es,ax"			\
	"mov		edi,KeyBuf_Off"\
	"xor		eax,eax"			\
	"in		al,60h"			\
	"cmp		al,128"			\
	"jnb		break"			\
	"mov		byte ptr [edi+eax],1"\
	"jmp		endkey"			\
"break:"							\
	"and		al,127"			\
	"mov		byte ptr [edi+eax],0"\
"endkey:"						\
	"in		al,61h"			\
	"mov		ah,al"			\
	"or		al,80h"			\
	"out		61h,al"			\
	"mov		al,20h"			\
	"out		20h,al"			\
	"sti"							\
	"pop		edi"				\
	"pop		eax"				\
	"pop		es"				\
modify [eax edi];

void interrupt Newkey()
//The keyboard handler calls inline routine newkey()
//Saving of registers & IRET taken care of by interrupt keyword
{
  newkey();
}

void initkey(char *buffer);
//Initialize keyboard interrupt handler
#pragma aux initkey =      \
  "push  	ds"				\
  "push  	es"				\
  "mov   	KeyBuf_Seg,ds"	\
  "mov   	KeyBuf_Off,eax"\
  "mov   	ax,3509h"		\
  "int   	21h"				\
  "mov   	IntKey_Off,ebx"\
  "mov   	IntKey_Seg,es"	\
  "mov   	edx,offset Newkey"\
  "mov   	ax,seg Newkey"	\
  "mov   	ds,ax"			\
  "mov   	ax,2509h"		\
  "int   	21h"				\
  "pop   	es"				\
  "pop   	ds"				\
modify [ebx edx]           \
parm [eax];

void remkey();
//remove the keyboard handler
#pragma aux remkey =      	\
  "push  	ds"				\
  "mov   	edx,IntKey_Off"\
  "mov   	ax,IntKey_Seg"	\
  "mov   	ds,ax" 			\
  "mov   	ax,2509h"		\
  "int   	21h"				\
  "pop		ds"				\
modify [edx eax];

#endif
