/****************************************************************************
*
*                               S H A N D Y
*
*                             1996 Andrew Cheung
*
*  FILENAME :     $RCSfile: material.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C++
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  Texture/Materials functions for shandy program - these functions should
*  really become member functions of a materials class
*
*  $Id: material.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "shandy.hpp"
#include "globals.hpp"

int numTextures = 0;

//Searches a Texture list for the Material name
int SearchMatList(MatStruct **texture_list,char *material_name)
{
	int i,result;

	for(i=0; i<numTextures ;i++)
	{
		result = strcmp(texture_list[i]->MaterialName,material_name);
		if(result==0)
			return(i);
	}
	return(-1);
}

//Searches textures.dat for a material name
int SearchMatFile(FILE *texfile,MatStruct **texture_list, char *material_name)
{
	char c, cptr[1]="";
	char tempString[80]="";
	int result;

	//Parse textures.dat
	for(;;)
	{
		while(c!='"')
		{
			c=fgetc(texfile);
			if(feof(texfile))             //no textures found
			{
				rewind(texfile);
				return(-1);
			}
			if(c==';')                    //comment, so get the whole line
				fgets(tempString,80,texfile);
		}
		//Got here, so we're at the material name
		char name[80]="";

		while((c=fgetc(texfile))!='"')   //fgetc gets spaces as well
		{
			if(feof(texfile))             //no matching quote found
			{
				rewind(texfile);
				return(-1);
			}
			cptr[0]=c;
			strncat(name,cptr,1);
		}
		//OK, name contains the material name e.g. "3D CEL TEXMAP"
		//do a strcmp with material_name
		result = strcmp(name,material_name);

		if(result==0)
		{
			fscanf(texfile,"%s",name);
			printf("Loading material %s with graphic file %s\n",material_name,name);
			//MallocMaterial();

			if(!(texture_list[numTextures] = new MatStruct ))
			{
				printf("Couldn't allocate memory for a MatStruct");
				delete(texture_list[numTextures]);
				return(-1);
			}

			if(!(texture_list[numTextures]->TFile = new tga_struct))
			{
				puts("Couldn't allocate memory for graphics file");
				delete(texture_list[numTextures]->TFile);
				return(-1);
			}

			if(loadtga(name,texture_list[numTextures]->TFile))
			{
				printf("Couldn't load %s\n",name);
				rewind(texfile);
				delete(texture_list[numTextures]->TFile);
				delete(texture_list[numTextures]);
				return(-1);
			}
			else  //Loaded the Targa file
			{
				strcpy(texture_list[numTextures]->MaterialName,material_name);
				strcpy(texture_list[numTextures]->FileName,name);
				numTextures++;
				printf("Loaded %s\n",name);
				rewind(texfile);
				return(numTextures-1);
			}
		}//if(result==0)
		//else   result!=0 so continue searching
		c='X';   //Reset c to something
	 } //infinte for loop
}
