/****************************************************************************
*
*                               S H A N D Y
*
*                          1996 Andrew Cheung
*
*  FILENAME :     $RCSfile: polygon.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C++
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  Polygon Class and member functions for the SHANDY program
*
*  $Id: polygon.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include "shandy.hpp"
#include "globals.hpp"
//#include "defines.h"
#include "shading.h"

//========================= DOT PRODUCT =====================================

float DotProduct(Point *p1, Point *p2)
{
	//return( (p1->localX * p2->localX) + (p1->localY * p2->localY) +
	//      (p1->localZ * p2->localZ));

	return( (p1->x3d * p2->x3d) + (p1->y3d * p2->y3d) + (p1->z3d * p2->z3d));
}

void SubVec(Point *p1, Point *p2)
{
	tPoint->x3d = p1->x3d - p2->x3d;
	tPoint->y3d = p1->y3d - p2->y3d;
	tPoint->z3d = p1->z3d - p2->z3d;

	/*tPoint->localX = tPoint->x3d;
	tPoint->localY = tPoint->y3d;
	tPoint->localZ = tPoint->z3d;*/
}

/****************************************************************************
*
*                              POLYGON CLASS
*
****************************************************************************/

Polygon::Polygon()
{
}

Polygon::Polygon(Point *p1, Point *p2, Point *p3, int c)
{
	SetTo(p1,p2,p3);
	normal = new Point;
	CalcNormal();
	SetShading(GOURAUD);
	SetColor(c);
}

Polygon::~Polygon()
{
	delete p1;
	delete p2;
	delete p3;
	delete normal;
}

void Polygon::SetTo(Point *P1, Point *P2, Point *P3)
{
	p1 = P1;
	p2 = P2;
	p3 = P3;
}

void Polygon::CalcNormal()
{
	float a,b,c,magnitude;
	float d1[3],d2[3];                  //2 direction vectors

	d1[0] = p2->localX - p1->localX;    //find two vectors parallel to the plane
	d2[0] = p3->localX - p1->localX;

	d1[1] = p2->localY - p1->localY;
	d2[1] = p3->localY - p1->localY;

	d1[2] = p2->localZ - p1->localZ;
	d2[2] = p3->localZ - p1->localZ;

	a = d1[2]*d2[1] - d1[1]*d2[2];      //find the normal vector to the plane n=[a,b,c]=d2Xd1
	b = d1[0]*d2[2] - d1[2]*d2[0];      //this gives the OUTER normal
	c = d1[1]*d2[0] - d1[0]*d2[1];

	//float d;
	//d=(-(a*p1->localX+b*p1->localY+c*p1->localZ));//take the dot product with P-P1
	magnitude=sqrt( (a * a) + (b * b) + (c * c));

	a /= magnitude;
	b /= magnitude;
	c /= magnitude;

	normal->SetCoords(a,b,c);
}

//average Z value of a polygon, used for depth sorting
float Polygon::AvgZ()
{
	return( ((p1->eyeZ + p2->eyeZ + p3->eyeZ) / 3));
}

void Polygon::SetColor(int c)
{
	color = c;
}

void Polygon::SetShading(int shade)
{
	shading = shade;
}

void Polygon::SetNewLocalOrigin(Point *p)
{
	p1->SetNewLocalOrigin(p);
	p2->SetNewLocalOrigin(p);
	p3->SetNewLocalOrigin(p);
	normal->SetNewLocalOrigin(p);
}


void Polygon::CalcGNormals()
{
	p1->AddNormals(normal->localX, normal->localY, normal->localZ);
	p2->AddNormals(normal->localX, normal->localY, normal->localZ);
	p3->AddNormals(normal->localX, normal->localY, normal->localZ);
}

void Polygon::WireFrame()
{
	Line(p1,p2);
	Line(p2,p3);
	Line(p3,p1);
}

void Polygon::FlatShade()
{
	int i;
	float tempIntensity,intensity=0.0;

	for(i=0; i < scene->numLights; i++)
	{  //[p1] or [scene->object[0]->midpoint - fudge for uniform light]
		SubVec(scene->light[i],p1);
		tPoint->Normalise();
		tempIntensity = DotProduct(normal, tPoint);
		if(tempIntensity > 0.0)
			intensity += tempIntensity;
	}
	intensity += AMBIENT_LIGHT;
	if(intensity >1.0)
		intensity = 1.0;
	FlatFill(this, (char)(intensity*255.0));
}

void Polygon::GouraudShade()
{
	int i;
	float intensity1=0.0, intensity2=0.0, intensity3=0.0;
	float tempIntensity;

	//repeat operation 3 times for 3 points
	for(i=0; i <scene->numLights; i++)
	{
		SubVec(scene->light[i],p1);
		tPoint->Normalise();
		if(shading == GOURAUD_FLAT)
			tempIntensity = DotProduct(normal, tPoint);
		else
			tempIntensity = DotProduct((Point *) p1->normal, tPoint);
		if(tempIntensity > 0.0)
			intensity1 += tempIntensity;
	}
	intensity1 += AMBIENT_LIGHT;
	if(intensity1 > 1.0)
		intensity1 = 1.0;

	for(i=0; i <scene->numLights; i++)
	{
		SubVec(scene->light[i],p2);
		tPoint->Normalise();
		if(shading == GOURAUD_FLAT)
			tempIntensity = DotProduct(normal, tPoint);
		else
			tempIntensity = DotProduct((Point *) p2->normal, tPoint);
		if(tempIntensity > 0.0)
			intensity2 += tempIntensity;
	}
	intensity2 += AMBIENT_LIGHT;
	if(intensity2 > 1.0)
		intensity2 = 1.0;

	for(i=0; i <scene->numLights; i++)
	{
		SubVec(scene->light[i],p3);
		tPoint->Normalise();
		if(shading == GOURAUD_FLAT)
			tempIntensity = DotProduct(normal, tPoint);
		else
			tempIntensity = DotProduct((Point *) p3->normal, tPoint);
		if(tempIntensity > 0.0)
			intensity3 += tempIntensity;
	}
	intensity3 += AMBIENT_LIGHT;
	if(intensity3 > 1.0)
		intensity3 = 1.0;

	p1->color = (int)(intensity1*255.0);
	p2->color = (int)(intensity2*255.0);
	p3->color = (int)(intensity3*255.0);

	GouraudFill(this);
}


void Polygon::TextureMap()
{
	int i;
	float tempIntensity,intensity=0.0;

	if(shading == TEXTURE_FLAT)
	{
		for(i=0; i <scene->numLights; i++)
		{
			SubVec(scene->light[i],p1);
			tPoint->Normalise();
			tempIntensity = DotProduct(normal, tPoint);
			if(tempIntensity > 0.0)
				intensity += tempIntensity;
		}
		intensity += AMBIENT_LIGHT;
		if(intensity > 1.0)
			intensity = 1.0;
		TexMap(this,this->texture,(long)(31.0*intensity));
	}
	else  //No lighting calculations
		TexMap(this,this->texture,31);
}


void Polygon::Display()
{
	float dot;

	//Backface culling - should really be midpoint of polygon, not p1
	SubVec(camera->position,p1);
	dot = DotProduct(normal,tPoint);

	if( (dot > 0.0) && (p1->eyeZ > 0.0) && (p2->eyeZ > 0.0) && (p3->eyeZ > 0.0))
	// for side & top/bottom clipping as well, include:
	/*  && (p1->eyeX < (p1->eyeZ/1.6)) && (p2->eyeX < (p2->eyeZ/1.6)) && (p3->eyeX < (p3->eyeZ/1.6))
		 && (p1->eyeX > (p1->eyeZ/-1.6)) && (p2->eyeX > (p2->eyeZ/-1.6)) && (p3->eyeX > (p3->eyeZ/-1.6))
		 && (p1->eyeY < (p1->eyeZ/2)) && (p2->eyeY < (p2->eyeZ/2)) && (p3->eyeY < (p3->eyeZ/2))
		 && (p1->eyeY > (p1->eyeZ/-2)) && (p2->eyeY > (p2->eyeZ/-2)) && (p3->eyeY> (p3->eyeZ/-2)) )*/
	//  eyeZ/2 or 1.6 is the desired height/width of the view frustrum and should be assigned to
	//  variables. I've just included these for testing.
	{
		switch(shading)
		{
			case WIRE         : WireFrame(); break;
			case FLAT         :
			case FLAT_DEPTH   : FlatShade(); break;
			case GOURAUD      :
			case GOURAUD_FLAT :
			case GOURAUD_PHONG: GouraudShade(); break;
			case PHONG        : break;//Phong shading not implemented yet
			case TEXTURE      :
			case TEXTURE_FLAT : TextureMap(); break;
		}
	}
}

