/****************************************************************************
*
*                               S H A N D Y
*
*						  			  1996 Andrew Cheung
*
* 	FILENAME	:     $RCSfile: scene.cpp $
* 	VERSION	:    	$Revision: 1.0 $
* 	DATE     :     $Date: 1996/07/28 17:03:00 $
* 	LANGUAGE	:     C++
*
* 	ENVIRONMENT:
*	IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*	Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
* 	DESCRIPTION:
*	Scene Class and member functions for the SHANDY program
*
*
* 	$Id: scene.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "shandy.hpp"
#include "globals.hpp"
#include "defines.h"

//Used for qsorting objects
int object_sort_function(Object **a, Object **b)
{
	return( (*b)->midpoint->eyeZ - (*a)->midpoint->eyeZ);
}

/****************************************************************************
*
*                            	  SCENE CLASS
*
****************************************************************************/

Scene::Scene()
{
	numObjs = 0;
	numLights = 0;
	numCameras = 0;
	object = new Object*[1];
	light = new Point*[1];
	cameras = new Camera*[1];
}

Scene::~Scene()
{
	int count;

	for (count = 0; count < numObjs; count++)
		delete object[count];

	for (count = 0; count < numLights; count++)
		delete light[count];

	for (count = 0; count < numCameras; count++)
		delete cameras[count];

	delete object;
	delete light;
	delete cameras;
}

/****************************************************************************
*
* Loads a scene with objects,lights and cameras
* fin - a file handle for the scene
* ftextures - a file handle to the texture data file
* shading is a global shading model for the scene (individual faces
* can have different shading models - global model is overidden by
* values specified in the textures file)
*
****************************************************************************/
void Scene::LoadScene(FILE *fin,FILE *ftextures,int *shading)
{
	char *tempString = new char[80];
	//If only even one object in scene is texture mapped, the palette
	//is set to the texture map palette
	int *tempShading= new int;

	*tempShading = GOURAUD;
	//Parse the input file
	while(!feof(fin))
	{
		fscanf(fin,"%s",tempString);
		if(strcmp("Tri-mesh,",tempString)==0)  //Found Tri-mesh
		{
			AddObject(); //allocates mem for object using new Object
			//Load the object into allocated memory
			object[numObjs-1]->LoadObject(fin,ftextures,shading);
			if(*shading == TEXTURE_FLAT)
				*tempShading = TEXTURE_FLAT;
		}
		if(strcmp("Direct",tempString)==0)		//Found Light source
		{
			while(strncmp(tempString,"Position:",9))
			{
				fscanf(fin, "%s", tempString);
				if(feof(fin))
				{
					printf("String \"Position\" not found in file.Exitting...\n");
					exit(1);
				}
			}
			LoadLight(fin);
		}
		if(strcmp("Camera",tempString)==0)		//Found Camera
		{
			while(strncmp(tempString,"Position:",9))
			{
				fscanf(fin, "%s", tempString);
				if(feof(fin))
				{
					printf("String \"Position\" not found in file.Exitting...\n");
					exit(1);
				}
			}
			LoadCamera(fin);
		}

	}
	if(*tempShading == TEXTURE_FLAT)
		*shading = TEXTURE_FLAT;

	//If no lights or cameras defined, then add some
	//Look directly into screen
	if(numLights == 0)
		AddLight(0.0, 0.0, -1024.0);
	if(numCameras == 0)
		AddCamera(0.0, 0.0, -1024.0,
					 0.0, 0.0, 0.0);
	/*if(numLights == 0)
		AddLight(252.473236, 1578.831421, -1885.349121);
	if(numCameras == 0)
		AddCamera(252.473236, 1578.831421, -1885.349121,
					 -105.012474, 187.897873, -8.706659); //from tscone2.asc*/

	//Set the 'active' camera to the first camera
	camera = cameras[0];
}

//Load a light source
void Scene::LoadLight(FILE *fin)
{
	float tempX, tempY, tempZ;
	char *tempString = new char [80];

	fscanf(fin, "%[^:]", tempString);   //get '     X'
	fgetc(fin);                         //get ':'
	fscanf(fin, "%f", &tempX);

	fscanf(fin, "%[^:]", tempString);
	fgetc(fin);
	fscanf(fin, "%f", &tempY);

	fscanf(fin, "%[^:]", tempString);
	fgetc(fin);
	fscanf(fin, "%f", &tempZ);

	AddLight(tempX, tempZ, tempY);		//swap y & z because of 3DStudio
}

//Load a camera
void Scene::LoadCamera(FILE *fin)
{
	float tempX, tempY, tempZ, tempA,tempB,tempC;
	char *tempString = new char [80];

	//Viewpoint
	fscanf(fin, "%[^:]", tempString);   //get '     X'
	fgetc(fin);                         //get ':'
	fscanf(fin, "%f", &tempX);

	fscanf(fin, "%[^:]", tempString);
	fgetc(fin);
	fscanf(fin, "%f", &tempY);

	fscanf(fin, "%[^:]", tempString);
	fgetc(fin);
	fscanf(fin, "%f", &tempZ);

	while(strncmp(tempString,"Target:",7))
	{
		fscanf(fin, "%s", tempString);
		if(feof(fin))
		{
			printf("String \"Target\" not found in file.Exitting...\n");
			exit(1);
		}
	}
	//Target point
	fscanf(fin, "%[^:]", tempString);   //get '     X'
	fgetc(fin);                         //get ':'
	fscanf(fin, "%f", &tempA);

	fscanf(fin, "%[^:]", tempString);
	fgetc(fin);
	fscanf(fin, "%f", &tempB);

	fscanf(fin, "%[^:]", tempString);
	fgetc(fin);
	fscanf(fin, "%f", &tempC);
	AddCamera(tempX, tempZ, tempY, tempA,tempC,tempB);		//swap y & z because of 3DStudio
}

void Scene::AddObject()
{
	 Object **temp;

	 temp = new Object*[numObjs + 1];
	 memcpy(temp, object, numObjs * sizeof(Object*));

	 delete object;
	 object = temp;

	 object[numObjs] = new Object(0.0, 0.0, 0.0);
	 numObjs++;
}

void Scene::AddLight(float x, float y, float z)
{
	 Point **temp;

	 temp = new Point*[numLights + 1];
	 memcpy(temp, light, numLights * sizeof(Point*));

	 delete light;
	 light = temp;

	 light[numLights] = new Point(x, y, z);
	 numLights++;
}

void Scene::AddCamera(float vx, float vy, float vz,
							 float tx, float ty, float tz)
{
	 Camera **temp;

	 temp = new Camera*[numCameras + 1];
	 memcpy(temp, cameras, numCameras * sizeof(Camera*));

	 delete cameras;
	 cameras = temp;

	 cameras[numCameras] = new Camera(vx,vy,vz,tx,ty,tz);
	 numCameras++;
}

void Scene::SortObjs()
{
#ifndef PROFILE
	if(numObjs > 1)
		qsort(object,numObjs,sizeof(Object *),(int(*)(const void *,const void *))object_sort_function);
#endif
}

void Scene::EyeSpace()
{
	int i;
	for(i=0; i < numObjs; i++)
		object[i]->EyeSpace();
}

void Scene::Display()
{
	int i;
	for(i=0; i < numObjs; i++)
		object[i]->Display();
}

