/****************************************************************************
*
*                               S H A N D Y
*
*                    Copyright (C) 1996 Andrew Cheung
*                          All rights reserved.
*
*  FILENAME :     $RCSfile: shading.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C++
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  2D shading routines for lines, flat filling,Gouraud,and texture shading
*  triangles.
*  Inline assembler all over the place so it's not that neat, but saves the
*  trouble with coding entire routines in assembler. Optimised here and there
*  but NOT super optimised. Lots of work can still be done - esp. with texture
*  mapping
*
*  $Id: shading.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include <stdlib.h>
#include "shandy.hpp"
#include "globals.hpp"
#include "shading.h"

#ifdef SVGAKIT
	#include"svga.h"
#endif

int max (int value1, int value2);
int min (int value1, int value2);

int max(int value1, int value2)
{
	return((value1 > value2) ? value1 : value2);
}

int min(int value1, int value2)
{
	return((value1 < value2) ? value1 : value2);
}

// Pointers into left & right edge arrays - size of array = MAXY
long *edge1,*edge2,*cedge1,*cedge2;
void (*TexMap)(Polygon *pg, tga_struct *texture,long intensity);
//extern int texarray[64][64]; //old texmap routine with 64x64 texmaps

//////////////////////   WATCOM INLINE ASSEMBLER  ///////////////////////////
#ifdef WATCOM32
// A fast horizontal line routine
void HLine(unsigned char *start, int length, char color);
#pragma aux HLine =     \
	"mov		ah,al"      \
	"test		edi,1"      \
	"jz		even"       \
	"stosb"              \
	"dec     cx"         \
"even:"                 \
	"shr		cx,1"       \
	"rep		stosw"      \
	"adc		cx,0"       \
	"rep		stosb"      \
modify [eax]            \
parm [edi] [ecx] [al];

// A fast Gouraud horizontal line routine
void GHLine(unsigned char *start, int length, long mc, long color);
#pragma aux GHLine =    \
"@shadedlineloop:"      \
	"mov		[edi],ah"   \
	"add		ax,bx"      \
	"inc		edi"        \
	"dec		cx"         \
	"jnz		@shadedlineloop"  \
parm [edi] [ecx] [ebx] [eax];

#endif

//=================================  LINE  ==================================
// A differential line routine using only integers - no clipping performed
//===========================================================================
void Line(Point *p1, Point *p2)
{
	long topx,topy,botx,boty;
	long slope,fix_start;
	int i;
	Point *top_point, *bot_point, *tmp_point;

	if( (p1->x2d < 0 || p1->x2d > MAXX) || (p1->y2d < 0 || p1->y2d > MAXY)
	  ||(p2->x2d < 0 || p2->x2d > MAXX) || (p2->y2d < 0 || p2->y2d > MAXY))
		;     //do nothing as a point is outside of the screen
	else
	{
		if(video_mode == 0x13)
		{
			top_point = p1;
			bot_point = p2;

			if( abs(top_point->y2d - bot_point->y2d) > abs(top_point->x2d - bot_point->x2d))
			{  // the line's major axis is the y-axis
				if(top_point->y2d > bot_point->y2d)
				{
					tmp_point = top_point;
					top_point = bot_point;
					bot_point = tmp_point;
				}

				topx = top_point->x2d; topy = top_point->y2d;
				botx = bot_point->x2d; boty = bot_point->y2d;

				slope = (topx - botx)<<16;
				if(topy-boty!=0)
					slope /= (topy-boty);
				/*Clip to the top & bottom edges
				if(boty > MAXY)
					boty = MAXY;
				if(topy < 0)
					{topx += (-topy * slope)>>16; topy=0;}*/

				fix_start = topx <<16;

				for(i=topy;i<=boty;i++)
				{
					Screen[ScreenY[i]+(fix_start>>16)] = 255;
					fix_start += slope;
				}
			}
			else // the line's major axis is the x-axis
			{
				//Here, top means left & bot means right
				if(top_point->x2d > bot_point->x2d)
				{
					tmp_point = top_point;
					top_point = bot_point;
					bot_point = tmp_point;
				}

				topx = top_point->x2d; topy = top_point->y2d;
				botx = bot_point->x2d; boty = bot_point->y2d;

				slope = (topy - boty)<<16;
				if(topx-botx!=0)
					slope /= (topx-botx);
				fix_start = topy <<16;

				for(i=topx;i<=botx;i++)
				{
					Screen[ScreenY[(fix_start>>16)]+i] = 255;
					fix_start += slope;
				}
			}
		}
	#ifdef SVGAKIT
		else  //an SVGAKIT mode
			line(p1->x2d,p1->y2d,p2->x2d,p2->y2d,255);
	#endif
	}
}

//==============================  FLATFILL  =================================
// Fills a triangle with the color color
//===========================================================================
void FlatFill(Polygon *pg, char color)
{
	long topy,topx,midx,midy,botx,boty; //x,y coords of the 3 points
	long topm,botm,longm;               //gradients of the 3 edges
	long fix_topx,fix_botx,fix_longx;   //fixed point xcoords of the start of each edge
	long *ledge,*redge;
	int i,length;
	unsigned char *start;
	Point *top_point, *mid_point, *bot_point, *tmp;

	if( (min(pg->p1->x2d,min(pg->p2->x2d,pg->p3->x2d)) > MAXX) ||
		 (min(pg->p1->y2d,min(pg->p2->y2d,pg->p3->y2d)) > MAXY) ||
		 (max(pg->p1->x2d,max(pg->p2->x2d,pg->p3->x2d)) < 0) ||
		 (max(pg->p1->y2d,max(pg->p2->y2d,pg->p3->y2d)) < 0)
	  )
	return;
	//Step 1: store points as top,middle and bottom points
	top_point = pg->p1;
	mid_point = pg->p2;
	bot_point = pg->p3;

	if(top_point->y2d > mid_point->y2d)
	{
		tmp = top_point;
		top_point = mid_point;
		mid_point = tmp;
	}

	if(top_point->y2d > bot_point->y2d)
	{
		tmp = top_point;
		top_point = bot_point;
		bot_point = tmp;
	}

	if(mid_point->y2d > bot_point->y2d)
	{
		tmp = mid_point;
		mid_point = bot_point;
		bot_point = tmp;
	}

	topx = top_point->x2d; topy = top_point->y2d;
	midx = mid_point->x2d; midy = mid_point->y2d;
	botx = bot_point->x2d; boty = bot_point->y2d;

	//Step 2: Find the gradients of each edge and fixed point starting xcoords
	//        for each edge
	botm = (midx-botx)<<16;   //bottom edge
	if(midy-boty!=0)
		botm /= (midy-boty);

	topm = (topx-midx)<<16;   //top edge
	if(topy-midy!=0)
		topm /= (topy-midy);

	longm = (topx-botx)<<16;  //longest edge
	if(topy-boty!=0)
		longm /= (topy-boty);

	fix_botx = midx<<16;    //starting fixed point x value of the bottom edge
	fix_topx = topx<<16;    //starting fixed point x value of the top edge
	fix_longx = fix_topx;   // == fix_longx = topx<<16;

	//Step 3: scan convert the triangle

	for(i=topy;i<midy;i++)              //    /|
	{                                   //   /  |
		if(i >=0 && i<=MAXY)             //  /   |
		{                                // /     |   part
			edge1[i] = fix_topx>>16;
			edge2[i] = fix_longx>>16;
		}
		fix_longx += longm;
		fix_topx += topm;
	}
													// \    |
	for(i=midy;i<=boty;i++)             //  \    |
	{                                   //   \   |    part
		if(i >=0 && i<=MAXY)             //    \  |
		{                                //      \|
			edge1[i] = fix_botx>>16;      //     \ |
			edge2[i] = fix_longx>>16;
		}
		fix_longx += longm;
		fix_botx += botm;
	}

	//Step 4: ensure left and right edges are in correct order

	//if(midx > edge2[midy]) - no clipping
	if(midx > ( ((topx<<16)+((midy-topy) *longm)) >>16) )
	//if(midx > (topx+(midy-topy)*((float)longm/65536.0)) )
	{
		ledge = edge2;
		redge = edge1;
	}
	else
	{
		ledge = edge1;
		redge = edge2;
	}

	//Step5: draw the filled triangle onto the screen
	for(i=topy;i<=boty;i++)
	{
		if(i >= 0 && i <=MAXY)
		{
			if(redge[i] > MAXX)
				redge[i] = MAXX;
			if(ledge[i] < 0)
				ledge[i] = 0;

			length = redge[i]-ledge[i];
			if (length > 0)
			{
				start = Screen+ScreenY[i]+ledge[i];
				if(video_mode == 0x13)
				{
	#ifdef WATCOM32
					HLine(start,length,color);
	#endif
	#ifdef BC3
				asm{
					mov cx, word ptr length
					les di, start
					mov al, byte ptr color
					mov ah,al
					test di, 1
					jz even
					stosb
					dec cx
					}
				even:
				;
				asm{
					shr cx, 1
					rep stosw
					adc cx, 0
					rep stosb
					 }
	#endif
				}
			#ifdef SVGAKIT
				else
					line(ledge[i],i,redge[i],i,color);
			#endif
			}// if(length > 0)
		}   // if(i >= 0 && i <=MAXY)
	}
}

//=============================  GOURUADFILL  ===============================
// Gouraud shades a triangle. The color at each of the 3 points is already
// stored with the point
//===========================================================================
void GouraudFill(Polygon *pg)
{
	long topy,topx,midy,midx,boty,botx; // x,y coords of the 3 points
	long topm,botm,longm;               // gradients of the 3 edges
	long topmc,botmc,longmc;            // colour gradients of the 3 edges
	long topc,midc,botc;                // colours at the 3 points
	long fix_topx,fix_botx,fix_longx;   // fixed point values of xcoords
	long fix_topc,fix_botc,fix_longc;   // fixed point values of colours
	long *ledge,*redge,*lcedge,*rcedge; // and colour (intensity) values

	//variables for the GHLine part
	long mc,c;
	int i,j,length;
	unsigned char *start;

	Point *top_point, *mid_point, *bot_point, *tmp;

	if( (min(pg->p1->x2d,min(pg->p2->x2d,pg->p3->x2d)) > MAXX) ||
		 (min(pg->p1->y2d,min(pg->p2->y2d,pg->p3->y2d)) > MAXY) ||
		 (max(pg->p1->x2d,max(pg->p2->x2d,pg->p3->x2d)) < 0) ||
		 (max(pg->p1->y2d,max(pg->p2->y2d,pg->p3->y2d)) < 0)
	  )
	return;

	//Step 1: store points as top,middle and bottom points
	top_point = pg->p1;
	mid_point = pg->p2;
	bot_point = pg->p3;

	if(top_point->y2d > mid_point->y2d)
	{
		tmp = top_point;
		top_point = mid_point;
		mid_point = tmp;
	}

	if(top_point->y2d > bot_point->y2d)
	{
		tmp = top_point;
		top_point = bot_point;
		bot_point = tmp;
	}

	if(mid_point->y2d > bot_point->y2d)
	{
		tmp = mid_point;
		mid_point = bot_point;
		bot_point = tmp;
	}

	topx = top_point->x2d; topy = top_point->y2d;
	midx = mid_point->x2d; midy = mid_point->y2d;
	botx = bot_point->x2d; boty = bot_point->y2d;

	//Step 1.5: store colour values into (int topc,midc & botc)
	topc = top_point->color;
	midc = mid_point->color;
	botc = bot_point->color;


	//Step2: find gradients m and starting points of 3 lines
	//       and interpolate colours into colour lists

	botm = (midx-botx)<<16;               //bottom edge
	botmc = (midc-botc)<<16;
	if(midy-boty!=0)
		{botm /= (midy-boty); botmc /= (midy-boty);}
	//else
	// {botm=0; botmc=0;}
													//top edge
	topm = (topx-midx)<<16;
	topmc = (topc-midc)<<16;
	if(topy-midy!=0)
		{topm /= (topy-midy); topmc /= (topy-midy);}
	//else
	// {topm=0;topmc=0;}
													//longest edge
	longm = (topx-botx)<<16;
	longmc = (topc-botc)<<16;
	if(topy-boty!=0)
		{longm /= (topy-boty); longmc /= (topy-boty);}
	//else
	// {longm=0;longmc=0;}

	fix_botx = midx<<16;    // Starting fixed point x & color values
	fix_botc = midc<<16;    // for each of the 3 edges
	fix_topx = topx<<16;
	fix_topc = topc<<16;
	fix_longx = fix_topx;
	fix_longc = fix_topc;

	//Step 3: scan convert the triangle
	for(i=topy;i<midy;i++)              //    /|
	{                                   //   /  |
		if(i >=0 && i<=MAXY)             //  /   |
		{                                // /     | part
			edge1[i] = fix_topx>>16;      ///      |
			cedge1[i] = fix_topc>>16;
			edge2[i] = fix_longx>>16;
			cedge2[i] = fix_longc>>16;
		}
		fix_topx += topm;
		fix_topc += topmc;
		fix_longx += longm;
		fix_longc += longmc;
	}
													// \    |
	for(i=midy;i<=boty;i++)             //  \    |
	{                                   //   \   |    part
		if(i >=0 && i<=MAXY)             //    \  |
		{                                //     \ |
			edge1[i] = fix_botx>>16;      //      \|
			cedge1[i] = fix_botc>>16;
			edge2[i] = fix_longx>>16;
			cedge2[i] = fix_longc>>16;
		}
		fix_botx += botm;
		fix_botc += botmc;
		fix_longx += longm;
		fix_longc += longmc;
	}

	//Step 4: ensure left and right edges are in correct order

	//if(midx > edge2[midy]) - no clipping
	if(midx > ( ((topx<<16)+((midy-topy) *longm)) >>16) )
	{
		ledge = edge2; lcedge = cedge2;
		redge = edge1; rcedge = cedge1;
	}
	else
	{
		ledge = edge1; lcedge = cedge1;
		redge = edge2; rcedge = cedge2;
	}

	//Step5: draw the triangle onto the screen

	for(i=topy;i<=boty;i++)
	{
		if(i >= 0 && i <=MAXY)
		{
			length = redge[i]-ledge[i];
			if(length>0)
			{
				mc = (rcedge[i]-lcedge[i])<<8;
				mc /= length;                       //color slope of scanline
				c = lcedge[i]<<8;                   //starting color value of scanline
			}

			if(redge[i] > MAXX)
				redge[i] = MAXX;
			if(ledge[i] < 0)
			{
				c += -ledge[i]*mc;                  //work out new starting color
				ledge[i] = 0;                       //of scanline
			}

			length=redge[i]-ledge[i];
			if(length>0)
			{
				start = Screen + ScreenY[i] + ledge[i];
				if(video_mode==0x13)
				{
	#ifdef WATCOM32
				GHLine(start,length,mc,c);
	#endif
	#ifdef BC3
				asm{
					mov cx, word ptr length
					les di, start
					mov ax, word ptr c
					}
				shadedlineloop:
				 ;
				asm {
					mov [es:di], ah
					add ax, word ptr mc
					inc di
					dec cx
					jnz shadedlineloop
					 }
	#endif
				}
				#ifdef SVGAKIT
				else
				{
					for(j=ledge[i];j<=redge[i];j++)
						{putPixel(j,i,c>>8); c+=mc;}
				}
				#endif
			}  //if(length>0)
		}     //if(i >= 0 && i <=MAXY)
	}        //for loop
}


//=============================  TEXMAP256  =================================
// TEXMAP256 - used with my mode13h, NOT SVGAKIT
// DDA texture maps a tga file (256 color tga) onto a triangle pg
// Texture is a pointer to the tga graphics file to be mapped onto the triangle
// Intensity is the intensity of the triangle face
// The tga graphics file can be variably sized
// NOTE: Completely UNOPTIMISED e.g. right edge of texture triangle does not
//       need to be tracked
//===========================================================================
void TexMap256(Polygon *pg, tga_struct *texture,long intensity)
{
	long top_y,top_x,mid_y,mid_x,bot_y,bot_x; //x,y coords of the 3 points
	long topm,botm,longm;                     //gradients of the 3 edges
	long fix_topx,fix_botx,fix_longx;         //fixed point xcoords of the 3 points
	long *ledge,*redge;
	long sh1,sh2,th1,tw1,th2,tw2;
	// sh1,sh2 = height in pixels of current edges 1 & 2 of the screen triangle
	// th1,th2 = fixed point increments in height of edges 1 & 2 of the texture triangle
	// tw1,tw2 = fixed point increments in width of edges 1 & 2 of the texture triangle
	long rflag,color;
	long currslength,currtexwidth,currtexheight;//currslength = current scanline length of triangle
	long currtx1,currty1,currtx2,currty2;     //fixed point x & y coords along edges of texture map triangle
	long stepx,stepy,fillx,filly;             //fixed point slope increments along edges & inside texture map triangle
	long i,j;
	Point *lefts1texnum,*rights1texnum,*lefte1texnum,*righte1texnum;
	Point *lefts2texnum,*rights2texnum,*lefte2texnum,*righte2texnum;

	// The texnum varibles map a screen point to its associated texture point
	// Not all needed, but included for clarity

	// s = start, e = end, similarly for a right pointed triangle

	//                 lefts1texnum,rights1texnum,rights2texnum
	//                             /|
	//                            /  |                       1st half
	//                           /   |
	//             lefte1texnum /     |

	//                                                       =========
	//             lefts2texnum \    |
	//                           \   |
	//                            \  |                       2nd half
	//                             \ |
	//                              \|
	//                 lefte2texnum,righte2texnum,righte1texnum

	Point *top_point,*mid_point,*bot_point,*tmp;

	if( (min(pg->p1->x2d,min(pg->p2->x2d,pg->p3->x2d)) > MAXX) ||
		 (min(pg->p1->y2d,min(pg->p2->y2d,pg->p3->y2d)) > MAXY) ||
		 (max(pg->p1->x2d,max(pg->p2->x2d,pg->p3->x2d)) < 0) ||
		 (max(pg->p1->y2d,max(pg->p2->y2d,pg->p3->y2d)) < 0)
	  )
	return;

	//Step 1: store points as top,middle and bottom points
	top_point = pg->p1;
	mid_point = pg->p2;
	bot_point = pg->p3;

	if(top_point->y2d > mid_point->y2d)
	{
		tmp = top_point;
		top_point = mid_point;
		mid_point = tmp;
	}

	if(top_point->y2d > bot_point->y2d)
	{
		tmp = top_point;
		top_point = bot_point;
		bot_point = tmp;
	}

	if(mid_point->y2d > bot_point->y2d)
	{
		tmp = mid_point;
		mid_point = bot_point;
		bot_point = tmp;
	}

	if((top_point->y2d == mid_point->y2d) && (top_point->x2d > mid_point->x2d))
	{
		tmp = top_point;
		top_point = mid_point;
		mid_point = tmp;
	}

	//if the bottom point and medium points have the same y coords, then
	//medium x coord is less than bottom x coord
	/*if((mid_point->y2d == bot_point->y2d) && (mid_point->x2d > bot_point->x2d))
	{
		tmp = mid_point;
		mid_point = bot_point;
		bot_point = tmp;
	}*/

	top_x = top_point->x2d; top_y = top_point->y2d;
	mid_x = mid_point->x2d; mid_y = mid_point->y2d;
	bot_x = bot_point->x2d; bot_y = bot_point->y2d;

	//Step2: find gradients m and starting points of 3 edges.

	topm = (top_x-mid_x)<<16;   //top edge
	if(top_y-mid_y!=0)
		topm /= (top_y-mid_y);

	longm = (top_x-bot_x)<<16;  //longest edge (joins top and bottom points)
	if(top_y-bot_y!=0)
		longm /= (top_y-bot_y);

	botm = (mid_x-bot_x)<<16;   //bottom edge
	if(mid_y-bot_y!=0)
		botm /= (mid_y-bot_y);

	fix_botx = mid_x<<16;
	fix_topx = top_x<<16;
	fix_longx = fix_topx;

	//Step 3: scan convert the triangle

	for(i=top_y;i<mid_y;i++)            //    /|
	{                                   //   /  |
		if(i >=0 && i<=MAXY)             //  /   |
		{                                // /     |   part
			edge1[i] = fix_topx>>16;
			edge2[i] = fix_longx>>16;
		}
		fix_topx += topm;
		fix_longx += longm;
	}

	for(i=mid_y;i<=bot_y;i++)           //  \    |
	{                                   //   \   |    part
		if(i >=0 && i<=MAXY)             //    \  |
		{                                //     \ |
			edge1[i] = fix_botx>>16;      //      \|
			edge2[i] = fix_longx>>16;
		}
		fix_botx += botm;
		fix_longx += longm;
	}

	//Step 4: ensure the left and right edges are in the correct order

	//if(mid_x > edge2[mid_y])
	if(mid_x > ( ((top_x<<16)+((mid_y-top_y) *longm)) >>16) )
	{
		rflag = 1;
		lefts2texnum = top_point;
		lefte1texnum = bot_point;       // right pointed triangle
		rights2texnum = mid_point;
		righte1texnum = mid_point;
		ledge = edge2;
		redge = edge1;
	}
	else
	{
		ledge = edge1;
		redge = edge2;
		rflag = 0;                      // left pointed triangle
		lefts2texnum = mid_point;
		lefte1texnum = mid_point;
		rights2texnum = top_point;
		righte1texnum = bot_point;
	}
	//Step 5: calculate height of screen poly edges and step sizes
	//        of 3 texture edges

	lefts1texnum = top_point;
	rights1texnum = top_point;

	//set up fixed point variables
	long width, height;
	width = texture->header.image_width;
	height = texture->header.image_height;
	//Note: texnum->u,v are 16:16 fixed point numbers whilst width &
	//      height are normal integers so texnum->u,v * width,height
	//      give 16:16 fixed point for th1,tw1,th2,tw2

	th1=( (lefte1texnum->v * height) - (lefts1texnum->v * height));
	tw1=( (lefte1texnum->u * width ) - (lefts1texnum->u * width ));

	th2=( (righte1texnum->v* height) - (rights1texnum->v * height));
	tw2=( (righte1texnum->u* width ) - (rights1texnum->u * width ));

	//check if triangle vertex points to right
	if(rflag)
	{
		sh2 = mid_y-top_y;
		if(sh2!=0)
			{th2 /= sh2; tw2 /= sh2;}

		sh1 = bot_y-top_y;      //right pointed tri so left edge is bottomy - top_y
		if(sh1!=0)
			{th1 /= sh1; tw1 /= sh1;}
	}
	else
	{
		//left pointed
		sh1 = mid_y-top_y;
		if(sh1!=0)
			{th1 /= sh1; tw1 /= sh1;}

		sh2 = bot_y-top_y;         //left pointed tri so right edge is bot_y-top_y
		if(sh2!=0)
			{th2 /= sh2; tw2 /= sh2;}
	}

	//Step 6: loop through scanlines from top_y to bottom y in screen poly

	//Big for loop doing the edge interpolation from edge 1 to edge 2
	// currtx1,currtx2 = starting left/right x coord in texture
	// currty1,currtx2 = starting left/right y coord in texture
	currtx1 = currtx2 = (lefts1texnum->u * width);
	currty1 = currty2 = (lefts1texnum->v * height);
	long start;

		  /*currslength=redge[mid_y]-ledge[mid_y];
		  currtexwidth  = (currtx2+ (mid_y-top_y)*tw2)-(currtx1+ (mid_y-top_y)*tw1);
		  currtexheight = (currty2+ (mid_y-top_y)*th2)-(currty1+ (mid_y-top_y)*th1);
		  if(currslength!=0)
		  {
			stepx=currtexwidth/currslength;
			stepy=currtexheight/currslength;
		  }*/
	for(i=top_y;i<mid_y;i++)
	{
		if(i >= 0 && i <=MAXY)
		{
			currslength = redge[i]-ledge[i];   //should never be negative
			currtexwidth = (currtx2-currtx1);
			currtexheight = (currty2-currty1);

			if(currslength!=0)
			{
				stepx = currtexwidth/currslength;
				stepy = currtexheight/currslength;
			}

			fillx=currtx1; //starting fixed point values for left edge of texture
			filly=currty1;

			if(redge[i] > MAXX)
				redge[i] = MAXX;
			if(ledge[i] < 0)
			{
				fillx += -ledge[i]*stepx;
				filly += -ledge[i]*stepy;
				ledge[i] = 0;
			}

			currslength = redge[i]-ledge[i];
			start = ScreenY[i]+ledge[i];

			//Finally, the draw loop
			for(j=0;j<=currslength;j++)
			{
				color = texture->image[(filly>>16)*width+(fillx>>16)];
				Screen[start++] = litetable[intensity][color];
				fillx += stepx;
				filly += stepy;
			}
		}
		currtx2 += tw2;  //increment edge2's x coord
		currty2 += th2;  //increment edge2's y coord
		currtx1 += tw1;  //increment edge1's x coord
		currty1 += th1;  //increment edge1's y coord
	}

//================ NOW FOR THE BOTTOM HALF ============================

	//variables
	lefte2texnum = bot_point;
	righte2texnum = bot_point;

	//check if triangle vertex points to right
	if(rflag)
	{
		th2 = (righte2texnum->v* height)-(rights2texnum->v * height);
		tw2 = (righte2texnum->u* width)-(rights2texnum->u * width);

		sh2 = bot_y-mid_y;

		if(sh2!=0)
			{th2 /= sh2; tw2 /= sh2;}

		currtx2 = (rights2texnum->u * width);
		currty2 = (rights2texnum->v * height);

		//for the left edge in a right pointed tri, th1 & tw1 remain the same
	}
	else
	{
		//left pointed
		th1 = (lefte2texnum->v * height)-(lefts2texnum->v * height);
		tw1 = (lefte2texnum->u * width)-(lefts2texnum->u * width);

		sh1 = bot_y-mid_y;
		if(sh1!=0)
			{th1 /= sh1; tw1 /= sh1;}
		//for the right edge in a left pointed tri, th2 & tw2 remain the same
	}

	//Step 6: loop through scanlines from top_y to bottom y in screen poly
	//Big for loop doing the edge interpolation from edge 1 to edge 2
	for(i=mid_y;i<bot_y;i++)
	{
		if(i>=0 && i<=MAXY)
		{
			currslength = redge[i]-ledge[i];   //should never be negative
			currtexwidth = (currtx2-currtx1);
			currtexheight = (currty2-currty1);

			if(currslength!=0)
			{
				stepx = currtexwidth/currslength;
				stepy = currtexheight/currslength;
			}

			fillx = currtx1; //starting values for left edge of texture
			filly = currty1;

			if(redge[i] > MAXX)
				redge[i] = MAXX;
			if(ledge[i] < 0)
			{
				fillx += -ledge[i]*stepx;
				filly += -ledge[i]*stepy;
				ledge[i] = 0;
			}
			currslength = redge[i]-ledge[i];

			start = ScreenY[i]+ledge[i];
			//Finally, the draw loop
			for(j=0;j<=currslength;j++)
			{
				color = texture->image[(filly>>16)*width+(fillx>>16)];
				Screen[start++] = litetable[intensity][color];
				fillx += stepx;
				filly += stepy;
			}
		}
		currtx2 += tw2;  //increment edge2's x coord
		currty2 += th2;  //increment edge2's y coord
		currtx1 += tw1;  //increment edge1's x coord
		currty1 += th1;  //increment edge1's y coord
	}
}

//=============================  TEXMAP16M  =================================
// TEXMAP16M - used with SVGAKIT, 256 cols & 16 million cols
// DDA texture maps a tga file (256 color tga) onto a triangle pg
// Texture is a pointer to the tga graphics file to be mapped onto the triangle
// Intensity is the intensity of the triangle face
// The tga graphics file can be variably sized
// NOTE: Completely UNOPTIMISED e.g. the right edge of the triangle does not
//       need to be tracked. First attempt at texture mapping.
//===========================================================================
void TexMap16M(Polygon *pg, tga_struct *texture,long intensity)
{

//Have a stub of a function if SVGAKIT is not included
#ifdef SVGAKIT
	long top_y,top_x,mid_y,mid_x,bot_y,bot_x; //x,y coords of the 3 points
	long topm,botm,longm;                     //gradients of the 3 edges
	long fix_topx,fix_botx,fix_longx;         //fixed point xcoords of the 3 points
	long *ledge,*redge;
	long sh1,sh2,th1,tw1,th2,tw2;
	// sh1,sh2 = height in pixels of current edges 1 & 2 of the screen triangle
	// th1,th2 = fixed point increments in height of edges 1 & 2 of the texture triangle
	// tw1,tw2 = fixed point increments in width of edges 1 & 2 of the texture triangle
	long rflag,color;
	long currslength,currtexwidth,currtexheight;//currslength = current scanline length of triangle
	long currtx1,currty1,currtx2,currty2;     //x & y coords along edges of texture map triangle
	long stepx,stepy,fillx,filly;             //fixed point slope increments along edges & inside texture map triangle
	long i,j;
	Point *lefts1texnum,*rights1texnum,*lefte1texnum,*righte1texnum;
	Point *lefts2texnum,*rights2texnum,*lefte2texnum,*righte2texnum;

	Point *top_point,*mid_point,*bot_point,*tmp;

	unsigned char r,g,b;

	if( (min(pg->p1->x2d,min(pg->p2->x2d,pg->p3->x2d)) > MAXX) ||
		 (min(pg->p1->y2d,min(pg->p2->y2d,pg->p3->y2d)) > MAXY) ||
		 (max(pg->p1->x2d,max(pg->p2->x2d,pg->p3->x2d)) < 0) ||
		 (max(pg->p1->y2d,max(pg->p2->y2d,pg->p3->y2d)) < 0)
	  )
	return;

	//convert from 6 bit VGA colors to 8 bit colors
	float fintensity = ((float)intensity/32.0) * 4.0;

	//Step 1: store points as top,middle and bottom points
	top_point = pg->p1;
	mid_point = pg->p2;
	bot_point = pg->p3;

	if(top_point->y2d > mid_point->y2d)
	{
		tmp = top_point;
		top_point = mid_point;
		mid_point = tmp;
	}

	if(top_point->y2d > bot_point->y2d)
	{
		tmp = top_point;
		top_point = bot_point;
		bot_point = tmp;
	}

	if(mid_point->y2d > bot_point->y2d)
	{
		tmp = mid_point;
		mid_point = bot_point;
		bot_point = tmp;
	}

	if((top_point->y2d == mid_point->y2d) && (top_point->x2d > mid_point->x2d))
	{
		tmp = top_point;
		top_point = mid_point;
		mid_point = tmp;
	}

	//if the bottom point and medium points have the same y coords, then
	//medium x coord is less than bottom x coord
	/*if((mid_point->y2d == bot_point->y2d) && (mid_point->x2d > bot_point->x2d))
	{
		tmp = mid_point;
		mid_point = bot_point;
		bot_point = tmp;
	}*/

	top_x = top_point->x2d; top_y = top_point->y2d;
	mid_x = mid_point->x2d; mid_y = mid_point->y2d;
	bot_x = bot_point->x2d; bot_y = bot_point->y2d;

	//Step2: find gradients m and starting points of 3 edges.

	topm = (top_x-mid_x)<<16;   //top edge
	if(top_y-mid_y!=0)
		topm /= (top_y-mid_y);

	longm = (top_x-bot_x)<<16;  //longest edge (joins top and bottom points)
	if(top_y-bot_y!=0)
		longm /= (top_y-bot_y);

	botm = (mid_x-bot_x)<<16;   //bottom edge
	if(mid_y-bot_y!=0)
		botm /= (mid_y-bot_y);

	fix_botx = mid_x<<16;
	fix_topx = top_x<<16;
	fix_longx = fix_topx;

	//Step 3: scan convert the triangle

	for(i=top_y;i<mid_y;i++)            //    /|
	{                                   //   /  |
		if(i >=0 && i<=MAXY)             //  /   |
		{                                // /     |   part
			edge1[i] = fix_topx>>16;
			edge2[i] = fix_longx>>16;
		}
		fix_topx += topm;
		fix_longx += longm;
	}

	for(i=mid_y;i<=bot_y;i++)           //  \    |
	{                                   //   \   |    part
		if(i >=0 && i<=MAXY)             //    \  |
		{                                //     \ |
			edge1[i] = fix_botx>>16;      //      \|
			edge2[i] = fix_longx>>16;
		}
		fix_botx += botm;
		fix_longx += longm;
	}

	//Step 4: ensure the left and right edges are in the correct order

	//if(mid_x > edge2[mid_y])
	if(mid_x > ( ((top_x<<16)+((mid_y-top_y) *longm)) >>16) )
	{
		rflag = 1;
		lefts2texnum = top_point;
		lefte1texnum = bot_point;       // right pointed triangle
		rights2texnum = mid_point;
		righte1texnum = mid_point;
		ledge = edge2;
		redge = edge1;
	}
	else
	{
		ledge = edge1;
		redge = edge2;
		rflag = 0;                      // left pointed triangle
		lefts2texnum = mid_point;
		lefte1texnum = mid_point;
		rights2texnum = top_point;
		righte1texnum = bot_point;
	}

	//Step 5: calculate height of screen poly edges and step sizes
	//        of 3 texture edges

	lefts1texnum = top_point;
	rights1texnum = top_point;

	//set up fixed point variables
	long width, height;
	width = texture->header.image_width;
	height = texture->header.image_height;
	th1=( (lefte1texnum->v * height) - (lefts1texnum->v * height));
	tw1=( (lefte1texnum->u * width ) - (lefts1texnum->u * width ));

	th2=( (righte1texnum->v* height) - (rights1texnum->v * height));
	tw2=( (righte1texnum->u* width ) - (rights1texnum->u * width ));

	//check if triangle vertex points to right
	if(rflag)
	{
		sh2 = mid_y-top_y;
		if(sh2!=0)
			{th2 /= sh2; tw2 /= sh2;}

		sh1 = bot_y-top_y;      //right pointed tri so left edge is bottomy - top_y
		if(sh1!=0)
			{th1 /= sh1; tw1 /= sh1;}
	}
	else
	{
		//left pointed
		sh1 = mid_y-top_y;
		if(sh1!=0)
			{th1 /= sh1; tw1 /= sh1;}

		sh2 = bot_y-top_y;         //left pointed tri so right edge is bot_y-top_y
		if(sh2!=0)
			{th2 /= sh2; tw2 /= sh2;}
	}

	//Step 6: loop through scanlines from top_y to bottom y in screen poly

	//Big for loop doing the edge interpolation from edge 1 to edge 2
	// currtx1,currtx2 = starting left/right x coord in texture
	// currty1,currtx2 = starting left/right y coord in texture
	currtx1 = currtx2 = (lefts1texnum->u * width);
	currty1 = currty2 = (lefts1texnum->v * height);

		  /*currslength=redge[mid_y]-ledge[mid_y];
		  currtexwidth  = (currtx2+ (mid_y-top_y)*tw2)-(currtx1+ (mid_y-top_y)*tw1);
		  currtexheight = (currty2+ (mid_y-top_y)*th2)-(currty1+ (mid_y-top_y)*th1);
		  if(currslength!=0)
		  {
			stepx=currtexwidth/currslength;
			stepy=currtexheight/currslength;
		  }*/

	for(i=top_y;i<mid_y;i++)
	{
		if(i>=0 && i<=MAXY)
		{
			currslength = redge[i]-ledge[i];   //should never be negative
			currtexwidth = (currtx2-currtx1);
			currtexheight = (currty2-currty1);

			if(currslength!=0)
			{
				stepx = currtexwidth/currslength;
				stepy = currtexheight/currslength;
			}

			fillx = currtx1; //starting values for left edge of texture
			filly = currty1;

			if(redge[i] > MAXX)
				redge[i] = MAXX;
			if(ledge[i] < 0)
			{
				fillx += -ledge[i]*stepx;
				filly += -ledge[i]*stepy;
				ledge[i] = 0;
			}
			currslength = redge[i]-ledge[i];

			//Finally, the draw loop
			for(j=0;j<=currslength;j++)
			{
				color = texture->image[(filly>>16)*width+(fillx>>16)];
				if(video_mode!=0x101)   //16M colors
				{
					r = (uchar)((float)(texture->palette[(3*color)])*fintensity);
					g = (uchar)((float)(texture->palette[(3*color)+1])*fintensity);
					b = (uchar)((float)(texture->palette[(3*color)+2])*fintensity);
					putPixel(ledge[i]+j,i,rgbColor(r,g,b));
				}
				else                   //256 colors
					putPixel(ledge[i]+j,i,litetable[intensity][color]);

				fillx += stepx;
				filly += stepy;
			}
		}
		currtx2 += tw2;  //increment edge2's x coord
		currty2 += th2;  //increment edge2's y coord
		currtx1 += tw1;  //increment edge1's x coord
		currty1 += th1;  //increment edge1's y coord
	}

//================ NOW FOR THE BOTTOM HALF ============================

	//variables
	lefte2texnum = bot_point;
	righte2texnum = bot_point;

	//check if triangle vertex points to right
	if(rflag)
	{
		th2 = (righte2texnum->v* height)-(rights2texnum->v * height);
		tw2 = (righte2texnum->u* width)-(rights2texnum->u * width);

		sh2 = bot_y-mid_y;

		if(sh2!=0)
			{th2 /= sh2; tw2 /= sh2;}

		currtx2 = (rights2texnum->u * width);
		currty2 = (rights2texnum->v * height);

		//for the left edge in a right pointed tri, th1 & tw1 remain the same
	}
	else
	{
		//left pointed
		th1 = (lefte2texnum->v * height)-(lefts2texnum->v * height);
		tw1 = (lefte2texnum->u * width)-(lefts2texnum->u * width);

		sh1 = bot_y-mid_y;
		if(sh1!=0)
			{th1 /= sh1; tw1 /= sh1;}
		//for the right edge in a left pointed tri, th2 & tw2 remain the same
	}

	//Step 6: loop through scanlines from top_y to bottom y in screen poly
	//Big for loop doing the edge interpolation from edge 1 to edge 2
	for(i=mid_y;i<bot_y;i++)
	{
		if(i>=0 && i<=MAXY)
		{
			currslength = redge[i]-ledge[i];   //should never be negative
			currtexwidth = (currtx2-currtx1);
			currtexheight = (currty2-currty1);

			if(currslength!=0)
			{
				stepx = currtexwidth/currslength;
				stepy = currtexheight/currslength;
			}

			fillx = currtx1; //starting values for left edge of texture
			filly = currty1;

			if(redge[i] > MAXX)
				redge[i] = MAXX;
			if(ledge[i] < 0)
			{
				fillx += -ledge[i]*stepx;
				filly += -ledge[i]*stepy;
				ledge[i] = 0;
			}
			currslength = redge[i]-ledge[i];

			//Finally, the draw loop
			for(j=0;j<=currslength;j++)
			{
				color = texture->image[(filly>>16)*width+(fillx>>16)];
				if(video_mode!=0x101)      //16M colors
				{
					r = (uchar)((float)(texture->palette[(3*color)])*fintensity);
					g = (uchar)((float)(texture->palette[(3*color)+1])*fintensity);
					b = (uchar)((float)(texture->palette[(3*color)+2])*fintensity);
					putPixel(ledge[i]+j,i,rgbColor(r,g,b));
				}
				else                       //256 colors
					putPixel(ledge[i]+j,i,litetable[intensity][color]);

				fillx += stepx;
				filly += stepy;
			}
		}
		currtx2 += tw2;  //increment edge2's x coord
		currty2 += th2;  //increment edge2's y coord
		currtx1 += tw1;  //increment edge1's x coord
		currty1 += th1;  //increment edge1's y coord
	}
#endif
}
