/****************************************************************************
*
*                               S H A N D Y
*
*									  1996 Andrew Cheung
*
* 	FILENAME	:     $RCSfile: tga.cpp $
* 	VERSION	:    	$Revision: 1.0 $
* 	DATE     :     $Date: 1996/07/28 17:03:00 $
* 	LANGUAGE	:     C++
*
* 	ENVIRONMENT:
*	IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*	Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
* 	DESCRIPTION:
*	A set of functions for loading TGA images.
*
* 	$Id: tga.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include  <stdio.h>
#include  <dos.h>
#include  <io.h>
#include  <fcntl.h>
#include  <mem.h>
#include  "tga.h"

// Load only type 1 TGA files (8-bit format) with a 24-bit colormap
int loadtga(char *filename,tga_struct *tga)
{
	int infile;

	if ((infile=open(filename,O_BINARY))==-1) return(-1);
	lseek(infile,0L,SEEK_SET);
	read(infile,&(tga->header),sizeof(tga_header));
	if (tga->header.image_type != 1) return(-1);
	//if (tga->header.image_width> 320) return(-1);
	//if (tga->header.image_height > 200) return(-1);
	if (tga->header.bits_per_pixel != 8) return(-1);
	if (tga->header.color_map_entry_size != 24) return(-1);

	if (tga->header.ID_length>0)
	{
		tga->ID=new char[tga->header.ID_length];
		read(infile,tga->ID,tga->header.ID_length);
	}
	else  tga->ID = 0;

	load_palette(infile,tga);
	if (load_image(infile,tga))
		return(-1);
	close(infile);
	return(0);
}

int load_image(int tgafile,tga_struct *tga)
{
	// Calculate size of image in bytes:
	unsigned int image_size=tga->header.image_width * tga->header.image_height;

	// Allocate memory for image, abort if not available:
	if((tga->image=new unsigned char[image_size])==NULL)
	{
		if (tga->ID)
			delete tga->ID;
		return(-1);
	}
	// Load image from file:
	read(tgafile,tga->image,image_size);
	return(0);
}

void load_palette(int tgafile,tga_struct *tga)
{
	for (int entry=0; entry<256; entry++)
	{
		for (int color=2; color>=0; --color)
		{
			read(tgafile,&(tga->palette[entry*3+color]),1);
			tga->palette[entry*3+color] >>= 2;
		}
	}
}
