/****************************************************************************
*
*                               S H A N D Y
*
*									1996 Andrew Cheung
*
*  FILENAME :     $RCSfile: trig.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C++
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  Floating Point Sine/Cosine tables. Stores 360 trig angles in floating point
*  array sin_table[360] & cos_table[360]
*
*  $Id: trig.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include <math.h>
#include "trig.h"

float sin_table[360];
float cosine_table[360];

float SinFP(int degree)
{
	if (degree < 0)
		degree += 360;
	return(sin_table[degree]);
}

float CosFP(int degree)
{
	if (degree < 0)
		degree += 360;
	return(cosine_table[degree]);
}

void CalcTrigTables()
{
	int i;

	for (i = 0; i < 360; i++)
	{
		sin_table[i] = sin((double) i * PI / 180.0);
		cosine_table[i] = cos((double) i * PI / 180.0);
	}
}
