/****************************************************************************
*
*                               S H A N D Y
*
*                            1996 Andrew Cheung
*
*  FILENAME :     $RCSfile: video.cpp $
*  VERSION  :     $Revision: 1.0 $
*  DATE     :     $Date: 1996/07/28 17:03:00 $
*  LANGUAGE :     C++
*
*  ENVIRONMENT:
*  IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*  Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
*  DESCRIPTION:
*  Functions that mask the low level mode 13h & SVGAKIT routines from
*  SHANDY
*  Low level inline assembler mode 13h routines for Watcom
*
*  $Id: video.cpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "shandy.hpp"
#include "globals.hpp"
#include "defines.h"
#include "video.h"
#include "screen.h"
#include "shading.h"

#ifdef SVGAKIT
	#include "svga.h"
	extern palette svgapal[256];
#endif

//Get a video mode from the user
int GetVideoMode()
{
	int mode,choice;

	printf("\n\n\n\n\n");
	printf("\t\t\t\tS H A N D Y\n");
	printf("\t\t\t\t===========\n");
	printf("\n");
	printf("\t\t\t\tVideo Modes\n");
	printf("\n");
	printf("\t\t\t[1] 320x200 VGA 256 colours\n");
	printf("\t\t\t[2] 320x200 SVGA 16 million colours\n");
	printf("\t\t\t[3] 640x480 SVGA 256 colours\n");
	printf("\t\t\t[4] 640x480 SVGA 16 million colours\n");
	printf("\t\t\t[5] Exit\n");


	while(1)
	{
		choice = getch();
		switch(choice)
		{
			case '1':   mode = 0x13;  return(mode);
			case '2':   mode = 0x10F; return(mode);
			case '3':   mode = 0x101; return(mode);
			case '4':   mode = 0x112; return(mode);
			case '5':   setmode(3); exit(0);
		}
	}
}

void InitVideoMode(int mode)
{

#ifdef SVGAKIT
	if(mode != 0x13) //I've only implemented mode 0x13
	{
		if (initSuperVGA(true) < 0x102)
		{
			printf("This program requires a VESA VBE 1.2 compatible SuperVGA. Try installing\n");
			printf("the Universal VESA VBE for your video card, or contact your video card\n");
			printf("vendor and ask for a suitable TSR\n");
			exit(1);
		}
		TexMap = TexMap16M;
	}
	else
#endif
		TexMap = TexMap256;

	if(mode==0x13)
	{
		// Create pointer to video memory:
	#ifdef PROFILE
		#ifdef WATCOM32
		Screen = (unsigned char *)(0x0A0000);
		#endif
		#ifdef BC3
		Screen = (unsigned char *)MK_FP(0xA000,0);
		#endif
	#else
		Buffer = new unsigned char[64000];
		Screen = (unsigned char *)Buffer;
	#endif
	}
}

void SetVideoMode(int mode)
{
	int i;

#ifdef SVGAKIT
	if(mode != 0x13)
	{
		if(!setSuperVGAMode(mode))
		{
			printf("\nERROR: Video mode %d did not set correctly!\n\n",mode);
			exit(1);
		}
	}
#endif
	if(mode == 0x13)
		setmode(0x13);

	switch(mode)
	{
		case 0x13   :
		case 0x10F  :  for(i=0;i<200;i++)
								ScreenY[i] = i*320;
							XPROJ=160; YPROJ=100;
							MAXX =319; MAXY =199;
							edge1 = new long[320]; edge2 = new long[320];
							cedge1 = new long[320]; cedge2 = new long[320];
							break;
		case 0x101  :
		case 0x112  :  for(i=0;i<480;i++)
								ScreenY[i] = i*640;
							XPROJ=320; YPROJ=240;
							MAXX =639; MAXY =479;
							edge1 = new long[480]; edge2 = new long[480];
							cedge1 = new long[480]; cedge2 = new long[480];
							break;
	}
}

void EndGraphics(void)
{
	if(video_mode == 0x13)
		setmode(3);
#ifdef SVGAKIT
	else
		restoreMode();
#endif

	delete []edge1; delete []edge2;
	delete []cedge1; delete []cedge2;
}

void Set256GreyPal(unsigned char *vgapal)
{
	int i,j;

	for(i=0;i<64;i++)
	{
		for(j=0;j<4;j++)
		{
			vgapal[(i*12)+j*3]     = i;
			vgapal[(i*12)+(j*3)+1] = i;
			vgapal[(i*12)+(j*3)+2] = i;
		}
	}
	SetPal(vgapal);
}

void Set256Pal(unsigned char *vgapal)
{
	int i,j;

	/*for(i=0;i<3;i++)
	{
		for(j=0;j<64;j++)
		{
			vgapal[i*192+(j*3)] = (i==0 ? j : 0);
			vgapal[i*192+(j*3)+1] = (i==1 ? j : 0);
			vgapal[i*192+(j*3)+2] = (i==2 ? j : 0);
		}
	}*/
	for(i=0;i<64;i++)
	{
		for(j=0;j<4;j++)
		{
			vgapal[(i*12)+j*3]     = i;
			vgapal[(i*12)+(j*3)+1] = 0;
			vgapal[(i*12)+(j*3)+2] = 0;
		}
	}
	//vgapal[0]=63;vgapal[1]=63;vgapal[2]=63;
	SetPal(vgapal);
}

void Set256TexMapPal(unsigned char *vgapal)
{
	int i;
	// Can only have one texture palette -> select the first one
	for(i=0;i<256;i++)
	{
		vgapal[i*3]     = texture_list[0]->TFile->palette[i*3];
		vgapal[(i*3)+1] = texture_list[0]->TFile->palette[(i*3)+1];
		vgapal[(i*3)+2] = texture_list[0]->TFile->palette[(i*3)+2];
	}
	SetPal(vgapal);
}

/* Pseudo Phong palette. Obtained by blending white with rgb, using
	different gains (gamma) to obtain a non-linear highlight. spec
	controls the gain of the white component, high values giving a
	tighter highlight. Doesn't work too well as it stands. Too much
	white everywhere */
/*void SetPhongPal(unsigned char *vgapal, float spec, float gamma)
{
	float c, r,g,b;
	int i, j;
	for(j=0;j<8;j++)
	{
		for(i=0;i<32; i++)
		{
			c = (float)i/31.0;
			r = (j&1) * (pow(c,gamma)-pow(c,spec) ) * 63;
			g = ((j&2)?1:0) * (pow(c,gamma)-pow(c,spec) ) * 63;
			b = ((j&4)?1:0) * (pow(c,gamma)-pow(c,spec) ) * 63;

			r += pow(c,spec) * 63;
			g += pow(c,spec) * 63;
			b += pow(c,spec) * 63;

			if(r>63) r = 63;
			if(g>63) g = 63;
			if(b>63) b = 63;

			vgapal[ ((j<<5)|i) * 3  ] = r;
			vgapal[ ((j<<5)|i) * 3 + 1] = g;
			vgapal[ ((j<<5)|i) * 3 + 2] = b;
		}
	}
	SetPal(vgapal);
}*/

//Actually, just loads a JASC 256 color palette file that SHOULD
//contain a Phong palette. Substitue any palette for phong.pal
void SetPhongPal(unsigned char *vgapal, float spec, float gamma)
{
	FILE *fin;
	char string[80];
	int r,g,b;
	int i;

	if((fin = fopen("phong.pal","rt"))!=NULL )
	{
		fgets(string,80,fin);     //Read first 3 lines
		fgets(string,80,fin);
		fgets(string,80,fin);

		for (i=0; i<256; i++)
		{
			fscanf(fin, "%d", &r);    //Simply read rgb values
			fscanf(fin, "%d", &g);
			fscanf(fin, "%d", &b);
			vgapal[i*3]     = r>>2;   //Convert from 8 bits -> VGA 6 bits
			vgapal[(i*3)+1] = g>>2;
			vgapal[(i*3)+2] = b>>2;
		}
	}
	fclose(fin);
	SetPal(vgapal);
}

//Set the 256 colour palette vgapal (or svga palette if SVGA is chosen)
void SetPal(unsigned char *vgapal)
{
	if(video_mode == 0x13)
		setpalette(vgapal);
#ifdef SVGAKIT
	else
	{
		int i;

		for(i=0; i<256; i++)
		{
			svgapal[i].red   = vgapal[i*3];
			svgapal[i].green = vgapal[(i*3)+1];
			svgapal[i].blue  = vgapal[(i*3)+2];
		}
		setPalette(0,256,svgapal);
	}
#endif
}

void ClearScreen(unsigned char *Screen)
{
#ifndef PROFILE
	if(video_mode == 0x13)
		cls(Screen);
	#ifdef SVGAKIT
	else
		clear(0);
	#endif
#endif
}

void PageFlip(unsigned char *Buffer)
{
	//apage = the active page, the one which is to be drawn to
	//vpage = the visual page, the one to be displayed
	static int apage=1,vpage=0; //maxpage = 2;
#ifndef PROFILE
	if(video_mode == 0x13)
		FlipPage(Buffer);
	#ifdef SVGAKIT
	else
	{
		vpage = ++vpage % 3;   // 3 == maxpage+1
		setVisualPage(vpage);  // Display hidden page
		apage = ++apage % 3;   // 3 == maxpage+1
		setActivePage(apage);  // Prepare to draw to hidden page
	}
	#endif
#endif
}


/////////////////////////  WATCOM INLINE ASSEMBLER  /////////////////////////

// See SVGA.ASM for comments

#ifdef WATCOM32
void setmode(short mode);
//Set VGA adapter to BIOS MODE mode
#pragma aux setmode = \
	"int     10h"      \
parm [ax];

void setpalette(unsigned char *color_regs);
//Set 256 VGA color registers
#pragma aux setpalette =   \
	"mov		al,0"          \
	"mov 		dx, 3C8h"      \
	"out		dx, al"        \
	"mov 		dx, 3C9h"      \
	"mov		cx,256"        \
"@SetPalLoop:"             \
	"mov 		al,[edi]"      \
	"out		dx, al"        \
	"mov 		al,[edi+1]"    \
	"out		dx, al"        \
	"mov 		al,[edi+2]"    \
	"out		dx, al"        \
	"add		di,3"          \
	"dec		cx"            \
	"jnz		@SetPalLoop"   \
modify [eax ecx edx]       \
parm [edi];

void cls(unsigned char *Screen);
#pragma aux cls =          \
	"cld"                   \
	"mov    	ecx,16000"     \
	"mov     eax,0"         \
	"cli"                   \
	"rep     stosd"         \
	"sti"                   \
modify [ecx eax]           \
parm [edi];


void FlipPage(unsigned char *Buffer);
#pragma aux FlipPage =     \
	"mov		ecx,16000"       \
	"mov		edi,0A0000h"     \
	"cli"                   \
	"rep		movsd"           \
	"sti"                   \
modify [ecx edi]           \
parm [esi];


#endif
