/****************************************************************************

 EVENTMGR.H

 Event Manager header file for shandy program

 Definitions, data types and prototypes for the event management function
 in module EVENTMGR.CPP

 Andrew Cheung 7/96

 ***************************************************************************/
#ifndef _EVENTMGR_H
#define _EVENTMGR_H

// Key definitions by scan code:

#define	 ENTER		28
#define   UPARROW 	72
#define   DOWNARROW  80
#define   LEFTARROW  75
#define   RIGHTARROW 77
#define   RSHIFT	   54   //rightshift key
#define   LSHIFT	   42   //leftshift key
#define   ALT	      56   //either alt key
#define   CTRL	 	   29   //either ctrl key
#define   ESC	       1   //escape key
#define   TAB			15	  //tab key
#define	 OKEY			24	  //O key
#define	 LKEY			38	  //L key
#define   CKEY			46	  //C key
#define   HKEY			35	  //H key
#define   SKEY			31	  //S key
#define	 SPACEBAR	57	  //Spacebar
#define	 F1			59	  //F1 key
#define	 F2			60	  //F2 key
#define   GRAYPLUS	78	  // Numpad +
#define   GRAYMINUS	74	  // Numpad -

// Mouse buttons
#define   LMBUTTON    1
#define   RMBUTTON    2

// Definitions for requesting events:
const MOUSE_EVENTS=1,JOYSTICK_EVENTS=2,KEYBOARD_EVENTS=4;
const	S_CAMERA=1,S_CAMERA_TARGET=2,S_OBJECT=3,S_LIGHT=4,S_SCENE=5,S_ORIGIN=6;

// Structure for passing events to calling program:
struct event_struct
{
  int go_forward,go_back,go_left,go_right,
		go_up,go_down,rote_up,rote_down,rote_left,
		rote_right,rote_clock,rote_aclock,
		selected,change_mode,change_step,
		moving,set_origin,help,quit;
};

void InitEvents();     // Initialize event manager
void ClearEvents(event_struct *events);// Clear all events
void EndEvents();      // Terminate event manager
int GetEvents(int event_mask,event_struct *events);
#endif
