/****************************************************************************
*
*                               S H A N D Y
*
*							Copyright (C) 1996 Andrew Cheung
*  								All rights reserved.
*
* 	FILENAME	:     $RCSfile: globals.hpp $
* 	VERSION	:    	$Revision: 1.0 $
* 	DATE     :     $Date: 1996/07/28 17:03:00 $
* 	LANGUAGE	:     C++
*
* 	ENVIRONMENT:
*	IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*	Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
* 	DESCRIPTION:
*	Contains the main global variables & constants used in the
*  shandy program
*
* 	$Id: globals.hpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/

#ifndef _GLOBALS_HPP
#define _GLOBALS_HPP

//Constants
const int SINX = 0;
const int COSX = 1;
const int SINY = 2;
const int COSY = 3;
const int SINZ = 4;
const int COSZ = 5;

const int MULTI = 0;
const int DOTS = 1;
const int WIRE = 2;
const int FLAT = 3;
const int FLAT_DEPTH = 4;
const int GOURAUD = 5;
const int GOURAUD_FLAT = 6;
const int GOURAUD_PHONG = 7;
const int PHONG = 8;
const int TEXTURE_FLAT = 9;
const int TEXTURE = 10;
const int DEFAULT=GOURAUD;

const int MAXLIGHT = 32;
const int PALETTESIZE = 256;
const float AMBIENT_LIGHT = 0.2;

//const float FRONTCLIP = 0.0;

//Variables
extern int video_mode;
extern int XPROJ;
extern int YPROJ;
extern int MAXX;
extern int MAXY;

extern unsigned char *Screen;
extern unsigned char *Buffer;
extern int ScreenY[480];
extern unsigned char vgapal[3*256];
extern unsigned char litetable[MAXLIGHT+1][PALETTESIZE];

extern char keybuffer[128]; // Buffer for 128 scan codes

extern MatStruct **texture_list;
extern Scene *scene;
extern Camera *camera;
extern Point *tPoint;

#endif
