/****************************************************************************

 SHADING.H

 Shading header file for shandy program

 Definitions, data types and prototypes for the shading functions and
 rendering routines in SHANDY

 Andrew Cheung 7/96

 ***************************************************************************/
#ifndef _SHADING_H
#define _SHADING_H

// Pointers into left & right edge arrays - size of array = MAXY and is set
// when the video mode is initialised
extern long *edge1,*edge2,*cedge1,*cedge2;

void Line(Point *p1, Point *p2);
void FlatFill(Polygon *pg, char color);
void GouraudFill(Polygon *pg);
extern void (*TexMap)(Polygon *pg, tga_struct *texture,long intensity);
void TexMap256(Polygon *pg, tga_struct *texture,long intensity);
void TexMap16M(Polygon *pg, tga_struct *texture,long intensity);

#endif
