/****************************************************************************
*
*                               S H A N D Y
*
*							Copyright (C) 1996 Andrew Cheung
*  								All rights reserved.
*
* 	FILENAME	:     $RCSfile: shandy.hpp $
* 	VERSION	:    	$Revision: 1.0 $
* 	DATE     :     $Date: 1996/07/28 17:03:00 $
* 	LANGUAGE	:     C++
*
* 	ENVIRONMENT:
*	IBM PC (MSDOS) Real Mode and 32 bit Protected Mode.
*	Watcom C/C++ 10.0,Borland C++ 3.1 - flat or large memory model
*
* 	DESCRIPTION:
*  Contains the class definitions, member variables, member function
*	declarations, other function declarations and type definitions for
*	SHANDY
*
* 	$Id: shandy.hpp 1.0 1996/07/28 17:03:00 apwc Release apwc $
*
****************************************************************************/

#ifndef _SHANDY_HPP
#define _SHANDY_HPP

#include <stdio.h>
#include <math.h>
#include "trig.h"
#include "tga.h"


//============================= 3D POINT CLASS ==============================

class Point
{
public:
	//Members
	float x3d, y3d, z3d;          //(x,y,z) 3D world coordinates of point
	float eyeX, eyeY, eyeZ;       //(x,y,z) 3D coordinates of point in eye space
	float localX, localY, localZ; //(x,y,z) 3D local coordinates of point
	float localOX, localOY, localOZ;  //(x,y,z) 3D world coords of local origin for point
	int x2d, y2d,numNormals;      //(x,y) 2D screen coords
	long u, v;                    //(u,v,) coordinates of point into 2D texture map
	float normalX, normalY, normalZ;
	void *normal;                 //Gouraud normal of point (another point)
	int color;                    //color of point for Gouraud shading

	//Functions
		  Point();
		  Point(float x, float y, float z);
			~Point();
	void SetCoords(float x, float y, float z);
	void SetTexCoords(float tempU,float tempV);
	void EyeSpace();
	void NEyeSpace();
	void Project();
	void Display(char color);
	void SetNewLocalOrigin(Point *p);
	void TranslateLocalOrigin(Point *p);

	void RotateLocal(int XDeg, int YDeg, int ZDeg);
	void RotateLocal(float *matrix);
	void RotateGlobal(float *matrix);
	void RotateLocalX(float *matrix);
	void RotateLocalY(float *matrix);
	void RotateLocalZ(float *matrix);

	void RotateLocalX(int XDeg);
	void RotateLocalY(int YDeg);
	void RotateLocalZ(int ZDeg);


	void TranslateLocal(float xDist, float yDist, float zDist);
	void TranslateLocalX(float xDist);
	void TranslateLocalY(float yDist);
	void TranslateLocalZ(float zDist);

	void FormGlobalCoords();
	void Normalise();
	void ZeroNormal();
	void AddNormals(float x,float y, float z);
	void AvgNormal();
};


struct Texpoint
{
public:
	Point *p;
	int texpointnum;
};

struct MatStruct
{
	tga_struct *TFile;
	char MaterialName[32];
	char FileName[80];
};

class Polygon
{
public:
	 //Members
	 Point *p1, *p2, *p3, *normal;
	 //Texpoint *t1,*t2,*t3;
	 tga_struct *texture;
	 int color,shading;

public:
	 //Functions
			Polygon();
			Polygon(Point *v1, Point *v2, Point *v3, int c);
			~Polygon();
	 void SetTo(Point *P1, Point *P2, Point *P3);
	 void CalcNormal();
	 float AvgZ();
	 void SetColor(int c);
	 void SetShading(int shade);
	 void SetNewLocalOrigin(Point *p);
	 void CalcGNormals();

	 void WireFrame();
	 void FlatShade();
	 void GouraudShade();
	 void TextureMap();
	 void Display();
};

class Object
{
private:
	//Members
	float *matrix;
	int shading;

public:
	//Members
	Point *origin;
	Point  **point;            //Point,normal & polygon lists
	Point  **normal;
	Point *midpoint;
	Polygon  **poly;
	int numPoints, numNormals, numPolys, count;
	int StartShade;

	//Functions
		  Object();
		  Object(float x, float y, float z);
		  ~Object();
	void SetShading(int s);
	void AddLocalPoint(float x, float y, float z);
	void AddLocalPoint(Point *p);
	void AddGlobalPoint(float x, float y, float z);
	void AddGlobalPoint(Point *p);
	void AddNormal(float x, float y, float z);
	void AddNormal(Point *p);

	void AddLocalPoly(Polygon *pg);
	void AddLocalPoly(int p1, int p2, int p3, int c);
	void AddGlobalPoly(Polygon *pg);

	void RotateLocal(int XDeg, int YDeg, int ZDeg);
	void RotateGlobal(float *matrix);
	void RotateLocalX(int XDeg);
	void RotateLocalY(int YDeg);
	void RotateLocalZ(int ZDeg);

	void TranslateLocal(float XDist, float YDist, float ZDist);
	//void Project();
	void SortPlanes();

	void Dots(char color);
	void WireFrame();
	void FlatShade();
	void GouraudShade();
	void Display();

	void SetLocation(float x, float y, float z);
	void SetGNormals();
	void AddMidPoint();
	void EyeSpace();
	void LoadObject(FILE *fin,FILE *texture_file,int *ShadeModel);
};

class Camera
{
public:

	Point *target, *position;
	//N is the vector into the view plane
	//V is the 'up' direction
	//U is the direction of increasing x
	float Nx,Ny,Nz, Vx,Vy,Vz, Ux,Uy,Uz;

		  Camera();
		  Camera(float ViewX,float ViewY,float ViewZ,
					float TargX,float TargY,float TargZ);
		  ~Camera();
	void SetCamSpace();
	void Display();
};
/*
class Light
{
public:

	Point *location;
	float red,green,blue;

	Light();
	~Light();
};
*/
class Scene
{
public:

	//Members
	Object **object;        //object list
	Point **light;
	Camera **cameras;
	int numObjs;
	int numLights;
	int numCameras;

		  Scene();
		  ~Scene();
	void MSort();
	void LoadScene(FILE *fin,FILE *ftextures,int *shading);
	void AddObject();
	void AddLight(float x,float y, float z);
	void LoadLight(FILE *fin);
	void AddCamera(float vx,float vy, float vz,
						float nx,float ny, float nz);
	void LoadCamera(FILE *fin);
	void SortObjs();
	void EyeSpace();
	void Display();
};

void SubVec(Point *p1,Point *p2);
int SearchMatList(MatStruct **texture_list,char *material_name);
int SearchMatFile(FILE *texfile,MatStruct **texture_list,char *material_name);

#endif
